#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 atomic-primops
version:              0.8.4
visibility:           public
id:                   atomic-primops-0.8.4-16S7z4TcMrS7td21bF0FwU
key:                  atomic-primops-0.8.4-16S7z4TcMrS7td21bF0FwU
license:              BSD-3-Clause
maintainer:           rrnewton@gmail.com
author:               Ryan Newton
homepage:             https://github.com/rrnewton/haskell-lockfree/wiki
synopsis:             A safe approach to CAS and other atomic ops in Haskell.
description:
    After GHC 7.4 a new `casMutVar#` primop became available, but it'\''s
    difficult to use safely, because pointer equality is a highly
    unstable property in Haskell.  This library provides a safer method
    based on the concept of "Tickets".

    Also, this library uses the "foreign primop" capability of GHC to
    add access to other variants that may be of
    interest, specifically, compare and swap inside an array.

    Note that as of GHC 7.8, the relevant primops have been included in GHC itself.
    This library is engineered to work pre- and post-GHC-7.8, while exposing the
    same interface.

category:             Data
abi:                  9cdd3cd222ad342f08db940de8f87143
exposed:              True
exposed-modules:
    Data.Atomics Data.Atomics.Counter Data.Atomics.Internal

import-dirs:          /usr/lib/ghc-8.10.5/site-local/atomic-primops-0.8.4
library-dirs:         /usr/lib/ghc-8.10.5/site-local/atomic-primops-0.8.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/atomic-primops-0.8.4
hs-libraries:         HSatomic-primops-0.8.4-16S7z4TcMrS7td21bF0FwU
depends:
    base-4.14.2.0 ghc-prim-0.6.1
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh

haddock-interfaces:
    /usr/share/doc/haskell-atomic-primops/html/atomic-primops.haddock

haddock-html:         /usr/share/doc/haskell-atomic-primops/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

