#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 atomic-write
version:              0.2.0.7
visibility:           public
id:                   atomic-write-0.2.0.7-EpGthskVMzK1fsEcdLdU4
key:                  atomic-write-0.2.0.7-EpGthskVMzK1fsEcdLdU4
license:              MIT
copyright:            2015-2019 Stack Builders Inc.
maintainer:           support@stackbuilders.com
author:               Justin Leitgeb
homepage:             https://github.com/stackbuilders/atomic-write
synopsis:             Atomically write to a file
description:

    Atomically write to a file on POSIX-compliant systems while preserving
    permissions.

    On most Unix systems, `mv` is an atomic operation. This makes it simple to write
    to a file atomically just by using the mv operation. However, this will
    destroy the permissions on the original file. This library does the following
    to preserve permissions while atomically writing to a file:

    * If an original file exists, take those permissions and apply them to the
    temp file before `mv`ing the file into place.

    * If the original file does not exist, create a following with default
    permissions (based on the currently-active umask).

    This way, when the file is `mv`'\''ed into place, the permissions will be the ones
    held by the original file.

    This library is based on similar implementations found in common libraries in
    Ruby and Python:

    * <http://apidock.com/rails/File/atomic_write/class Ruby on Rails includes a similar method called atomic_write>

    * <https://github.com/chef/chef/blob/c4631816132fcfefaba3d123a1d0dfe8bc2866bb/lib/chef/file_content_management/deploy/mv_unix.rb#L23:L71 Chef includes atomic update functionality>

    * <https://github.com/sashka/atomicfile There is a python library for atomically updating a file>

    To use `atomic-write`, import the module corresponding to the type you wish to
    write atomically, e.g., to write a (strict) ByteString atomically:

    > import System.AtomicWrite.Writer.ByteString

    Then you can use the atomicWriteFile function that accepts a `FilePath` and a
    `ByteString`, e.g.:

    > atomicWriteFile myFilePath myByteString

category:             System
abi:                  b30480017753827c3f87f57031ad263c
exposed:              True
exposed-modules:
    System.AtomicWrite.Writer.ByteString
    System.AtomicWrite.Writer.ByteString.Binary
    System.AtomicWrite.Writer.ByteStringBuilder
    System.AtomicWrite.Writer.LazyByteString
    System.AtomicWrite.Writer.LazyByteString.Binary
    System.AtomicWrite.Writer.LazyText
    System.AtomicWrite.Writer.LazyText.Binary
    System.AtomicWrite.Writer.String
    System.AtomicWrite.Writer.String.Binary
    System.AtomicWrite.Writer.Text
    System.AtomicWrite.Writer.Text.Binary

hidden-modules:       System.AtomicWrite.Internal
import-dirs:          /usr/lib/ghc-8.10.5/site-local/atomic-write-0.2.0.7
library-dirs:         /usr/lib/ghc-8.10.5/site-local/atomic-write-0.2.0.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/atomic-write-0.2.0.7
hs-libraries:         HSatomic-write-0.2.0.7-EpGthskVMzK1fsEcdLdU4
depends:
    base-4.14.2.0 bytestring-0.10.12.0 directory-1.3.6.0
    filepath-1.4.2.1 temporary-1.3-2IjA4J7jKmb3rvOA3dYC2H text-1.2.4.1
    unix-compat-0.5.3-1KqjYp6svTH6EdzCzH8QEz

haddock-interfaces:
    /usr/share/doc/haskell-atomic-write/html/atomic-write.haddock

haddock-html:         /usr/share/doc/haskell-atomic-write/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

