#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-prelude
version:              1.2.5
visibility:           public
id:                   clash-prelude-1.2.5-9vVnr6snCPAA4x59VhcBTz
key:                  clash-prelude-1.2.5-9vVnr6snCPAA4x59VhcBTz
license:              BSD-2-Clause
copyright:
    Copyright © 2013-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:             CAES Language for Synchronous Hardware - Prelude library
description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Prelude library containing datatypes and functions for circuit design

    To use the library:

    * Import "Clash.Prelude"

    * Alternatively, if you want to explicitly route clock and reset ports,
    for more straightforward multi-clock designs, you can import the
    "Clash.Explicit.Prelude" module. Note that you should not import
    "Clash.Prelude" and "Clash.Explicit.Prelude" at the same time as they
    have overlapping definitions.

    A preliminary version of a tutorial can be found in "Clash.Tutorial", for a
    general overview of the library you should however check out "Clash.Prelude".
    Some circuit examples can be found in "Clash.Examples".

category:             Hardware
abi:                  0e8a7fc317cb55be57e932a2a2dc7067
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation
    Clash.Annotations.BitRepresentation.Deriving
    Clash.Annotations.BitRepresentation.Internal
    Clash.Annotations.BitRepresentation.Util
    Clash.Annotations.Primitive Clash.Annotations.SynthesisAttributes
    Clash.Annotations.TH Clash.Annotations.TopEntity
    Clash.Class.AutoReg Clash.Class.BitPack Clash.Class.Exp
    Clash.Class.HasDomain Clash.Class.HasDomain.CodeGen
    Clash.Class.HasDomain.Common Clash.Class.HasDomain.HasSingleDomain
    Clash.Class.HasDomain.HasSpecificDomain Clash.Class.Num
    Clash.Class.Parity Clash.Class.Resize Clash.Clocks
    Clash.Clocks.Deriving Clash.Examples Clash.Explicit.BlockRam
    Clash.Explicit.BlockRam.File Clash.Explicit.DDR
    Clash.Explicit.Mealy Clash.Explicit.Moore Clash.Explicit.Prelude
    Clash.Explicit.Prelude.Safe Clash.Explicit.RAM Clash.Explicit.ROM
    Clash.Explicit.ROM.File Clash.Explicit.Signal
    Clash.Explicit.Signal.Delayed Clash.Explicit.SimIO
    Clash.Explicit.Synchronizer Clash.Explicit.Testbench
    Clash.HaskellPrelude Clash.Hidden Clash.Intel.ClockGen
    Clash.Intel.DDR Clash.Magic Clash.NamedTypes Clash.Prelude
    Clash.Prelude.BitIndex Clash.Prelude.BitReduction
    Clash.Prelude.BlockRam Clash.Prelude.BlockRam.File
    Clash.Prelude.DataFlow Clash.Prelude.Mealy Clash.Prelude.Moore
    Clash.Prelude.RAM Clash.Prelude.ROM Clash.Prelude.ROM.File
    Clash.Prelude.Safe Clash.Prelude.Testbench Clash.Promoted.Nat
    Clash.Promoted.Nat.Literals Clash.Promoted.Nat.TH
    Clash.Promoted.Nat.Unsafe Clash.Promoted.Symbol Clash.Signal
    Clash.Signal.BiSignal Clash.Signal.Bundle Clash.Signal.Delayed
    Clash.Signal.Delayed.Bundle Clash.Signal.Delayed.Internal
    Clash.Signal.Internal Clash.Signal.Internal.Ambiguous
    Clash.Signal.Trace Clash.Sized.BitVector Clash.Sized.Fixed
    Clash.Sized.Index Clash.Sized.Internal.BitVector
    Clash.Sized.Internal.Index Clash.Sized.Internal.Mod
    Clash.Sized.Internal.Signed Clash.Sized.Internal.Unsigned
    Clash.Sized.RTree Clash.Sized.Signed Clash.Sized.Unsigned
    Clash.Sized.Vector Clash.Tutorial Clash.XException
    Clash.XException.TH Clash.Xilinx.ClockGen Clash.Xilinx.DDR

hidden-modules:
    Clash.Class.AutoReg.Instances Clash.Class.AutoReg.Internal
    Clash.Class.BitPack.Internal Clash.CPP Clash.Examples.Internal
    Clash.Signal.Bundle.Internal Language.Haskell.TH.Compat
    Paths_clash_prelude

import-dirs:          /usr/lib/ghc-8.10.2/site-local/clash-prelude-1.2.5
library-dirs:         /usr/lib/ghc-8.10.2/site-local/clash-prelude-1.2.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.2/clash-prelude-1.2.5
hs-libraries:         HSclash-prelude-1.2.5-9vVnr6snCPAA4x59VhcBTz
depends:
    QuickCheck-2.14.2-ARY5VhnqZvrLWt5AtS7Ok6 array-0.5.4.0
    base-4.14.1.0 bifunctors-5.5.8-EY8llczdNCq37wcxyT4W5Q
    binary-0.8.8.0 bytestring-0.10.10.0
    constraints-0.12-1co4zakfFOkI16bwhAR8q4 containers-0.6.2.1
    data-binary-ieee754-0.4.4-HlSlHq1qDaTKAKUZNW5rdz
    data-default-class-0.1.2.0-56BXPST0gStFZdhRwxhsn8 deepseq-1.4.4.0
    ghc-prim-0.6.1 ghc-typelits-extra-0.4.1-20CQekLjLpCK9SMIboSHYU
    ghc-typelits-knownnat-0.7.3-7O72yAU5NgrBiRgGhLVjEF
    ghc-typelits-natnormalise-0.7.2-3aaaIxam7Vi9MOD8GCYpg7
    half-0.3-DzLciZp3278BJF29zGVuVA
    hashable-1.3.0.0-uTeBoAQZ7BHIL2DWfxNGp integer-gmp-1.0.3.0
    interpolate-0.2.1-GPbY43LlYXO9QEaAuKfXx5
    lens-4.19.2-JSkoiVQrRhp9nCM2N7ftOG
    recursion-schemes-5.2.1-HOrKNm7lQ6PE7XIqBaP0ST
    reflection-2.1.6-I0DMW2ntL7L7JPqn2O0ZJU
    singletons-2.7-4dlbRxOhGpz4QM6QPctUZC template-haskell-2.16.0.0
    text-1.2.3.2 text-show-3.9-9VFWiy52H8UBNSxmCjDkNW
    th-abstraction-0.4.1.0-A7JgjUrazebFmefKqpqS0Q
    th-lift-0.8.2-KbqTijfzZAG4Np7SJXnjP2
    th-orphans-0.13.11-JRR0p8OVlnW8OSGfdzNFow time-1.9.3
    transformers-0.5.6.2 type-errors-0.2.0.0-fHHxh4OTroCW3XKBphRUC
    uniplate-1.6.13-47ZVHn3IldNJCXInR4tOsg
    vector-0.12.1.2-IO5RJnkQnAxDAG50LdixTd

haddock-interfaces:
    /usr/share/doc/haskell-clash-prelude/html/clash-prelude.haddock

haddock-html:         /usr/share/doc/haskell-clash-prelude/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

