#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 memory
version:              0.16.0
visibility:           public
id:                   memory-0.16.0-E1gXzMJzgEcJ8QhI9dLs6S
key:                  memory-0.16.0-E1gXzMJzgEcJ8QhI9dLs6S
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:
    vincent@snarc.org, Nicolas Di Prima <nicolas@primetype.co.uk>

author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/vincenthz/hs-memory
synopsis:             memory and related abstraction stuff
description:
    Chunk of memory, polymorphic byte array management and manipulation

    * A polymorphic byte array abstraction and function similar to strict ByteString.

    * Different type of byte array abstraction.

    * Raw memory IO operations (memory set, memory copy, ..)

    * Aliasing with endianness support.

    * Encoding : Base16, Base32, Base64.

    * Hashing : FNV, SipHash

category:             memory
abi:                  dcc8a09b9ace1a155e6e0effeeafc994
exposed:              True
exposed-modules:
    Data.ByteArray Data.ByteArray.Encoding Data.ByteArray.Hash
    Data.ByteArray.Mapping Data.ByteArray.Pack Data.ByteArray.Parse
    Data.ByteArray.Sized Data.Memory.Encoding.Base16
    Data.Memory.Encoding.Base32 Data.Memory.Encoding.Base64
    Data.Memory.Endian Data.Memory.ExtendedWords Data.Memory.PtrMethods

hidden-modules:
    Data.Memory.Internal.Compat Data.Memory.Internal.CompatPrim
    Data.Memory.Internal.CompatPrim64 Data.Memory.Internal.DeepSeq
    Data.Memory.Internal.Imports Data.Memory.Hash.SipHash
    Data.Memory.Hash.FNV Data.ByteArray.Pack.Internal
    Data.ByteArray.Types Data.ByteArray.Bytes
    Data.ByteArray.ScrubbedBytes Data.ByteArray.Methods
    Data.ByteArray.MemView Data.ByteArray.View Data.Memory.MemMap.Posix

import-dirs:          /usr/lib/ghc-8.10.5/site-local/memory-0.16.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/memory-0.16.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/memory-0.16.0
hs-libraries:         HSmemory-0.16.0-E1gXzMJzgEcJ8QhI9dLs6S
depends:
    base-4.14.2.0 basement-0.0.12-I5rgpQyLmajwT0dUlA8hE
    bytestring-0.10.12.0 deepseq-1.4.4.0 ghc-prim-0.6.1

haddock-interfaces:   /usr/share/doc/haskell-memory/html/memory.haddock
haddock-html:         /usr/share/doc/haskell-memory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

