#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 monad-control
version:              1.0.2.3
visibility:           public
id:                   monad-control-1.0.2.3-Bi4GOATU8bxGtDgK1rR68J
key:                  monad-control-1.0.2.3-Bi4GOATU8bxGtDgK1rR68J
license:              BSD-3-Clause
copyright:            (c) 2011 Bas van Dijk, Anders Kaseorg
maintainer:           Bas van Dijk <v.dijk.bas@gmail.com>
author:               Bas van Dijk, Anders Kaseorg
homepage:             https://github.com/basvandijk/monad-control
synopsis:
    Lift control operations, like exception catching, through monad transformers

description:
    This package defines the type class @MonadBaseControl@, a subset of
    @MonadBase@ into which generic control operations such as @catch@ can be
    lifted from @IO@ or any other base monad. Instances are based on monad
    transformers in @MonadTransControl@, which includes all standard monad
    transformers in the @transformers@ library except @ContT@.

    See the <http://hackage.haskell.org/package/lifted-base lifted-base>
    package which uses @monad-control@ to lift @IO@
    operations from the @base@ library (like @catch@ or @bracket@) into any monad
    that is an instance of @MonadBase@ or @MonadBaseControl@.

    Note that this package is a rewrite of Anders Kaseorg'\''s @monad-peel@
    library. The main difference is that this package provides CPS style operators
    and exploits the @RankNTypes@ and @TypeFamilies@ language extensions to
    simplify and speedup most definitions.

category:             Control
abi:                  57ec533d26880c2e794f86bd548a4277
exposed:              True
exposed-modules:      Control.Monad.Trans.Control
import-dirs:          /usr/lib/ghc-8.10.5/site-local/monad-control-1.0.2.3
library-dirs:         /usr/lib/ghc-8.10.5/site-local/monad-control-1.0.2.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/monad-control-1.0.2.3
hs-libraries:         HSmonad-control-1.0.2.3-Bi4GOATU8bxGtDgK1rR68J
depends:
    base-4.14.2.0 stm-2.5.0.1 transformers-0.5.6.2
    transformers-base-0.4.5.2-KzHjyAKDkdpHt6juu1Rjxn
    transformers-compat-0.6.6-8xD7tdhdla21VYsnm1hEvk

haddock-interfaces:
    /usr/share/doc/haskell-monad-control/html/monad-control.haddock

haddock-html:         /usr/share/doc/haskell-monad-control/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

