#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 optics-core
version:              0.4
visibility:           public
id:                   optics-core-0.4-ASCFnMeArQt2z7PKRP4hO3
key:                  optics-core-0.4-ASCFnMeArQt2z7PKRP4hO3
license:              BSD-3-Clause
maintainer:           optics@well-typed.com
author:               Adam Gundry, Andres Löh, Andrzej Rybczak, Oleg Grenrus
synopsis:             Optics as an abstract interface: core definitions
description:
    This package makes it possible to define and use Lenses, Traversals, Prisms
    and other optics, using an abstract interface.

    This variant provides core definitions with a minimal dependency footprint.
    See the @<https://hackage.haskell.org/package/optics optics>@ package (and its
    dependencies) for documentation and the "batteries-included" variant.

category:             Data, Optics, Lenses
abi:                  ad3e1a094c60552dfab372f65fa9780b
exposed:              True
exposed-modules:
    Data.Either.Optics Data.IntMap.Optics Data.IntSet.Optics
    Data.List.Optics Data.Map.Optics Data.Maybe.Optics
    Data.Sequence.Optics Data.Set.Optics Data.Tree.Optics
    Data.Tuple.Optics Data.Typeable.Optics GHC.Generics.Optics
    Numeric.Optics Optics.AffineFold Optics.AffineTraversal
    Optics.Arrow Optics.At.Core Optics.Coerce Optics.Cons.Core
    Optics.Core Optics.Each.Core Optics.Empty.Core Optics.Fold
    Optics.Generic Optics.Getter Optics.Indexed.Core Optics.Internal.Bi
    Optics.Internal.Fold Optics.Internal.Generic
    Optics.Internal.Generic.TypeLevel Optics.Internal.Indexed
    Optics.Internal.Indexed.Classes Optics.Internal.IxFold
    Optics.Internal.IxSetter Optics.Internal.IxTraversal
    Optics.Internal.Magic Optics.Internal.Optic
    Optics.Internal.Optic.Subtyping Optics.Internal.Optic.TypeLevel
    Optics.Internal.Optic.Types Optics.Internal.Setter
    Optics.Internal.Traversal Optics.Internal.Utils Optics.Iso
    Optics.IxAffineFold Optics.IxAffineTraversal Optics.IxFold
    Optics.IxGetter Optics.IxLens Optics.IxSetter Optics.IxTraversal
    Optics.Label Optics.Lens Optics.Mapping Optics.Operators
    Optics.Operators.Unsafe Optics.Optic Optics.Prism Optics.Re
    Optics.ReadOnly Optics.ReversedLens Optics.ReversedPrism
    Optics.Review Optics.Setter Optics.Traversal

import-dirs:          /usr/lib/ghc-8.10.5/site-local/optics-core-0.4
library-dirs:         /usr/lib/ghc-8.10.5/site-local/optics-core-0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/optics-core-0.4
hs-libraries:         HSoptics-core-0.4-ASCFnMeArQt2z7PKRP4hO3
depends:
    array-0.5.4.0 base-4.14.2.0 containers-0.6.4.1
    indexed-profunctors-0.1.1-BHGNHi6ZLuyCTtTgkvdNcW
    indexed-traversable-0.1.1-1Z2GfU1EWlL3ZzMnGNHsA4
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-optics-core/html/optics-core.haddock
haddock-html:         /usr/share/doc/haskell-optics-core/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

