#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-theory
version:              1.6.0
visibility:           public
id:                   tamarin-prover-theory-1.6.0-9gGDoVwDk2A5tofIVNCYRb
key:                  tamarin-prover-theory-1.6.0-9gGDoVwDk2A5tofIVNCYRb
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018

maintainer:
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Security protocol types and constraint solver library for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides the types to represent security
    protocols, and it implements the constraint solver.

category:             Theorem Provers
abi:                  c6aacedcf5bc192afd389956333b1d50
exposed:              True
exposed-modules:
    Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.Heuristics
    Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.System Theory.Constraint.System.Constraints
    Theory.Constraint.System.Dot Theory.Constraint.System.Guarded
    Theory.Constraint.System.JSON Theory.Model Theory.Model.Atom
    Theory.Model.Fact Theory.Model.Formula Theory.Model.Restriction
    Theory.Model.Rule Theory.Model.Signature Theory.Proof Theory.Sapic
    Theory.Sapic.Print Theory.Text.Parser Theory.Text.Parser.Token
    Theory.Text.Pretty Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.RuleVariants Theory.Tools.Wellformedness

import-dirs:          /usr/lib/ghc-8.10.5/site-local/tamarin-prover-theory-1.6.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/tamarin-prover-theory-1.6.0
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/i386-linux-ghc-8.10.5/tamarin-prover-theory-1.6.0

hs-libraries:         HStamarin-prover-theory-1.6.0-9gGDoVwDk2A5tofIVNCYRb
depends:
    aeson-1.5.6.0-IA546NaLWlLGqcowhw6tTs
    aeson-pretty-0.8.8-7Y85LeXJfbRBFaLbPECV89 base-4.14.2.0
    binary-0.8.8.0 bytestring-0.10.12.0 containers-0.6.4.1
    deepseq-1.4.4.0 dlist-1.0-AY7L3vPTTCQEIACGjuCugq exceptions-0.10.4
    fclabels-2.0.5.1-FSncE8vc2bkLN1piqQd8cc mtl-2.2.2
    parallel-3.2.2.0-H513jAs1HA11zQonYV0DH5 parsec-3.1.14.0
    process-1.6.9.0 safe-0.3.19-DlKvqLTtraZKItu5PR3KBM
    tamarin-prover-term-1.6.0-8OSwa2d3yxZG88e0eAH0VK
    tamarin-prover-utils-1.6.0-EieUoQz9U5P995WMJxZ9E4 text-1.2.4.1
    transformers-0.5.6.2 uniplate-1.6.13-HvGjBVisCmDIIHRdDwqYqK

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

