#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 idris
version:              1.3.3
visibility:           public
id:                   idris-1.3.3-92D44UcWBvm9YsekpDTOcj
key:                  idris-1.3.3-92D44UcWBvm9YsekpDTOcj
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  feefbf3255f7ba272a2b659c760e335d
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-8.10.2/site-local/idris-1.3.3
library-dirs:         /usr/lib/ghc-8.10.2/site-local/idris-1.3.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.3-92D44UcWBvm9YsekpDTOcj
extra-libraries:      gmp
depends:
    aeson-1.5.5.1-7ZKmq9KLIncxnBfAj9HU2
    annotated-wl-pprint-0.7.0-HXu68S9Nys8Hg2W61VXV5e
    ansi-terminal-0.11-2SXi8ZhU18i2uWLidRUotS
    ansi-wl-pprint-0.6.9-4tU0KPt7JPA3kQcTPEEEXE array-0.5.4.0
    async-2.2.2-6WjYHdzpa4C5cwFlX6aJ0s base-4.14.1.0
    base64-bytestring-1.2.0.1-Fdadxgck2fY14EcGX9uAqX binary-0.8.8.0
    blaze-html-0.9.1.2-2CxRFZ3pUcb2942dceW5fY
    blaze-markup-0.8.2.7-LxYHHNtMMqd23FQvjJOkWQ bytestring-0.10.10.0
    cheapskate-0.1.1.2-HbgPxajPd17HA0EVQf1mhU
    code-page-0.2-1lNAShZKBs0E8I4pr7cPwp containers-0.6.2.1
    deepseq-1.4.4.0 directory-1.3.6.0 filepath-1.4.2.1
    fingertree-0.1.4.2-ATIKmKT6oB8Bf5TzSBYZaY
    fsnotify-0.3.0.1-GwlN3WgKN4aCOcGWdITfh8 haskeline-0.8.0.1
    ieee754-0.8.0-Fa1NJsiKKLb2eXdrTUzFMJ
    libffi-0.1-2J6Lt4ad2928yARSk026UU
    megaparsec-9.0.1-7ezJya5FEus11KMFfvxnu7 mtl-2.2.2
    network-3.1.2.1-Gpsuc7SHQHF6OBh84JF5QV
    optparse-applicative-0.16.1.0-JDPEASK1GJS1Nsq2qjjZCq
    parser-combinators-1.2.1-BgKMLJR8mPH8EvrPvvjrd8 pretty-1.1.3.6
    process-1.6.9.0 regex-tdfa-1.3.1.0-AFxBgVqbB6pDA5wu8Xc5xC
    safe-0.3.19-AfrHSVViU1189qUhjBUb5b
    split-0.2.3.4-Z2AXpm9hdZ9RE4TCf1ynQ
    terminal-size-0.3.2.1-HihNy0RThZk4O1UkYpAxTd text-1.2.3.2
    time-1.9.3 transformers-0.5.6.2
    uniplate-1.6.13-7INy05orCDcAnhbIyEZVqc unix-2.7.2.2
    unordered-containers-0.2.13.0-HeBOjfSts31GSj9apQxnyX
    utf8-string-1.0.2-HUqQmSn9IO47m4xMtrZfHc
    vector-0.12.1.2-IO5RJnkQnAxDAG50LdixTd
    vector-binary-instances-0.2.5.1-DH3txoLgwZx8DyU0b9wM1l
    zip-archive-0.4.1-8cjseWOU4vfITwHqyeE64q

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

