/*******************************************************************************
* Copyright 2014-2022 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

#ifndef VERYBASICPROFILER_HPP
#define VERYBASICPROFILER_HPP

#include <string>
#include <vector>
#ifndef HPCG_NO_MPI
#include <mpi.h>
#endif

/*!
  To be used with chrome::/tracing
*/
class VeryBasicProfiler {
#ifdef BASIC_PROFILING
public:
#ifdef HPCG_NO_MPI
    VeryBasicProfiler();
#else
    VeryBasicProfiler(MPI_Comm comm);
#endif
    ~VeryBasicProfiler() { }

    void begin(const std::string& name);
    void end(const std::string& end);

    void Clear();
    void Write(const std::string& filename);

private:
    int rank_;
    int size_;
    std::vector<std::string> names_;
    std::vector<int> begin_end_;  // should be an enum, I am lazy
    std::vector<double> timestamps_;
#endif
};

#endif // VERYBASICPROFILER_HPP
