/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.TimeComboBox;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;

class OverviewTab
extends Tab {
    JPanel gridPanel;
    TimeComboBox timeComboBox;

    public static String getTabName() {
        return Messages.OVERVIEW;
    }

    public OverviewTab(VMPanel vmPanel) {
        super(vmPanel, OverviewTab.getTabName());
        this.setBorder(new EmptyBorder(4, 4, 3, 4));
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        this.add((Component)topPanel, "North");
        JPanel controlPanel = new JPanel(new FlowLayout(1, 20, 5));
        topPanel.add((Component)controlPanel, "Center");
        this.timeComboBox = new TimeComboBox(new Plotter[0]);
        LabeledComponent lc = new LabeledComponent(Messages.TIME_RANGE_COLON, Resources.getMnemonicInt(Messages.TIME_RANGE_COLON), this.timeComboBox);
        controlPanel.add(lc);
        this.gridPanel = new JPanel(new AutoGridLayout(10, 6));
        this.gridPanel.setBorder(null);
        JScrollPane sp = new JScrollPane(this.gridPanel);
        sp.setBorder(null);
        sp.setViewportBorder(null);
        this.add((Component)sp, "Center");
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return new SwingWorker<Object, Object>(){

            @Override
            public Object doInBackground() {
                return null;
            }

            @Override
            protected void done() {
                if (OverviewTab.this.gridPanel.getComponentCount() == 0) {
                    final ArrayList<Plotter> plotters = new ArrayList<Plotter>();
                    for (Tab tab : OverviewTab.this.vmPanel.getTabs()) {
                        OverviewPanel[] ops = tab.getOverviewPanels();
                        if (ops == null) continue;
                        for (OverviewPanel op : ops) {
                            OverviewTab.this.gridPanel.add(op);
                            Plotter plotter = op.getPlotter();
                            if (plotter == null) continue;
                            plotters.add(plotter);
                            OverviewTab.this.timeComboBox.addPlotter(plotter);
                        }
                    }
                    if (plotters.size() > 0) {
                        OverviewTab.this.workerAdd(new Runnable(){

                            @Override
                            public void run() {
                                ProxyClient proxyClient = OverviewTab.this.vmPanel.getProxyClient();
                                for (Plotter plotter : plotters) {
                                    proxyClient.addWeakPropertyChangeListener(plotter);
                                }
                            }
                        });
                    }
                    if (OverviewTab.this.getParent() instanceof JTabbedPane) {
                        Utilities.updateTransparency((JTabbedPane)OverviewTab.this.getParent());
                    }
                }
            }
        };
    }

    private class AutoGridLayout
    extends GridLayout {
        public AutoGridLayout(int hGap, int vGap) {
            super(0, 1, hGap, vGap);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            this.updateColumns(parent);
            return super.minimumLayoutSize(parent);
        }

        private void updateColumns(Container parent) {
            int maxCols;
            int parentWidth = OverviewTab.this.getWidth();
            int columnWidth = 1;
            for (Component c : parent.getComponents()) {
                columnWidth = Math.max(columnWidth, c.getPreferredSize().width);
            }
            int n = parent.getComponentCount();
            for (int columns = maxCols = Math.min(n, parentWidth / columnWidth); columns >= 1; --columns) {
                if (columns == 1) {
                    this.setColumns(maxCols);
                    continue;
                }
                if (n % columns != 0) continue;
                this.setColumns(columns);
                break;
            }
        }
    }
}

