/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.EventObject;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.inspector.ThreadDialog;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XTable;
import sun.tools.jconsole.inspector.XTextFieldEditor;

public class XMBeanAttributes
extends XTable {
    final Logger LOGGER = Logger.getLogger(XMBeanAttributes.class.getPackage().getName());
    private static final String[] columnNames = new String[]{Messages.NAME, Messages.VALUE};
    private XMBean mbean;
    private MBeanInfo mbeanInfo;
    private MBeanAttributeInfo[] attributesInfo;
    private HashMap<String, Object> attributes;
    private HashMap<String, Object> unavailableAttributes;
    private HashMap<String, Object> viewableAttributes;
    private WeakHashMap<XMBean, HashMap<String, ZoomedCell>> viewersCache = new WeakHashMap();
    private final TableModelListener attributesListener;
    private MBeansTab mbeansTab;
    private TableCellEditor valueCellEditor = new ValueCellEditor();
    private int rowMinHeight = -1;
    private AttributesMouseListener mouseListener = new AttributesMouseListener();
    private static TableCellEditor editor = new Utils.ReadOnlyTableCellEditor(new JTextField());

    public XMBeanAttributes(MBeansTab mbeansTab) {
        this.mbeansTab = mbeansTab;
        ((DefaultTableModel)this.getModel()).setColumnIdentifiers(columnNames);
        this.attributesListener = new AttributesListener(this);
        this.getModel().addTableModelListener(this.attributesListener);
        this.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.addMouseListener(this.mouseListener);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnEditors();
        this.addKeyListener(new Utils.CopyKeyAdapter());
    }

    @Override
    public synchronized Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        if (row >= this.getRowCount()) {
            return null;
        }
        return super.prepareRenderer(renderer, row, column);
    }

    void updateRowHeight(Object obj, int row) {
        ZoomedCell cell = null;
        if (obj instanceof ZoomedCell) {
            cell = (ZoomedCell)obj;
            if (cell.isInited()) {
                this.setRowHeight(row, cell.getHeight());
            } else if (this.rowMinHeight != -1) {
                this.setRowHeight(row, this.rowMinHeight);
            }
        } else if (this.rowMinHeight != -1) {
            this.setRowHeight(row, this.rowMinHeight);
        }
    }

    @Override
    public synchronized TableCellRenderer getCellRenderer(int row, int column) {
        ZoomedCell cell;
        Object obj;
        if (row >= this.getRowCount()) {
            return null;
        }
        if (column == 1 && (obj = this.getModel().getValueAt(row, column)) instanceof ZoomedCell && (cell = (ZoomedCell)obj).isInited()) {
            DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)cell.getRenderer();
            renderer.setToolTipText(this.getToolTip(row, column));
            return renderer;
        }
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)super.getCellRenderer(row, column);
        if (!(this.isCellError(row, column) || this.isColumnEditable(column) && this.isWritable(row) && Utils.isEditableType(this.getClassName(row)))) {
            renderer.setForeground(this.getDefaultColor());
        }
        return renderer;
    }

    private void setColumnEditors() {
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < columnNames.length; ++i) {
            TableColumn tc = tcm.getColumn(i);
            if (this.isColumnEditable(i)) {
                tc.setCellEditor(this.valueCellEditor);
                continue;
            }
            tc.setCellEditor(editor);
        }
    }

    public void cancelCellEditing() {
        TableCellEditor tableCellEditor;
        if (this.LOGGER.isLoggable(Level.FINER)) {
            this.LOGGER.finer("Cancel Editing Row: " + this.getEditingRow());
        }
        if ((tableCellEditor = this.getCellEditor()) != null) {
            tableCellEditor.cancelCellEditing();
        }
    }

    public void stopCellEditing() {
        TableCellEditor tableCellEditor;
        if (this.LOGGER.isLoggable(Level.FINER)) {
            this.LOGGER.finer("Stop Editing Row: " + this.getEditingRow());
        }
        if ((tableCellEditor = this.getCellEditor()) != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    @Override
    public final boolean editCellAt(int row, int column, EventObject e) {
        TableCellEditor tableCellEditor;
        boolean retVal;
        if (this.LOGGER.isLoggable(Level.FINER)) {
            this.LOGGER.finer("editCellAt(row=" + row + ", col=" + column + ", e=" + e + ")");
        }
        if (JConsole.isDebug()) {
            System.err.println("edit: " + this.getValueName(row) + "=" + this.getValue(row));
        }
        if ((retVal = super.editCellAt(row, column, e)) && (tableCellEditor = this.getColumnModel().getColumn(column).getCellEditor()) == this.valueCellEditor) {
            ((JComponent)((Object)tableCellEditor)).requestFocus();
        }
        return retVal;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.isColumnEditable(col)) {
            return true;
        }
        Object obj = this.getModel().getValueAt(row, col);
        if (obj instanceof ZoomedCell) {
            ZoomedCell cell = (ZoomedCell)obj;
            return cell.isMaximized();
        }
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (!this.isCellError(row, column) && this.isColumnEditable(column) && this.isWritable(row) && Utils.isEditableType(this.getClassName(row))) {
            if (JConsole.isDebug()) {
                System.err.println("validating [row=" + row + ", column=" + column + "]: " + this.getValueName(row) + "=" + value);
            }
            super.setValueAt(value, row, column);
        }
    }

    @Override
    public boolean isTableEditable() {
        return true;
    }

    @Override
    public void setTableValue(Object value, int row) {
    }

    @Override
    public boolean isColumnEditable(int column) {
        if (column < this.getColumnCount()) {
            return this.getColumnName(column).equals(Messages.VALUE);
        }
        return false;
    }

    @Override
    public String getClassName(int row) {
        int index = this.convertRowToIndex(row);
        if (index != -1) {
            return this.attributesInfo[index].getType();
        }
        return null;
    }

    @Override
    public String getValueName(int row) {
        int index = this.convertRowToIndex(row);
        if (index != -1) {
            return this.attributesInfo[index].getName();
        }
        return null;
    }

    @Override
    public Object getValue(int row) {
        Object val = ((DefaultTableModel)this.getModel()).getValueAt(row, 1);
        return val;
    }

    @Override
    public String getToolTip(int row, int column) {
        int index;
        if (this.isCellError(row, column)) {
            return (String)this.unavailableAttributes.get(this.getValueName(row));
        }
        if (this.isColumnEditable(column)) {
            Object value = this.getValue(row);
            String tip = null;
            if (value != null) {
                tip = value.toString();
                if (this.isAttributeViewable(row, 1)) {
                    tip = Messages.DOUBLE_CLICK_TO_EXPAND_FORWARD_SLASH_COLLAPSE + ". " + tip;
                }
            }
            return tip;
        }
        if (column == 0 && (index = this.convertRowToIndex(row)) != -1) {
            return this.attributesInfo[index].getDescription();
        }
        return null;
    }

    @Override
    public synchronized boolean isWritable(int row) {
        int index = this.convertRowToIndex(row);
        if (index != -1) {
            return this.attributesInfo[index].isWritable();
        }
        return false;
    }

    @Override
    public synchronized int getRowCount() {
        return super.getRowCount();
    }

    @Override
    public synchronized boolean isReadable(int row) {
        int index = this.convertRowToIndex(row);
        if (index != -1) {
            return this.attributesInfo[index].isReadable();
        }
        return false;
    }

    @Override
    public synchronized boolean isCellError(int row, int col) {
        return this.isColumnEditable(col) && this.unavailableAttributes.containsKey(this.getValueName(row));
    }

    @Override
    public synchronized boolean isAttributeViewable(int row, int col) {
        Object obj;
        boolean isViewable = false;
        if (col == 1 && (obj = this.getModel().getValueAt(row, col)) instanceof ZoomedCell) {
            isViewable = true;
        }
        return isViewable;
    }

    public void loadAttributes(final XMBean mbean, final MBeanInfo mbeanInfo) {
        SwingWorker<Runnable, Void> load = new SwingWorker<Runnable, Void>(){

            @Override
            protected Runnable doInBackground() throws Exception {
                return XMBeanAttributes.this.doLoadAttributes(mbean, mbeanInfo);
            }

            @Override
            protected void done() {
                block6: {
                    try {
                        Runnable updateUI = (Runnable)this.get();
                        if (updateUI != null) {
                            updateUI.run();
                        }
                    }
                    catch (RuntimeException x) {
                        throw x;
                    }
                    catch (ExecutionException x) {
                        if (JConsole.isDebug()) {
                            System.err.println("Exception raised while loading attributes: " + x.getCause());
                            x.printStackTrace();
                        }
                    }
                    catch (InterruptedException x) {
                        if (!JConsole.isDebug()) break block6;
                        System.err.println("Interrupted while loading attributes: " + x);
                        x.printStackTrace();
                    }
                }
            }
        };
        this.mbeansTab.workerAdd(load);
    }

    private Runnable doLoadAttributes(final XMBean mbean, MBeanInfo infoOrNull) throws JMException, IOException {
        HashMap<String, Object> viewableAttrs;
        HashMap<String, String> unavailableAttrs;
        HashMap<String, Object> attrs;
        MBeanAttributeInfo[] attrsInfo;
        MBeanInfo curMBeanInfo;
        block15: {
            MBeanAttributeInfo attributeInfo;
            int i;
            if (mbean == null) {
                return null;
            }
            curMBeanInfo = infoOrNull == null ? mbean.getMBeanInfo() : infoOrNull;
            attrsInfo = curMBeanInfo.getAttributes();
            attrs = new HashMap<String, Object>(attrsInfo.length);
            unavailableAttrs = new HashMap<String, String>(attrsInfo.length);
            viewableAttrs = new HashMap<String, Object>(attrsInfo.length);
            AttributeList list = null;
            try {
                list = mbean.getAttributes(attrsInfo);
            }
            catch (Exception e) {
                if (JConsole.isDebug()) {
                    System.err.println("Error calling getAttributes() on MBean \"" + mbean.getObjectName() + "\". JConsole will " + "try to get them individually calling " + "getAttribute() instead. Exception:");
                    e.printStackTrace(System.err);
                }
                list = new AttributeList();
                for (i = 0; i < attrsInfo.length; ++i) {
                    String name = null;
                    try {
                        name = attrsInfo[i].getName();
                        Object value = mbean.getMBeanServerConnection().getAttribute(mbean.getObjectName(), name);
                        list.add(new Attribute(name, value));
                        continue;
                    }
                    catch (Exception ex) {
                        if (!attrsInfo[i].isReadable()) continue;
                        unavailableAttrs.put(name, Utils.getActualException(ex).toString());
                    }
                }
            }
            try {
                int att_length = list.size();
                for (i = 0; i < att_length; ++i) {
                    Attribute attribute = (Attribute)list.get(i);
                    if (this.isViewable(attribute)) {
                        viewableAttrs.put(attribute.getName(), attribute.getValue());
                        continue;
                    }
                    attrs.put(attribute.getName(), attribute.getValue());
                }
                if (att_length >= attrsInfo.length) break block15;
                for (i = 0; i < attrsInfo.length; ++i) {
                    attributeInfo = attrsInfo[i];
                    if (attrs.containsKey(attributeInfo.getName()) || viewableAttrs.containsKey(attributeInfo.getName()) || unavailableAttrs.containsKey(attributeInfo.getName()) || !attributeInfo.isReadable()) continue;
                    try {
                        Object v = mbean.getMBeanServerConnection().getAttribute(mbean.getObjectName(), attributeInfo.getName());
                        attrs.put(attributeInfo.getName(), v);
                        continue;
                    }
                    catch (Exception e) {
                        unavailableAttrs.put(attributeInfo.getName(), Utils.getActualException(e).toString());
                    }
                }
            }
            catch (Exception e) {
                for (i = 0; i < attrsInfo.length; ++i) {
                    attributeInfo = attrsInfo[i];
                    if (!attributeInfo.isReadable()) continue;
                    unavailableAttrs.put(attributeInfo.getName(), Utils.getActualException(e).toString());
                }
            }
        }
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                XMBeanAttributes xMBeanAttributes = XMBeanAttributes.this;
                synchronized (xMBeanAttributes) {
                    XMBeanAttributes.this.mbean = mbean;
                    XMBeanAttributes.this.mbeanInfo = curMBeanInfo;
                    XMBeanAttributes.access$302(XMBeanAttributes.this, attrsInfo);
                    XMBeanAttributes.this.attributes = attrs;
                    XMBeanAttributes.this.unavailableAttributes = unavailableAttrs;
                    XMBeanAttributes.this.viewableAttributes = viewableAttrs;
                    DefaultTableModel tableModel = (DefaultTableModel)XMBeanAttributes.this.getModel();
                    XMBeanAttributes.this.emptyTable(tableModel);
                    XMBeanAttributes.this.addTableData(tableModel, mbean, attrsInfo, attrs, unavailableAttrs, viewableAttrs);
                    tableModel.newDataAvailable(new TableModelEvent(tableModel));
                    tableModel.addTableModelListener(XMBeanAttributes.this.attributesListener);
                }
            }
        };
    }

    void collapse(String attributeName, Component c) {
        int row = this.getSelectedRow();
        Object obj = this.getModel().getValueAt(row, 1);
        if (obj instanceof ZoomedCell) {
            this.cancelCellEditing();
            ZoomedCell cell = (ZoomedCell)obj;
            cell.reset();
            this.setRowHeight(row, cell.getHeight());
            this.editCellAt(row, 1);
            this.invalidate();
            this.repaint();
        }
    }

    ZoomedCell updateZoomedCell(int row, int col) {
        Object obj = this.getModel().getValueAt(row, 1);
        ZoomedCell cell = null;
        if (obj instanceof ZoomedCell) {
            cell = (ZoomedCell)obj;
            if (!cell.isInited()) {
                Object elem = cell.getValue();
                String attributeName = (String)this.getModel().getValueAt(row, 0);
                Component comp = this.mbeansTab.getDataViewer().createAttributeViewer(elem, this.mbean, attributeName, this);
                if (comp != null) {
                    if (this.rowMinHeight == -1) {
                        this.rowMinHeight = this.getRowHeight(row);
                    }
                    cell.init(super.getCellRenderer(row, col), comp, this.rowMinHeight);
                    XDataViewer.registerForMouseEvent(comp, this.mouseListener);
                } else {
                    return cell;
                }
            }
            cell.switchState();
            this.setRowHeight(row, cell.getHeight());
            if (!cell.isMaximized()) {
                this.cancelCellEditing();
                this.editCellAt(row, 1);
            }
            this.invalidate();
            this.repaint();
        }
        return cell;
    }

    public void refreshAttributes() {
        this.refreshAttributes(true);
    }

    private void refreshAttributes(final boolean stopCellEditing) {
        SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ProxyClient.SnapshotMBeanServerConnection mbsc = XMBeanAttributes.this.mbeansTab.getSnapshotMBeanServerConnection();
                mbsc.flush();
                return null;
            }

            @Override
            protected void done() {
                block3: {
                    try {
                        this.get();
                        if (stopCellEditing) {
                            XMBeanAttributes.this.stopCellEditing();
                        }
                        XMBeanAttributes.this.loadAttributes(XMBeanAttributes.this.mbean, XMBeanAttributes.this.mbeanInfo);
                    }
                    catch (Exception x) {
                        if (!JConsole.isDebug()) break block3;
                        x.printStackTrace();
                    }
                }
            }
        };
        this.mbeansTab.workerAdd(sw);
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        if (this.isEditing()) {
            this.stopCellEditing();
        }
        super.columnMarginChanged(e);
    }

    @Override
    void sortRequested(int column) {
        if (this.isEditing()) {
            this.stopCellEditing();
        }
        super.sortRequested(column);
    }

    @Override
    public synchronized void emptyTable() {
        this.emptyTable((DefaultTableModel)this.getModel());
    }

    private void emptyTable(DefaultTableModel model) {
        model.removeTableModelListener(this.attributesListener);
        super.emptyTable();
    }

    private boolean isViewable(Attribute attribute) {
        Object data = attribute.getValue();
        return XDataViewer.isViewableValue(data);
    }

    synchronized void removeAttributes() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
        if (this.unavailableAttributes != null) {
            this.unavailableAttributes.clear();
        }
        if (this.viewableAttributes != null) {
            this.viewableAttributes.clear();
        }
        this.mbean = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZoomedCell getZoomedCell(XMBean mbean, String attribute, Object value) {
        WeakHashMap<XMBean, HashMap<String, ZoomedCell>> weakHashMap = this.viewersCache;
        synchronized (weakHashMap) {
            ZoomedCell cell;
            HashMap<Object, Object> viewers = this.viewersCache.containsKey(mbean) ? this.viewersCache.get(mbean) : new HashMap();
            if (viewers.containsKey(attribute)) {
                cell = (ZoomedCell)viewers.get(attribute);
                cell.setValue(value);
                if (cell.isMaximized() && cell.getType() != 3) {
                    Component comp = this.mbeansTab.getDataViewer().createAttributeViewer(value, mbean, attribute, this);
                    cell.init(cell.getMinRenderer(), comp, cell.getMinHeight());
                    XDataViewer.registerForMouseEvent(comp, this.mouseListener);
                }
            } else {
                cell = new ZoomedCell(value);
                viewers.put(attribute, cell);
            }
            this.viewersCache.put(mbean, viewers);
            return cell;
        }
    }

    protected void addTableData(DefaultTableModel tableModel, XMBean mbean, MBeanAttributeInfo[] attributesInfo, HashMap<String, Object> attributes, HashMap<String, Object> unavailableAttributes, HashMap<String, Object> viewableAttributes) {
        Object[] rowData = new Object[2];
        int col1Width = 0;
        int col2Width = 0;
        for (int i = 0; i < attributesInfo.length; ++i) {
            rowData[0] = attributesInfo[i].getName();
            if (unavailableAttributes.containsKey(rowData[0])) {
                rowData[1] = Messages.UNAVAILABLE;
            } else if (viewableAttributes.containsKey(rowData[0])) {
                rowData[1] = viewableAttributes.get(rowData[0]);
                if (!attributesInfo[i].isWritable() || !Utils.isEditableType(attributesInfo[i].getType())) {
                    rowData[1] = this.getZoomedCell(mbean, (String)rowData[0], rowData[1]);
                }
            } else {
                rowData[1] = attributes.get(rowData[0]);
            }
            tableModel.addRow(rowData);
            String str = null;
            if (rowData[0] != null && (str = rowData[0].toString()).length() > col1Width) {
                col1Width = str.length();
            }
            if (rowData[1] == null || (str = rowData[1].toString()).length() <= col2Width) continue;
            col2Width = str.length();
        }
        this.updateColumnWidth(col1Width, col2Width);
    }

    private void updateColumnWidth(int col1Width, int col2Width) {
        TableColumnModel colModel = this.getColumnModel();
        if ((col1Width *= 7) + (col2Width *= 7) < (int)this.getPreferredScrollableViewportSize().getWidth()) {
            col2Width = (int)this.getPreferredScrollableViewportSize().getWidth() - col1Width;
        }
        colModel.getColumn(0).setPreferredWidth(50);
    }

    static /* synthetic */ MBeanAttributeInfo[] access$302(XMBeanAttributes x0, MBeanAttributeInfo[] x1) {
        x0.attributesInfo = x1;
        return x1;
    }

    class AttributesListener
    implements TableModelListener {
        private Component component;

        public AttributesListener(Component component) {
            this.component = component;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (XMBeanAttributes.this.isColumnEditable(e.getColumn())) {
                TableModel model = (TableModel)e.getSource();
                Object tableValue = model.getValueAt(e.getFirstRow(), e.getColumn());
                if (XMBeanAttributes.this.LOGGER.isLoggable(Level.FINER)) {
                    XMBeanAttributes.this.LOGGER.finer("tableChanged: firstRow=" + e.getFirstRow() + ", lastRow=" + e.getLastRow() + ", column=" + e.getColumn() + ", value=" + tableValue);
                }
                if (tableValue instanceof String) {
                    try {
                        tableValue = Utils.createObjectFromString(XMBeanAttributes.this.getClassName(e.getFirstRow()), (String)tableValue);
                    }
                    catch (Throwable ex) {
                        this.popupAndLog(ex, "tableChanged", Messages.PROBLEM_SETTING_ATTRIBUTE);
                    }
                }
                String attributeName = XMBeanAttributes.this.getValueName(e.getFirstRow());
                Attribute attribute = new Attribute(attributeName, tableValue);
                this.setAttribute(attribute, "tableChanged");
            }
        }

        private void setAttribute(final Attribute attribute, final String method) {
            SwingWorker<Void, Void> setAttribute = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        if (JConsole.isDebug()) {
                            System.err.println("setAttribute(" + attribute.getName() + "=" + attribute.getValue() + ")");
                        }
                        XMBeanAttributes.this.mbean.setAttribute(attribute);
                    }
                    catch (Throwable ex) {
                        AttributesListener.this.popupAndLog(ex, method, Messages.PROBLEM_SETTING_ATTRIBUTE);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    block2: {
                        try {
                            this.get();
                        }
                        catch (Exception x) {
                            if (!JConsole.isDebug()) break block2;
                            x.printStackTrace();
                        }
                    }
                    XMBeanAttributes.this.refreshAttributes(false);
                }
            };
            XMBeanAttributes.this.mbeansTab.workerAdd(setAttribute);
        }

        private void popupAndLog(Throwable ex, String method, String title) {
            ex = Utils.getActualException(ex);
            if (JConsole.isDebug()) {
                ex.printStackTrace();
            }
            String message = ex.getMessage() != null ? ex.getMessage() : ex.toString();
            EventQueue.invokeLater(new ThreadDialog(this.component, message + "\n", title, 0));
        }
    }

    class ZoomedCell {
        TableCellRenderer minRenderer;
        MaximizedCellRenderer maxRenderer;
        int minHeight;
        boolean minimized = true;
        boolean init = false;
        int type;
        Object value;

        ZoomedCell(Object value) {
            this.type = XDataViewer.getViewerType(value);
            this.value = value;
        }

        boolean isInited() {
            return this.init;
        }

        Object getValue() {
            return this.value;
        }

        void setValue(Object value) {
            this.value = value;
        }

        void init(TableCellRenderer minRenderer, Component maxComponent, int minHeight) {
            this.minRenderer = minRenderer;
            this.maxRenderer = new MaximizedCellRenderer(maxComponent);
            this.minHeight = minHeight;
            this.init = true;
        }

        int getType() {
            return this.type;
        }

        void reset() {
            this.init = false;
            this.minimized = true;
        }

        void switchState() {
            this.minimized = !this.minimized;
        }

        boolean isMaximized() {
            return !this.minimized;
        }

        void minimize() {
            this.minimized = true;
        }

        void maximize() {
            this.minimized = false;
        }

        int getHeight() {
            if (this.minimized) {
                return this.minHeight;
            }
            return (int)this.maxRenderer.getComponent().getPreferredSize().getHeight();
        }

        int getMinHeight() {
            return this.minHeight;
        }

        public String toString() {
            if (this.value == null) {
                return null;
            }
            if (this.value.getClass().isArray()) {
                String name = Utils.getArrayClassName(this.value.getClass().getName());
                int length = Array.getLength(this.value);
                return name + "[" + length + "]";
            }
            if (this.value instanceof CompositeData || this.value instanceof TabularData) {
                return this.value.getClass().getName();
            }
            return this.value.toString();
        }

        TableCellRenderer getRenderer() {
            if (this.minimized) {
                return this.minRenderer;
            }
            return this.maxRenderer;
        }

        TableCellRenderer getMinRenderer() {
            return this.minRenderer;
        }
    }

    class MaximizedCellRenderer
    extends DefaultTableCellRenderer {
        Component comp;

        MaximizedCellRenderer(Component comp) {
            this.comp = comp;
            Dimension d = comp.getPreferredSize();
            if (d.getHeight() > 220.0) {
                comp.setPreferredSize(new Dimension((int)d.getWidth(), 220));
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.comp;
        }

        public Component getComponent() {
            return this.comp;
        }
    }

    class ValueCellEditor
    extends XTextFieldEditor {
        ValueCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Object val = value;
            if (column == 1) {
                Object obj = XMBeanAttributes.this.getModel().getValueAt(row, column);
                if (obj instanceof ZoomedCell) {
                    ZoomedCell cell = (ZoomedCell)obj;
                    if (cell.getRenderer() instanceof MaximizedCellRenderer) {
                        MaximizedCellRenderer zr = (MaximizedCellRenderer)cell.getRenderer();
                        return zr.getComponent();
                    }
                } else {
                    Component comp = super.getTableCellEditorComponent(table, val, isSelected, row, column);
                    if (XMBeanAttributes.this.isCellError(row, column) || !XMBeanAttributes.this.isWritable(row) || !Utils.isEditableType(XMBeanAttributes.this.getClassName(row))) {
                        this.textField.setEditable(false);
                    }
                    return comp;
                }
            }
            return super.getTableCellEditorComponent(table, val, isSelected, row, column);
        }

        @Override
        public boolean stopCellEditing() {
            ZoomedCell cell;
            Object obj;
            int editingRow = XMBeanAttributes.this.getEditingRow();
            int editingColumn = XMBeanAttributes.this.getEditingColumn();
            if (editingColumn == 1 && (obj = XMBeanAttributes.this.getModel().getValueAt(editingRow, editingColumn)) instanceof ZoomedCell && (cell = (ZoomedCell)obj).isMaximized()) {
                this.cancelCellEditing();
                return true;
            }
            return super.stopCellEditing();
        }
    }

    class AttributesMouseListener
    extends MouseAdapter {
        AttributesMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() >= 2) {
                int row = XMBeanAttributes.this.getSelectedRow();
                int col = XMBeanAttributes.this.getSelectedColumn();
                if (col != 1) {
                    return;
                }
                if (col == -1 || row == -1) {
                    return;
                }
                XMBeanAttributes.this.updateZoomedCell(row, col);
            }
        }
    }
}

