/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.sparc.MemoryInstructionDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisterIndirectAddress;
import sun.jvm.hotspot.asm.sparc.SPARCV9InstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCV9RegisterIndirectAddress;
import sun.jvm.hotspot.asm.sparc.V9InstructionDecoder;

abstract class V9AlternateSpaceDecoder
extends MemoryInstructionDecoder
implements V9InstructionDecoder {
    V9AlternateSpaceDecoder(int op3, String name, int dataType) {
        super(op3, name, dataType);
    }

    @Override
    SPARCRegisterIndirectAddress newRegisterIndirectAddress(SPARCRegister rs1, SPARCRegister rs2) {
        return new SPARCV9RegisterIndirectAddress(rs1, rs2);
    }

    @Override
    SPARCRegisterIndirectAddress newRegisterIndirectAddress(SPARCRegister rs1, int offset) {
        return new SPARCV9RegisterIndirectAddress(rs1, offset);
    }

    abstract Instruction decodeV9AsiLoadStore(int var1, SPARCV9RegisterIndirectAddress var2, SPARCRegister var3, SPARCV9InstructionFactory var4);

    @Override
    Instruction decodeMemoryInstruction(int instruction, SPARCRegisterIndirectAddress addr, SPARCRegister rd, SPARCInstructionFactory factory) {
        SPARCV9RegisterIndirectAddress v9addr = (SPARCV9RegisterIndirectAddress)addr;
        if (V9AlternateSpaceDecoder.isIBitSet(instruction)) {
            v9addr.setIndirectAsi(true);
        } else {
            int asi = (instruction & 0x1FE0) >>> 5;
            v9addr.setAddressSpace(asi);
        }
        return this.decodeV9AsiLoadStore(instruction, v9addr, rd, (SPARCV9InstructionFactory)factory);
    }
}

