/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.asm.sparc.SPARCV9InstructionFactory;
import sun.jvm.hotspot.asm.sparc.V9CMoveDecoder;

class V9MOVrDecoder
extends V9CMoveDecoder {
    private static final String[] regConditionNames = new String[]{null, "movrz", "movrlez", "movrlz", null, "movrnz", "movrgz", "movrgez"};

    V9MOVrDecoder() {
    }

    private static String getMOVrName(int conditionCode) {
        return regConditionNames[conditionCode];
    }

    @Override
    Instruction decode(int instruction, SPARCInstructionFactory factory) {
        SPARCV9InstructionFactory v9factory = (SPARCV9InstructionFactory)factory;
        SPARCInstruction instr = null;
        int regConditionCode = V9MOVrDecoder.getRegisterConditionCode(instruction);
        String name = V9MOVrDecoder.getMOVrName(regConditionCode);
        if (name == null) {
            instr = v9factory.newIllegalInstruction(instruction);
        } else {
            int rdNum = V9MOVrDecoder.getDestinationRegister(instruction);
            SPARCRegister rd = SPARCRegisters.getRegister(rdNum);
            SPARCRegister rs1 = SPARCRegisters.getRegister(V9MOVrDecoder.getSourceRegister1(instruction));
            ImmediateOrRegister operand2 = V9MOVrDecoder.getCMoveSource(instruction, 10);
            instr = v9factory.newV9MOVrInstruction(name, rs1, operand2, rd, regConditionCode);
        }
        return instr;
    }
}

