/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.coroutine.CoroutineBlock;
import org.jetbrains.kotlin.js.coroutine.CoroutineBodyTransformer;
import org.jetbrains.kotlin.js.coroutine.CoroutinePassesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformationContext;
import org.jetbrains.kotlin.js.inline.clean.FunctionPostProcessor;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J4\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001fH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010!\u001a\u00020\u000eH\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u000eH\u0002J,\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00112\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001bH\u0002J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010(\u001a\b\u0012\u0004\u0012\u00020%0\u0011H\u0002J\f\u0010)\u001a\u00020\u0016*\u00020\u000bH\u0002J,\u0010*\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\u00120\u001b2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\"\u00100\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\u00120\u001b2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineFunctionTransformer;", "", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "name", "", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;Ljava/lang/String;)V", "innerFunction", "functionWithBody", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "localVariables", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "className", "transform", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "isTailCall", "", "transformSimple", "", "generateContinuationConstructor", "context", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;", "statements", "", "globalCatchBlockIndex", "", "survivingLocalVars", "", "generateCoroutinePrototype", "constructorName", "generateCoroutineMetadata", "generateDoResume", "coroutineBlocks", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "generateCoroutineInstantiation", "generateCoroutineBody", "blocks", "collectAdditionalLocalVariables", "assignToField", "fieldName", "value", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "psiElement", "Lcom/intellij/psi/PsiElement;", "assignToPrototype", "js.translator"})
@SourceDebugExtension(value={"SMAP\nCoroutineFunctionTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineFunctionTransformer.kt\norg/jetbrains/kotlin/js/coroutine/CoroutineFunctionTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1863#2,2:321\n1863#2,2:323\n1557#2:325\n1628#2,3:326\n1863#2,2:329\n1557#2:332\n1628#2,3:333\n1557#2:336\n1628#2,3:337\n1557#2:340\n1628#2,3:341\n1557#2:344\n1628#2,3:345\n1557#2:348\n1628#2,3:349\n1#3:331\n*S KotlinDebug\n*F\n+ 1 CoroutineFunctionTransformer.kt\norg/jetbrains/kotlin/js/coroutine/CoroutineFunctionTransformer\n*L\n50#1:321,2\n54#1:323,2\n57#1:325\n57#1:326,3\n58#1:329,2\n143#1:332\n143#1:333,3\n156#1:336\n156#1:337,3\n156#1:340\n156#1:341,3\n233#1:344\n233#1:345,3\n281#1:348\n281#1:349,3\n*E\n"})
public final class CoroutineFunctionTransformer {
    @NotNull
    private final JsFunction function;
    @Nullable
    private final JsFunction innerFunction;
    @NotNull
    private final JsFunction functionWithBody;
    @NotNull
    private final JsBlock body;
    @NotNull
    private final Set<JsName> localVariables;
    @NotNull
    private final JsName className;

    public CoroutineFunctionTransformer(@NotNull JsFunction function2, @Nullable String name2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        this.function = function2;
        this.innerFunction = FunctionUtilsKt.getInnerFunction(this.function);
        JsFunction jsFunction = this.innerFunction;
        if (jsFunction == null) {
            jsFunction = this.function;
        }
        this.functionWithBody = jsFunction;
        JsBlock jsBlock = this.functionWithBody.getBody();
        Intrinsics.checkNotNullExpressionValue(jsBlock, "getBody(...)");
        this.body = jsBlock;
        Set set = SetsKt.plus(CollectUtilsKt.collectLocalVariables$default(this.function, false, 1, null), CollectUtilsKt.collectLocalVariables$default(this.functionWithBody, false, 1, null));
        List<JsParameter> list = this.functionWithBody.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        this.localVariables = CollectionsKt.toMutableSet((Iterable)SetsKt.minus(set, CollectionsKt.last(list).getName()));
        StringBuilder stringBuilder = new StringBuilder().append("Coroutine$");
        String string2 = name2;
        if (string2 == null) {
            string2 = "anonymous";
        }
        JsName jsName = JsScope.declareTemporaryName(stringBuilder.append(string2).toString());
        Intrinsics.checkNotNullExpressionValue(jsName, "declareTemporaryName(...)");
        this.className = jsName;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JsStatement> transform() {
        Collection<JsName> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.isTailCall() && !MetadataProperties.getForceStateMachine(this.function)) {
            this.transformSimple();
            return CollectionsKt.emptyList();
        }
        JsFunctionScope jsFunctionScope = this.function.getScope();
        Intrinsics.checkNotNullExpressionValue(jsFunctionScope, "getScope(...)");
        CoroutineTransformationContext context2 = new CoroutineTransformationContext(jsFunctionScope, this.function);
        CoroutineBodyTransformer bodyTransformer = new CoroutineBodyTransformer(context2);
        bodyTransformer.preProcess(this.body);
        List<JsStatement> list = this.body.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement it = (JsStatement)element$iv;
            boolean bl = false;
            it.accept(bodyTransformer);
        }
        List<CoroutineBlock> coroutineBlocks = bodyTransformer.postProcess();
        int globalCatchBlockIndex = coroutineBlocks.indexOf(context2.getGlobalCatchBlock());
        Iterable $this$forEach$iv2 = coroutineBlocks;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CoroutineBlock it = (CoroutineBlock)element$iv;
            boolean bl = false;
            this.collectAdditionalLocalVariables(it.getJsBlock());
        }
        List<JsParameter> list2 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getParameters(...)");
        Iterable $i$f$forEach22 = list2;
        Set<JsName> set = this.localVariables;
        List<CoroutineBlock> list3 = coroutineBlocks;
        boolean $i$f$map = false;
        void element$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        Set<JsName> survivingLocalVars = CoroutinePassesKt.collectVariablesSurvivingBetweenBlocks(list3, set, CollectionsKt.toSet((Iterable)collection));
        Iterable $this$forEach$iv3 = coroutineBlocks;
        boolean $i$f$forEach3 = false;
        for (Object element$iv2 : $this$forEach$iv3) {
            CoroutineBlock it = (CoroutineBlock)element$iv2;
            boolean bl = false;
            CoroutinePassesKt.replaceLocalVariables(it.getJsBlock(), context2, survivingLocalVars);
        }
        List additionalStatements2 = new ArrayList();
        this.generateDoResume(coroutineBlocks, context2, additionalStatements2);
        this.generateContinuationConstructor(context2, additionalStatements2, globalCatchBlockIndex, survivingLocalVars);
        this.generateCoroutineInstantiation(context2);
        return additionalStatements2;
    }

    private final boolean isTailCall() {
        HashSet<JsExpression> suspendCalls = new HashSet<JsExpression>();
        this.body.accept(new RecursiveJsVisitor(suspendCalls){
            final /* synthetic */ HashSet<JsExpression> $suspendCalls;
            {
                this.$suspendCalls = $suspendCalls;
            }

            protected void visitElement(JsNode node) {
                Intrinsics.checkNotNullParameter(node, "node");
                if (node instanceof JsExpression && MetadataProperties.isSuspend((JsExpression)node)) {
                    ((Collection)this.$suspendCalls).add(node);
                }
                super.visitElement(node);
            }
        });
        if (suspendCalls.isEmpty()) {
            return true;
        }
        this.body.accept(new RecursiveJsVisitor(this, suspendCalls){
            final /* synthetic */ CoroutineFunctionTransformer this$0;
            final /* synthetic */ HashSet<JsExpression> $suspendCalls;
            {
                this.this$0 = $receiver;
                this.$suspendCalls = $suspendCalls;
            }

            public void visitBlock(JsBlock x) {
                block6: {
                    JsExpression suspendExpression;
                    block5: {
                        Intrinsics.checkNotNullParameter(x, "x");
                        super.visitBlock(x);
                        if (CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements().size() < 2) {
                            return;
                        }
                        List<JsStatement> list = CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements();
                        Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
                        JsStatement jsStatement = CollectionsKt.last(list);
                        JsReturn jsReturn = jsStatement instanceof JsReturn ? (JsReturn)jsStatement : null;
                        if (jsReturn == null) {
                            return;
                        }
                        JsReturn lastStatement = jsReturn;
                        if (!CoroutinePassesKt.isStateMachineResult(lastStatement.getExpression())) {
                            return;
                        }
                        List<JsStatement> list2 = CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements();
                        List<JsStatement> list3 = CoroutineFunctionTransformer.access$getBody$p(this.this$0).getStatements();
                        Intrinsics.checkNotNullExpressionValue(list3, "getStatements(...)");
                        JsStatement jsStatement2 = list2.get(CollectionsKt.getLastIndex(list3) - 1);
                        JsExpressionStatement jsExpressionStatement = jsStatement2 instanceof JsExpressionStatement ? (JsExpressionStatement)jsStatement2 : null;
                        if (jsExpressionStatement == null) {
                            return;
                        }
                        JsExpressionStatement statementBeforeLast = jsExpressionStatement;
                        JsExpression jsExpression = statementBeforeLast.getExpression();
                        Intrinsics.checkNotNullExpressionValue(jsExpression, "getExpression(...)");
                        suspendExpression = jsExpression;
                        if (!this.$suspendCalls.contains(suspendExpression)) break block5;
                        ((Collection)this.$suspendCalls).remove(suspendExpression);
                        break block6;
                    }
                    Pair<JsExpression, JsExpression> pair = JsAstUtils.decomposeAssignment(suspendExpression);
                    if (pair == null) break block6;
                    Pair<JsExpression, JsExpression> pair2 = pair;
                    HashSet<JsExpression> hashSet = this.$suspendCalls;
                    Pair<JsExpression, JsExpression> pair3 = pair2;
                    boolean bl = false;
                    JsExpression lhs = pair3.component1();
                    JsExpression rhs = pair3.component2();
                    if (hashSet.contains(rhs) && CoroutinePassesKt.isStateMachineResult(lhs)) {
                        ((Collection)hashSet).remove(rhs);
                    }
                }
            }
        });
        return suspendCalls.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void transformSimple() {
        void $this$transformSimple_u24lambda_u244;
        JsVars jsVars;
        List<JsParameter> list = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        JsParameter continuationParam = CollectionsKt.last(list);
        JsName jsName = JsScope.declareTemporaryName("$result");
        Intrinsics.checkNotNullExpressionValue(jsName, "declareTemporaryName(...)");
        JsName resultVar = jsName;
        Intrinsics.checkNotNull(continuationParam);
        CoroutinePassesKt.replaceSpecialReferencesInSimpleFunction(this.body, continuationParam, resultVar);
        JsVars jsVars2 = jsVars = JsAstUtils.newVar(resultVar, null);
        int n = 0;
        List<JsStatement> list2 = this.body.getStatements();
        boolean bl = false;
        Intrinsics.checkNotNull($this$transformSimple_u24lambda_u244);
        MetadataProperties.setSynthetic((HasMetadata)$this$transformSimple_u24lambda_u244, true);
        Unit unit = Unit.INSTANCE;
        list2.add(n, jsVars);
        new JsVisitorWithContextImpl(resultVar){
            final /* synthetic */ JsName $resultVar;
            {
                this.$resultVar = $resultVar;
            }

            public void endVisit(JsExpressionStatement x, JsContext<? super JsStatement> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "getExpression(...)");
                if (MetadataProperties.isSuspend(jsExpression)) {
                    ctx.replaceMe((JsNode)JsAstUtils.assignment(JsAstUtils.pureFqn(this.$resultVar, null), x.getExpression()).source(x.getSource()).makeStmt());
                }
                super.endVisit(x, ctx);
            }
        }.accept((JsNode)this.body);
        new FunctionPostProcessor(this.functionWithBody, null, 2, null).apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateContinuationConstructor(CoroutineTransformationContext context2, List<JsStatement> statements, int globalCatchBlockIndex, Set<? extends JsName> survivingLocalVars) {
        List list;
        List list2;
        Iterable $this$mapTo$iv$iv;
        JsName jsName;
        JsName lastParameter;
        Collection collection;
        void $this$mapTo$iv$iv2;
        PsiElement psiElement = context2.getMetadata().getPsiElement();
        JsFunction constructor2 = new JsFunction(this.function.getScope().getParent(), new JsBlock(), "Continuation");
        constructor2.setSource(psiElement);
        PsiElement psiElement2 = psiElement;
        Object object = psiElement2 != null ? UtilsKt.getFinalElement(psiElement2) : null;
        constructor2.getBody().setSource(object instanceof LeafPsiElement ? (LeafPsiElement)object : null);
        constructor2.setName(this.className);
        if (context2.getMetadata().getHasReceiver()) {
            List<JsParameter> list3 = constructor2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list3, "getParameters(...)");
            object = list3;
            object.add(new JsParameter(context2.getReceiverFieldName()));
        }
        List<JsParameter> list4 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list4, "getParameters(...)");
        Collection collection2 = list4;
        JsFunction jsFunction = this.innerFunction;
        List<JsParameter> list5 = jsFunction != null ? jsFunction.getParameters() : null;
        if (list5 == null) {
            list5 = CollectionsKt.emptyList();
        }
        List parameters = CollectionsKt.plus(collection2, (Iterable)list5);
        List<JsParameter> list6 = constructor2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list6, "getParameters(...)");
        Collection collection3 = list6;
        Iterable $this$map$iv = parameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new JsParameter(it.getName()));
        }
        $this$map$iv = (List)destination$iv$iv2;
        CollectionsKt.addAll(collection3, $this$map$iv);
        JsParameter jsParameter = (JsParameter)CollectionsKt.lastOrNull(parameters);
        JsName jsName2 = lastParameter = jsParameter != null ? jsParameter.getName() : null;
        if (context2.getMetadata().getHasController()) {
            JsName $this$generateContinuationConstructor_u24lambda_u246 = $i$f$map = JsScope.declareTemporaryName("controller");
            boolean bl = false;
            List<JsParameter> list7 = constructor2.getParameters();
            List<JsParameter> list8 = constructor2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list8, "getParameters(...)");
            list7.add(CollectionsKt.getLastIndex(list8), new JsParameter($this$generateContinuationConstructor_u24lambda_u246));
            jsName = $i$f$map;
        } else {
            jsName = null;
        }
        JsName controllerName = jsName;
        JsName jsName3 = lastParameter;
        Intrinsics.checkNotNull(jsName3);
        JsNameRef jsNameRef = jsName3.makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
        JsNameRef interceptorRef = jsNameRef;
        List<JsParameter> list9 = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list9, "getParameters(...)");
        Iterable $this$map$iv2 = list9;
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo222 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            JsParameter jsParameter2 = (JsParameter)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(((JsParameter)((Object)it)).getName());
        }
        Collection collection4 = (List)destination$iv$iv3;
        Object object2 = this.innerFunction;
        if (object2 != null && (object2 = ((JsFunction)object2).getParameters()) != null) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            $this$mapTo$iv$iv = (Iterable)object2;
            collection = collection4;
            boolean $i$f$map3 = false;
            void $i$f$mapTo222 = $this$map$iv3;
            Collection collection5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                JsParameter jsParameter3 = (JsParameter)item$iv$iv;
                Collection collection6 = collection5;
                boolean bl = false;
                collection6.add(it.getName());
            }
            list2 = (List)collection5;
            collection4 = collection;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        Set parameterNames = CollectionsKt.toSet(CollectionsKt.plus(collection4, (Iterable)list));
        List<JsStatement> $this$generateContinuationConstructor_u24lambda_u249 = constructor2.getBody().getStatements();
        boolean bl = false;
        JsExpression jsExpression = context2.getMetadata().getBaseClassRef().deepCopy();
        Intrinsics.checkNotNullExpressionValue(jsExpression, "deepCopy(...)");
        JsExpression baseClass = jsExpression;
        Intrinsics.checkNotNull($this$generateContinuationConstructor_u24lambda_u249);
        Collection collection5 = $this$generateContinuationConstructor_u24lambda_u249;
        JsExpression[] jsExpressionArray = new JsExpression[]{new JsThisRef(), interceptorRef};
        collection5.add(((JsExpression)new JsInvocation((JsExpression)Namer.getFunctionCallRef(baseClass), jsExpressionArray).source(psiElement)).makeStmt());
        if (controllerName != null) {
            JsName jsName4 = context2.getControllerFieldName();
            JsNameRef jsNameRef2 = controllerName.makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef2, "makeRef(...)");
            this.assignToField($this$generateContinuationConstructor_u24lambda_u249, jsName4, jsNameRef2, psiElement);
        }
        this.assignToField($this$generateContinuationConstructor_u24lambda_u249, context2.getMetadata().getExceptionStateName(), new JsIntLiteral(globalCatchBlockIndex), psiElement);
        if (context2.getMetadata().getHasReceiver()) {
            JsName jsName5 = context2.getReceiverFieldName();
            JsNameRef jsNameRef3 = context2.getReceiverFieldName().makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef3, "makeRef(...)");
            this.assignToField($this$generateContinuationConstructor_u24lambda_u249, jsName5, jsNameRef3, psiElement);
        }
        for (JsName jsName6 : survivingLocalVars) {
            JsExpression jsExpression2 = !parameterNames.contains(jsName6) ? Namer.getUndefinedExpression() : (JsExpression)jsName6.makeRef();
            Intrinsics.checkNotNull(jsExpression2);
            JsExpression value2 = jsExpression2;
            this.assignToField($this$generateContinuationConstructor_u24lambda_u249, context2.getFieldName(jsName6), value2, psiElement);
        }
        JsStatement[] jsStatementArray = new JsStatement[2];
        jsStatementArray[0] = constructor2.makeStmt();
        JsName jsName7 = constructor2.getName();
        Intrinsics.checkNotNullExpressionValue(jsName7, "getName(...)");
        jsStatementArray[1] = this.generateCoroutineMetadata(jsName7);
        Collection collection7 = CollectionsKt.listOf(jsStatementArray);
        JsName jsName8 = constructor2.getName();
        Intrinsics.checkNotNullExpressionValue(jsName8, "getName(...)");
        statements.addAll(0, CollectionsKt.plus(collection7, (Iterable)this.generateCoroutinePrototype(jsName8)));
    }

    private final List<JsStatement> generateCoroutinePrototype(JsName constructorName) {
        JsExpression jsExpression = JsAstUtils.prototypeOf(new JsNameRef(constructorName));
        Intrinsics.checkNotNullExpressionValue(jsExpression, "prototypeOf(...)");
        JsExpression prototype = jsExpression;
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull(coroutineMetadata);
        JsInvocation jsInvocation = Namer.createObjectWithPrototypeFrom(coroutineMetadata.getBaseClassRef().deepCopy());
        Intrinsics.checkNotNullExpressionValue(jsInvocation, "createObjectWithPrototypeFrom(...)");
        JsInvocation baseClass = jsInvocation;
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(prototype, baseClass);
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "assignment(...)");
        JsBinaryOperation assignPrototype = jsBinaryOperation;
        JsBinaryOperation jsBinaryOperation2 = JsAstUtils.assignment(new JsNameRef("constructor", prototype.deepCopy()), new JsNameRef(constructorName));
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation2, "assignment(...)");
        JsBinaryOperation assignConstructor = jsBinaryOperation2;
        JsStatement[] jsStatementArray = new JsStatement[]{assignPrototype.makeStmt(), assignConstructor.makeStmt()};
        return CollectionsKt.listOf(jsStatementArray);
    }

    private final JsStatement generateCoroutineMetadata(JsName constructorName) {
        JsObjectLiteral jsObjectLiteral;
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull(coroutineMetadata);
        JsExpression jsExpression = coroutineMetadata.getBaseClassRef().deepCopy();
        Intrinsics.checkNotNullExpressionValue(jsExpression, "deepCopy(...)");
        JsExpression baseClassRefRef = jsExpression;
        JsObjectLiteral $this$generateCoroutineMetadata_u24lambda_u2410 = jsObjectLiteral = new JsObjectLiteral(true);
        boolean bl = false;
        List<JsPropertyInitializer> list = $this$generateCoroutineMetadata_u24lambda_u2410.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(list, "getPropertyInitializers(...)");
        Collection collection = list;
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(new JsNameRef("kind"), new JsNameRef("CLASS", (JsExpression)new JsNameRef("Kind", "Kotlin")));
        collection.add(jsPropertyInitializer);
        List<JsPropertyInitializer> list2 = $this$generateCoroutineMetadata_u24lambda_u2410.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(list2, "getPropertyInitializers(...)");
        collection = list2;
        collection.add(new JsPropertyInitializer(new JsNameRef("simpleName"), new JsNullLiteral()));
        List<JsPropertyInitializer> list3 = $this$generateCoroutineMetadata_u24lambda_u2410.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(list3, "getPropertyInitializers(...)");
        collection = list3;
        collection.add(new JsPropertyInitializer(new JsNameRef("interfaces"), new JsArrayLiteral(CollectionsKt.listOf(baseClassRefRef))));
        JsObjectLiteral metadataObject = jsObjectLiteral;
        JsStatement jsStatement = JsAstUtils.assignment(new JsNameRef("$metadata$", (JsExpression)constructorName.makeRef()), metadataObject).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "makeStmt(...)");
        return jsStatement;
    }

    private final void generateDoResume(List<CoroutineBlock> coroutineBlocks, CoroutineTransformationContext context2, List<JsStatement> statements) {
        List<JsStatement> list;
        List<JsStatement> list2;
        JsFunction resumeFunction = new JsFunction(this.function.getScope().getParent(), new JsBlock(), "resume function");
        PsiElement psi = context2.getMetadata().getPsiElement();
        resumeFunction.setSource(psi);
        PsiElement psiElement = psi;
        PsiElement psiElement2 = psiElement != null ? UtilsKt.getFinalElement(psiElement) : null;
        resumeFunction.getBody().setSource(psiElement2 instanceof LeafPsiElement ? (LeafPsiElement)psiElement2 : null);
        List<JsStatement> coroutineBody = this.generateCoroutineBody(context2, coroutineBlocks);
        this.functionWithBody.getBody().getStatements().clear();
        List<JsStatement> $this$generateDoResume_u24lambda_u2411 = list2 = resumeFunction.getBody().getStatements();
        boolean bl = false;
        Intrinsics.checkNotNull($this$generateDoResume_u24lambda_u2411);
        CollectionsKt.addAll((Collection)$this$generateDoResume_u24lambda_u2411, (Iterable)coroutineBody);
        JsName resumeName = context2.getMetadata().getDoResumeName();
        List<JsStatement> $this$generateDoResume_u24lambda_u2412 = list = statements;
        boolean bl2 = false;
        this.assignToPrototype($this$generateDoResume_u24lambda_u2412, resumeName, resumeFunction);
        new FunctionPostProcessor(resumeFunction, null, 2, null).apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCoroutineInstantiation(CoroutineTransformationContext context2) {
        void $this$mapTo$iv$iv;
        Object object;
        PsiElement psiElement = context2.getMetadata().getPsiElement();
        Object $this$generateCoroutineInstantiation_u24lambda_u2413 = object = new JsNew(this.className.makeRef());
        boolean bl = false;
        ((SourceInfoAwareJsNode)$this$generateCoroutineInstantiation_u24lambda_u2413).setSource(psiElement);
        JsNew instantiation = object;
        if (context2.getMetadata().getHasReceiver()) {
            List<JsExpression> list = instantiation.getArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
            object = list;
            object.add(new JsThisRef());
        }
        List<JsParameter> list = this.function.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        Collection collection = list;
        JsFunction jsFunction = this.innerFunction;
        List<JsParameter> list2 = jsFunction != null ? jsFunction.getParameters() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List parameters = CollectionsKt.plus(collection, (Iterable)list2);
        List<JsExpression> list3 = instantiation.getArguments();
        Intrinsics.checkNotNullExpressionValue(list3, "getArguments(...)");
        $this$generateCoroutineInstantiation_u24lambda_u2413 = list3;
        JsExpression[] $this$map$iv = (JsExpression[])CollectionsKt.dropLast(parameters, 1);
        boolean $i$f$map22 = false;
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(it.getName().makeRef());
        }
        $this$map$iv = (List)destination$iv$iv;
        CollectionsKt.addAll($this$generateCoroutineInstantiation_u24lambda_u2413, $this$map$iv);
        CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(this.function);
        Intrinsics.checkNotNull(coroutineMetadata);
        if (coroutineMetadata.getHasController()) {
            List<JsExpression> list4 = instantiation.getArguments();
            Intrinsics.checkNotNullExpressionValue(list4, "getArguments(...)");
            $this$generateCoroutineInstantiation_u24lambda_u2413 = list4;
            $this$generateCoroutineInstantiation_u24lambda_u2413.add(new JsThisRef());
        }
        List<JsExpression> list5 = instantiation.getArguments();
        Intrinsics.checkNotNullExpressionValue(list5, "getArguments(...)");
        $this$generateCoroutineInstantiation_u24lambda_u2413 = list5;
        $this$generateCoroutineInstantiation_u24lambda_u2413.add(((JsParameter)CollectionsKt.last(parameters)).getName().makeRef());
        JsName jsName = JsScope.declareTemporaryName("suspended");
        Intrinsics.checkNotNullExpressionValue(jsName, "declareTemporaryName(...)");
        JsName suspendedName = jsName;
        List<JsParameter> list6 = this.functionWithBody.getParameters();
        Intrinsics.checkNotNullExpressionValue(list6, "getParameters(...)");
        $this$map$iv = list6;
        $this$map$iv.add(new JsParameter(suspendedName));
        JsName jsName2 = JsScope.declareTemporaryName("instance");
        Intrinsics.checkNotNullExpressionValue(jsName2, "declareTemporaryName(...)");
        JsName instanceName = jsName2;
        List<JsStatement> list7 = this.functionWithBody.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list7, "getStatements(...)");
        Collection $i$f$map22 = list7;
        $i$f$map22.add(JsAstUtils.newVar(instanceName, instantiation));
        object2 = new JsExpression[]{new JsNullLiteral()};
        JsReturn invokeResume = new JsReturn((JsExpression)new JsInvocation((JsExpression)new JsNameRef(context2.getMetadata().getDoResumeName(), (JsExpression)instanceName.makeRef()), (JsExpression[])object2).source(psiElement));
        List<JsStatement> list8 = this.functionWithBody.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list8, "getStatements(...)");
        object2 = list8;
        object2.add(new JsIf(suspendedName.makeRef().source(psiElement), new JsReturn(instanceName.makeRef().source(psiElement)), invokeResume));
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> generateCoroutineBody(CoroutineTransformationContext context2, List<CoroutineBlock> blocks) {
        void $this$mapTo$iv$iv;
        int indexOfGlobalCatch = blocks.indexOf(context2.getGlobalCatchBlock());
        JsNameRef stateRef = new JsNameRef(context2.getMetadata().getStateName(), (JsExpression)new JsThisRef());
        JsNameRef exceptionStateRef = new JsNameRef(context2.getMetadata().getExceptionStateName(), (JsExpression)new JsThisRef());
        JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(stateRef, new JsIntLiteral(indexOfGlobalCatch));
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "equality(...)");
        JsBinaryOperation isFromGlobalCatch = jsBinaryOperation;
        JsCatch jsCatch = new JsCatch(this.functionWithBody.getScope(), "e");
        JsStatement[] jsStatementArray = new JsStatement[]{JsAstUtils.assignment(stateRef.deepCopy(), exceptionStateRef.deepCopy()).makeStmt(), JsAstUtils.assignment(new JsNameRef(context2.getMetadata().getExceptionName(), (JsExpression)new JsThisRef()), jsCatch.getParameter().getName().makeRef()).makeStmt()};
        JsBlock continueWithException = new JsBlock(jsStatementArray);
        JsStatement jsStatement = JsAstUtils.assignment(exceptionStateRef.deepCopy(), stateRef.deepCopy()).makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "makeStmt(...)");
        JsStatement adjustExceptionState = jsStatement;
        JsStatement[] jsStatementArray2 = new JsStatement[]{adjustExceptionState, new JsThrow(jsCatch.getParameter().getName().makeRef())};
        jsCatch.setBody(new JsBlock((JsStatement)new JsIf(isFromGlobalCatch, new JsBlock(jsStatementArray2), continueWithException)));
        JsNameRef throwResultRef = new JsNameRef(context2.getMetadata().getExceptionName(), (JsExpression)new JsThisRef());
        ((Collection)context2.getGlobalCatchBlock().getStatements()).add(new JsThrow(throwResultRef));
        Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)blocks);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsCase jsCase;
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            CoroutineBlock block = (CoroutineBlock)indexedValue.component2();
            JsCase $this$generateCoroutineBody_u24lambda_u2416_u24lambda_u2415 = jsCase = new JsCase();
            boolean bl2 = false;
            $this$generateCoroutineBody_u24lambda_u2416_u24lambda_u2415.setCaseExpression(new JsIntLiteral(index));
            List<JsStatement> list = $this$generateCoroutineBody_u24lambda_u2416_u24lambda_u2415.getStatements();
            Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
            Collection collection2 = list;
            CollectionsKt.addAll(collection2, (Iterable)block.getStatements());
            collection.add(jsCase);
        }
        List cases = (List)destination$iv$iv;
        JsDefault $this$generateCoroutineBody_u24lambda_u2417 = $i$f$map = new JsDefault();
        boolean bl = false;
        JsStatement[] jsStatementArray3 = new JsStatement[]{JsAstUtils.assignment(stateRef, new JsIntLiteral(indexOfGlobalCatch)).makeStmt(), new JsThrow(new JsNew((JsExpression)new JsNameRef("Error"), CollectionsKt.listOf(new JsStringLiteral("State Machine Unreachable execution"))))};
        JsBlock block = new JsBlock(jsStatementArray3);
        List<JsStatement> list = $this$generateCoroutineBody_u24lambda_u2417.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
        ((Collection)list).add(block);
        JsDefault defaultCase = $i$f$map;
        JsSwitch switchStatement = new JsSwitch(stateRef.deepCopy(), CollectionsKt.plus((Collection)cases, defaultCase));
        JsDoWhile loop = new JsDoWhile(new JsBooleanLiteral(true), new JsTry(new JsBlock((JsStatement)switchStatement), jsCatch, null));
        return CollectionsKt.listOf(loop);
    }

    private final void collectAdditionalLocalVariables(JsBlock $this$collectAdditionalLocalVariables) {
        $this$collectAdditionalLocalVariables.accept(new RecursiveJsVisitor(this){
            final /* synthetic */ CoroutineFunctionTransformer this$0;
            {
                this.this$0 = $receiver;
            }

            public void visit(JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter(x, "x");
                super.visit(x);
                ((Collection)CoroutineFunctionTransformer.access$getLocalVariables$p(this.this$0)).add(x.getName());
            }
        });
    }

    private final void assignToField(List<JsStatement> $this$assignToField, JsName fieldName, JsExpression value2, PsiElement psiElement) {
        ((Collection)$this$assignToField).add(JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)new JsThisRef()), value2).source(psiElement).makeStmt());
    }

    private final void assignToPrototype(List<JsStatement> $this$assignToPrototype, JsName fieldName, JsExpression value2) {
        ((Collection)$this$assignToPrototype).add(JsAstUtils.assignment(new JsNameRef(fieldName, JsAstUtils.prototypeOf(this.className.makeRef())), value2).makeStmt());
    }

    public static final /* synthetic */ JsBlock access$getBody$p(CoroutineFunctionTransformer $this) {
        return $this.body;
    }

    public static final /* synthetic */ Set access$getLocalVariables$p(CoroutineFunctionTransformer $this) {
        return $this.localVariables;
    }
}

