/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import io.opentelemetry.api.common.Attributes;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.CheckResults;
import org.languagetool.DetectedLanguage;
import org.languagetool.ErrorRateTooHighException;
import org.languagetool.FragmentWithLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.Premium;
import org.languagetool.ResultCache;
import org.languagetool.RuleMatchListener;
import org.languagetool.ToneTag;
import org.languagetool.UserConfig;
import org.languagetool.language.identifier.LanguageIdentifier;
import org.languagetool.language.identifier.LanguageIdentifierService;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.DictionaryMatchFilter;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.rules.spelling.morfologik.suggestions_ordering.SuggestionsOrdererConfig;
import org.languagetool.server.AuthException;
import org.languagetool.server.BadRequestException;
import org.languagetool.server.DatabaseAccess;
import org.languagetool.server.DatabaseCheckLogEntry;
import org.languagetool.server.DatabaseLogger;
import org.languagetool.server.DatabasePingLogEntry;
import org.languagetool.server.ErrorRequestLimiter;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.LanguageToolHttpHandler;
import org.languagetool.server.Pipeline;
import org.languagetool.server.PipelinePool;
import org.languagetool.server.PipelineSettings;
import org.languagetool.server.RequestCounter;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.ResultExtender;
import org.languagetool.server.ServerMetricsCollector;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextTooLongException;
import org.languagetool.server.TooManyRequestsException;
import org.languagetool.server.UnavailableException;
import org.languagetool.server.UserLimits;
import org.languagetool.server.tools.AbTestService;
import org.languagetool.server.tools.LocalAbTestService;
import org.languagetool.tools.LtThreadPoolFactory;
import org.languagetool.tools.TelemetryProvider;
import org.languagetool.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class TextChecker {
    private static final Logger log = LoggerFactory.getLogger(TextChecker.class);
    private static final int PINGS_CLEAN_MILLIS = 60000;
    private static final int PINGS_MAX_SIZE = 5000;
    private static final String SPAN_NAME_PREFIX = "/v2/check-";
    private static final Pattern COMMA_WHITESPACE_PATTERN = Pattern.compile(",\\s*");
    private static final AbTestService AB_TEST_SERVICE = new LocalAbTestService();
    protected static final int CONTEXT_SIZE = 40;
    protected static final int NUM_PIPELINES_PER_SETTING = 3;
    protected final HTTPServerConfig config;
    private static final String ENCODING = "UTF-8";
    private static final int CACHE_STATS_PRINT = 500;
    private final Map<String, Integer> languageCheckCounts = new HashMap<String, Integer>();
    private final Queue<Runnable> workQueue;
    private final RequestCounter reqCounter;
    private final LanguageIdentifier languageIdentifier;
    private final ExecutorService executorService;
    private final ResultCache cache;
    private final DatabaseLogger databaseLogger;
    private final Long logServerId;
    private final Random random = new Random();
    private final Set<DatabasePingLogEntry> pings = new HashSet<DatabasePingLogEntry>();
    private long pingsCleanDateMillis = System.currentTimeMillis();
    PipelinePool pipelinePool;

    protected abstract void setHeaders(HttpExchange var1);

    protected abstract String getResponse(AnnotatedText var1, Language var2, DetectedLanguage var3, Language var4, List<CheckResults> var5, List<RuleMatch> var6, String var7, int var8, boolean var9, JLanguageTool.Mode var10);

    @NotNull
    protected abstract List<String> getPreferredVariants(Map<String, String> var1);

    protected abstract DetectedLanguage getLanguage(String var1, Map<String, String> var2, List<String> var3, List<String> var4, List<String> var5, boolean var6);

    protected abstract boolean getLanguageAutoDetect(Map<String, String> var1);

    @NotNull
    protected abstract List<String> getEnabledRuleIds(Map<String, String> var1);

    @NotNull
    protected abstract List<String> getDisabledRuleIds(Map<String, String> var1);

    TextChecker(HTTPServerConfig config, boolean internalServer, Queue<Runnable> workQueue, RequestCounter reqCounter) {
        this.config = config;
        this.workQueue = workQueue;
        this.reqCounter = reqCounter;
        this.languageIdentifier = config.isLocalApiMode() ? LanguageIdentifierService.INSTANCE.getSimpleLanguageIdentifier(config.preferredLanguages) : LanguageIdentifierService.INSTANCE.getDefaultLanguageIdentifier(0, config.getNgramLangIdentData(), config.getFasttextBinary(), config.getFasttextModel());
        this.executorService = LtThreadPoolFactory.createFixedThreadPoolExecutor((String)"lt-text-checker-thread", (int)config.getMaxTextCheckerThreads(), (int)config.getMaxTextCheckerThreads(), (int)config.getTextCheckerQueueSize(), (long)60L, (boolean)false, (thread, throwable) -> log.error("Thread: " + thread.getName() + " failed with: " + throwable.getMessage()), (boolean)false);
        int remoteRuleCount = 0;
        if (config.getRemoteRulesConfigFile() != null) {
            try (FileInputStream fis = new FileInputStream(config.getRemoteRulesConfigFile());){
                remoteRuleCount = RemoteRuleConfig.parse((InputStream)fis).size();
            }
            catch (IOException e) {
                log.error("Couldn't read RemoteRule configuration", (Throwable)e);
            }
        }
        if (remoteRuleCount > 0) {
            LtThreadPoolFactory.createFixedThreadPoolExecutor((String)"remote-rule-executing-thread", (int)config.getMaxCheckThreads(), (int)(config.getMaxCheckThreads() * remoteRuleCount * 4), (int)-1, (long)5L, (boolean)true, (thread, throwable) -> log.error("Thread: " + thread.getName() + " failed with: " + throwable.getMessage()), (boolean)true);
        }
        this.cache = config.getCacheSize() > 0 ? new ResultCache((long)config.getCacheSize(), config.getCacheTTLSeconds(), TimeUnit.SECONDS) : null;
        this.databaseLogger = DatabaseLogger.getInstance();
        this.logServerId = this.databaseLogger.isLogging() ? DatabaseAccess.getInstance().getOrCreateServerId() : null;
        if (this.cache != null && !config.isLocalApiMode()) {
            ServerMetricsCollector.getInstance().monitorCache("languagetool_matches_cache", this.cache.getMatchesCache());
            ServerMetricsCollector.getInstance().monitorCache("languagetool_remote_matches_cache", this.cache.getRemoteMatchesCache());
            ServerMetricsCollector.getInstance().monitorCache("languagetool_sentences_cache", this.cache.getSentenceCache());
            ServerMetricsCollector.getInstance().monitorCache("languagetool_remote_matches_cache", this.cache.getRemoteMatchesCache());
        }
        this.pipelinePool = new PipelinePool(config, this.cache, internalServer);
        if (config.isPipelinePrewarmingEnabled()) {
            log.info("Prewarming pipelines...");
            this.prewarmPipelinePool();
            log.info("Prewarming finished.");
        }
        if (config.getAbTest() != null) {
            UserConfig.enableABTests();
            log.info("A/B-Test enabled: " + config.getAbTest());
            if (config.getAbTest().equals("SuggestionsOrderer")) {
                SuggestionsOrdererConfig.setMLSuggestionsOrderingEnabled((boolean)true);
            }
        }
    }

    protected static Language parseLanguage(String code) throws BadRequestException {
        try {
            return Languages.getLanguageForShortCode((String)code);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    private void prewarmPipelinePool() {
        HashMap<PipelineSettings, Integer> prewarmSettings = new HashMap<PipelineSettings, Integer>();
        ArrayList prewarmLanguages = new ArrayList();
        if (this.config.preferredLanguages.isEmpty()) {
            prewarmLanguages.addAll(Stream.of("de-DE", "en-US", "en-GB", "pt-BR", "ru-RU", "es", "it", "fr", "pl-PL", "uk-UA").map(Languages::getLanguageForShortCode).collect(Collectors.toList()));
        } else {
            this.config.preferredLanguages.forEach(s -> prewarmLanguages.add(Languages.getLanguageForShortCode((String)s)));
        }
        List<String> addonDisabledRules = Collections.singletonList("WHITESPACE_RULE");
        List<JLanguageTool.Mode> addonModes = Arrays.asList(JLanguageTool.Mode.TEXTLEVEL_ONLY, JLanguageTool.Mode.ALL_BUT_TEXTLEVEL_ONLY);
        UserConfig user = new UserConfig();
        for (Language language : prewarmLanguages) {
            for (JLanguageTool.Mode mode : addonModes) {
                QueryParams params = new QueryParams(Collections.emptyList(), Collections.emptyList(), addonDisabledRules, Collections.emptyList(), Collections.emptyList(), false, true, true, true, Premium.isPremiumVersion(), false, mode, JLanguageTool.Level.PICKY, null);
                PipelineSettings settings = new PipelineSettings(language, null, params, this.config.globalConfig, user);
                prewarmSettings.put(settings, 3);
                PipelineSettings settingsMotherTongueEqual = new PipelineSettings(language, language, params, this.config.globalConfig, user);
                PipelineSettings settingsMotherTongueEnglish = new PipelineSettings(language, Languages.getLanguageForName((String)"English"), params, this.config.globalConfig, user);
                prewarmSettings.put(settingsMotherTongueEqual, 3);
                prewarmSettings.put(settingsMotherTongueEnglish, 3);
            }
        }
        try {
            for (Map.Entry entry : prewarmSettings.entrySet()) {
                int numPipelines = (Integer)entry.getValue();
                PipelineSettings setting = (PipelineSettings)entry.getKey();
                ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
                for (int i = 0; i < numPipelines; ++i) {
                    Pipeline p = this.pipelinePool.getPipeline(setting);
                    p.check("LanguageTool");
                    pipelines.add(p);
                }
                for (Pipeline p : pipelines) {
                    this.pipelinePool.returnPipeline(setting, p);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while prewarming pipelines", e);
        }
    }

    void shutdownNow() {
        this.executorService.shutdownNow();
        RemoteRule.shutdown();
    }

    void checkText(AnnotatedText aText, HttpExchange httpExchange, Map<String, String> params, ErrorRequestLimiter errorRequestLimiter, String remoteAddress) throws Exception {
        Future<List> future;
        this.checkParams(params);
        long timeStart = System.currentTimeMillis();
        UserLimits limits = ServerTools.getUserLimits(params, this.config);
        String requestId = httpExchange.getRequestHeaders().getFirst("X-Request-ID");
        String agent = params.get("useragent") != null ? params.get("useragent") : "-";
        Long agentId = null;
        Long userId = null;
        if (this.databaseLogger.isLogging()) {
            DatabaseAccess db = DatabaseAccess.getInstance();
            agentId = db.getOrCreateClientId(params.get("useragent"));
            userId = limits.getPremiumUid();
        }
        String referrer = httpExchange.getRequestHeaders().getFirst("Referer");
        String userAgent = httpExchange.getRequestHeaders().getFirst("User-Agent");
        if (!this.config.isAnonymousAccessAllowed() && limits.getPremiumUid() == null) {
            throw new AuthException("Anonymous access is prohibited on this server, please provide authentication.");
        }
        int length = aText.getPlainText().length();
        if ("true".equals(params.get("languageChanged"))) {
            log.info("languageChanged to " + params.get("language") + " for text with length " + aText.getPlainText().trim().length());
        }
        if (length > limits.getMaxTextLength()) {
            ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.MAX_TEXT_SIZE);
            throw new TextTooLongException("Your text exceeds the limit of " + limits.getMaxTextLength() + " characters (it's " + length + " characters). Please submit a shorter text.");
        }
        if (!this.config.isLocalApiMode()) {
            try {
                RequestLimiter.checkUserLimit(referrer, userAgent, limits);
            }
            catch (TooManyRequestsException e) {
                String text;
                String response = "Error: Access denied: " + e.getMessage();
                httpExchange.sendResponseHeaders(403, response.getBytes(ENCODING).length);
                httpExchange.getResponseBody().write(response.getBytes(ENCODING));
                String message = "Blocked request from uid:" + userId + " because user limit is reached: ";
                message = message + "limit = " + limits.getRequestsPerDay() + ", mode = " + (Object)((Object)limits.getLimitEnforcementMode()) + ". ";
                message = message + "Access from " + remoteAddress + ", ";
                message = message + "HTTP user agent: " + userAgent + ", ";
                message = message + "User agent param: " + params.get("useragent") + ", ";
                message = message + "Referrer: " + referrer + ", ";
                message = message + "language: " + params.get("language") + ", ";
                message = message + "h: " + this.reqCounter.getHandleCount() + ", ";
                message = message + "r: " + this.reqCounter.getRequestCount();
                if (params.get("username") != null) {
                    message = message + ", user: " + params.get("username");
                }
                if (params.get("apiKey") != null) {
                    message = message + ", apiKey: " + params.get("apiKey");
                }
                if ((text = params.get("text")) != null) {
                    message = message + ", text length: " + text.length();
                }
                log.warn(message);
                return;
            }
        }
        List<String> dictGroups = null;
        String dictName = "default";
        if (params.containsKey("dicts")) {
            dictGroups = Arrays.asList(params.get("dicts").split(","));
            dictGroups.sort(Comparator.naturalOrder());
            dictName = "groups_" + String.join((CharSequence)",", dictGroups);
        }
        List<String> finalDictGroups = dictGroups;
        List dictWords = limits.getPremiumUid() != null ? (List)TelemetryProvider.INSTANCE.createSpan("/v2/check-GetUserDictWords", Attributes.empty(), () -> this.getUserDictWords(limits, finalDictGroups)) : Collections.emptyList();
        boolean filterDictionaryMatches = "true".equals(params.getOrDefault("filterDictionaryMatches", "true"));
        Long textSessionId = null;
        try {
            if (params.containsKey("textSessionId")) {
                String textSessionIdStr = params.get("textSessionId");
                if (textSessionIdStr.startsWith("user:")) {
                    int sepPos = textSessionIdStr.indexOf(58);
                    String sessionId = textSessionIdStr.substring(sepPos + 1);
                    textSessionId = Long.valueOf(sessionId);
                } else if (textSessionIdStr.contains(":")) {
                    int sepPos = textSessionIdStr.indexOf(58);
                    long random = Long.parseLong(textSessionIdStr.substring(0, sepPos));
                    long timestamp = Long.parseLong(textSessionIdStr.substring(sepPos + 1));
                    long maxRandom = 100000L;
                    long randomSegmentSize = (Long.MAX_VALUE - maxRandom) / maxRandom;
                    long segmentOffset = random * randomSegmentSize;
                    if (timestamp > randomSegmentSize) {
                        log.warn(String.format("Could not transform textSessionId '%s'", textSessionIdStr));
                    }
                    textSessionId = segmentOffset + timestamp;
                } else {
                    textSessionId = Long.valueOf(textSessionIdStr);
                }
            }
        }
        catch (NumberFormatException ex) {
            log.info("Could not parse textSessionId '" + params.get("textSessionId") + "' as long: " + ex.getMessage() + ", user agent: " + params.get("useragent") + ", version: " + params.get("v") + ", HTTP user agent: " + ServerTools.getHttpUserAgent(httpExchange) + ", referrer: " + ServerTools.getHttpReferrer(httpExchange));
        }
        List<String> abTest = AB_TEST_SERVICE.getActiveAbTestForClient(params, this.config);
        boolean enableHiddenRules = "true".equals(params.get("enableHiddenRules"));
        if (limits.hasPremium()) {
            enableHiddenRules = false;
        }
        boolean autoDetectLanguage = this.getLanguageAutoDetect(params);
        List<String> preferredVariants = this.getPreferredVariants(params);
        if (params.get("noopLanguages") != null && !autoDetectLanguage) {
            ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.INVALID_REQUEST);
            throw new BadRequestException("You can specify 'noopLanguages' only when also using 'language=auto'");
        }
        List noopLangs = params.get("noopLanguages") != null ? Arrays.asList(params.get("noopLanguages").split(",")) : Collections.emptyList();
        List preferredLangs = params.get("preferredLanguages") != null ? Arrays.asList(params.get("preferredLanguages").split(",")) : Collections.emptyList();
        DetectedLanguage detLang = (DetectedLanguage)TelemetryProvider.INSTANCE.createSpan("/v2/check-DetetectLanguage", Attributes.empty(), () -> this.getLanguage(aText.getPlainText(), params, preferredVariants, noopLangs, preferredLangs, params.getOrDefault("ld", "control").equalsIgnoreCase("test")));
        Language lang = detLang.getGivenLanguage();
        List userRules = (List)TelemetryProvider.INSTANCE.createSpan("/v2/check-GetUserRules", Attributes.empty(), () -> this.getUserRules(limits, lang, finalDictGroups));
        boolean untrustedSource = false;
        if (referrer != null) {
            untrustedSource = this.config.getUntrustedReferrers().stream().anyMatch(s -> ServerTools.siteMatches(referrer, s));
        }
        UserConfig userConfig = new UserConfig(dictWords, userRules, this.getRuleValues(params), this.config.getMaxSpellingSuggestions(), limits.getPremiumUid(), dictName, limits.getDictCacheSize(), null, filterDictionaryMatches, abTest, textSessionId, !limits.hasPremium() && enableHiddenRules, preferredLangs, untrustedSource);
        Integer count = this.languageCheckCounts.get(lang.getShortCodeWithCountryAndVariant());
        if (count == null) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        String motherTongueParam = params.get("motherTongue");
        Language motherTongue = motherTongueParam != null ? TextChecker.parseLanguage(motherTongueParam) : null;
        boolean useEnabledOnly = "yes".equals(params.get("enabledOnly")) || "true".equals(params.get("enabledOnly"));
        ArrayList<Language> altLanguages = new ArrayList<Language>();
        if (params.get("altLanguages") != null) {
            String[] altLangParams;
            for (String langCode : altLangParams = COMMA_WHITESPACE_PATTERN.split(params.get("altLanguages"))) {
                Language altLang = TextChecker.parseLanguage(langCode);
                altLanguages.add(altLang);
                if (!altLang.hasVariant() || altLang.isVariant()) continue;
                ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.INVALID_REQUEST);
                throw new BadRequestException("You specified altLanguage '" + langCode + "', but for this language you need to specify a variant, e.g. 'en-GB' instead of just 'en'");
            }
        }
        List<String> enabledRules = this.getEnabledRuleIds(params);
        List<String> disabledRules = this.getDisabledRuleIds(params);
        List<CategoryId> enabledCategories = this.getCategoryIds("enabledCategories", params);
        List<CategoryId> disabledCategories = this.getCategoryIds("disabledCategories", params);
        if ((disabledRules.size() > 0 || disabledCategories.size() > 0) && useEnabledOnly) {
            ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.INVALID_REQUEST);
            throw new BadRequestException("You cannot specify disabled rules or categories using enabledOnly=true");
        }
        if (enabledRules.isEmpty() && enabledCategories.isEmpty() && useEnabledOnly) {
            ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.INVALID_REQUEST);
            throw new BadRequestException("You must specify enabled rules or categories when using enabledOnly=true");
        }
        boolean enableTempOffRules = "true".equals(params.get("enableTempOffRules"));
        boolean useQuerySettings = enabledRules.size() > 0 || disabledRules.size() > 0 || enabledCategories.size() > 0 || disabledCategories.size() > 0 || enableTempOffRules;
        boolean allowIncompleteResults = "true".equals(params.get("allowIncompleteResults"));
        JLanguageTool.Mode mode = ServerTools.getMode(params);
        JLanguageTool.Level level = ServerTools.getLevel(params);
        String[] toneTagNames = params.get("toneTags") != null ? params.get("toneTags").split(",") : null;
        HashSet<ToneTag> toneTags = new HashSet<ToneTag>(ToneTag.values().length);
        if (toneTagNames != null) {
            if (toneTagNames.length == 1 && toneTagNames[0].isEmpty()) {
                toneTags.add(ToneTag.ALL_WITHOUT_GOAL_SPECIFIC);
            } else {
                for (String toneTagName : toneTagNames) {
                    if (toneTagNames.length > 1 && (toneTagName.equals("NO_TONE_RULE") || toneTagName.equals("ALL_TONE_RULES"))) {
                        log.warn("NO_TONE_RULE and ALL_TONE_RULES will be ignored if more than one toneTag is in params.");
                        continue;
                    }
                    try {
                        toneTags.add(ToneTag.valueOf((String)toneTagName));
                    }
                    catch (IllegalArgumentException ex) {
                        log.warn("Unsupported toneTag found in params: {}", (Object)toneTagName);
                    }
                }
            }
        } else {
            toneTags.add(ToneTag.ALL_WITHOUT_GOAL_SPECIFIC);
        }
        String callback = params.get("callback");
        boolean inputLogging = !params.getOrDefault("inputLogging", "").equals("no");
        QueryParams qParams = new QueryParams(altLanguages, enabledRules, disabledRules, enabledCategories, disabledCategories, useEnabledOnly, useQuerySettings, allowIncompleteResults, enableHiddenRules, limits.getPremiumUid() != null && limits.hasPremium(), enableTempOffRules, mode, level, toneTags, callback, inputLogging);
        int textSize = length;
        List ruleMatchesSoFar = Collections.synchronizedList(new ArrayList());
        try {
            future = this.executorService.submit(() -> {
                try (MDC.MDCCloseable c = MDC.putCloseable((String)"rID", (String)LanguageToolHttpHandler.getRequestId(httpExchange));){
                    log.debug("Starting text check on {} chars; params: {}", (Object)length, (Object)qParams);
                    long time = System.currentTimeMillis();
                    List<CheckResults> results = this.getRuleMatches(aText, lang, motherTongue, params, qParams, userConfig, f -> ruleMatchesSoFar.add(new CheckResults(Collections.singletonList(f), Collections.emptyList())));
                    log.debug("Finished text check in {}ms. Starting suggestion generation.", (Object)(System.currentTimeMillis() - time));
                    time = System.currentTimeMillis();
                    results.stream().flatMap(r -> r.getRuleMatches().stream()).forEach(RuleMatch::computeLazySuggestedReplacements);
                    log.debug("Finished suggestion generation in {}ms, returning results.", (Object)(System.currentTimeMillis() - time));
                    List<CheckResults> list = results;
                    return list;
                }
            });
        }
        catch (RejectedExecutionException e) {
            throw new UnavailableException("Server overloaded, please try again later", e);
        }
        String incompleteResultReason = null;
        Attributes textCheckingAttributes = Attributes.builder().put("text.language", lang.getShortCode()).put("text.size", (long)textSize).put("userRules.size", (long)userRules.size()).put("dictionary.size", (long)dictWords.size()).build();
        Integer finalCount = count;
        Map.Entry resAndReason = (Map.Entry)TelemetryProvider.INSTANCE.createSpan("/v2/check-GetRuleMatches", textCheckingAttributes, span -> {
            List localRes;
            String localReason = null;
            try {
                localRes = limits.getMaxCheckTimeMillis() < 0L ? (ArrayList)future.get() : (List)future.get(limits.getMaxCheckTimeMillis(), TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                future.cancel(true);
                if (ExceptionUtils.getRootCause((Throwable)e) instanceof ErrorRateTooHighException) {
                    ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.TOO_MANY_ERRORS);
                }
                if (qParams.allowIncompleteResults && ExceptionUtils.getRootCause((Throwable)e) instanceof ErrorRateTooHighException) {
                    log.warn(e.getMessage() + " - returning " + ruleMatchesSoFar.size() + " matches found so far. Detected language: " + detLang + ", " + ServerTools.getLoggingInfo(remoteAddress, null, -1, httpExchange, params, System.currentTimeMillis() - timeStart, this.reqCounter));
                    localRes = new ArrayList(ruleMatchesSoFar);
                    localReason = "Results are incomplete: " + ExceptionUtils.getRootCause((Throwable)e).getMessage();
                }
                if (e.getCause() != null && e.getCause() instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)e.getCause();
                }
                throw new RuntimeException(ServerTools.cleanUserTextFromMessage(e.getMessage(), params) + ", detected: " + detLang, e);
            }
            catch (TimeoutException e) {
                String loadInfo;
                boolean cancelled = future.cancel(true);
                Path loadFile = Paths.get("/proc/loadavg", new String[0]);
                String string = loadInfo = loadFile.toFile().exists() ? Files.readAllLines(loadFile).toString() : "(unknown)";
                if (errorRequestLimiter != null) {
                    errorRequestLimiter.logAccess(remoteAddress, httpExchange.getRequestHeaders(), params);
                }
                String message = "Text checking took longer than allowed maximum of " + limits.getMaxCheckTimeMillis() + " milliseconds (cancelled: " + cancelled + ", lang: " + lang.getShortCodeWithCountryAndVariant() + ", detected: " + detLang + ", #" + finalCount + ", " + length + " characters of text, mode: " + mode.toString().toLowerCase() + ", h: " + this.reqCounter.getHandleCount() + ", r: " + this.reqCounter.getRequestCount() + ", requestId: " + requestId + ", system load: " + loadInfo + ")";
                if (qParams.allowIncompleteResults) {
                    log.info(message + " - returning " + ruleMatchesSoFar.size() + " matches found so far");
                    localRes = new ArrayList(ruleMatchesSoFar);
                    localReason = "Results are incomplete: text checking took longer than allowed maximum of " + String.format(Locale.ENGLISH, "%.2f", (double)limits.getMaxCheckTimeMillis() / 1000.0) + " seconds";
                    span.setAttribute("incompleteResults", true);
                }
                ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.MAX_CHECK_TIME);
                throw new RuntimeException(message, e);
            }
            return new AbstractMap.SimpleEntry<List, Object>(localRes, localReason);
        });
        List res = (List)resAndReason.getKey();
        incompleteResultReason = (String)resAndReason.getValue();
        res.forEach(checkResults -> checkResults.getRuleMatches().forEach(RuleMatch::discardLazySuggestedReplacements));
        this.setHeaders(httpExchange);
        ArrayList<RuleMatch> hiddenMatches = new ArrayList<RuleMatch>();
        boolean temporaryPremiumDisabledRuleMatch = false;
        HashSet<String> temporaryPremiumDisabledRuleMatchedIds = new HashSet<String>();
        if (!qParams.premium && qParams.enableHiddenRules) {
            ArrayList<RuleMatch> allMatches = new ArrayList<RuleMatch>();
            ArrayList<RuleMatch> premiumMatches = new ArrayList<RuleMatch>();
            for (CheckResults result : res) {
                ArrayList<RuleMatch> filteredMatches = new ArrayList<RuleMatch>();
                for (RuleMatch match : result.getRuleMatches()) {
                    if (Premium.get().isPremiumRule(match.getRule()) && !Premium.isTempNotPremium((Rule)match.getRule())) {
                        premiumMatches.add(match);
                    } else if (userConfig.getAbTest() != null && userConfig.getAbTest().equals("ALLOW_PREMIUM_IN_BASIC") && Premium.get().isPremiumRule(match.getRule()) && Premium.isTempNotPremium((Rule)match.getRule())) {
                        System.out.println("Rule: " + match.getRule().getId() + " is premium but temporary available in basic");
                        filteredMatches.add(match);
                        allMatches.add(match);
                        temporaryPremiumDisabledRuleMatch = true;
                        temporaryPremiumDisabledRuleMatchedIds.add(match.getRule().getId());
                    } else {
                        filteredMatches.add(match);
                        allMatches.add(match);
                    }
                    result.setRuleMatches(filteredMatches);
                }
            }
            hiddenMatches.addAll(ResultExtender.getAsHiddenMatches(allMatches, premiumMatches));
        }
        int compactMode = Integer.parseInt(params.getOrDefault("c", "0"));
        String response = this.getResponse(aText, lang, detLang, motherTongue, res, hiddenMatches, incompleteResultReason, compactMode, limits.getPremiumUid() == null, qParams.mode);
        if (qParams.callback != null) {
            response = qParams.callback + "(" + response + ");";
        }
        String messageSent = "sent";
        String languageMessage = lang.getShortCodeWithCountryAndVariant();
        try {
            httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
            httpExchange.getResponseBody().write(response.getBytes(ENCODING));
            ServerMetricsCollector.getInstance().logResponse(200);
        }
        catch (IOException exception) {
            messageSent = "notSent: " + exception.getMessage();
        }
        if (motherTongue != null) {
            languageMessage = languageMessage + " (mother tongue: " + motherTongue.getShortCodeWithCountryAndVariant() + ")";
        }
        if (autoDetectLanguage) {
            languageMessage = languageMessage + "[auto]";
        }
        this.languageCheckCounts.put(lang.getShortCodeWithCountryAndVariant(), count);
        int computationTime = (int)(System.currentTimeMillis() - timeStart);
        Premium premium = Premium.get();
        List premiumMatchRuleIds = res.stream().flatMap(r -> r.getRuleMatches().stream()).filter(k -> premium.isPremiumRule(k.getRule())).map(k -> k.getRule().getId()).collect(Collectors.toList());
        Map<String, Integer> ruleMatchCount = this.getRuleMatchCount(res);
        int matchCount = ruleMatchCount.size();
        String version = params.get("v") != null ? ", version: " + params.get("v") : "";
        String skipLimits = limits.getSkipLimits() ? ", skipLimits" : "";
        log.info("Check done: " + length + " chars, " + languageMessage + ", requestId: " + requestId + ", #" + count + ", " + referrer + ", " + premiumMatchRuleIds.size() + "/" + matchCount + " matches, " + computationTime + "ms, agent:" + agent + version + ", " + messageSent + ", q:" + (this.workQueue != null ? Integer.valueOf(this.workQueue.size()) : "?") + ", h:" + this.reqCounter.getHandleCount() + ", dH:" + this.reqCounter.getDistinctIps() + ", r:" + this.reqCounter.getRequestCount() + ", m:" + ServerTools.getModeForLog(mode) + skipLimits + ", premium: " + (limits.getPremiumUid() != null && limits.hasPremium()) + (limits.getPremiumUid() != null ? ", uid:" + limits.getPremiumUid() : ""));
        if (limits.getPremiumUid() != null && limits.getPremiumUid() == 1456L) {
            log.info("Eggbun input: " + aText.getPlainText().replace("\n", "\\n").replace("\r", "\\r"));
        }
        if (premiumMatchRuleIds.size() > 0) {
            for (String premiumMatchRuleId : premiumMatchRuleIds) {
                log.info("premium:" + lang.getShortCodeWithCountryAndVariant() + ":" + premiumMatchRuleId);
            }
        }
        if (!Premium.isPremiumStatusCheck((AnnotatedText)aText)) {
            ServerMetricsCollector.getInstance().logCheck(lang, computationTime, textSize, matchCount, mode);
            if (!this.config.isSkipLoggingChecks() && limits.getRequestsPerDay() != null) {
                DatabaseCheckLogEntry logEntry = new DatabaseCheckLogEntry(userId, agentId, this.logServerId, textSize, matchCount, lang, detLang.getDetectedLanguage(), computationTime, textSessionId, mode.toString());
                this.databaseLogger.log(logEntry);
            }
            if (this.databaseLogger.isLogging()) {
                DatabasePingLogEntry ping;
                if (System.currentTimeMillis() - this.pingsCleanDateMillis > 60000L && this.pings.size() < 5000) {
                    log.info("Cleaning pings DB (" + this.pings.size() + " items)");
                    this.pings.clear();
                    this.pingsCleanDateMillis = System.currentTimeMillis();
                }
                if (agentId != null && userId != null && !this.pings.contains(ping = new DatabasePingLogEntry(agentId, userId))) {
                    this.databaseLogger.log(ping);
                    if (this.pings.size() >= 5000) {
                        log.warn("Pings DB has reached max size: " + this.pings.size());
                    } else {
                        this.pings.add(ping);
                    }
                }
            }
        }
    }

    public boolean checkerQueueAlmostFull() {
        if (this.executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executorService;
            int maxQueueSize = this.config.getTextCheckerQueueSize();
            int queuesize = threadPoolExecutor.getQueue().size();
            if (queuesize > maxQueueSize / 2) {
                log.warn("TextChecker queue is almost full requests in queue: {} active request: {}", (Object)queuesize, (Object)threadPoolExecutor.getActiveCount());
                return true;
            }
        }
        return false;
    }

    @NotNull
    private Map<String, Integer> getRuleMatchCount(List<CheckResults> res) {
        HashMap<String, Integer> ruleMatchCount = new HashMap<String, Integer>();
        for (CheckResults r : res) {
            for (RuleMatch ruleMatch : r.getRuleMatches()) {
                String ruleId = ruleMatch.getRule().getId();
                ruleMatchCount.put(ruleId, ruleMatchCount.getOrDefault(ruleId, 0) + 1);
            }
        }
        return ruleMatchCount;
    }

    private Map<String, Integer> getRuleValues(Map<String, String> parameters) {
        String[] pairs;
        HashMap<String, Integer> ruleValues = new HashMap<String, Integer>();
        String parameterString = parameters.get("ruleValues");
        if (parameterString == null) {
            return ruleValues;
        }
        for (String pair : pairs = parameterString.split(",")) {
            String[] ruleAndValue = pair.split(":");
            ruleValues.put(ruleAndValue[0], Integer.parseInt(ruleAndValue[1]));
        }
        return ruleValues;
    }

    private List<String> getUserDictWords(UserLimits limits, List<String> groups) {
        DatabaseAccess db = DatabaseAccess.getInstance();
        return db.getWords(limits, groups, 0, Integer.MAX_VALUE);
    }

    private List<Rule> getUserRules(UserLimits limits, Language lang, List<String> groups) {
        if (limits.getPremiumUid() != null && DatabaseAccess.isReady()) {
            DatabaseAccess db = DatabaseAccess.getInstance();
            return db.getRules(limits, lang, groups);
        }
        return Collections.emptyList();
    }

    protected void checkParams(Map<String, String> parameters) {
        if (parameters.get("text") == null && parameters.get("data") == null) {
            throw new BadRequestException("Missing 'text' or 'data' parameter");
        }
    }

    private List<CheckResults> getRuleMatches(AnnotatedText aText, Language lang, Language motherTongue, Map<String, String> parameters, QueryParams params, UserConfig userConfig, RuleMatchListener listener) throws Exception {
        if (this.cache != null && this.cache.requestCount() > 0.0 && this.cache.requestCount() % 500.0 == 0.0) {
            String sentenceHitPercentage = String.format(Locale.ENGLISH, "%.2f", this.cache.getSentenceCache().stats().hitRate() * 100.0);
            String matchesHitPercentage = String.format(Locale.ENGLISH, "%.2f", this.cache.getMatchesCache().stats().hitRate() * 100.0);
            String remoteHitPercentage = String.format(Locale.ENGLISH, "%.2f", this.cache.getRemoteMatchesCache().stats().hitRate() * 100.0);
            log.info("Cache stats: " + sentenceHitPercentage + "% / " + matchesHitPercentage + "% / " + remoteHitPercentage + "% hit rate");
        }
        if (parameters.get("sourceText") != null) {
            if (parameters.get("sourceLanguage") == null) {
                throw new BadRequestException("'sourceLanguage' parameter missing - must be set when 'sourceText' is set");
            }
            Language sourceLanguage = TextChecker.parseLanguage(parameters.get("sourceLanguage"));
            JLanguageTool sourceLt = new JLanguageTool(sourceLanguage);
            JLanguageTool targetLt = new JLanguageTool(lang);
            if (userConfig.filterDictionaryMatches()) {
                targetLt.addMatchFilter((RuleMatchFilter)new DictionaryMatchFilter(userConfig));
            }
            List bitextRules = Tools.getBitextRules((Language)sourceLanguage, (Language)lang);
            return Collections.singletonList(new CheckResults(Tools.checkBitext((String)parameters.get("sourceText"), (String)aText.getPlainText(), (JLanguageTool)sourceLt, (JLanguageTool)targetLt, (List)bitextRules), Collections.emptyList()));
        }
        ArrayList<CheckResults> res = new ArrayList<CheckResults>();
        res.addAll(this.getPipelineResults(aText, lang, motherTongue, params, userConfig, listener));
        return res;
    }

    private Language getLanguageVariantForCode(String langCode, List<String> preferredVariants) {
        for (String preferredVariant : preferredVariants) {
            if (!preferredVariant.startsWith(langCode + "-")) continue;
            return TextChecker.parseLanguage(preferredVariant);
        }
        return TextChecker.parseLanguage(langCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<CheckResults> getPipelineResults(AnnotatedText aText, Language lang, Language motherTongue, QueryParams params, UserConfig userConfig, RuleMatchListener listener) throws Exception {
        PipelineSettings settings = null;
        Pipeline lt = null;
        ArrayList<CheckResults> res = new ArrayList<CheckResults>();
        try {
            settings = new PipelineSettings(lang, motherTongue, params, this.config.globalConfig, userConfig);
            lt = this.pipelinePool.getPipeline(settings);
            Long textSessionId = userConfig.getTextSessionId();
            if (params.regressionTestMode) {
                textSessionId = -2L;
            }
            res.add(lt.check2(aText, true, JLanguageTool.ParagraphHandling.NORMAL, listener, params.mode, params.level, params.toneTags, textSessionId));
            if (lt == null) return res;
        }
        catch (Throwable throwable) {
            if (lt == null) throw throwable;
            this.pipelinePool.returnPipeline(settings, lt);
            throw throwable;
        }
        this.pipelinePool.returnPipeline(settings, lt);
        return res;
    }

    @NotNull
    private Map<Language, AnnotatedTextBuilder> getBuilderMap(List<FragmentWithLanguage> fragments, Set<Language> maybeUsedLangs) {
        HashMap<Language, AnnotatedTextBuilder> lang2builder = new HashMap<Language, AnnotatedTextBuilder>();
        for (Language usedLang : maybeUsedLangs) {
            if (!lang2builder.containsKey(usedLang)) {
                lang2builder.put(usedLang, new AnnotatedTextBuilder());
            }
            AnnotatedTextBuilder atb = (AnnotatedTextBuilder)lang2builder.get(usedLang);
            for (FragmentWithLanguage fragment : fragments) {
                if (usedLang.getShortCodeWithCountryAndVariant().equals(fragment.getLangCode())) {
                    atb.addText(fragment.getFragment());
                    continue;
                }
                atb.addMarkup(fragment.getFragment());
            }
        }
        return lang2builder;
    }

    @NotNull
    private List<CategoryId> getCategoryIds(String paramName, Map<String, String> parameters) {
        List<String> stringIds = this.getCommaSeparatedStrings(paramName, parameters);
        ArrayList<CategoryId> ids = new ArrayList<CategoryId>();
        for (String stringId : stringIds) {
            ids.add(new CategoryId(stringId));
        }
        return ids;
    }

    @NotNull
    protected List<String> getCommaSeparatedStrings(String paramName, Map<String, String> parameters) {
        String disabledParam = parameters.get(paramName);
        ArrayList<String> result = new ArrayList<String>();
        if (disabledParam != null) {
            result.addAll(Arrays.asList(disabledParam.split(",")));
        }
        return result;
    }

    DetectedLanguage detectLanguageOfString(String text, String fallbackLanguage, List<String> preferredVariants, List<String> noopLangs, List<String> preferredLangs) {
        return this.detectLanguageOfString(text, fallbackLanguage, preferredVariants, noopLangs, preferredLangs, false);
    }

    DetectedLanguage detectLanguageOfString(String text, String fallbackLanguage, List<String> preferredVariants, List<String> noopLangs, List<String> preferredLangs, boolean forcePreferredLanguages) {
        String cleanText = this.languageIdentifier.cleanAndShortenText(text);
        DetectedLanguage detected = this.languageIdentifier.detectLanguage(cleanText, noopLangs, preferredLangs, forcePreferredLanguages);
        Language lang = detected == null ? TextChecker.parseLanguage(fallbackLanguage != null ? fallbackLanguage : "en") : detected.getDetectedLanguage();
        if (preferredVariants.size() > 0) {
            for (String preferredVariant : preferredVariants) {
                if (!preferredVariant.contains("-")) {
                    throw new BadRequestException("Invalid format for 'preferredVariants', expected a dash as in 'en-GB': '" + preferredVariant + "'");
                }
                String preferredVariantLang = preferredVariant.split("-")[0];
                if (!preferredVariantLang.equals(lang.getShortCode()) || (lang = TextChecker.parseLanguage(preferredVariant)) != null) continue;
                throw new BadRequestException("Invalid 'preferredVariants', no such language/variant found: '" + preferredVariant + "'");
            }
        } else if (lang.getDefaultLanguageVariant() != null) {
            lang = lang.getDefaultLanguageVariant();
        }
        return new DetectedLanguage(null, lang, detected != null ? detected.getDetectionConfidence() : 0.0f, detected != null ? detected.getDetectionSource() : null);
    }

    static class QueryParams {
        final List<Language> altLanguages;
        final List<String> enabledRules;
        final List<String> disabledRules;
        final List<CategoryId> enabledCategories;
        final List<CategoryId> disabledCategories;
        final boolean useEnabledOnly;
        final boolean useQuerySettings;
        final boolean allowIncompleteResults;
        final boolean enableHiddenRules;
        final boolean premium;
        final boolean enableTempOffRules;
        final JLanguageTool.Mode mode;
        final JLanguageTool.Level level;
        final Set<ToneTag> toneTags;
        final String callback;
        final boolean inputLogging;
        final boolean regressionTestMode;

        QueryParams() {
            this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, false, false, false, false, JLanguageTool.Mode.ALL, JLanguageTool.Level.DEFAULT, null);
        }

        QueryParams(List<Language> altLanguages, List<String> enabledRules, List<String> disabledRules, List<CategoryId> enabledCategories, List<CategoryId> disabledCategories, boolean useEnabledOnly, boolean useQuerySettings, boolean allowIncompleteResults, boolean enableHiddenRules, boolean premium, boolean enableTempOffRules, JLanguageTool.Mode mode, JLanguageTool.Level level, @Nullable String callback) {
            this(altLanguages, enabledRules, disabledRules, enabledCategories, disabledCategories, useEnabledOnly, useQuerySettings, allowIncompleteResults, enableHiddenRules, premium, enableTempOffRules, mode, level, callback, true);
        }

        QueryParams(List<Language> altLanguages, List<String> enabledRules, List<String> disabledRules, List<CategoryId> enabledCategories, List<CategoryId> disabledCategories, boolean useEnabledOnly, boolean useQuerySettings, boolean allowIncompleteResults, boolean enableHiddenRules, boolean premium, boolean enableTempOffRules, JLanguageTool.Mode mode, JLanguageTool.Level level, @Nullable String callback, boolean inputLogging) {
            this(altLanguages, enabledRules, disabledRules, enabledCategories, disabledCategories, useEnabledOnly, useQuerySettings, allowIncompleteResults, enableHiddenRules, premium, enableTempOffRules, mode, level, null, callback, inputLogging);
        }

        QueryParams(List<Language> altLanguages, List<String> enabledRules, List<String> disabledRules, List<CategoryId> enabledCategories, List<CategoryId> disabledCategories, boolean useEnabledOnly, boolean useQuerySettings, boolean allowIncompleteResults, boolean enableHiddenRules, boolean premium, boolean enableTempOffRules, JLanguageTool.Mode mode, JLanguageTool.Level level, Set<ToneTag> toneTags, @Nullable String callback, boolean inputLogging) {
            this.altLanguages = Objects.requireNonNull(altLanguages);
            this.enabledRules = enabledRules;
            this.disabledRules = disabledRules;
            this.enabledCategories = enabledCategories;
            this.disabledCategories = disabledCategories;
            this.useEnabledOnly = useEnabledOnly;
            this.useQuerySettings = useQuerySettings;
            this.allowIncompleteResults = allowIncompleteResults;
            this.enableHiddenRules = enableHiddenRules;
            this.premium = premium;
            this.enableTempOffRules = enableTempOffRules;
            this.regressionTestMode = enableTempOffRules;
            this.mode = Objects.requireNonNull(mode);
            this.level = Objects.requireNonNull(level);
            this.toneTags = toneTags;
            if (callback != null && !callback.matches("[a-zA-Z]+")) {
                throw new BadRequestException("'callback' value must match [a-zA-Z]+: '" + callback + "'");
            }
            this.callback = callback;
            this.inputLogging = inputLogging;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.altLanguages).append(this.enabledRules).append(this.disabledRules).append(this.enabledCategories).append(this.disabledCategories).append(this.useEnabledOnly).append(this.useQuerySettings).append(this.allowIncompleteResults).append(this.enableHiddenRules).append(this.premium).append(this.enableTempOffRules).append(this.regressionTestMode).append((Object)this.mode).append((Object)this.level).append((Object)this.callback).append(this.inputLogging).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            QueryParams other = (QueryParams)obj;
            return new EqualsBuilder().append(this.altLanguages, other.altLanguages).append(this.enabledRules, other.enabledRules).append(this.disabledRules, other.disabledRules).append(this.enabledCategories, other.enabledCategories).append(this.disabledCategories, other.disabledCategories).append(this.useEnabledOnly, other.useEnabledOnly).append(this.useQuerySettings, other.useQuerySettings).append(this.allowIncompleteResults, other.allowIncompleteResults).append(this.enableHiddenRules, other.enableHiddenRules).append(this.premium, other.premium).append(this.enableTempOffRules, other.enableTempOffRules).append(this.regressionTestMode, other.regressionTestMode).append((Object)this.mode, (Object)other.mode).append((Object)this.level, (Object)other.level).append((Object)this.callback, (Object)other.callback).append(this.inputLogging, other.inputLogging).isEquals();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("altLanguages", this.altLanguages).append("enabledRules", this.enabledRules).append("disabledRules", this.disabledRules).append("enabledCategories", this.enabledCategories).append("disabledCategories", this.disabledCategories).append("useEnabledOnly", this.useEnabledOnly).append("useQuerySettings", this.useQuerySettings).append("allowIncompleteResults", this.allowIncompleteResults).append("enableHiddenRules", this.enableHiddenRules).append("premium", this.premium).append("enableTempOffRules", this.enableTempOffRules).append("regressionTestMode", this.regressionTestMode).append("mode", (Object)this.mode).append("level", (Object)this.level).append("callback", (Object)this.callback).append("inputLogging", this.inputLogging).build();
        }
    }
}

