"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PantalaimonClient = void 0;
const MatrixClient_1 = require("./MatrixClient");
const MatrixAuth_1 = require("./MatrixAuth");
const ACCESS_TOKEN_STORAGE_KEY = "pantalaimon_access_token";
// TODO: Write a test for this (it's hard because of the many interactions with different parts)
/**
 * Supporting functions for interacting with a Pantalaimon instance.
 * @category Encryption
 */
class PantalaimonClient {
    /**
     * Creates a new PantalaimonClient class for interacting with Pantalaimon. The storage
     * provider given will also be used in the client.
     * @param {string} homeserverUrl The homeserver (Pantalaimon) URL to interact with.
     * @param {IStorageProvider} storageProvider The storage provider to back the client with.
     */
    constructor(homeserverUrl, storageProvider) {
        this.homeserverUrl = homeserverUrl;
        this.storageProvider = storageProvider;
        // nothing to do
    }
    /**
     * Authenticates and creates the Pantalaimon-capable client. The username and password given
     * are only used if the storage provider does not reveal an access token.
     * @param {string} username The username to log in with, if needed.
     * @param {string} password The password to log in with, if needed.
     * @returns {Promise<MatrixClient>} Resolves to a MatrixClient ready for interacting with Pantalaimon.
     */
    createClientWithCredentials(username, password) {
        return __awaiter(this, void 0, void 0, function* () {
            const accessToken = yield Promise.resolve(this.storageProvider.readValue(ACCESS_TOKEN_STORAGE_KEY));
            if (accessToken) {
                return new MatrixClient_1.MatrixClient(this.homeserverUrl, accessToken, this.storageProvider);
            }
            const auth = new MatrixAuth_1.MatrixAuth(this.homeserverUrl);
            const authedClient = yield auth.passwordLogin(username, password);
            yield Promise.resolve(this.storageProvider.storeValue(ACCESS_TOKEN_STORAGE_KEY, authedClient.accessToken));
            // We recreate the client to ensure we set it up with the right storage provider.
            return new MatrixClient_1.MatrixClient(this.homeserverUrl, authedClient.accessToken, this.storageProvider);
        });
    }
}
exports.PantalaimonClient = PantalaimonClient;
