/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.starter;

import com.google.common.util.concurrent.RateLimiter;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.controller.MVBandwidthCountingInputStream;
import mediathek.controller.ThrottlingInputStream;
import mediathek.controller.starter.Start;
import mediathek.controller.starter.StarterClass;
import mediathek.daten.DatenDownload;
import mediathek.gui.dialog.DialogContinueDownload;
import mediathek.gui.dialog.MeldungDownloadfehler;
import mediathek.gui.messages.BaseEvent;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.gui.messages.DownloadProgressChangedEvent;
import mediathek.gui.messages.DownloadRateLimitChangedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FileSize;
import mediathek.tool.MVHttpClient;
import mediathek.tool.MVInfoFile;
import mediathek.tool.MVSubtitle;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.listener.Handler;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DirectHttpDownload
extends Thread {
    private static final int HTTP_RANGE_NOT_SATISFIABLE = 416;
    private static final Logger logger = LogManager.getLogger(DirectHttpDownload.class);
    private final Daten daten;
    private final DatenDownload datenDownload;
    private final Start start;
    private final RateLimiter rateLimiter;
    private final MBassador<BaseEvent> messageBus;
    private final OkHttpClient httpClient;
    private HttpDownloadState state = HttpDownloadState.DOWNLOAD;
    private long alreadyDownloaded = 0L;
    private File file = null;
    private boolean retAbbrechen;
    private boolean dialogAbbrechenIsVis;
    private CompletableFuture<Void> infoFuture;
    private CompletableFuture<Void> subtitleFuture;

    public DirectHttpDownload(Daten daten, DatenDownload d) {
        this.httpClient = MVHttpClient.getInstance().getHttpClient();
        this.rateLimiter = RateLimiter.create(this.getDownloadLimit());
        this.messageBus = daten.getMessageBus();
        this.messageBus.subscribe(this);
        this.daten = daten;
        this.datenDownload = d;
        this.start = this.datenDownload.start;
        this.setName("DIRECT DL THREAD_" + d.arr[5]);
        this.start.status = (byte)2;
        StarterClass.notifyStartEvent(this.datenDownload);
    }

    @Handler
    private void handleRateLimitChanged(DownloadRateLimitChangedEvent evt) {
        long limit = this.calculateDownloadLimit(evt.newLimit);
        logger.info("thread changing download speed limit to {} KB", (Object)limit);
        this.rateLimiter.setRate(limit);
    }

    private long calculateDownloadLimit(long limit) {
        long newLimit = limit <= 0L ? 0x280000000L : limit * 1024L;
        return newLimit;
    }

    private long getDownloadLimit() {
        long downloadLimit = ApplicationConfiguration.getConfiguration().getLong("download.rate.limit", 0L);
        return this.calculateDownloadLimit(downloadLimit);
    }

    private long getContentLength(URL url) throws IOException {
        long contentSize = -1L;
        Request request = new Request.Builder().url(url).head().header("User-Agent", this.getUserAgent()).build();
        try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();){
            if (response.isSuccessful() && (contentSize = FileSize.getContentLength(response)) < 300000L) {
                contentSize = -1L;
            }
        }
        return contentSize;
    }

    private String getUserAgent() {
        return ApplicationConfiguration.getConfiguration().getString("application.user_agent");
    }

    private void startInfoFileDownload() {
        boolean downloadInfoFile = Boolean.parseBoolean(this.datenDownload.arr[35]);
        if (downloadInfoFile) {
            this.infoFuture = CompletableFuture.runAsync(() -> {
                MVInfoFile infoFile = new MVInfoFile();
                infoFile.writeInfoFile(this.datenDownload);
            });
        }
    }

    private void downloadSubtitleFile() {
        if (Boolean.parseBoolean(this.datenDownload.arr[37])) {
            this.subtitleFuture = CompletableFuture.runAsync(() -> {
                MVSubtitle subtitleFile = new MVSubtitle();
                subtitleFile.writeSubtitle(this.datenDownload);
            });
        }
    }

    private void downloadContent(InputStream inputStream2) throws IOException {
        this.startInfoFileDownload();
        this.downloadSubtitleFile();
        this.datenDownload.interruptRestart();
        int bufferSize = ApplicationConfiguration.getConfiguration().getInt("application.http_download.file_buffer_size", 65536);
        try (FileOutputStream fos = new FileOutputStream(this.file, this.alreadyDownloaded != 0L);
             BufferedOutputStream bos = new BufferedOutputStream(fos, bufferSize);
             ThrottlingInputStream tis = new ThrottlingInputStream(inputStream2, this.rateLimiter);
             MVBandwidthCountingInputStream mvis = new MVBandwidthCountingInputStream(tis);){
            int len;
            this.start.mVBandwidthCountingInputStream = mvis;
            this.datenDownload.mVFilmSize.addAktSize(this.alreadyDownloaded);
            byte[] buffer = new byte[1024];
            long pp = 0L;
            long startProzent = -1L;
            long aktSize = 0L;
            boolean melden = false;
            while ((len = this.start.mVBandwidthCountingInputStream.read(buffer)) != -1 && !this.start.stoppen) {
                long aktBandwidth;
                this.alreadyDownloaded += (long)len;
                bos.write(buffer, 0, len);
                this.datenDownload.mVFilmSize.addAktSize(len);
                if (aktSize != this.datenDownload.mVFilmSize.getAktSize()) {
                    aktSize = this.datenDownload.mVFilmSize.getAktSize();
                    melden = true;
                }
                if (this.datenDownload.mVFilmSize.getSize() > 0L) {
                    long p = aktSize * 1000L / this.datenDownload.mVFilmSize.getSize();
                    if (startProzent == -1L) {
                        startProzent = p;
                    }
                    if (p == 0L) {
                        p = 1L;
                    } else if (p >= 1000L) {
                        p = 999L;
                    }
                    this.start.percent = (int)p;
                    if (p != pp) {
                        pp = p;
                        if (p > 2L && p > startProzent) {
                            int diffZeit = this.start.startZeit.diffInSekunden();
                            int restProzent = 1000 - (int)p;
                            this.start.restSekunden = (long)(diffZeit * restProzent) / (p - startProzent);
                            this.bereitsAnschauen(this.datenDownload);
                        }
                        melden = true;
                    }
                }
                if ((aktBandwidth = this.start.mVBandwidthCountingInputStream.getBandwidth()) != this.start.bandbreite) {
                    this.start.bandbreite = aktBandwidth;
                    melden = true;
                }
                if (!melden) continue;
                this.daten.getMessageBus().publishAsync(new DownloadProgressChangedEvent());
                melden = false;
            }
        }
        this.start.bandbreite = this.start.mVBandwidthCountingInputStream.getSumBandwidth();
        if (!this.start.stoppen) {
            this.start.status = this.datenDownload.quelle == 1 ? (byte)3 : (StarterClass.pruefen(this.daten, this.datenDownload, this.start) ? (byte)3 : (byte)4);
        }
    }

    private void printHttpErrorMessage(Response response) {
        String responseCode = "Responsecode: " + response.code() + "\n" + response.message();
        logger.error("HTTP-Fehler: {} {}", (Object)response.code(), (Object)response.message());
        if (this.start.countRestarted >= 3) {
            SwingUtilities.invokeLater(() -> new MeldungDownloadfehler((Frame)MediathekGui.ui(), "URL des Films:\n" + this.datenDownload.arr[21] + "\n\n" + responseCode + "\n", this.datenDownload).setVisible(true));
        }
        this.state = HttpDownloadState.ERROR;
        this.start.status = (byte)4;
    }

    private Request buildDownloadRequest(@NotNull URL url) {
        Request.Builder request = new Request.Builder().url(url).get().header("User-Agent", this.getUserAgent());
        if (this.alreadyDownloaded != 0L) {
            request.header("Range", "bytes=" + this.alreadyDownloaded + "-");
        }
        return request.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        StarterClass.startmeldung(this.datenDownload, this.start);
        this.messageBus.publishAsync(new DownloadStartEvent());
        Response response = null;
        ResponseBody body = null;
        try {
            this.createDirectory();
            this.file = new File(this.datenDownload.arr[31]);
            if (!this.cancelDownload()) {
                URL url = new URL(this.datenDownload.arr[21]);
                this.datenDownload.mVFilmSize.setSize(this.getContentLength(url));
                this.datenDownload.mVFilmSize.setAktSize(0L);
                Request request = this.buildDownloadRequest(url);
                response = this.httpClient.newCall(request).execute();
                body = response.body();
                if (response.isSuccessful() && body != null) {
                    this.downloadContent(body.byteStream());
                } else if (response.code() == 416) {
                    if (body != null) {
                        body.close();
                    }
                    response.close();
                    this.alreadyDownloaded = 0L;
                    request = this.buildDownloadRequest(url);
                    response = this.httpClient.newCall(request).execute();
                    body = response.body();
                    if (response.isSuccessful() && body != null) {
                        this.downloadContent(body.byteStream());
                    } else {
                        this.printHttpErrorMessage(response);
                    }
                } else {
                    this.printHttpErrorMessage(response);
                }
            }
        }
        catch (IOException ex) {
            logger.error("run()", (Throwable)ex);
            this.start.status = (byte)4;
            this.state = HttpDownloadState.ERROR;
            SwingUtilities.invokeLater(() -> new MeldungDownloadfehler((Frame)MediathekGui.ui(), ex.getLocalizedMessage(), this.datenDownload).setVisible(true));
        }
        finally {
            if (body != null) {
                body.close();
            }
            if (response != null) {
                response.close();
            }
        }
        this.waitForPendingDownloads();
        StarterClass.finalizeDownload(this.datenDownload, this.start, this.state);
        this.messageBus.publishAsync(new DownloadFinishedEvent());
        this.messageBus.unsubscribe(this);
    }

    private void waitForPendingDownloads() {
        try {
            if (this.infoFuture != null) {
                this.infoFuture.get();
            }
            if (this.subtitleFuture != null) {
                this.subtitleFuture.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("waitForPendingDownloads().", (Throwable)e);
        }
    }

    private boolean cancelDownload() {
        if (!this.file.exists()) {
            return false;
        }
        this.dialogAbbrechenIsVis = true;
        this.retAbbrechen = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.retAbbrechen = this.abbrechen_();
        } else {
            SwingUtilities.invokeLater(() -> {
                this.retAbbrechen = this.abbrechen_();
                this.dialogAbbrechenIsVis = false;
            });
        }
        while (this.dialogAbbrechenIsVis) {
            try {
                this.wait(100L);
            }
            catch (Exception exception) {}
        }
        return this.retAbbrechen;
    }

    private void createDirectory() {
        try {
            Files.createDirectories(Paths.get(this.datenDownload.arr[30], new String[0]), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean abbrechen_() {
        boolean result = false;
        if (this.file.exists()) {
            DialogContinueDownload dialogContinueDownload = new DialogContinueDownload(MediathekGui.ui(), this.datenDownload, true);
            dialogContinueDownload.setVisible(true);
            switch (dialogContinueDownload.getResult()) {
                case CANCELLED: {
                    this.state = HttpDownloadState.CANCEL;
                    result = true;
                    break;
                }
                case CONTINUE: {
                    this.alreadyDownloaded = this.file.length();
                    break;
                }
                case RESTART_WITH_NEW_NAME: {
                    if (!dialogContinueDownload.isNewName()) break;
                    this.daten.getMessageBus().publishAsync(new DownloadListChangedEvent());
                    this.createDirectory();
                    this.file = new File(this.datenDownload.arr[31]);
                }
            }
        }
        return result;
    }

    private void bereitsAnschauen(DatenDownload datenDownload) {
        long zeitGeladen;
        long filmLength;
        if (datenDownload.film != null && datenDownload.start != null && (filmLength = datenDownload.film.getFilmLength()) > 0L && datenDownload.start.restSekunden > 0L && datenDownload.mVFilmSize.getAktSize() > 0L && datenDownload.mVFilmSize.getSize() > 0L && (double)(zeitGeladen = filmLength * datenDownload.mVFilmSize.getAktSize() / datenDownload.mVFilmSize.getSize()) > (double)datenDownload.start.restSekunden * 1.1) {
            datenDownload.start.beginnAnschauen = true;
        }
    }

    static enum HttpDownloadState {
        CANCEL,
        ERROR,
        DOWNLOAD;

    }
}

