/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.sansorm.SqlClosure;
import java.lang.ref.Cleaner;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import mediathek.config.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenFilmCleanupTask;
import mediathek.daten.DatenFilmFlags;
import mediathek.daten.PooledDatabaseConnection;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.DatumFilm;
import mediathek.tool.FileSize;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.MSLong;
import mediathek.tool.MemoryUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DatenFilm
implements AutoCloseable,
Comparable<DatenFilm>,
Cloneable {
    public static final int FILM_NR = 0;
    public static final int FILM_SENDER = 1;
    public static final int FILM_THEMA = 2;
    public static final int FILM_TITEL = 3;
    public static final int FILM_ABSPIELEN = 4;
    public static final int FILM_AUFZEICHNEN = 5;
    public static final int FILM_DATUM = 6;
    public static final int FILM_ZEIT = 7;
    public static final int FILM_DAUER = 8;
    public static final int FILM_GROESSE = 9;
    public static final int FILM_HD = 10;
    public static final int FILM_UT = 11;
    public static final int FILM_GEO = 12;
    public static final int FILM_URL = 13;
    public static final int FILM_ABO_NAME = 14;
    public static final int FILM_DATUM_LONG = 15;
    public static final int FILM_URL_HISTORY = 16;
    public static final int FILM_REF = 17;
    public static final int FILM_URL_HD = 18;
    public static final int FILM_URL_SUBTITLE = 19;
    public static final int FILM_URL_KLEIN = 20;
    public static final int FILM_NEU = 21;
    public static final int MAX_ELEM = 21;
    private static final AtomicInteger FILM_COUNTER = new AtomicInteger(0);
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    private static final Logger logger = LogManager.getLogger(DatenFilm.class);
    private final EnumSet<DatenFilmFlags> flags = EnumSet.noneOf(DatenFilmFlags.class);
    private DatenAbo abo = null;
    private DatumFilm datumFilm = new DatumFilm(0L);
    private MSLong filmSize;
    private long filmLength = 0L;
    private int databaseFilmNumber;
    private Cleaner.Cleanable cleaner = null;
    private String websiteLink = null;
    private String description = null;
    private String urlKlein = "";
    private Optional<String> highQuality_url = Optional.empty();
    private String aboName = "";
    private String datumLong = "";
    private String film_nr = "";
    private String sender = "";
    private String thema = "";
    private String titel = "";
    private Optional<String> availableInCountries = Optional.empty();
    private Optional<String> subtitle_url = Optional.empty();
    private String datum = "";
    private String sendeZeit = "";
    private String dauer = "";
    private String groesse = "";
    private String url = "";

    public DatenFilm() {
        this.filmSize = new MSLong(0L);
        this.databaseFilmNumber = FILM_COUNTER.getAndIncrement();
        this.writeFilmNumberToDatabase();
        this.setupDatabaseCleanup();
    }

    public DatenAbo getAbo() {
        return this.abo;
    }

    public void setAbo(DatenAbo abo) {
        this.abo = abo;
    }

    public DatumFilm getDatumFilm() {
        return this.datumFilm;
    }

    public String getUrlKlein() {
        return this.urlKlein;
    }

    public void setUrlKlein(String urlKlein) {
        this.urlKlein = urlKlein;
    }

    public String getHighQualityUrl() {
        return this.highQuality_url.orElse("");
    }

    public void setHighQualityUrl(String urlHd) {
        this.highQuality_url = !urlHd.isEmpty() ? Optional.of(urlHd) : Optional.empty();
    }

    public String getAboName() {
        return this.aboName;
    }

    public void setAboName(String aboName) {
        this.aboName = aboName;
    }

    public String getDatumLong() {
        return this.datumLong;
    }

    public void setDatumLong(String datumLong) {
        this.datumLong = datumLong;
    }

    private void writeFilmNumberToDatabase() {
        if (MemoryUtils.isLowMemoryEnvironment()) {
            SqlClosure.sqlExecute(connection -> {
                PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO mediathekview.film VALUES (?)");
                insertStatement.setInt(1, this.databaseFilmNumber);
                insertStatement.executeUpdate();
                return null;
            });
        }
    }

    public boolean isTrailerTeaser() {
        return this.flags.contains((Object)DatenFilmFlags.TRAILER_TEASER);
    }

    public void setTrailerTeaser(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.TRAILER_TEASER);
        } else {
            this.flags.remove((Object)DatenFilmFlags.TRAILER_TEASER);
        }
    }

    public boolean isAudioVersion() {
        return this.flags.contains((Object)DatenFilmFlags.AUDIO_VERSION);
    }

    public void setAudioVersion(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.AUDIO_VERSION);
        } else {
            this.flags.remove((Object)DatenFilmFlags.AUDIO_VERSION);
        }
    }

    public boolean isSignLanguage() {
        return this.flags.contains((Object)DatenFilmFlags.SIGN_LANGUAGE);
    }

    public void setSignLanguage(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.SIGN_LANGUAGE);
        } else {
            this.flags.remove((Object)DatenFilmFlags.SIGN_LANGUAGE);
        }
    }

    public int getFilmNr() {
        return this.databaseFilmNumber;
    }

    private void setupDatabaseCleanup() {
        boolean useCleaner;
        if (MemoryUtils.isLowMemoryEnvironment() && (useCleaner = ApplicationConfiguration.getConfiguration().getBoolean("database.cleanup.use_cleaner", false))) {
            this.installCleanupTask();
        }
    }

    private void installCleanupTask() {
        DatenFilmCleanupTask task = new DatenFilmCleanupTask(this.databaseFilmNumber);
        this.cleaner = Daten.getInstance().getCleaner().register(this, task);
    }

    public MSLong getFilmSize() {
        return this.filmSize;
    }

    @Override
    public void close() {
        if (this.cleaner != null) {
            this.cleaner.clean();
        }
    }

    public String getDescription() {
        if (MemoryUtils.isLowMemoryEnvironment()) {
            return SqlClosure.sqlExecute(connection -> {
                PreparedStatement statement = connection.prepareStatement("SELECT desc FROM mediathekview.description WHERE id = ?");
                statement.setLong(1, this.databaseFilmNumber);
                ResultSet rs = statement.executeQuery();
                return rs.next() ? rs.getString(1) : "";
            });
        }
        return StringUtils.defaultString(this.description);
    }

    public void setDescription(String desc) {
        if (desc != null && !desc.isEmpty()) {
            if (MemoryUtils.isLowMemoryEnvironment()) {
                SqlClosure.sqlExecute(connection -> {
                    PreparedStatement mergeStatement = connection.prepareStatement("MERGE INTO mediathekview.description KEY(ID) VALUES (?,?)");
                    mergeStatement.setInt(1, this.databaseFilmNumber);
                    mergeStatement.setString(2, desc);
                    mergeStatement.executeUpdate();
                    return null;
                });
            } else {
                this.description = desc;
            }
        }
    }

    public String getWebsiteLink() {
        if (MemoryUtils.isLowMemoryEnvironment()) {
            return SqlClosure.sqlExecute(connection -> {
                PreparedStatement statement = connection.prepareStatement("SELECT link FROM mediathekview.website_links WHERE id = ?");
                statement.setLong(1, this.databaseFilmNumber);
                ResultSet rs = statement.executeQuery();
                return rs.next() ? rs.getString(1) : "";
            });
        }
        return this.websiteLink != null ? this.websiteLink : "";
    }

    public void setWebsiteLink(String link) {
        if (link != null && !link.isEmpty()) {
            if (MemoryUtils.isLowMemoryEnvironment()) {
                SqlClosure.sqlExecute(connection -> {
                    PreparedStatement mergeStatement = connection.prepareStatement("MERGE INTO mediathekview.website_links KEY(ID) VALUES (?,?)");
                    mergeStatement.setInt(1, this.databaseFilmNumber);
                    mergeStatement.setString(2, link);
                    mergeStatement.executeUpdate();
                    return null;
                });
            } else {
                this.websiteLink = link;
            }
        }
    }

    public boolean isNew() {
        return this.flags.contains((Object)DatenFilmFlags.NEW_ENTRY);
    }

    public void setNew(boolean newFilm) {
        if (newFilm) {
            this.flags.add(DatenFilmFlags.NEW_ENTRY);
        } else {
            this.flags.remove((Object)DatenFilmFlags.NEW_ENTRY);
        }
    }

    public boolean isLivestream() {
        return this.flags.contains((Object)DatenFilmFlags.LIVESTREAM);
    }

    public void setLivestream(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.LIVESTREAM);
        } else {
            this.flags.remove((Object)DatenFilmFlags.LIVESTREAM);
        }
    }

    public boolean hasSubtitle() {
        return this.subtitle_url.isPresent();
    }

    public String getUrlFuerAufloesung(String aufloesung) {
        String ret;
        switch (aufloesung) {
            case "klein": 
            case "hd": {
                ret = this.getUrlNormalOrRequested(aufloesung);
                break;
            }
            default: {
                ret = this.getUrl();
            }
        }
        return ret;
    }

    public String getDateigroesse(String url) {
        if (url.equals(this.getUrl())) {
            return this.getSize();
        }
        return FileSize.laengeString(url);
    }

    public String getIndex() {
        return (this.getSender() + this.getThema()).toLowerCase() + this.getUrl();
    }

    public boolean isHighQuality() {
        return this.highQuality_url.isPresent();
    }

    public Object clone() throws CloneNotSupportedException {
        DatenFilm ret = (DatenFilm)super.clone();
        ret.datumFilm = this.datumFilm;
        ret.databaseFilmNumber = this.databaseFilmNumber;
        ret.filmSize = this.filmSize;
        ret.filmLength = this.filmLength;
        ret.abo = this.abo;
        ret.highQuality_url = this.highQuality_url;
        ret.urlKlein = this.urlKlein;
        ret.aboName = this.aboName;
        ret.datumLong = this.datumLong;
        ret.film_nr = this.film_nr;
        ret.sender = this.sender;
        ret.thema = this.thema;
        ret.titel = this.titel;
        ret.availableInCountries = this.availableInCountries;
        ret.datum = this.datum;
        ret.sendeZeit = this.sendeZeit;
        ret.dauer = this.dauer;
        ret.groesse = this.groesse;
        ret.url = this.url;
        ret.subtitle_url = this.subtitle_url;
        return ret;
    }

    @Override
    public int compareTo(@NotNull DatenFilm other) {
        int ret = sorter.compare(this.getSender(), other.getSender());
        if (ret == 0) {
            return sorter.compare(this.getThema(), other.getThema());
        }
        return ret;
    }

    public long getFilmLength() {
        return this.filmLength;
    }

    private long parseTimeToSeconds() {
        long seconds = 0L;
        String[] split = StringUtils.split(this.getDauer(), ':');
        try {
            seconds += Long.parseLong(split[0]) * 3600L;
            seconds += Long.parseLong(split[1]) * 60L;
            seconds += Long.parseLong(split[2]);
        }
        catch (Exception e) {
            seconds = 0L;
        }
        return seconds;
    }

    private void calculateFilmLength() {
        this.filmLength = this.parseTimeToSeconds();
    }

    private void setDatum() {
        if (!this.getSendeDatum().isEmpty()) {
            try {
                long l = Long.parseLong(this.getDatumLong());
                this.datumFilm = new DatumFilm(l * 1000L);
            }
            catch (Exception ex) {
                logger.debug("Datum: {}, Zeit: {}, Datum_LONG: {}", (Object)this.getSendeDatum(), (Object)this.getSendeZeit(), (Object)this.getDatumLong(), (Object)ex);
                this.datumFilm = new DatumFilm(0L);
                this.setSendeDatum("");
                this.setSendeZeit("");
            }
        }
    }

    public void init() {
        this.filmSize = new MSLong(this);
        this.calculateFilmLength();
        this.setDatum();
    }

    private String getUrlNormalOrRequested(@NotNull String aufloesung) {
        String ret;
        String requestedUrl = this.getUrlByAufloesung(aufloesung);
        if (requestedUrl.isEmpty()) {
            ret = this.getUrl();
        } else {
            try {
                int indexPipe = requestedUrl.indexOf(124);
                ret = indexPipe == -1 ? requestedUrl : this.decompressUrl(requestedUrl, indexPipe);
            }
            catch (Exception e) {
                ret = "";
                logger.error("getUrlNormalOrRequested(aufl\u00f6sung: {}, requestedUrl: {})", (Object)aufloesung, (Object)requestedUrl, (Object)e);
            }
        }
        return ret;
    }

    private String decompressUrl(@NotNull String requestedUrl, int indexPipe) {
        int i = Integer.parseInt(requestedUrl.substring(0, indexPipe));
        return this.getUrl().substring(0, i) + requestedUrl.substring(indexPipe + 1);
    }

    private String getUrlByAufloesung(@NotNull String aufloesung) {
        switch (aufloesung) {
            case "hd": {
                return this.getHighQualityUrl();
            }
            case "klein": {
                return this.getUrlKlein();
            }
        }
        return this.getUrl();
    }

    public String getNr() {
        return this.film_nr;
    }

    public void setNr(String nr) {
        this.film_nr = nr;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getThema() {
        return this.thema;
    }

    public void setThema(String thema) {
        this.thema = thema;
    }

    public String getTitle() {
        return this.titel;
    }

    public void setTitle(String title) {
        this.titel = title;
    }

    public String getSendeDatum() {
        return this.datum;
    }

    public void setSendeDatum(String sendeDatum) {
        this.datum = sendeDatum;
    }

    public String getSendeZeit() {
        return this.sendeZeit;
    }

    public void setSendeZeit(String sendeZeit) {
        this.sendeZeit = sendeZeit;
    }

    public String getDauer() {
        return this.dauer;
    }

    public void setDauer(String dauer) {
        this.dauer = dauer;
    }

    public String getSize() {
        return this.groesse;
    }

    public void setSize(String size) {
        this.groesse = size;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlSubtitle() {
        return this.subtitle_url.orElse("");
    }

    public void setUrlSubtitle(String urlSubtitle) {
        this.subtitle_url = !urlSubtitle.isEmpty() ? Optional.of(urlSubtitle) : Optional.empty();
    }

    public Optional<String> getGeo() {
        return this.availableInCountries;
    }

    public void setGeo(Optional<String> availableInCountries) {
        this.availableInCountries = availableInCountries;
    }

    public static class Database {
        private Database() {
        }

        public static void closeDatabase() {
            HikariDataSource ds = PooledDatabaseConnection.getInstance().getDataSource();
            ds.close();
        }

        public static void createIndices() {
            logger.trace("Creating SQL indices");
            SqlClosure.sqlExecute(connection -> {
                Statement statement = connection.createStatement();
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS IDX_FILM_ID ON mediathekview.film (id)");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS IDX_DESC_ID ON mediathekview.description (id)");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS IDX_WEBSITE_LINKS_ID ON mediathekview.website_links (id)");
                return null;
            });
            logger.trace("Finished creating SQL indices");
        }

        public static void initializeDatabase() {
            logger.debug("initializeDatabase()");
            SqlClosure.sqlExecute(connection -> {
                Statement statement = connection.createStatement();
                if (!MemoryUtils.isLowMemoryEnvironment()) {
                    statement.executeUpdate("SET WRITE_DELAY 5000");
                    statement.executeUpdate("SET MAX_OPERATION_MEMORY 0");
                }
                statement.executeUpdate("SET LOG 0");
                statement.executeUpdate("CREATE SCHEMA IF NOT EXISTS mediathekview");
                statement.executeUpdate("SET SCHEMA mediathekview");
                statement.executeUpdate("DROP INDEX IF EXISTS IDX_FILM_ID");
                statement.executeUpdate("DROP INDEX IF EXISTS IDX_DESC_ID");
                statement.executeUpdate("DROP INDEX IF EXISTS IDX_WEBSITE_LINKS_ID");
                statement.executeUpdate("DROP TABLE IF EXISTS mediathekview.description");
                statement.executeUpdate("DROP TABLE IF EXISTS mediathekview.website_links");
                statement.executeUpdate("DROP TABLE IF EXISTS mediathekview.film");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS film (id INTEGER NOT NULL PRIMARY KEY)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS description (id INTEGER NOT NULL PRIMARY KEY REFERENCES mediathekview.film ON DELETE CASCADE, desc VARCHAR(1024))");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS website_links (id INTEGER NOT NULL PRIMARY KEY REFERENCES mediathekview.film ON DELETE CASCADE, link VARCHAR(1024))");
                return null;
            });
            logger.debug("initializeDatabase() done.");
        }
    }
}

