local util = require 'lspconfig.util'

return {
  default_config = {
    filetypes = { 'arduino' },
    root_dir = util.root_pattern '*.ino',
    cmd = {
      'arduino-language-server',
    },
  },
  docs = {
    description = [[
https://github.com/arduino/arduino-language-server

Language server for Arduino

The `arduino-language-server` can be installed by running:

```
go install github.com/arduino/arduino-language-server@latest
```

The `arduino-cli` tool must also be installed. Follow [these
installation instructions](https://arduino.github.io/arduino-cli/latest/installation/) for
your platform.

After installing `arduino-cli`, follow [these
instructions](https://arduino.github.io/arduino-cli/latest/getting-started/#create-a-configuration-file)
for generating a configuration file if you haven't done so already, and make
sure you [install any relevant platforms
libraries](https://arduino.github.io/arduino-cli/latest/getting-started/#install-the-core-for-your-board).

The language server also requires `clangd` to be installed. Follow [these
installation instructions](https://clangd.llvm.org/installation) for your
platform.

If you don't have a sketch yet create one.

```sh
$ arduino-cli sketch new test
$ cd  test
```

You will need a `sketch.json` file in order for the language server to understand your project. It will also save you passing options to `arduino-cli` each time you compile or upload a file. You can generate the file like using the following commands.


First gather some information about your board. Make sure your board is connected and run the following:

```sh
$ arduino-cli board list
Port         Protocol Type              Board Name  FQBN            Core
/dev/ttyACM0 serial   Serial Port (USB) Arduino Uno arduino:avr:uno arduino:avr
```

Then generate the file:

```sh
arduino-cli board attach -p /dev/ttyACM0 test.ino
```

The resulting file should like like this:

```json
{
  "cpu": {
    "fqbn": "arduino:avr:uno",
    "name": "Arduino Uno",
    "port": "serial:///dev/ttyACM0"
  }
}
```

Your folder structure should look like this:

```
.
├── test.ino
└── sketch.json
```

For further instruction about configuration options, run `arduino-language-server --help`.
]],
  },
}
