/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.util.ArrayList;
import org.apache.batik.apps.svgbrowser.AbstractUndoableCommand;
import org.apache.batik.apps.svgbrowser.UndoableCommand;

public abstract class AbstractCompoundCommand
extends AbstractUndoableCommand {
    protected ArrayList atomCommands = new ArrayList();

    public void addCommand(UndoableCommand undoableCommand) {
        if (undoableCommand.shouldExecute()) {
            this.atomCommands.add(undoableCommand);
        }
    }

    public void execute() {
        int n = this.atomCommands.size();
        for (int i = 0; i < n; ++i) {
            UndoableCommand undoableCommand = (UndoableCommand)this.atomCommands.get(i);
            undoableCommand.execute();
        }
    }

    public void undo() {
        int n = this.atomCommands.size();
        for (int i = n - 1; i >= 0; --i) {
            UndoableCommand undoableCommand = (UndoableCommand)this.atomCommands.get(i);
            undoableCommand.undo();
        }
    }

    public void redo() {
        int n = this.atomCommands.size();
        for (int i = 0; i < n; ++i) {
            UndoableCommand undoableCommand = (UndoableCommand)this.atomCommands.get(i);
            undoableCommand.redo();
        }
    }

    public boolean shouldExecute() {
        boolean bl = true;
        if (this.atomCommands.size() == 0) {
            bl = false;
        }
        int n = this.atomCommands.size();
        for (int i = 0; i < n && bl; ++i) {
            UndoableCommand undoableCommand = (UndoableCommand)this.atomCommands.get(i);
            bl = undoableCommand.shouldExecute() && bl;
        }
        return bl;
    }

    public int getCommandNumber() {
        return this.atomCommands.size();
    }
}

