/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.rest.RestLanguage;
import com.jetbrains.rest.RestPythonElementTypes;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RestFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private Set<Language> myLanguages;

    public RestFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        RestLanguage restLanguage = RestLanguage.INSTANCE;
        if (restLanguage == null) {
            RestFileViewProvider.$$$reportNull$$$0(0);
        }
        return restLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        PythonLanguage pythonLanguage = PythonLanguage.getInstance();
        if (pythonLanguage == null) {
            RestFileViewProvider.$$$reportNull$$$0(1);
        }
        return pythonLanguage;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            RestFileViewProvider.$$$reportNull$$$0(2);
        }
        RestFileViewProvider restFileViewProvider = new RestFileViewProvider((PsiManager)this.getManager(), virtualFile, false);
        if (restFileViewProvider == null) {
            RestFileViewProvider.$$$reportNull$$$0(3);
        }
        return restFileViewProvider;
    }

    @NotNull
    public Set<Language> getLanguages() {
        if (this.myLanguages == null) {
            HashSet languages = ContainerUtil.newHashSet();
            languages.add(this.getBaseLanguage());
            Language djangoTemplateLanguage = Language.findLanguageByID((String)"DjangoTemplate");
            if (djangoTemplateLanguage != null) {
                languages.add(djangoTemplateLanguage);
            }
            languages.add(this.getTemplateDataLanguage());
            this.myLanguages = languages;
        }
        Set<Language> set = this.myLanguages;
        if (set == null) {
            RestFileViewProvider.$$$reportNull$$$0(4);
        }
        return set;
    }

    protected PsiFile createFile(@NotNull Language lang) {
        ParserDefinition def;
        if (lang == null) {
            RestFileViewProvider.$$$reportNull$$$0(5);
        }
        if ((def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) == null) {
            return null;
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)def.createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)RestPythonElementTypes.PYTHON_BLOCK_DATA);
            return file;
        }
        if (lang.getID().equals("DjangoTemplate")) {
            PsiFileImpl file = (PsiFileImpl)def.createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)RestPythonElementTypes.DJANGO_BLOCK_DATA);
            return file;
        }
        if (lang == RestLanguage.INSTANCE) {
            return def.createFile((FileViewProvider)this);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/rest/RestFileViewProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/rest/RestFileViewProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneInner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

