/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NSDefaults {
    private static final Logger LOG = Logger.getInstance(NSDefaults.class);
    public static final String ourTouchBarDomain = "com.apple.touchbar.agent";
    public static final String ourTouchBarNode = "PresentationModePerApp";
    public static final String ourTouchBarShowFnValue = "functionKeys";

    public static boolean isShowFnKeysEnabled(String appId) {
        Path path = Path.createDomainPath(ourTouchBarDomain, ourTouchBarNode);
        String sval = path.readStringVal(appId);
        return sval != null && sval.equals(ourTouchBarShowFnValue);
    }

    public static boolean setShowFnKeysEnabled(String appId, boolean val) {
        return NSDefaults.setShowFnKeysEnabled(appId, val, false);
    }

    public static boolean setShowFnKeysEnabled(String appId, boolean val, boolean performExtraDebugChecks) {
        Path path = Path.createDomainPath(ourTouchBarDomain, ourTouchBarNode);
        String sval = path.readStringVal(appId);
        boolean settingEnabled = sval != null && sval.equals(ourTouchBarShowFnValue);
        String initDesc = "appId='" + appId + "', value (requested be set) ='" + val + "', initial path (tail) value = '" + sval + "', path='" + path.toString() + "'";
        if (val == settingEnabled) {
            if (performExtraDebugChecks) {
                LOG.error("nothing to change: " + initDesc);
            }
            return false;
        }
        path.writeStringValue(appId, val ? ourTouchBarShowFnValue : null);
        if (performExtraDebugChecks) {
            boolean isFNEnabled;
            sval = path.readStringVal(appId, true);
            boolean bl = isFNEnabled = sval != null && sval.equals(ourTouchBarShowFnValue);
            if (val != isFNEnabled) {
                LOG.error("can't write value '" + val + "' (was written just now, but read '" + sval + "'): " + initDesc);
            } else {
                LOG.error("value '" + val + "' was written from second attempt: " + initDesc);
            }
        }
        return true;
    }

    public static String readStringVal(String domain, String key) {
        Path result = new Path();
        result.myPath.add(new Path.Node("persistentDomainForName:", domain));
        return result.readStringVal(key);
    }

    public static boolean isDomainExists(String domain) {
        Path result = new Path();
        result.myPath.add(new Path.Node("persistentDomainForName:", domain));
        return result.lastValidPos() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDarkMenuBar() {
        assert (SystemInfo.isMac);
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            if (defaults == null || defaults.equals((Object)ID.NIL)) {
                boolean bl = false;
                return bl;
            }
            ID valObj = Foundation.invoke(defaults, "objectForKey:", new Object[]{Foundation.nsString("AppleInterfaceStyle")});
            if (valObj == null || valObj.equals((Object)ID.NIL)) {
                boolean bl = false;
                return bl;
            }
            String sval = Foundation.toStringViaUTF8(valObj);
            boolean bl = sval != null && sval.equals("Dark");
            return bl;
        }
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _listAllKeys() {
        ArrayList<String> res = new ArrayList<String>(100);
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            ID allKeysDict = Foundation.invoke(defaults, "dictionaryRepresentation", new Object[0]);
            ID allKeysArr = Foundation.invoke(allKeysDict, "allKeys", new Object[0]);
            ID count = Foundation.invoke(allKeysArr, "count", new Object[0]);
            for (int c = 0; c < count.intValue(); ++c) {
                ID nsKeyName = Foundation.invoke(allKeysArr, "objectAtIndex:", c);
                String keyName = Foundation.toStringViaUTF8(nsKeyName);
                res.add(keyName);
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        finally {
            pool.drain();
        }
    }

    private static class Path {
        @NotNull
        private final ArrayList<Node> myPath = new ArrayList();

        private Path() {
        }

        public String toString() {
            String res = "";
            for (Node pn : this.myPath) {
                if (!res.isEmpty()) {
                    res = res + " | ";
                }
                res = res + pn.toString();
            }
            return res;
        }

        String readStringVal(@NotNull String key) {
            if (key == null) {
                Path.$$$reportNull$$$0(0);
            }
            return this.readStringVal(key, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String readStringVal(@NotNull String key, boolean doSyncronize) {
            if (key == null) {
                Path.$$$reportNull$$$0(1);
            }
            if (this.myPath.isEmpty()) {
                return null;
            }
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
                if (defaults == null || defaults.equals((Object)ID.NIL)) {
                    String string = null;
                    return string;
                }
                if (doSyncronize) {
                    Foundation.invoke(defaults, "synchronize", new Object[0]);
                }
                this._readPath(defaults);
                Node tail = this.myPath.get(this.myPath.size() - 1);
                if (!tail.isValid()) {
                    String string = null;
                    return string;
                }
                ID valObj = Foundation.invoke(tail.cachedNodeObj, "objectForKey:", new Object[]{Foundation.nsString(key)});
                if (valObj == null || valObj.equals((Object)ID.NIL)) {
                    String string = null;
                    return string;
                }
                String string = Foundation.toStringViaUTF8(valObj);
                return string;
            }
            finally {
                pool.drain();
                this._resetPathCache();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeStringValue(@NotNull String key, String val) {
            if (key == null) {
                Path.$$$reportNull$$$0(2);
            }
            if (this.myPath.isEmpty()) {
                return;
            }
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
                if (defaults == null || defaults.equals((Object)ID.NIL)) {
                    return;
                }
                this._readPath(defaults);
                int pos = this.myPath.size() - 1;
                Node child = this.myPath.get(pos--);
                if (!child.isValid() && val == null) {
                    return;
                }
                child.writeStringValue(key, val);
                while (pos >= 0) {
                    Node parent = this.myPath.get(pos--);
                    ID mnode = Foundation.invoke(parent.cachedNodeObj, "mutableCopy", new Object[0]);
                    Foundation.invoke(mnode, "setObject:forKey:", new Object[]{child.cachedNodeObj, Foundation.nsString(child.myNodeName)});
                    parent.cachedNodeObj = mnode;
                    child = parent;
                }
                String topWriteSelector = child.isDomain() ? "setPersistentDomain:forName:" : "setObject:forKey:";
                Foundation.invoke(defaults, topWriteSelector, new Object[]{child.cachedNodeObj, Foundation.nsString(child.myNodeName)});
            }
            finally {
                pool.drain();
                this._resetPathCache();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int lastValidPos() {
            if (this.myPath.isEmpty()) {
                return -1;
            }
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
                if (defaults == null || defaults.equals((Object)ID.NIL)) {
                    int n = -1;
                    return n;
                }
                this._readPath(defaults);
                for (int pos = 0; pos < this.myPath.size(); ++pos) {
                    Node pn = this.myPath.get(pos);
                    if (pn.isValid()) continue;
                    int n = pos - 1;
                    return n;
                }
                int n = this.myPath.size() - 1;
                return n;
            }
            finally {
                pool.drain();
                this._resetPathCache();
            }
        }

        @NotNull
        static Path createDomainPath(@NotNull String domain, @NotNull String[] nodes) {
            if (domain == null) {
                Path.$$$reportNull$$$0(3);
            }
            if (nodes == null) {
                Path.$$$reportNull$$$0(4);
            }
            Path result = new Path();
            result.myPath.add(new Node("persistentDomainForName:", domain));
            for (String nodeName : nodes) {
                result.myPath.add(new Node("objectForKey:", nodeName));
            }
            Path path = result;
            if (path == null) {
                Path.$$$reportNull$$$0(5);
            }
            return path;
        }

        @NotNull
        static Path createDomainPath(@NotNull String domain, @NotNull String nodeName) {
            if (domain == null) {
                Path.$$$reportNull$$$0(6);
            }
            if (nodeName == null) {
                Path.$$$reportNull$$$0(7);
            }
            Path result = new Path();
            result.myPath.add(new Node("persistentDomainForName:", domain));
            result.myPath.add(new Node("objectForKey:", nodeName));
            Path path = result;
            if (path == null) {
                Path.$$$reportNull$$$0(8);
            }
            return path;
        }

        private void _readPath(ID parent) {
            if (this.myPath.isEmpty()) {
                return;
            }
            for (Node pn : this.myPath) {
                pn.readNode(parent);
                if (!pn.isValid()) {
                    return;
                }
                parent = pn.cachedNodeObj;
            }
        }

        private void _resetPathCache() {
            for (Node pn : this.myPath) {
                pn.cachedNodeObj = ID.NIL;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/mac/foundation/NSDefaults$Path";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/mac/foundation/NSDefaults$Path";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDomainPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "readStringVal";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "writeStringValue";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createDomainPath";
                    break;
                }
                case 5: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class Node {
            @NotNull
            private final String mySelector;
            @NotNull
            private final String myNodeName;
            @NotNull
            private ID cachedNodeObj;

            Node(@NotNull String selector, @NotNull String nodeName) {
                if (selector == null) {
                    Node.$$$reportNull$$$0(0);
                }
                if (nodeName == null) {
                    Node.$$$reportNull$$$0(1);
                }
                this.cachedNodeObj = ID.NIL;
                this.mySelector = selector;
                this.myNodeName = nodeName;
            }

            public String toString() {
                return String.format("sel='%s' nodeName='%s'", this.mySelector, this.myNodeName);
            }

            boolean isValid() {
                return !this.cachedNodeObj.equals((Object)ID.NIL);
            }

            boolean isDomain() {
                return this.mySelector.equals("persistentDomainForName:");
            }

            void readNode(ID parent) {
                this.cachedNodeObj = ID.NIL;
                if (parent == null || parent.equals((Object)ID.NIL)) {
                    return;
                }
                ID nodeObj = Foundation.invoke(parent, this.mySelector, new Object[]{Foundation.nsString(this.myNodeName)});
                if (nodeObj == null || nodeObj.equals((Object)ID.NIL)) {
                    return;
                }
                this.cachedNodeObj = nodeObj;
            }

            private static ID _createDictionary() {
                return Foundation.invoke("NSMutableDictionary", "new", new Object[0]);
            }

            void writeStringValue(@NotNull String key, String val) {
                ID mnode;
                if (key == null) {
                    Node.$$$reportNull$$$0(2);
                }
                if (!this.isValid()) {
                    if (val == null) {
                        return;
                    }
                    mnode = Node._createDictionary();
                } else {
                    mnode = Foundation.invoke(this.cachedNodeObj, "mutableCopy", new Object[0]);
                }
                if (mnode == null || mnode.equals((Object)ID.NIL)) {
                    return;
                }
                if (val != null) {
                    Foundation.invoke(mnode, "setObject:forKey:", new Object[]{Foundation.nsString(val), Foundation.nsString(key)});
                } else {
                    Foundation.invoke(mnode, "removeObjectForKey:", new Object[]{Foundation.nsString(key)});
                }
                this.cachedNodeObj = mnode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selector";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nodeName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/mac/foundation/NSDefaults$Path$Node";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "writeStringValue";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

