/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.classes.PyMemberInfoStorage;
import com.jetbrains.python.refactoring.classes.PyMembersRefactoringSupport;
import org.jetbrains.annotations.NotNull;

public abstract class PyClassRefactoringHandler
implements RefactoringActionHandler,
ElementsHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            PyClassRefactoringHandler.$$$reportNull$$$0(0);
        }
        PsiElement element1 = null;
        PsiElement element2 = null;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            element1 = file.findElementAt(selectionModel.getSelectionStart());
            element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
        } else {
            CaretModel caretModel = editor.getCaretModel();
            Document document = editor.getDocument();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            if (lineNumber >= 0 && lineNumber < document.getLineCount()) {
                element1 = file.findElementAt(document.getLineStartOffset(lineNumber));
                element2 = file.findElementAt(document.getLineEndOffset(lineNumber) - 1);
            }
        }
        if (element1 == null || element2 == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyBundle.message("refactoring.introduce.selection.error", new Object[0]), (String)this.getTitle(), (String)"members.pull.up");
            return;
        }
        this.doRefactor(project, element1, element2, editor, file, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            PyClassRefactoringHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            PyClassRefactoringHandler.$$$reportNull$$$0(2);
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        this.doRefactor(project, elements[0], elements[elements.length - 1], editor, file, dataContext);
    }

    private void doRefactor(Project project, PsiElement element1, PsiElement element2, Editor editor, PsiFile file, DataContext dataContext) {
        if (ApplicationManagerEx.getApplicationEx().isUnitTestMode()) {
            return;
        }
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        PyClass clazz = PyUtil.getContainingClassOrSelf(element1);
        if (!this.inClass(clazz, project, editor, "refactoring.pull.up.error.cannot.perform.refactoring.not.inside.class")) {
            return;
        }
        assert (clazz != null);
        PyMemberInfoStorage infoStorage = PyMembersRefactoringSupport.getSelectedMemberInfos(clazz, element1, element2);
        this.doRefactorImpl(project, clazz, infoStorage, editor);
    }

    protected abstract void doRefactorImpl(@NotNull Project var1, @NotNull PyClass var2, @NotNull PyMemberInfoStorage var3, @NotNull Editor var4);

    protected boolean inClass(PyClass clazz, Project project, Editor editor, String errorMessageId) {
        if (clazz == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyBundle.message(errorMessageId, new Object[0]), (String)this.getTitle(), (String)this.getHelpId());
            return false;
        }
        return true;
    }

    protected abstract String getTitle();

    protected abstract String getHelpId();

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PyClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

