/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.reference.SoftReference;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class AbstractTreeBuilder
implements Disposable {
    private AbstractTreeUi myUi;
    @NonNls
    private static final String TREE_BUILDER = "TreeBuilder";
    protected static final boolean DEFAULT_UPDATE_INACTIVE = true;

    public AbstractTreeBuilder(@NotNull JTree tree, @NotNull DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator) {
        if (tree == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(0);
        }
        if (treeModel == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(1);
        }
        this(tree, treeModel, treeStructure, comparator, true);
    }

    public AbstractTreeBuilder(@NotNull JTree tree, @NotNull DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator, boolean updateIfInactive) {
        if (tree == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(2);
        }
        if (treeModel == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(3);
        }
        this.init(tree, treeModel, treeStructure, comparator, updateIfInactive);
    }

    protected AbstractTreeBuilder() {
    }

    protected void init(@NotNull JTree tree, @NotNull DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator, boolean updateIfInactive) {
        if (tree == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(4);
        }
        if (treeModel == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(5);
        }
        tree.putClientProperty(TREE_BUILDER, new WeakReference<AbstractTreeBuilder>(this));
        this.myUi = this.createUi();
        this.myUi.init(this, tree, treeModel, treeStructure, comparator, updateIfInactive);
        this.setPassthroughMode(AbstractTreeBuilder.isUnitTestingMode());
    }

    @NotNull
    protected AbstractTreeUi createUi() {
        AbstractTreeUi abstractTreeUi = new AbstractTreeUi();
        if (abstractTreeUi == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(6);
        }
        return abstractTreeUi;
    }

    public final void scrollTo(Object element) {
        this.scrollTo(element, null);
    }

    public final void scrollTo(Object element, Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userScrollTo(element, onDone == null ? null : new UserRunnable(onDone));
        }
    }

    public final void select(Object element) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userSelect(new Object[]{element}, null, false, true);
        }
    }

    public final void select(Object element, @Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userSelect(new Object[]{element}, new UserRunnable(onDone), false, true);
        }
    }

    public final void select(Object element, @Nullable Runnable onDone, boolean addToSelection) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userSelect(new Object[]{element}, new UserRunnable(onDone), addToSelection, true);
        }
    }

    public final void select(Object[] elements, @Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userSelect(elements, new UserRunnable(onDone), false, true);
        }
    }

    public final void select(Object[] elements, @Nullable Runnable onDone, boolean addToSelection) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.userSelect(elements, new UserRunnable(onDone), addToSelection, true);
        }
    }

    public final void expand(Object element, @Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.expand(element, (Runnable)new UserRunnable(onDone));
        }
    }

    public final void expand(Object[] element, @Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.expand(element, (Runnable)new UserRunnable(onDone));
        }
    }

    public final void collapseChildren(Object element, @Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.collapseChildren(element, new UserRunnable(onDone));
        }
    }

    @NotNull
    static AbstractTreeNode<Object> createSearchingTreeNodeWrapper() {
        AbstractTreeNodeWrapper abstractTreeNodeWrapper = new AbstractTreeNodeWrapper();
        if (abstractTreeNodeWrapper == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(7);
        }
        return abstractTreeNodeWrapper;
    }

    @Nullable
    protected AbstractTreeUpdater createUpdater() {
        if (this.isDisposed()) {
            return null;
        }
        AbstractTreeUpdater updater = new AbstractTreeUpdater(this);
        updater.setModalityStateComponent(MergingUpdateQueue.ANY_COMPONENT);
        return updater;
    }

    @Nullable
    protected final AbstractTreeUpdater getUpdater() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.getUpdater();
    }

    public final boolean addSubtreeToUpdateByElement(@NotNull Object element) {
        AbstractTreeUpdater updater;
        if (element == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(8);
        }
        return (updater = this.getUpdater()) != null && updater.addSubtreeToUpdateByElement(element);
    }

    public final void addSubtreeToUpdate(DefaultMutableTreeNode node) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.addSubtreeToUpdate(node);
        }
    }

    public final void addSubtreeToUpdate(DefaultMutableTreeNode node, Runnable afterUpdate) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.addSubtreeToUpdate(node, afterUpdate);
        }
    }

    @Nullable
    public final DefaultMutableTreeNode getRootNode() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.getRootNode();
    }

    public final void setNodeDescriptorComparator(Comparator<? super NodeDescriptor> nodeDescriptorComparator) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.setNodeDescriptorComparator(nodeDescriptorComparator);
        }
    }

    protected Object getTreeStructureElement(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor == null ? null : nodeDescriptor.getElement();
    }

    protected void updateNode(DefaultMutableTreeNode node) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.doUpdateNode(node);
        }
    }

    protected boolean validateNode(@NotNull Object child) {
        AbstractTreeStructure structure;
        if (child == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(9);
        }
        return (structure = this.getTreeStructure()) != null && structure.isValid(child);
    }

    protected boolean isDisposeOnCollapsing(NodeDescriptor nodeDescriptor) {
        return true;
    }

    public final JTree getTree() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.getTree();
    }

    public final AbstractTreeStructure getTreeStructure() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.getTreeStructure();
    }

    public final void setTreeStructure(@NotNull AbstractTreeStructure structure) {
        AbstractTreeUi ui;
        if (structure == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(10);
        }
        if ((ui = this.getUi()) != null) {
            ui.setTreeStructure(structure);
        }
    }

    @Nullable
    public Object getRootElement() {
        AbstractTreeStructure structure = this.getTreeStructure();
        return structure == null ? null : structure.getRootElement();
    }

    @Deprecated
    public void updateFromRoot() {
        this.queueUpdate();
    }

    public void initRootNode() {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.initRootNode();
        }
    }

    @NotNull
    public final ActionCallback queueUpdate() {
        ActionCallback actionCallback = this.queueUpdate(true);
        if (actionCallback == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(11);
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback queueUpdate(boolean withStructure) {
        ActionCallback actionCallback = this.queueUpdateFrom(this.getRootElement(), true, withStructure);
        if (actionCallback == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(12);
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback queueUpdateFrom(Object element, boolean forceResort) {
        ActionCallback actionCallback = this.queueUpdateFrom(element, forceResort, true);
        if (actionCallback == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(13);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback queueUpdateFrom(final Object element, final boolean forceResort, final boolean updateStructure) {
        AbstractTreeUi ui = this.getUi();
        if (ui == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                AbstractTreeBuilder.$$$reportNull$$$0(14);
            }
            return actionCallback;
        }
        final ActionCallback result2 = new ActionCallback();
        ui.invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeBuilder.queueUpdateFrom"){

            @Override
            public void perform() {
                AbstractTreeUi ui = AbstractTreeBuilder.this.getUi();
                if (ui == null) {
                    return;
                }
                if (updateStructure && forceResort) {
                    ui.incComparatorStamp();
                }
                ui.queueUpdate(element, updateStructure).notify(result2);
            }
        });
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(15);
        }
        return actionCallback;
    }

    @Deprecated
    public void buildNodeForElement(@NotNull Object element) {
        AbstractTreeUi ui;
        if (element == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(16);
        }
        if ((ui = this.getUi()) != null) {
            ui.buildNodeForElement(element);
        }
    }

    @Deprecated
    @Nullable
    public DefaultMutableTreeNode getNodeForElement(@NotNull Object element) {
        AbstractTreeUi ui;
        if (element == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(17);
        }
        return (ui = this.getUi()) == null ? null : ui.getNodeForElement(element, false);
    }

    public void cleanUp() {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.doCleanUp();
        }
    }

    @Nullable
    protected ProgressIndicator createProgressIndicator() {
        return null;
    }

    protected void expandNodeChildren(@NotNull DefaultMutableTreeNode node) {
        AbstractTreeUi ui;
        if (node == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(18);
        }
        if ((ui = this.getUi()) != null) {
            ui.doExpandNodeChildren(node);
        }
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return !this.isDisposed() && this.getRootElement() == this.getTreeStructureElement(nodeDescriptor);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        return false;
    }

    protected boolean isSmartExpand() {
        return true;
    }

    public final boolean isDisposed() {
        return this.getUi() == null;
    }

    final boolean wasRootNodeInitialized() {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.wasRootNodeInitialized();
    }

    public final boolean isNodeBeingBuilt(TreePath path2) {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.isNodeBeingBuilt(path2);
    }

    @Nullable
    protected Object findNodeByElement(@NotNull Object element) {
        AbstractTreeUi ui;
        if (element == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(19);
        }
        return (ui = this.getUi()) == null ? null : ui.findNodeByElement(element);
    }

    public static boolean isLoadingNode(DefaultMutableTreeNode node) {
        return AbstractTreeUi.isLoadingNode(node);
    }

    void runOnYieldingDone(@NotNull Runnable onDone) {
        AbstractTreeUi ui;
        if (onDone == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(20);
        }
        if ((ui = this.getUi()) == null) {
            return;
        }
        if (ui.isPassthroughMode() || SwingUtilities.isEventDispatchThread()) {
            onDone.run();
        } else {
            EdtExecutorService.getInstance().execute(() -> {
                if (!this.isDisposed()) {
                    onDone.run();
                }
            });
        }
    }

    protected void yield(@NotNull Runnable runnable) {
        AbstractTreeUi ui;
        if (runnable == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(21);
        }
        if ((ui = this.getUi()) == null) {
            return;
        }
        if (ui.isPassthroughMode()) {
            runnable.run();
        } else {
            EdtExecutorService.getInstance().execute(() -> {
                if (!this.isDisposed()) {
                    runnable.run();
                }
            });
        }
    }

    public boolean isToEnsureSelectionOnFocusGained() {
        return true;
    }

    protected void runBackgroundLoading(final @NotNull Runnable runnable) {
        if (runnable == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(22);
        }
        if (this.isDisposed()) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            app.runReadAction(new TreeRunnable("AbstractTreeBuilder.runBackgroundLoading"){

                @Override
                public void perform() {
                    runnable.run();
                }
            });
        } else {
            runnable.run();
        }
    }

    protected void updateAfterLoadedInBackground(@NotNull Runnable runnable) {
        AbstractTreeUi ui;
        if (runnable == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(23);
        }
        if ((ui = this.getUi()) == null) {
            return;
        }
        if (ui.isPassthroughMode()) {
            runnable.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        }
    }

    @NotNull
    public final ActionCallback getInitialized() {
        AbstractTreeUi ui = this.getUi();
        ActionCallback actionCallback = ui == null ? ActionCallback.REJECTED : ui.getInitialized();
        if (actionCallback == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(24);
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback getReady(Object requestor) {
        AbstractTreeUi ui = this.getUi();
        ActionCallback actionCallback = ui == null ? ActionCallback.REJECTED : ui.getReady(requestor);
        if (actionCallback == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(25);
        }
        return actionCallback;
    }

    protected void sortChildren(Comparator<? super TreeNode> nodeComparator, DefaultMutableTreeNode node, List<? extends TreeNode> children) {
        Collections.sort(children, nodeComparator);
    }

    public void setPassthroughMode(boolean passthrough) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.setPassthroughMode(passthrough);
        }
    }

    public void expandAll(@Nullable Runnable onDone) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.expandAll(onDone);
        }
    }

    @NotNull
    public ActionCallback cancelUpdate() {
        AbstractTreeUi ui = this.getUi();
        ActionCallback actionCallback = ui == null ? ActionCallback.REJECTED : ui.cancelUpdate();
        if (actionCallback == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(26);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback batch(@NotNull Progressive progressive) {
        AbstractTreeUi ui;
        if (progressive == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(27);
        }
        ActionCallback actionCallback = (ui = this.getUi()) == null ? ActionCallback.REJECTED : ui.batch(progressive);
        if (actionCallback == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(28);
        }
        return actionCallback;
    }

    @NotNull
    public Promise<Object> revalidateElement(@NotNull Object element) {
        AbstractTreeStructure structure;
        if (element == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(29);
        }
        if ((structure = this.getTreeStructure()) == null) {
            Promise<Object> promise = Promises.rejectedPromise();
            if (promise == null) {
                AbstractTreeBuilder.$$$reportNull$$$0(30);
            }
            return promise;
        }
        AsyncPromise<Object> promise = new AsyncPromise<Object>();
        structure.revalidateElement(element).doWhenDone((Consumer<Object>)((Consumer)o -> promise.setResult(o))).doWhenRejected((Consumer<? super String>)((Consumer)s -> promise.setError((String)s)));
        AsyncPromise<Object> asyncPromise = promise;
        if (asyncPromise == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(31);
        }
        return asyncPromise;
    }

    public final AbstractTreeUi getUi() {
        AbstractTreeUi ui = this.myUi;
        return ui == null || ui.isReleaseRequested() ? null : ui;
    }

    public void dispose() {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.requestRelease();
        }
    }

    void releaseUi() {
        this.myUi = null;
    }

    protected boolean updateNodeDescriptor(@NotNull NodeDescriptor descriptor) {
        AbstractTreeUi ui;
        if (descriptor == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(32);
        }
        return (ui = this.getUi()) != null && descriptor.update();
    }

    @Nullable
    public final DefaultTreeModel getTreeModel() {
        AbstractTreeUi ui = this.getUi();
        return ui == null ? null : ui.getTreeModel();
    }

    @NotNull
    public final Set<Object> getSelectedElements() {
        AbstractTreeUi ui = this.getUi();
        Set<Object> set = ui == null ? Collections.emptySet() : ui.getSelectedElements();
        if (set == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(33);
        }
        return set;
    }

    @NotNull
    public final <T> Set<T> getSelectedElements(@NotNull Class<T> elementClass) {
        if (elementClass == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(34);
        }
        LinkedHashSet<Object> result2 = new LinkedHashSet<Object>();
        for (Object o : this.getSelectedElements()) {
            Object each = this.transformElement(o);
            if (!elementClass.isInstance(each)) continue;
            result2.add(each);
        }
        LinkedHashSet<Object> linkedHashSet = result2;
        if (linkedHashSet == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(35);
        }
        return linkedHashSet;
    }

    protected Object transformElement(Object object) {
        return object;
    }

    public final void setCanYieldUpdate(boolean yield) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.setCanYield(yield);
        }
    }

    @Nullable
    public static AbstractTreeBuilder getBuilderFor(@NotNull JTree tree) {
        if (tree == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(36);
        }
        Reference ref = (Reference)tree.getClientProperty(TREE_BUILDER);
        return (AbstractTreeBuilder)SoftReference.dereference((Reference)ref);
    }

    @Nullable
    public final <T> Object accept(@NotNull Class<?> nodeClass, @NotNull TreeVisitor<T> visitor) {
        if (nodeClass == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(37);
        }
        if (visitor == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(38);
        }
        return this.accept(nodeClass, this.getRootElement(), visitor);
    }

    @Nullable
    private <T> Object accept(@NotNull Class<?> nodeClass, Object element, @NotNull TreeVisitor<T> visitor) {
        Object[] children;
        if (nodeClass == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(39);
        }
        if (visitor == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(40);
        }
        if (element == null) {
            return null;
        }
        AbstractTreeStructure structure = this.getTreeStructure();
        if (structure == null) {
            return null;
        }
        if (nodeClass.isAssignableFrom(element.getClass()) && visitor.visit(element)) {
            return element;
        }
        for (Object each : children = structure.getChildElements(element)) {
            Object childObject = this.accept(nodeClass, each, visitor);
            if (childObject == null) continue;
            return childObject;
        }
        return null;
    }

    public <T> boolean select(@NotNull Class nodeClass, @NotNull TreeVisitor<T> visitor, @Nullable Runnable onDone, boolean addToSelection) {
        Object element;
        if (nodeClass == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(41);
        }
        if (visitor == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(42);
        }
        if ((element = this.accept(nodeClass, visitor)) != null) {
            this.select(element, onDone, addToSelection);
            return true;
        }
        return false;
    }

    public void scrollSelectionToVisible(@Nullable Runnable onDone, boolean shouldBeCentered) {
        AbstractTreeUi ui = this.getUi();
        if (ui != null) {
            ui.scrollSelectionToVisible(onDone, shouldBeCentered);
        }
    }

    private static boolean isUnitTestingMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    public static boolean isToPaintSelection(@NotNull JTree tree) {
        AbstractTreeBuilder builder;
        if (tree == null) {
            AbstractTreeBuilder.$$$reportNull$$$0(43);
        }
        return (builder = AbstractTreeBuilder.getBuilderFor(tree)) == null || builder.getUi() == null || builder.getUi().isToPaintSelection();
    }

    public boolean isSelectionBeingAdjusted() {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.isSelectionBeingAdjusted();
    }

    public boolean isToBuildChildrenInBackground(Object element) {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.isToBuildChildrenInBackground(element);
    }

    public final boolean isConsistent() {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.isConsistent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/AbstractTreeBuilder";
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressive";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 37: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeClass";
                break;
            }
            case 38: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createUi";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchingTreeNodeWrapper";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "queueUpdate";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "queueUpdateFrom";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialized";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelUpdate";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "batch";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "revalidateElement";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSubtreeToUpdateByElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTreeStructure";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildNodeForElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNodeForElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "expandNodeChildren";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findNodeByElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runOnYieldingDone";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "yield";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runBackgroundLoading";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateAfterLoadedInBackground";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "batch";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "revalidateElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateNodeDescriptor";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderFor";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isToPaintSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class UserRunnable
    implements Runnable {
        private final Runnable myRunnable;

        UserRunnable(Runnable runnable) {
            this.myRunnable = runnable;
        }

        @Override
        public void run() {
            if (this.myRunnable != null) {
                AbstractTreeUi ui = AbstractTreeBuilder.this.getUi();
                if (ui != null) {
                    ui.executeUserRunnable(this.myRunnable);
                } else {
                    this.myRunnable.run();
                }
            }
        }
    }

    private static class AbstractTreeNodeWrapper
    extends AbstractTreeNode<Object> {
        AbstractTreeNodeWrapper() {
            super(null, TREE_WRAPPER_VALUE);
        }

        @Override
        @NotNull
        public Collection<AbstractTreeNode> getChildren() {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                AbstractTreeNodeWrapper.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        public void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                AbstractTreeNodeWrapper.$$$reportNull$$$0(1);
            }
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            return object instanceof AbstractTreeNode && Comparing.equal((Object)this.getEqualityObject(), (Object)((AbstractTreeNode)object).getEqualityObject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/treeView/AbstractTreeBuilder$AbstractTreeNodeWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeBuilder$AbstractTreeNodeWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

