/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.semantic;

import com.intellij.semantic.SemElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SemKey<T extends SemElement> {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final String myDebugName;
    @NotNull
    private final SemKey<? super T>[] mySupers;
    private final List<SemKey> myInheritors;
    private final int myUniqueId;

    @SafeVarargs
    private SemKey(String debugName, SemKey<? super T> ... supers) {
        if (supers == null) {
            SemKey.$$$reportNull$$$0(0);
        }
        this.myInheritors = ContainerUtil.createEmptyCOWList();
        this.myDebugName = debugName;
        this.mySupers = supers;
        this.myUniqueId = counter.getAndIncrement();
        this.myInheritors.add(this);
        this.registerInheritor(this);
    }

    private void registerInheritor(SemKey eachParent) {
        for (SemKey<? super T> superKey : eachParent.mySupers) {
            superKey.myInheritors.add(this);
            this.registerInheritor(superKey);
        }
    }

    @NotNull
    public SemKey<? super T>[] getSupers() {
        if (this.mySupers == null) {
            SemKey.$$$reportNull$$$0(1);
        }
        return this.mySupers;
    }

    public List<SemKey> getInheritors() {
        return this.myInheritors;
    }

    public boolean isKindOf(SemKey<?> another) {
        if (another == this) {
            return true;
        }
        for (SemKey<T> semKey : this.mySupers) {
            if (!semKey.isKindOf(another)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.myDebugName;
    }

    @SafeVarargs
    public static <T extends SemElement> SemKey<T> createKey(String debugName, SemKey<? super T> ... supers) {
        if (supers == null) {
            SemKey.$$$reportNull$$$0(2);
        }
        return new SemKey<T>(debugName, supers);
    }

    public int hashCode() {
        return this.myUniqueId;
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    @SafeVarargs
    public final <K extends T> SemKey<K> subKey(@NonNls String debugName, SemKey<? super T> ... otherSupers) {
        if (otherSupers == null) {
            SemKey.$$$reportNull$$$0(3);
        }
        if (otherSupers.length == 0) {
            return new SemKey<T>(debugName, this);
        }
        return new SemKey<T>(debugName, (SemKey[])ArrayUtil.append((Object[])otherSupers, (Object)this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/semantic/SemKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherSupers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/semantic/SemKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "subKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

