/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WildcardFileNameMatcher
extends FileNameMatcherEx {
    private final String myPattern;
    private final MaskMatcher myMatcher;

    public WildcardFileNameMatcher(@NotNull @NonNls String pattern) {
        if (pattern == null) {
            WildcardFileNameMatcher.$$$reportNull$$$0(0);
        }
        this.myPattern = pattern;
        this.myMatcher = WildcardFileNameMatcher.createMatcher(pattern);
    }

    private static MaskMatcher createMatcher(String pattern) {
        int len = pattern.length();
        if (len > 1 && pattern.indexOf(63) < 0) {
            if (pattern.charAt(0) == '*' && pattern.indexOf(42, 1) < 0) {
                return new SuffixMatcher(pattern.substring(1));
            }
            if (pattern.indexOf(42) == len - 1) {
                return new PrefixMatcher(pattern.substring(0, len - 1));
            }
            if (len > 2 && pattern.charAt(0) == '*' && pattern.indexOf(42, 1) == len - 1) {
                return new InfixMatcher(pattern.substring(1, len - 1));
            }
        }
        return new RegexpMatcher(pattern);
    }

    public boolean acceptsCharSequence(@NonNls @NotNull CharSequence fileName) {
        if (fileName == null) {
            WildcardFileNameMatcher.$$$reportNull$$$0(1);
        }
        return this.myMatcher.matches(fileName);
    }

    @NonNls
    @NotNull
    public String getPresentableString() {
        String string = this.myPattern;
        if (string == null) {
            WildcardFileNameMatcher.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WildcardFileNameMatcher that = (WildcardFileNameMatcher)((Object)o);
        return this.myPattern.equals(that.myPattern);
    }

    public int hashCode() {
        return this.myPattern.hashCode();
    }

    public String getPattern() {
        return this.myPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/WildcardFileNameMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/WildcardFileNameMatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCharSequence";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class InfixMatcher
    implements MaskMatcher {
        private final String myInfix;

        private InfixMatcher(String infix) {
            this.myInfix = infix;
        }

        @Override
        public boolean matches(CharSequence filename) {
            return StringUtil.contains((CharSequence)filename, (CharSequence)this.myInfix);
        }
    }

    private static final class PrefixMatcher
    implements MaskMatcher {
        private final String myPrefix;

        private PrefixMatcher(String prefix) {
            this.myPrefix = prefix;
        }

        @Override
        public boolean matches(CharSequence filename) {
            return StringUtil.startsWith((CharSequence)filename, (CharSequence)this.myPrefix);
        }
    }

    private static final class SuffixMatcher
    implements MaskMatcher {
        private final String mySuffix;

        private SuffixMatcher(String suffix) {
            this.mySuffix = suffix;
        }

        @Override
        public boolean matches(CharSequence filename) {
            return StringUtil.endsWith((CharSequence)filename, (CharSequence)this.mySuffix);
        }
    }

    private static final class RegexpMatcher
    implements MaskMatcher {
        private final Matcher myMatcher;

        private RegexpMatcher(String pattern) {
            this.myMatcher = PatternUtil.fromMask((String)pattern).matcher("");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matches(CharSequence filename) {
            Matcher matcher = this.myMatcher;
            synchronized (matcher) {
                this.myMatcher.reset(filename);
                return this.myMatcher.matches();
            }
        }
    }

    private static interface MaskMatcher {
        public boolean matches(CharSequence var1);
    }
}

