/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsReferenceableElement;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsElementCollectionImpl;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryReferenceImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRootRole;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsLibraryImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsLibraryImpl<P>>
implements JpsTypedLibrary<P> {
    private static final ConcurrentMap<JpsOrderRootType, JpsElementCollectionRole<JpsLibraryRoot>> ourRootRoles = ContainerUtil.newConcurrentMap();
    private final JpsLibraryType<P> myLibraryType;
    private static final Set<String> AR_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"jar", "zip", "swc", "ane"});

    public JpsLibraryImpl(@NotNull String name, @NotNull JpsLibraryType<P> type, @NotNull P properties) {
        if (name == null) {
            JpsLibraryImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JpsLibraryImpl.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            JpsLibraryImpl.$$$reportNull$$$0(2);
        }
        super(name);
        this.myLibraryType = type;
        this.myContainer.setChild(this.myLibraryType.getPropertiesRole(), properties);
    }

    private JpsLibraryImpl(@NotNull JpsLibraryImpl<P> original) {
        if (original == null) {
            JpsLibraryImpl.$$$reportNull$$$0(3);
        }
        super(original);
        this.myLibraryType = original.myLibraryType;
    }

    @NotNull
    public JpsLibraryType<P> getType() {
        JpsLibraryType<P> jpsLibraryType = this.myLibraryType;
        if (jpsLibraryType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(4);
        }
        return jpsLibraryType;
    }

    @Nullable
    public <P extends JpsElement> JpsTypedLibrary<P> asTyped(@NotNull JpsLibraryType<P> type) {
        if (type == null) {
            JpsLibraryImpl.$$$reportNull$$$0(5);
        }
        return this.myLibraryType.equals(type) ? this : null;
    }

    @NotNull
    public P getProperties() {
        JpsElement jpsElement = this.myContainer.getChild(this.myLibraryType.getPropertiesRole());
        if (jpsElement == null) {
            JpsLibraryImpl.$$$reportNull$$$0(6);
        }
        return (P)jpsElement;
    }

    @NotNull
    public List<JpsLibraryRoot> getRoots(@NotNull JpsOrderRootType rootType) {
        JpsElementCollection rootsCollection;
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(7);
        }
        List list = (rootsCollection = (JpsElementCollection)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType))) != null ? rootsCollection.getElements() : Collections.emptyList();
        if (list == null) {
            JpsLibraryImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        if (url == null) {
            JpsLibraryImpl.$$$reportNull$$$0(9);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(10);
        }
        this.addRoot(url, rootType, JpsLibraryRoot.InclusionOptions.ROOT_ITSELF);
    }

    public void addRoot(@NotNull File file, @NotNull JpsOrderRootType rootType) {
        if (file == null) {
            JpsLibraryImpl.$$$reportNull$$$0(11);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(12);
        }
        this.addRoot(JpsPathUtil.getLibraryRootUrl((File)file), rootType);
    }

    public void addRoot(@NotNull String url, @NotNull JpsOrderRootType rootType, @NotNull JpsLibraryRoot.InclusionOptions options) {
        if (url == null) {
            JpsLibraryImpl.$$$reportNull$$$0(13);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(14);
        }
        if (options == null) {
            JpsLibraryImpl.$$$reportNull$$$0(15);
        }
        ((JpsElementCollection)this.myContainer.getOrSetChild(JpsLibraryImpl.getRole(rootType))).addChild((JpsElement)new JpsLibraryRootImpl(url, rootType, options));
    }

    public void removeUrl(@NotNull String url, @NotNull JpsOrderRootType rootType) {
        JpsElementCollection rootsCollection;
        if (url == null) {
            JpsLibraryImpl.$$$reportNull$$$0(16);
        }
        if (rootType == null) {
            JpsLibraryImpl.$$$reportNull$$$0(17);
        }
        if ((rootsCollection = (JpsElementCollection)this.myContainer.getChild(JpsLibraryImpl.getRole(rootType))) != null) {
            for (JpsLibraryRoot root : rootsCollection.getElements()) {
                if (!root.getUrl().equals(url) || !root.getRootType().equals(rootType)) continue;
                rootsCollection.removeChild((JpsElement)root);
                break;
            }
        }
    }

    private static JpsElementCollectionRole<JpsLibraryRoot> getRole(JpsOrderRootType type) {
        JpsElementCollectionRole role = (JpsElementCollectionRole)ourRootRoles.get(type);
        if (role != null) {
            return role;
        }
        ourRootRoles.putIfAbsent(type, (JpsElementCollectionRole<JpsLibraryRoot>)JpsElementCollectionRole.create((JpsElementChildRole)new JpsLibraryRootRole(type)));
        return (JpsElementCollectionRole)ourRootRoles.get(type);
    }

    public void delete() {
        this.getParent().removeChild(this);
    }

    public JpsElementCollectionImpl<JpsLibrary> getParent() {
        return (JpsElementCollectionImpl)this.myParent;
    }

    @NotNull
    public JpsLibraryImpl<P> createCopy() {
        JpsLibraryImpl<P> jpsLibraryImpl = new JpsLibraryImpl<P>(this);
        if (jpsLibraryImpl == null) {
            JpsLibraryImpl.$$$reportNull$$$0(18);
        }
        return jpsLibraryImpl;
    }

    @NotNull
    public JpsLibraryReference createReference() {
        JpsLibraryReferenceImpl jpsLibraryReferenceImpl = new JpsLibraryReferenceImpl(this.getName(), this.createParentReference());
        if (jpsLibraryReferenceImpl == null) {
            JpsLibraryImpl.$$$reportNull$$$0(19);
        }
        return jpsLibraryReferenceImpl;
    }

    private JpsElementReference<JpsCompositeElement> createParentReference() {
        return ((JpsReferenceableElement)this.getParent().getParent()).createReference();
    }

    public List<File> getFiles(JpsOrderRootType rootType) {
        List<String> urls = this.getRootUrls(rootType);
        ArrayList<File> files = new ArrayList<File>(urls.size());
        for (String url : urls) {
            if (JpsPathUtil.isJrtUrl((String)url)) continue;
            files.add(JpsPathUtil.urlToFile((String)url));
        }
        return files;
    }

    public List<String> getRootUrls(JpsOrderRootType rootType) {
        ArrayList<String> urls = new ArrayList<String>();
        for (JpsLibraryRoot root : this.getRoots(rootType)) {
            switch (root.getInclusionOptions()) {
                case ROOT_ITSELF: {
                    urls.add(root.getUrl());
                    break;
                }
                case ARCHIVES_UNDER_ROOT: {
                    JpsLibraryImpl.collectArchives(JpsPathUtil.urlToFile((String)root.getUrl()), false, urls);
                    break;
                }
                case ARCHIVES_UNDER_ROOT_RECURSIVELY: {
                    JpsLibraryImpl.collectArchives(JpsPathUtil.urlToFile((String)root.getUrl()), true, urls);
                }
            }
        }
        return urls;
    }

    private static void collectArchives(File file, boolean recursively, List<String> result) {
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                String extension = FileUtilRt.getExtension((String)child.getName());
                if (child.isDirectory()) {
                    if (!recursively) continue;
                    JpsLibraryImpl.collectArchives(child, recursively, result);
                    continue;
                }
                if (!AR_EXTENSIONS.contains(extension)) continue;
                result.add(JpsPathUtil.getLibraryRootUrl((File)child));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/library/impl/JpsLibraryImpl";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/library/impl/JpsLibraryImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asTyped";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

