/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBrancher;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class GitDeleteTagOperation
extends GitBranchOperation {
    private static final Logger LOG = Logger.getInstance(GitDeleteTagOperation.class);
    @NotNull
    private final String myTagName;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final Map<GitRepository, String> myDeletedTagTips;

    GitDeleteTagOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<GitRepository> repositories, @NotNull String tagName) {
        if (project == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(3);
        }
        if (tagName == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(4);
        }
        super(project, git, uiHandler, repositories);
        this.myDeletedTagTips = new HashMap<GitRepository, String>();
        this.myTagName = tagName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
    }

    @Override
    public void execute() {
        for (GitRepository repository : this.getRepositories()) {
            try {
                GitRevisionNumber revisionNumber = GitRevisionNumber.resolve(this.myProject, repository.getRoot(), "refs/tags/" + this.myTagName);
                this.myDeletedTagTips.put(repository, revisionNumber.asString());
            }
            catch (VcsException e) {
                String title = "Couldn't find tag " + this.myTagName;
                if (!GitUtil.justOneGitRepository(this.myProject)) {
                    title = title + " in " + repository.getPresentableUrl();
                }
                this.fatalError(title, "");
                return;
            }
        }
        while (this.hasMoreRepositories()) {
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.deleteTag(repository, this.myTagName, new GitLineHandlerListener[0]);
            if (result2.success()) {
                repository.getRepositoryFiles().refreshTagsFiles();
                this.markSuccessful(repository);
                continue;
            }
            this.fatalError(String.format("Tag %s wasn't deleted", this.myTagName), result2.getErrorOutputAsJoinedString());
            return;
        }
        this.notifySuccess();
    }

    @Override
    protected void notifySuccess() {
        String message = "<b>Deleted Tag:</b> " + this.myTagName;
        Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("", message, NotificationType.INFORMATION, null);
        notification.addAction((AnAction)NotificationAction.createSimple((String)"Restore", () -> this.restoreInBackground(notification)));
        int remotes = 0;
        for (GitRepository repository : this.getRepositories()) {
            remotes += repository.getRemotes().size();
        }
        if (remotes > 0) {
            String text = "Delete on " + StringUtil.pluralize((String)"Remote", (int)remotes);
            notification.addAction((AnAction)NotificationAction.createSimple((String)text, () -> this.pushRemotesInBackground()));
        }
        this.myNotifier.notify(notification);
    }

    private void restoreInBackground(final @NotNull Notification notification) {
        if (notification == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(5);
        }
        new Task.Backgroundable(this.myProject, "Restoring Tag " + this.myTagName + "..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitDeleteTagOperation.this.rollbackTagDeletion(notification);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitDeleteTagOperation$1", "run"));
            }
        }.queue();
    }

    @Override
    protected void rollback() {
        GitCompoundResult result2 = this.doRollback();
        if (result2.totalSuccess()) {
            Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("Rollback Successful", "Restored tag " + this.myTagName, NotificationType.INFORMATION, null);
            this.myNotifier.notify(notification);
        } else {
            this.myNotifier.notifyError("Error during rollback of tag deletion", result2.getErrorOutputWithReposIndication());
        }
    }

    private void rollbackTagDeletion(@NotNull Notification notification) {
        GitCompoundResult result2;
        if (notification == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(6);
        }
        if ((result2 = this.doRollback()).totalSuccess()) {
            notification.expire();
        } else {
            this.myNotifier.notifyError("Couldn't Restore <b><code>" + this.myTagName + "</code></b>", result2.getErrorOutputWithReposIndication());
        }
    }

    @NotNull
    private GitCompoundResult doRollback() {
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            GitCommandResult res = this.myGit.createNewTag(repository, this.myTagName, null, this.myDeletedTagTips.get(repository));
            result2.append(repository, res);
            repository.getRepositoryFiles().refreshTagsFiles();
        }
        GitCompoundResult gitCompoundResult = result2;
        if (gitCompoundResult == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(7);
        }
        return gitCompoundResult;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String string = "However tag deletion has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>You may rollback (recreate " + this.myTagName + " in these roots) not to let tags diverge.";
        if (string == null) {
            GitDeleteTagOperation.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getOperationName() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        throw new UnsupportedOperationException();
    }

    private void pushRemotesInBackground() {
        GitBrancher.getInstance(this.myProject).deleteRemoteTag(this.myTagName, ContainerUtil.map2Map(this.getRepositories(), it -> Pair.create((Object)it, (Object)this.myDeletedTagTips.get(it))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitDeleteTagOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitDeleteTagOperation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doRollback";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "restoreInBackground";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rollbackTagDeletion";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

