/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.documentation.DocCommentFixer;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixDocCommentAction
extends EditorAction {
    @NotNull
    @NonNls
    public static final String ACTION_ID = "FixDocComment";

    public FixDocCommentAction() {
        super((EditorActionHandler)new MyHandler());
    }

    private static void process(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Project project, int offset) {
        PsiElement elementAtOffset;
        if (file2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FixDocCommentAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            FixDocCommentAction.$$$reportNull$$$0(2);
        }
        if ((elementAtOffset = file2.findElementAt(offset)) == null || !FileModificationService.getInstance().preparePsiElementForWrite(elementAtOffset)) {
            return;
        }
        FixDocCommentAction.generateOrFixComment(elementAtOffset, project, editor);
    }

    public static void generateOrFixComment(@NotNull PsiElement element, @NotNull Project project, @NotNull Editor editor) {
        Runnable task;
        Language language;
        DocumentationProvider langDocumentationProvider;
        Object docProvider;
        if (element == null) {
            FixDocCommentAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            FixDocCommentAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            FixDocCommentAction.$$$reportNull$$$0(5);
        }
        if ((docProvider = (langDocumentationProvider = LanguageDocumentation.INSTANCE.forLanguage(language = element.getLanguage())) instanceof CompositeDocumentationProvider ? ((CompositeDocumentationProvider)langDocumentationProvider).getFirstCodeDocumentationProvider() : (langDocumentationProvider instanceof CodeDocumentationProvider ? (CodeDocumentationProvider)langDocumentationProvider : null)) == null) {
            return;
        }
        Pair pair = docProvider.parseContext(element);
        if (pair == null) {
            return;
        }
        Commenter c = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (!(c instanceof CodeDocumentationAwareCommenter)) {
            return;
        }
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)c;
        if (pair.second == null || ((PsiComment)pair.second).getTextRange().isEmpty()) {
            task = () -> FixDocCommentAction.lambda$generateOrFixComment$0(pair, editor, (CodeDocumentationProvider)docProvider, commenter, project);
        } else {
            DocCommentFixer fixer = (DocCommentFixer)DocCommentFixer.EXTENSION.forLanguage(language);
            if (fixer == null) {
                return;
            }
            task = () -> fixer.fixComment(project, editor, (PsiComment)pair.second);
        }
        Runnable command = () -> ApplicationManager.getApplication().runWriteAction(task);
        CommandProcessor.getInstance().executeCommand(project, command, "Fix documentation", null);
    }

    private static void generateComment(@NotNull PsiElement anchor2, @NotNull Editor editor, @NotNull CodeDocumentationProvider documentationProvider, @NotNull CodeDocumentationAwareCommenter commenter, @NotNull Project project) {
        char c;
        String linePrefix;
        int commentStartOffset;
        Document document;
        int lineStartOffset;
        if (anchor2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            FixDocCommentAction.$$$reportNull$$$0(7);
        }
        if (documentationProvider == null) {
            FixDocCommentAction.$$$reportNull$$$0(8);
        }
        if (commenter == null) {
            FixDocCommentAction.$$$reportNull$$$0(9);
        }
        if (project == null) {
            FixDocCommentAction.$$$reportNull$$$0(10);
        }
        if ((lineStartOffset = (document = editor.getDocument()).getLineStartOffset(document.getLineNumber(commentStartOffset = anchor2.getTextRange().getStartOffset()))) > 0 && lineStartOffset < commentStartOffset) {
            int nonWhiteSpaceOffset = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)(commentStartOffset - 1), (String)" \t");
            commentStartOffset = Math.max(nonWhiteSpaceOffset, lineStartOffset);
        }
        int commentBodyRelativeOffset = 0;
        int caretOffsetToSet = -1;
        StringBuilder buffer = new StringBuilder();
        String commentPrefix = commenter.getDocumentationCommentPrefix();
        if (commentPrefix != null) {
            buffer.append(commentPrefix).append("\n");
            commentBodyRelativeOffset += commentPrefix.length() + 1;
        }
        if ((linePrefix = commenter.getDocumentationCommentLinePrefix()) != null) {
            buffer.append(linePrefix);
            caretOffsetToSet = commentStartOffset + (commentBodyRelativeOffset += linePrefix.length());
        }
        buffer.append("\n");
        ++commentBodyRelativeOffset;
        String commentSuffix = commenter.getDocumentationCommentSuffix();
        if (commentSuffix != null) {
            buffer.append(commentSuffix).append("\n");
        }
        if (buffer.length() <= 0) {
            return;
        }
        document.insertString(commentStartOffset, (CharSequence)buffer);
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
        docManager.commitDocument(document);
        Pair pair = documentationProvider.parseContext(anchor2);
        if (pair == null || pair.second == null) {
            return;
        }
        String stub = documentationProvider.generateDocumentationContentStub((PsiComment)pair.second);
        CaretModel caretModel = editor.getCaretModel();
        if (stub != null) {
            int insertionOffset = commentStartOffset + commentBodyRelativeOffset;
            document.insertString(insertionOffset, (CharSequence)stub);
            docManager.commitDocument(document);
            pair = documentationProvider.parseContext(anchor2);
        }
        if (caretOffsetToSet >= 0) {
            caretModel.moveToOffset(caretOffsetToSet);
            editor.getSelectionModel().removeSelection();
        }
        if (pair == null || pair.second == null) {
            return;
        }
        int start2 = Math.min(FixDocCommentAction.calcStartReformatOffset((PsiElement)pair.first), FixDocCommentAction.calcStartReformatOffset((PsiElement)pair.second));
        int end = ((PsiComment)pair.second).getTextRange().getEndOffset();
        FixDocCommentAction.reformatCommentKeepingEmptyTags(anchor2.getContainingFile(), project, start2, end);
        editor.getCaretModel().moveToOffset(document.getLineEndOffset(document.getLineNumber(editor.getCaretModel().getOffset())));
        int caretOffset = caretModel.getOffset();
        if (caretOffset > 0 && caretOffset <= document.getTextLength() && !StringUtil.isWhiteSpace((char)(c = document.getCharsSequence().charAt(caretOffset - 1)))) {
            document.insertString(caretOffset, (CharSequence)" ");
            caretModel.moveToOffset(caretOffset + 1);
        }
    }

    private static void reformatCommentKeepingEmptyTags(@NotNull PsiFile file2, @NotNull Project project, int start2, int end) {
        if (file2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(11);
        }
        if (project == null) {
            FixDocCommentAction.$$$reportNull$$$0(12);
        }
        CodeStyleSettings tempSettings = CodeStyle.getSettings((PsiFile)file2).clone();
        LanguageCodeStyleSettingsProvider langProvider = LanguageCodeStyleSettingsProvider.forLanguage((Language)file2.getLanguage());
        if (langProvider != null) {
            DocCommentSettings docCommentSettings = langProvider.getDocCommentSettings(tempSettings);
            docCommentSettings.setRemoveEmptyTags(false);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        CodeStyle.doWithTemporarySettings((Project)project, (CodeStyleSettings)tempSettings, () -> codeStyleManager.reformatText(file2, start2, end));
    }

    private static int calcStartReformatOffset(@NotNull PsiElement element) {
        if (element == null) {
            FixDocCommentAction.$$$reportNull$$$0(13);
        }
        int result2 = element.getTextRange().getStartOffset();
        for (PsiElement e = element.getPrevSibling(); e != null && e instanceof PsiWhiteSpace; e = e.getPrevSibling()) {
            result2 = e.getTextRange().getStartOffset();
        }
        return result2;
    }

    private static /* synthetic */ void lambda$generateOrFixComment$0(Pair pair, Editor editor, CodeDocumentationProvider docProvider, CodeDocumentationAwareCommenter commenter, Project project) {
        FixDocCommentAction.generateComment((PsiElement)pair.first, editor, docProvider, commenter, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentationProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commenter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/FixDocCommentAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "generateOrFixComment";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "generateComment";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatCommentKeepingEmptyTags";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "calcStartReformatOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyHandler
    extends EditorActionHandler {
        private MyHandler() {
        }

        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            Project project;
            if (editor == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            if (psiFile == null) {
                return;
            }
            FixDocCommentAction.process(psiFile, editor, project, editor.getCaretModel().getOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/FixDocCommentAction$MyHandler", "doExecute"));
        }
    }
}

