/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.CommonBundle;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.CompatibilityAwareRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecutionManagerImpl
extends ExecutionManager
implements Disposable {
    public static final Key<Object> EXECUTION_SESSION_ID_KEY = Key.create((String)"EXECUTION_SESSION_ID_KEY");
    public static final Key<Boolean> EXECUTION_SKIP_RUN = Key.create((String)"EXECUTION_SKIP_RUN");
    protected static final Logger LOG = Logger.getInstance(ExecutionManagerImpl.class);
    private static final ProcessHandler[] EMPTY_PROCESS_HANDLERS = new ProcessHandler[0];
    private final Project myProject;
    private final Alarm myAwaitingTerminationAlarm;
    private final Map<RunProfile, ExecutionEnvironment> myAwaitingRunProfiles;
    protected final List<Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor>> myRunningConfigurations;

    @NotNull
    public static ExecutionManagerImpl getInstance(@NotNull Project project) {
        if (project == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(0);
        }
        ExecutionManagerImpl executionManagerImpl = (ExecutionManagerImpl)((Object)ServiceManager.getService((Project)project, ExecutionManager.class));
        if (executionManagerImpl == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(1);
        }
        return executionManagerImpl;
    }

    protected ExecutionManagerImpl(@NotNull Project project) {
        if (project == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(2);
        }
        this.myAwaitingTerminationAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myAwaitingRunProfiles = ContainerUtil.newHashMap();
        this.myRunningConfigurations = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    @NotNull
    private static ExecutionEnvironmentBuilder createEnvironmentBuilder(@NotNull Project project, @NotNull Executor executor, @Nullable RunnerAndConfigurationSettings configuration) {
        if (project == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(3);
        }
        if (executor == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(4);
        }
        ExecutionEnvironmentBuilder builder2 = new ExecutionEnvironmentBuilder(project, executor);
        ProgramRunner runner = ProgramRunnerUtil.getRunner(executor.getId(), configuration);
        if (runner == null && configuration != null) {
            LOG.error("Cannot find runner for " + configuration.getName());
        } else if (runner != null) {
            builder2.runnerAndSettings(runner, configuration);
        }
        ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder2;
        if (executionEnvironmentBuilder == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(5);
        }
        return executionEnvironmentBuilder;
    }

    public static boolean isProcessRunning(@Nullable RunContentDescriptor descriptor) {
        ProcessHandler processHandler2 = descriptor == null ? null : descriptor.getProcessHandler();
        return processHandler2 != null && !processHandler2.isProcessTerminated();
    }

    private static void restart(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(6);
        }
        if (environment.getProject().isDisposed()) {
            return;
        }
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        ProgramRunnerUtil.executeConfiguration(environment, settings != null && settings.isEditBeforeRun(), true);
    }

    private static boolean userApprovesStopForSameTypeConfigurations(Project project, String configName, int instancesCount) {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
        final RunManagerConfig config2 = runManager.getConfig();
        if (!config2.isRestartRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return config2.isRestartRequiresConfirmation();
            }

            public void setToBeShown(boolean value, int exitCode) {
                config2.setRestartRequiresConfirmation(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ExecutionManagerImpl$1", "getDoNotShowMessage"));
            }
        };
        return Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"rerun.singleton.confirmation.message", (Object[])new Object[]{configName, instancesCount}), (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{configName}), (String)ExecutionBundle.message((String)"rerun.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option) == 0;
    }

    private static boolean userApprovesStopForIncompatibleConfigurations(Project project, String configName, List<RunContentDescriptor> runningIncompatibleDescriptors) {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
        final RunManagerConfig config2 = runManager.getConfig();
        if (!config2.isStopIncompatibleRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return config2.isStopIncompatibleRequiresConfirmation();
            }

            public void setToBeShown(boolean value, int exitCode) {
                config2.setStopIncompatibleRequiresConfirmation(value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ExecutionManagerImpl$2", "getDoNotShowMessage"));
            }
        };
        StringBuilder names = new StringBuilder();
        for (RunContentDescriptor descriptor : runningIncompatibleDescriptors) {
            String name = descriptor.getDisplayName();
            if (names.length() > 0) {
                names.append(", ");
            }
            names.append(StringUtil.isEmpty((String)name) ? ExecutionBundle.message((String)"run.configuration.no.name", (Object[])new Object[0]) : String.format("'%s'", name));
        }
        return Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.message", (Object[])new Object[]{configName, names.toString(), runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"incompatible.configuration.is.running.dialog.title", (Object[])new Object[]{runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option) == 0;
    }

    public static void stopProcess(@Nullable RunContentDescriptor descriptor) {
        ExecutionManagerImpl.stopProcess(descriptor != null ? descriptor.getProcessHandler() : null);
    }

    public static void stopProcess(@Nullable ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            return;
        }
        processHandler2.putUserData(ProcessHandler.TERMINATION_REQUESTED, (Object)Boolean.TRUE);
        if (processHandler2 instanceof KillableProcess && processHandler2.isProcessTerminating()) {
            ((KillableProcess)processHandler2).killProcess();
            return;
        }
        if (!processHandler2.isProcessTerminated()) {
            if (processHandler2.detachIsDefault()) {
                processHandler2.detachProcess();
            } else {
                processHandler2.destroyProcess();
            }
        }
    }

    public void dispose() {
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            Disposer.dispose((Disposable)((Disposable)trinity.first));
        }
        this.myRunningConfigurations.clear();
    }

    @NotNull
    public RunContentManager getContentManager() {
        RunContentManager runContentManager = RunContentManager.getInstance((Project)this.myProject);
        if (runContentManager == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(7);
        }
        return runContentManager;
    }

    @NotNull
    public static List<RunContentDescriptor> getAllDescriptors(@NotNull Project project) {
        RunContentManager contentManager;
        if (project == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(8);
        }
        List list2 = (contentManager = (RunContentManager)ServiceManager.getServiceIfCreated((Project)project, RunContentManager.class)) == null ? Collections.emptyList() : contentManager.getAllDescriptors();
        if (list2 == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    public ProcessHandler[] getRunningProcesses() {
        List handlers = null;
        for (RunContentDescriptor descriptor : ExecutionManagerImpl.getAllDescriptors(this.myProject)) {
            ProcessHandler processHandler2 = descriptor.getProcessHandler();
            if (processHandler2 == null) continue;
            if (handlers == null) {
                handlers = new SmartList();
            }
            handlers.add(processHandler2);
        }
        ProcessHandler[] processHandlerArray = handlers == null ? EMPTY_PROCESS_HANDLERS : handlers.toArray(new ProcessHandler[0]);
        if (processHandlerArray == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(10);
        }
        return processHandlerArray;
    }

    public void compileAndRun(@NotNull Runnable startRunnable2, @NotNull ExecutionEnvironment environment, @Nullable RunProfileState state, @Nullable Runnable onCancelRunnable) {
        RunProfile profile2;
        long id;
        if (startRunnable2 == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(11);
        }
        if (environment == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(12);
        }
        if ((id = environment.getExecutionId()) == 0L) {
            id = environment.assignNewExecutionId();
        }
        if (!((profile2 = environment.getRunProfile()) instanceof RunConfiguration)) {
            startRunnable2.run();
            return;
        }
        RunConfiguration runConfiguration = (RunConfiguration)profile2;
        List<BeforeRunTask<?>> beforeRunTasks = RunManagerImplKt.doGetBeforeRunTasks(runConfiguration);
        if (beforeRunTasks.isEmpty()) {
            startRunnable2.run();
        } else {
            DataContext context = environment.getDataContext();
            DataContext projectContext = context != null ? context : SimpleDataContext.getProjectContext(this.myProject);
            long finalId = id;
            Long executionSessionId = new Long(id);
            Map<BeforeRunTask<?>, Executor> runBeforeRunExecutorMap = Collections.synchronizedMap(new LinkedHashMap());
            for (BeforeRunTask<?> task : beforeRunTasks) {
                RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask runBeforeRun;
                RunnerAndConfigurationSettings settings;
                BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)this.myProject, (Key)task.getProviderId());
                if (provider == null || !(task instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || (settings = (runBeforeRun = (RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task).getSettings()) == null) continue;
                runBeforeRunExecutorMap.put(task, RunManagerImpl.canRunConfiguration(settings, environment.getExecutor()) ? environment.getExecutor() : DefaultRunExecutor.getRunExecutorInstance());
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                for (BeforeRunTask task : beforeRunTasks) {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)this.myProject, (Key)task.getProviderId());
                    if (provider == null) {
                        LOG.warn("Cannot find BeforeRunTaskProvider for id='" + task.getProviderId() + "'");
                        continue;
                    }
                    ExecutionEnvironmentBuilder builder2 = new ExecutionEnvironmentBuilder(environment).contentToReuse(null);
                    Executor executor = (Executor)runBeforeRunExecutorMap.get(task);
                    if (executor != null) {
                        builder2.executor(executor);
                    }
                    ExecutionEnvironment taskEnvironment = builder2.build();
                    taskEnvironment.setExecutionId(finalId);
                    EXECUTION_SESSION_ID_KEY.set((UserDataHolder)taskEnvironment, (Object)executionSessionId);
                    if (provider.executeTask(projectContext, runConfiguration, taskEnvironment, task)) continue;
                    if (onCancelRunnable != null) {
                        SwingUtilities.invokeLater(onCancelRunnable);
                    }
                    return;
                }
                this.doRun(environment, startRunnable2);
            });
        }
    }

    protected void doRun(@NotNull ExecutionEnvironment environment, @NotNull Runnable startRunnable2) {
        Boolean allowSkipRun;
        if (environment == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(13);
        }
        if (startRunnable2 == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(14);
        }
        if ((allowSkipRun = (Boolean)environment.getUserData(EXECUTION_SKIP_RUN)) != null && allowSkipRun.booleanValue()) {
            ((ExecutionListener)environment.getProject().getMessageBus().syncPublisher(EXECUTION_TOPIC)).processNotStarted(environment.getExecutor().getId(), environment);
        } else {
            SwingUtilities.invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
                    if (settings != null && !settings.getType().isDumbAware() && DumbService.isDumb((Project)this.myProject)) {
                        DumbService.getInstance((Project)this.myProject).runWhenSmart(startRunnable2);
                    } else {
                        try {
                            startRunnable2.run();
                        }
                        catch (IndexNotReadyException ignored) {
                            ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException("cannot start while indexing is in progress."));
                        }
                    }
                }
            });
        }
    }

    public void restartRunProfile(@NotNull Project project, @NotNull Executor executor, @NotNull ExecutionTarget target2, @Nullable RunnerAndConfigurationSettings configuration, @Nullable ProcessHandler processHandler2) {
        if (project == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(15);
        }
        if (executor == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(16);
        }
        if (target2 == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(17);
        }
        ExecutionEnvironmentBuilder builder2 = ExecutionManagerImpl.createEnvironmentBuilder(project, executor, configuration);
        if (processHandler2 != null) {
            for (RunContentDescriptor descriptor : ExecutionManagerImpl.getAllDescriptors(project)) {
                if (descriptor.getProcessHandler() != processHandler2) continue;
                builder2.contentToReuse(descriptor);
                break;
            }
        }
        this.restartRunProfile(builder2.target(target2).build());
    }

    public void restartRunProfile(final @NotNull ExecutionEnvironment environment) {
        RunnerAndConfigurationSettings configuration;
        if (environment == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(18);
        }
        List<Object> runningIncompatible = (configuration = environment.getRunnerAndConfigurationSettings()) == null ? Collections.emptyList() : this.getIncompatibleRunningDescriptors(configuration);
        RunContentDescriptor contentToReuse = environment.getContentToReuse();
        SmartList runningOfTheSameType = new SmartList();
        if (configuration != null && !configuration.getConfiguration().isAllowRunningInParallel()) {
            runningOfTheSameType.addAll(this.getRunningDescriptorsOfTheSameConfigType(configuration));
        } else if (ExecutionManagerImpl.isProcessRunning(contentToReuse)) {
            runningOfTheSameType.add(contentToReuse);
        }
        List runningToStop = ContainerUtil.concat((List)runningOfTheSameType, runningIncompatible);
        if (!runningToStop.isEmpty()) {
            if (configuration != null) {
                if (!(runningOfTheSameType.isEmpty() || runningOfTheSameType.size() <= 1 && contentToReuse != null && runningOfTheSameType.get(0) == contentToReuse || ExecutionManagerImpl.userApprovesStopForSameTypeConfigurations(environment.getProject(), configuration.getName(), runningOfTheSameType.size()))) {
                    return;
                }
                if (!runningIncompatible.isEmpty() && !ExecutionManagerImpl.userApprovesStopForIncompatibleConfigurations(this.myProject, configuration.getName(), runningIncompatible)) {
                    return;
                }
            }
            for (RunContentDescriptor descriptor : runningToStop) {
                ExecutionManagerImpl.stopProcess(descriptor);
            }
        }
        if (this.myAwaitingRunProfiles.get(environment.getRunProfile()) == environment) {
            return;
        }
        this.myAwaitingRunProfiles.put(environment.getRunProfile(), environment);
        this.awaitTermination(new Runnable((List)runningOfTheSameType){
            final /* synthetic */ List val$runningOfTheSameType;
            {
                this.val$runningOfTheSameType = list2;
            }

            @Override
            public void run() {
                if (ExecutionManagerImpl.this.myAwaitingRunProfiles.get(environment.getRunProfile()) != environment) {
                    return;
                }
                if (DumbService.getInstance((Project)ExecutionManagerImpl.this.myProject).isDumb() && configuration != null && !configuration.getType().isDumbAware() || ExecutorRegistry.getInstance().isStarting(environment)) {
                    ExecutionManagerImpl.this.awaitTermination(this, 100L);
                    return;
                }
                for (RunContentDescriptor descriptor : this.val$runningOfTheSameType) {
                    ProcessHandler processHandler2 = descriptor.getProcessHandler();
                    if (processHandler2 == null || processHandler2.isProcessTerminated()) continue;
                    ExecutionManagerImpl.this.awaitTermination(this, 100L);
                    return;
                }
                ExecutionManagerImpl.this.myAwaitingRunProfiles.remove(environment.getRunProfile());
                ExecutionManagerImpl.restart(environment);
            }
        }, 50L);
    }

    private void awaitTermination(@NotNull Runnable request, long delayMillis) {
        if (request == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(19);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(request, ModalityState.any());
        } else {
            this.myAwaitingTerminationAlarm.addRequest(request, delayMillis);
        }
    }

    @NotNull
    private List<RunContentDescriptor> getRunningDescriptorsOfTheSameConfigType(@NotNull RunnerAndConfigurationSettings configurationAndSettings) {
        if (configurationAndSettings == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(20);
        }
        List<RunContentDescriptor> list2 = this.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)runningConfigurationAndSettings -> configurationAndSettings == runningConfigurationAndSettings));
        if (list2 == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    private List<RunContentDescriptor> getIncompatibleRunningDescriptors(@NotNull RunnerAndConfigurationSettings configurationAndSettings) {
        if (configurationAndSettings == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(22);
        }
        RunConfiguration configurationToCheckCompatibility = configurationAndSettings.getConfiguration();
        List<RunContentDescriptor> list2 = this.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)runningConfigurationAndSettings -> {
            RunConfiguration runningConfiguration;
            RunConfiguration runConfiguration = runningConfiguration = runningConfigurationAndSettings == null ? null : runningConfigurationAndSettings.getConfiguration();
            if (!(runningConfiguration instanceof CompatibilityAwareRunProfile)) {
                return false;
            }
            return ((CompatibilityAwareRunProfile)runningConfiguration).mustBeStoppedToRun(configurationToCheckCompatibility);
        }));
        if (list2 == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @NotNull
    public List<RunContentDescriptor> getRunningDescriptors(@NotNull Condition<RunnerAndConfigurationSettings> condition) {
        if (condition == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(24);
        }
        SmartList result2 = new SmartList();
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            ProcessHandler processHandler2;
            if (trinity.getSecond() == null || !condition.value(trinity.getSecond()) || (processHandler2 = ((RunContentDescriptor)trinity.getFirst()).getProcessHandler()) == null || processHandler2.isProcessTerminated()) continue;
            result2.add(trinity.getFirst());
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(25);
        }
        return smartList;
    }

    @NotNull
    public List<RunContentDescriptor> getDescriptors(@NotNull Condition<RunnerAndConfigurationSettings> condition) {
        if (condition == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(26);
        }
        SmartList result2 = new SmartList();
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            if (trinity.getSecond() == null || !condition.value(trinity.getSecond())) continue;
            result2.add(trinity.getFirst());
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(27);
        }
        return smartList;
    }

    @NotNull
    public Set<Executor> getExecutors(RunContentDescriptor descriptor) {
        HashSet<Executor> result2 = new HashSet<Executor>();
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            if (descriptor != trinity.first) continue;
            result2.add((Executor)trinity.third);
        }
        HashSet<Executor> hashSet = result2;
        if (hashSet == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    @NotNull
    public Set<RunnerAndConfigurationSettings> getConfigurations(RunContentDescriptor descriptor) {
        HashSet<RunnerAndConfigurationSettings> result2 = new HashSet<RunnerAndConfigurationSettings>();
        for (Trinity<RunContentDescriptor, RunnerAndConfigurationSettings, Executor> trinity : this.myRunningConfigurations) {
            if (descriptor != trinity.first) continue;
            result2.add((RunnerAndConfigurationSettings)trinity.second);
        }
        HashSet<RunnerAndConfigurationSettings> hashSet = result2;
        if (hashSet == null) {
            ExecutionManagerImpl.$$$reportNull$$$0(29);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ExecutionManagerImpl";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRunnable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationAndSettings";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ExecutionManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnvironmentBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDescriptors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningProcesses";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningDescriptorsOfTheSameConfigType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncompatibleRunningDescriptors";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningDescriptors";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutors";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEnvironmentBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "restart";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllDescriptors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compileAndRun";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "restartRunProfile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRunningDescriptorsOfTheSameConfigType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getIncompatibleRunningDescriptors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRunningDescriptors";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

