/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.google.common.collect.Lists;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecentFilesSEContributor
extends FileSearchEverywhereContributor {
    public RecentFilesSEContributor(@Nullable Project project, @Nullable PsiElement context) {
        super(project, context);
    }

    @Override
    @NotNull
    public String getSearchProviderId() {
        String string = RecentFilesSEContributor.class.getSimpleName();
        if (string == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupName() {
        if ("Recent Files" == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(1);
        }
        return "Recent Files";
    }

    @Override
    public String includeNonProjectItemsText() {
        return null;
    }

    @Override
    public int getSortWeight() {
        return 70;
    }

    @Override
    public int getElementPriority(@NotNull Object element, @NotNull String searchPattern) {
        if (element == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(2);
        }
        if (searchPattern == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(3);
        }
        return super.getElementPriority(element, searchPattern) + 1;
    }

    @Override
    public void fetchElements(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<FileType> filter, @NotNull ProgressIndicator progressIndicator, @NotNull Function<Object, Boolean> consumer) {
        if (pattern == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(4);
        }
        if (progressIndicator == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            RecentFilesSEContributor.$$$reportNull$$$0(6);
        }
        if (this.myProject == null) {
            return;
        }
        String searchString = this.filterControlSymbols(pattern);
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + searchString)).build();
        List<VirtualFile> opened = Arrays.asList(FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles());
        List history = Lists.reverse(EditorHistoryManager.getInstance(this.myProject).getFileList());
        ArrayList res2 = new ArrayList();
        ProgressIndicatorUtils.yieldToPendingWriteActions();
        ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            Stream<Object> stream = history.stream();
            if (!StringUtil.isEmptyOrSpaces((String)searchString)) {
                stream = stream.filter(file2 -> matcher.matches(file2.getName()));
            }
            res2.addAll(stream.filter(vf -> !opened.contains(vf) && vf.isValid()).distinct().map(vf -> psiManager.findFile(vf)).filter(file2 -> file2 != null).collect(Collectors.toList()));
            for (Object element : res2) {
                if (((Boolean)consumer.apply(element)).booleanValue()) continue;
                return;
            }
        }, progressIndicator);
    }

    public boolean isEmptyPatternSupported() {
        return true;
    }

    @Override
    public boolean isShownInSeparateTab() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/RecentFilesSEContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/RecentFilesSEContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementPriority";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

