/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundTreeStructureProvider
implements TreeStructureProvider {
    private static final TreeStructureProvider EMPTY = new CompoundTreeStructureProvider(new TreeStructureProvider[0]);
    private static final Key<TreeStructureProvider> KEY = Key.create((String)"TreeStructureProvider");
    private static final Logger LOG = Logger.getInstance(CompoundTreeStructureProvider.class);
    private final TreeStructureProvider[] providers;

    @NotNull
    public static TreeStructureProvider get(@Nullable Project project) {
        if (project == null || project.isDisposed()) {
            TreeStructureProvider treeStructureProvider = EMPTY;
            if (treeStructureProvider == null) {
                CompoundTreeStructureProvider.$$$reportNull$$$0(0);
            }
            return treeStructureProvider;
        }
        TreeStructureProvider provider = (TreeStructureProvider)project.getUserData(KEY);
        if (provider != null) {
            TreeStructureProvider treeStructureProvider = provider;
            if (treeStructureProvider == null) {
                CompoundTreeStructureProvider.$$$reportNull$$$0(1);
            }
            return treeStructureProvider;
        }
        provider = new CompoundTreeStructureProvider((TreeStructureProvider[])EP_NAME.getExtensions((AreaInstance)project));
        project.putUserData(KEY, (Object)provider);
        TreeStructureProvider treeStructureProvider = provider;
        if (treeStructureProvider == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(2);
        }
        return treeStructureProvider;
    }

    public CompoundTreeStructureProvider(TreeStructureProvider ... providers) {
        if (providers == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(3);
        }
        this.providers = providers;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
        if (parent == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(4);
        }
        if (children2 == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(5);
        }
        for (TreeStructureProvider provider : this.providers) {
            try {
                children2 = provider.modify(parent, children2, settings);
                if (!children2.stream().anyMatch(Objects::isNull)) continue;
                LOG.warn("null child provided by " + provider);
                children2 = StreamEx.of((Collection)children2).nonNull().toImmutableList();
            }
            catch (IndexNotReadyException exception) {
                throw new ProcessCanceledException((Throwable)exception);
            }
            catch (ProcessCanceledException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOG.warn("unexpected error in " + provider, (Throwable)exception);
            }
        }
        children2.forEach(node -> node.setParent(parent));
        Collection collection = children2;
        if (collection == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Nullable
    public Object getData(@NotNull Collection<AbstractTreeNode> selection, @NotNull String dataId) {
        if (selection == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(7);
        }
        if (dataId == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(8);
        }
        if (dataId != null && !selection.isEmpty()) {
            for (TreeStructureProvider provider : this.providers) {
                try {
                    Object data = provider.getData(selection, dataId);
                    if (data != null) {
                        return data;
                    }
                }
                catch (IndexNotReadyException data) {
                }
                catch (ProcessCanceledException data) {
                }
                catch (Exception exception) {
                    LOG.warn("unexpected error in " + provider, (Throwable)exception);
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/CompoundTreeStructureProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/CompoundTreeStructureProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

