/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.util.Producer;
import com.intellij.util.net.IOExceptionDialog;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubDownloadUtil {
    private static final String PROJECT_GENERATORS = "projectGenerators";

    private GithubDownloadUtil() {
    }

    @NotNull
    private static String formatGithubRepositoryName(@NotNull String userName, @NotNull String repositoryName) {
        if (userName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(0);
        }
        if (repositoryName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(1);
        }
        String string = "github-" + userName + "-" + repositoryName;
        if (string == null) {
            GithubDownloadUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String formatGithubUserName(@NotNull String userName) {
        if (userName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(3);
        }
        String string = "github-" + userName;
        if (string == null) {
            GithubDownloadUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static File getCacheDir(@NotNull String userName, @NotNull String repositoryName) {
        File file2;
        if (userName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(5);
        }
        if (repositoryName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(6);
        }
        File generatorsDir = new File(PathManager.getSystemPath(), PROJECT_GENERATORS);
        String dirName = GithubDownloadUtil.formatGithubRepositoryName(userName, repositoryName);
        File dir = new File(generatorsDir, dirName);
        try {
            file2 = dir.getCanonicalFile();
        }
        catch (IOException e) {
            File file3 = dir;
            if (file3 == null) {
                GithubDownloadUtil.$$$reportNull$$$0(8);
            }
            return file3;
        }
        if (file2 == null) {
            GithubDownloadUtil.$$$reportNull$$$0(7);
        }
        return file2;
    }

    @NotNull
    public static File getUserCacheDir(@NotNull String userName) {
        File file2;
        if (userName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(9);
        }
        File generatorsDir = new File(PathManager.getSystemPath(), PROJECT_GENERATORS);
        String dirName = GithubDownloadUtil.formatGithubUserName(userName);
        File dir = new File(generatorsDir, dirName);
        try {
            file2 = dir.getCanonicalFile();
        }
        catch (IOException e) {
            File file3 = dir;
            if (file3 == null) {
                GithubDownloadUtil.$$$reportNull$$$0(11);
            }
            return file3;
        }
        if (file2 == null) {
            GithubDownloadUtil.$$$reportNull$$$0(10);
        }
        return file2;
    }

    public static File findCacheFile(@NotNull String userName, @NotNull String repositoryName, @NotNull String cacheFileName) {
        if (userName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(12);
        }
        if (repositoryName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(13);
        }
        if (cacheFileName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(14);
        }
        File dir = GithubDownloadUtil.getCacheDir(userName, repositoryName);
        return new File(dir, cacheFileName);
    }

    public static void downloadContentToFileWithProgressSynchronously(@Nullable Project project, @NotNull String url, @NotNull String progressTitle, @NotNull File outputFile, @NotNull String userName, @NotNull String repositoryName, boolean retryOnError) throws GeneratorException {
        Outcome<File> outcome;
        File out;
        if (url == null) {
            GithubDownloadUtil.$$$reportNull$$$0(15);
        }
        if (progressTitle == null) {
            GithubDownloadUtil.$$$reportNull$$$0(16);
        }
        if (outputFile == null) {
            GithubDownloadUtil.$$$reportNull$$$0(17);
        }
        if (userName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(18);
        }
        if (repositoryName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(19);
        }
        if ((out = (outcome = DownloadUtil.provideDataWithProgressSynchronously(project, progressTitle, "Downloading zip archive${content-length} ...", () -> {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            GithubDownloadUtil.downloadAtomically(progress, url, outputFile, userName, repositoryName);
            return outputFile;
        }, (Producer<Boolean>)((Producer)() -> {
            if (!retryOnError) {
                return false;
            }
            return IOExceptionDialog.showErrorDialog((String)"Download Error", (String)("Can not download '" + url + "'"));
        }))).get()) != null) {
            return;
        }
        Exception e = outcome.getException();
        if (e != null) {
            throw new GeneratorException("Can not fetch content from " + url, e);
        }
        throw new GeneratorException("Download was cancelled");
    }

    public static void downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile, @NotNull String userName, @NotNull String repositoryName) throws IOException {
        if (url == null) {
            GithubDownloadUtil.$$$reportNull$$$0(20);
        }
        if (outputFile == null) {
            GithubDownloadUtil.$$$reportNull$$$0(21);
        }
        if (userName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(22);
        }
        if (repositoryName == null) {
            GithubDownloadUtil.$$$reportNull$$$0(23);
        }
        String tempFileName = String.format("github-%s-%s-%s", userName, repositoryName, outputFile.getName());
        File tempFile = FileUtil.createTempFile((String)(tempFileName + "-"), (String)".tmp");
        DownloadUtil.downloadAtomically(indicator, url, outputFile, tempFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userName";
                break;
            }
            case 1: 
            case 6: 
            case 13: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryName";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheFileName";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/GithubDownloadUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatGithubRepositoryName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formatGithubUserName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheDir";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserCacheDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatGithubRepositoryName";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatGithubUserName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCacheDir";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUserCacheDir";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findCacheFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "downloadContentToFileWithProgressSynchronously";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "downloadAtomically";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

