/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.UndefinedMacrosConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.WaitForProgressToShow;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ProjectMacrosUtil {
    private ProjectMacrosUtil() {
    }

    public static boolean showMacrosConfigurationDialog(Project project, Collection<String> undefinedMacros) {
        String text = ProjectBundle.message((String)"project.load.undefined.path.variables.message", (Object[])new Object[0]);
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment() || application.isUnitTestMode()) {
            throw new RuntimeException(text + ": " + StringUtil.join(undefinedMacros, (String)", "));
        }
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new UndefinedMacrosConfigurable(text, undefinedMacros));
    }

    public static boolean checkNonIgnoredMacros(Project project, Set<String> usedMacros) {
        PathMacros pathMacros = PathMacros.getInstance();
        Iterator<String> iterator = usedMacros.iterator();
        while (iterator.hasNext()) {
            if (!pathMacros.isIgnoredMacroName(iterator.next())) continue;
            iterator.remove();
        }
        return ProjectMacrosUtil.checkMacros(project, usedMacros);
    }

    public static boolean checkMacros(@NotNull Project project, @NotNull Set<String> usedMacros) {
        if (project == null) {
            ProjectMacrosUtil.$$$reportNull$$$0(0);
        }
        if (usedMacros == null) {
            ProjectMacrosUtil.$$$reportNull$$$0(1);
        }
        PathMacros pathMacros = PathMacros.getInstance();
        usedMacros.removeAll(pathMacros.getSystemMacroNames());
        usedMacros.removeAll(pathMacros.getUserMacroNames());
        String pathMacroSystemPrefix = "path.macro.";
        Iterator<String> it = usedMacros.iterator();
        while (it.hasNext()) {
            String macro = it.next();
            String value = System.getProperty(pathMacroSystemPrefix + macro, null);
            if (value == null) continue;
            pathMacros.setMacro(macro, value);
            it.remove();
        }
        if (usedMacros.isEmpty()) {
            return true;
        }
        boolean[] result2 = new boolean[1];
        WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(() -> {
            result2[0] = ProjectMacrosUtil.showMacrosConfigurationDialog(project, usedMacros);
        }, (ModalityState)ModalityState.NON_MODAL);
        return result2[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "usedMacros";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/project/impl/ProjectMacrosUtil";
        objectArray[2] = "checkMacros";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

