/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.containers.CacheOneStepIterator;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShowDiffFromAnnotation
extends DumbAwareAction
implements UpToDateLineNumberListener {
    private static final Logger LOG = Logger.getInstance(ShowDiffFromAnnotation.class);
    @NotNull
    private final Project myProject;
    private final FileAnnotation myFileAnnotation;
    private final FileAnnotation.RevisionChangesProvider myChangesProvider;
    private int currentLine;
    private static final int ourVicinity = 5;

    ShowDiffFromAnnotation(@NotNull Project project, @NotNull FileAnnotation fileAnnotation) {
        if (project == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(0);
        }
        if (fileAnnotation == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(1);
        }
        this.currentLine = -1;
        ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowDiff");
        this.setShortcutSet((ShortcutSet)CustomShortcutSet.EMPTY);
        this.myProject = project;
        this.myFileAnnotation = fileAnnotation;
        this.myChangesProvider = fileAnnotation.getRevisionsChangesProvider();
    }

    public void consume(Integer integer) {
        this.currentLine = integer;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(2);
        }
        int number = this.currentLine;
        e.getPresentation().setVisible(this.myChangesProvider != null);
        e.getPresentation().setEnabled(this.myChangesProvider != null && number >= 0 && number < this.myFileAnnotation.getLineCount());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        int actualNumber;
        if (e == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(3);
        }
        if ((actualNumber = this.currentLine) < 0) {
            return;
        }
        VcsRevisionNumber revisionNumber = this.myFileAnnotation.getLineRevisionNumber(actualNumber);
        if (revisionNumber == null) {
            return;
        }
        MyLoadingRequestChain requestChain = new MyLoadingRequestChain(this.myFileAnnotation, this.myChangesProvider, actualNumber);
        DiffManager.getInstance().showDiff(this.myProject, (DiffRequestChain)requestChain, DiffDialogHints.FRAME);
    }

    @NotNull
    private static ListSelection<ChangeDiffRequestProducer> loadRequests(@NotNull FileAnnotation fileAnnotation, @NotNull FileAnnotation.RevisionChangesProvider changesProvider, int actualNumber) throws DiffRequestProducerException {
        ListSelection listSelection;
        if (fileAnnotation == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(4);
        }
        if (changesProvider == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(5);
        }
        try {
            Pair pair = changesProvider.getChangesIn(actualNumber);
            if (pair == null || pair.getFirst() == null || pair.getSecond() == null) {
                throw new DiffRequestProducerException("Can not load data to show diff");
            }
            FilePath targetPath = (FilePath)pair.getSecond();
            List changes2 = ContainerUtil.sorted((Collection)((CommittedChangeList)pair.getFirst()).getChanges(), ChangesComparator.getInstance(true));
            HashMap context = new HashMap();
            int idx = ShowDiffFromAnnotation.findSelfInList(changes2, targetPath);
            if (idx != -1) {
                DiffNavigationContext navigationContext = ShowDiffFromAnnotation.createDiffNavigationContext(fileAnnotation, actualNumber);
                context.put(changes2.get(idx), Collections.singletonMap(DiffUserDataKeysEx.NAVIGATION_CONTEXT, navigationContext));
            }
            ListSelection changeSelection = ListSelection.createAt((List)changes2, (int)idx);
            listSelection = changeSelection.map(change -> ChangeDiffRequestProducer.create(fileAnnotation.getProject(), change, (Map)context.get(change)));
        }
        catch (VcsException e) {
            throw new DiffRequestProducerException((Throwable)e);
        }
        if (listSelection == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(6);
        }
        return listSelection;
    }

    private static int findSelfInList(@NotNull List<Change> changes2, @NotNull FilePath filePath) {
        if (changes2 == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(7);
        }
        if (filePath == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(8);
        }
        int idx = -1;
        for (int i = 0; i < changes2.size(); ++i) {
            Change change = changes2.get(i);
            if (change.getAfterRevision() == null || !change.getAfterRevision().getFile().equals(filePath)) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            return idx;
        }
        idx = 0;
        String name = filePath.getName();
        for (int i = 0; i < changes2.size(); ++i) {
            Change change = changes2.get(i);
            if (change.getAfterRevision() == null || !change.getAfterRevision().getFile().getName().equals(name)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    @Nullable
    private static DiffNavigationContext createDiffNavigationContext(final @NotNull FileAnnotation fileAnnotation, int actualLine) {
        String annotatedContent;
        if (fileAnnotation == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmptyOrSpaces((String)(annotatedContent = fileAnnotation.getAnnotatedContent()))) {
            return null;
        }
        final String[] contentsLines = LineTokenizer.tokenize((CharSequence)annotatedContent, (boolean)false, (boolean)false);
        if (contentsLines.length <= actualLine) {
            return null;
        }
        final int correctedLine = ShowDiffFromAnnotation.correctActualLineIfTextEmpty(fileAnnotation, contentsLines, actualLine);
        return new DiffNavigationContext((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new CacheOneStepIterator((Iterator)new ContextLineIterator(contentsLines, fileAnnotation, correctedLine));
            }
        }, contentsLines[correctedLine]);
    }

    private static int correctActualLineIfTextEmpty(@NotNull FileAnnotation fileAnnotation, @NotNull String[] contentsLines, int actualLine) {
        VcsRevisionNumber revision;
        if (fileAnnotation == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(10);
        }
        if (contentsLines == null) {
            ShowDiffFromAnnotation.$$$reportNull$$$0(11);
        }
        if ((revision = fileAnnotation.getLineRevisionNumber(actualLine)) == null) {
            return actualLine;
        }
        if (!StringUtil.isEmptyOrSpaces((String)contentsLines[actualLine])) {
            return actualLine;
        }
        int upperBound = Math.min(actualLine + 5, contentsLines.length);
        for (int i = actualLine + 1; i < upperBound; ++i) {
            if (!revision.equals(fileAnnotation.getLineRevisionNumber(i)) || StringUtil.isEmptyOrSpaces((String)contentsLines[i])) continue;
            return i;
        }
        int lowerBound = Math.max(actualLine - 5, 0);
        for (int i = actualLine - 1; i >= lowerBound; --i) {
            if (!revision.equals(fileAnnotation.getLineRevisionNumber(i)) || StringUtil.isEmptyOrSpaces((String)contentsLines[i])) continue;
            return i;
        }
        return actualLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAnnotation";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentsLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadRequests";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSelfInList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDiffNavigationContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "correctActualLineIfTextEmpty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContextLineIterator
    implements Iterator<String> {
        @NotNull
        private final String[] myContentsLines;
        private final VcsRevisionNumber myRevisionNumber;
        @NotNull
        private final FileAnnotation myAnnotation;
        private final int myStopAtLine;
        private int myCurrentLine;

        private ContextLineIterator(@NotNull String[] contentLines, @NotNull FileAnnotation annotation, int stopAtLine) {
            if (contentLines == null) {
                ContextLineIterator.$$$reportNull$$$0(0);
            }
            if (annotation == null) {
                ContextLineIterator.$$$reportNull$$$0(1);
            }
            this.myAnnotation = annotation;
            this.myRevisionNumber = this.myAnnotation.originalRevision(stopAtLine);
            this.myStopAtLine = stopAtLine;
            this.myContentsLines = contentLines;
        }

        @Override
        public boolean hasNext() {
            return this.myRevisionNumber != null && this.lineNumberInBounds();
        }

        private boolean lineNumberInBounds() {
            return this.myCurrentLine < this.myContentsLines.length && this.myCurrentLine < this.myStopAtLine;
        }

        @Override
        public String next() {
            while (this.lineNumberInBounds()) {
                VcsRevisionNumber vcsRevisionNumber = this.myAnnotation.originalRevision(this.myCurrentLine);
                String text = this.myContentsLines[this.myCurrentLine];
                ++this.myCurrentLine;
                if (!this.myRevisionNumber.equals(vcsRevisionNumber) || StringUtil.isEmptyOrSpaces((String)text)) continue;
                return text;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contentLines";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "annotation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation$ContextLineIterator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyLoadingRequestChain
    extends AsyncDiffRequestChain
    implements GoToChangePopupBuilder.Chain {
        @NotNull
        private final FileAnnotation myFileAnnotation;
        @NotNull
        private final FileAnnotation.RevisionChangesProvider myChangesProvider;
        private final int myLineNumber;

        private MyLoadingRequestChain(@NotNull FileAnnotation fileAnnotation, @NotNull FileAnnotation.RevisionChangesProvider changesProvider, int lineNuber) {
            if (fileAnnotation == null) {
                MyLoadingRequestChain.$$$reportNull$$$0(0);
            }
            if (changesProvider == null) {
                MyLoadingRequestChain.$$$reportNull$$$0(1);
            }
            this.myFileAnnotation = fileAnnotation;
            this.myChangesProvider = changesProvider;
            this.myLineNumber = lineNuber;
        }

        @NotNull
        protected ListSelection<ChangeDiffRequestProducer> loadRequestProducers() throws DiffRequestProducerException {
            ListSelection listSelection = ShowDiffFromAnnotation.loadRequests(this.myFileAnnotation, this.myChangesProvider, this.myLineNumber);
            if (listSelection == null) {
                MyLoadingRequestChain.$$$reportNull$$$0(2);
            }
            return listSelection;
        }

        @Override
        @NotNull
        public AnAction createGoToChangeAction(@NotNull Consumer<Integer> onSelected) {
            if (onSelected == null) {
                MyLoadingRequestChain.$$$reportNull$$$0(3);
            }
            AnAction anAction = ChangeDiffRequestChain.createGoToChangeAction(this, onSelected);
            if (anAction == null) {
                MyLoadingRequestChain.$$$reportNull$$$0(4);
            }
            return anAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileAnnotation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesProvider";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation$MyLoadingRequestChain";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onSelected";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/actions/ShowDiffFromAnnotation$MyLoadingRequestChain";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadRequestProducers";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGoToChangeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createGoToChangeAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

