/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.CollectingHistorySessionConsumer;
import com.intellij.openapi.vcs.history.LimitHistoryCheck;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistorySessionConsumer;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCachingHistory {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsHistoryCache myVcsHistoryCache;
    @NotNull
    private final VcsHistoryProvider myHistoryProvider;
    @NotNull
    private final VcsType myType;
    private final DiffProvider myDiffProvider;

    private VcsCachingHistory(@NotNull AbstractVcs vcs, @NotNull VcsHistoryProvider historyProvider, DiffProvider diffProvider) {
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(0);
        }
        if (historyProvider == null) {
            VcsCachingHistory.$$$reportNull$$$0(1);
        }
        this.myProject = vcs.getProject();
        this.myVcsHistoryCache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsHistoryCache();
        this.myHistoryProvider = historyProvider;
        this.myType = vcs.getType();
        this.myDiffProvider = diffProvider;
    }

    private void reportHistoryInBackground(final @NotNull FilePath filePath, final @Nullable VcsRevisionNumber startRevisionNumber, final @NotNull VcsKey vcsKey, final @NotNull BackgroundableActionLock lock, final @NotNull VcsHistorySessionConsumer partner, final boolean canUseCache) {
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(2);
        }
        if (vcsKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(3);
        }
        if (lock == null) {
            VcsCachingHistory.$$$reportNull$$$0(4);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(5);
        }
        if (lock.isLocked()) {
            return;
        }
        lock.lock();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText(VcsUtil.getPathForProgressPresentation((File)filePath.getIOFile()));
                indicator.setIndeterminate(true);
                VcsCachingHistory.this.reportHistory(filePath, startRevisionNumber, vcsKey, partner, canUseCache);
            }

            public void onFinished() {
                lock.unlock();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/history/VcsCachingHistory$1", "run"));
            }
        });
    }

    private void reportHistory(@NotNull FilePath filePath, @Nullable VcsRevisionNumber startRevisionNumber, @NotNull VcsKey vcsKey, @NotNull VcsHistorySessionConsumer partner, boolean canUseCache) {
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(6);
        }
        if (vcsKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(7);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(8);
        }
        try {
            if (startRevisionNumber == null) {
                partner = this.wrapPartnerToCachingPartner(vcsKey, filePath, partner);
            }
            VcsAbstractHistorySession cachedSession = null;
            VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory = this.getCacheableFactory();
            if (canUseCache && cacheableFactory != null) {
                cachedSession = this.getSessionFromCacheWithLastRevisionCheck(filePath, vcsKey, cacheableFactory);
            }
            if (cachedSession != null) {
                partner.reportCreatedEmptySession(cachedSession);
            } else if (this.myHistoryProvider instanceof VcsHistoryProviderEx) {
                ((VcsHistoryProviderEx)this.myHistoryProvider).reportAppendableHistory(filePath, startRevisionNumber, (VcsAppendableHistorySessionPartner)partner);
            } else {
                this.myHistoryProvider.reportAppendableHistory(filePath, (VcsAppendableHistorySessionPartner)partner);
            }
            partner.finished();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (LimitHistoryCheck.VcsFileHistoryLimitReachedException ignored) {
            partner.finished();
        }
        catch (VcsException e) {
            partner.reportException(e);
        }
        catch (Throwable t) {
            partner.reportException(new VcsException(t));
        }
    }

    @Nullable
    private VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> getCacheableFactory() {
        if (!(this.myHistoryProvider instanceof VcsCacheableHistorySessionFactory)) {
            return null;
        }
        return (VcsCacheableHistorySessionFactory)this.myHistoryProvider;
    }

    @NotNull
    private VcsHistoryCache getHistoryCache() {
        VcsHistoryCache vcsHistoryCache = this.myVcsHistoryCache;
        if (vcsHistoryCache == null) {
            VcsCachingHistory.$$$reportNull$$$0(9);
        }
        return vcsHistoryCache;
    }

    @NotNull
    private VcsHistorySessionConsumer wrapPartnerToCachingPartner(@NotNull VcsKey vcsKey, @NotNull FilePath filePath, @NotNull VcsHistorySessionConsumer partner) {
        VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory;
        if (vcsKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(10);
        }
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(11);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(12);
        }
        if ((cacheableFactory = this.getCacheableFactory()) != null) {
            HistoryPartnerProxy historyPartnerProxy = new HistoryPartnerProxy(partner, session2 -> {
                if (session2 == null) {
                    return;
                }
                FilePath correctedPath = cacheableFactory.getUsedFilePath(session2);
                this.myVcsHistoryCache.put(filePath, correctedPath, vcsKey, (VcsAbstractHistorySession)session2.copy(), cacheableFactory, true);
            });
            if (historyPartnerProxy == null) {
                VcsCachingHistory.$$$reportNull$$$0(13);
            }
            return historyPartnerProxy;
        }
        VcsHistorySessionConsumer vcsHistorySessionConsumer = partner;
        if (vcsHistorySessionConsumer == null) {
            VcsCachingHistory.$$$reportNull$$$0(14);
        }
        return vcsHistorySessionConsumer;
    }

    @Nullable
    private VcsAbstractHistorySession getSessionFromCacheWithLastRevisionCheck(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory) {
        VcsAbstractHistorySession cached;
        ProgressIndicator indicator;
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(15);
        }
        if (vcsKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(16);
        }
        if (cacheableFactory == null) {
            VcsCachingHistory.$$$reportNull$$$0(17);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setText2("Checking last revision");
        }
        if ((cached = this.myVcsHistoryCache.getFull(filePath, vcsKey, cacheableFactory)) == null || cached.getRevisionList().isEmpty()) {
            return null;
        }
        FilePath correctedFilePath = cacheableFactory.getUsedFilePath(cached);
        FilePath path = correctedFilePath != null ? correctedFilePath : filePath;
        VcsRevisionNumber currentRevision = null;
        if (VcsType.distributed.equals((Object)this.myType)) {
            currentRevision = cached.calcCurrentRevisionNumber();
        } else {
            ItemLatestState lastRevision = this.myDiffProvider.getLastRevision(path);
            if (lastRevision != null && !lastRevision.isDefaultHead() && lastRevision.isItemExists()) {
                currentRevision = lastRevision.getNumber();
            }
        }
        VcsRevisionNumber firstCachedRevision = ((VcsFileRevision)cached.getRevisionList().get(0)).getRevisionNumber();
        if (currentRevision != null && firstCachedRevision.equals(currentRevision)) {
            return cached;
        }
        return null;
    }

    public static List<VcsFileRevision> collect(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber revision) throws VcsException {
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(18);
        }
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(19);
        }
        VcsCachingHistory history = new VcsCachingHistory(vcs, (VcsHistoryProvider)ObjectUtils.notNull((Object)vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        CollectingHistorySessionConsumer partner = new CollectingHistorySessionConsumer();
        history.reportHistory(filePath, revision, vcs.getKeyInstanceMethod(), (VcsHistorySessionConsumer)partner, true);
        partner.check();
        return partner.getSession().getRevisionList();
    }

    public static void collectInBackground(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsBackgroundableActions actionKey, @NotNull Consumer<VcsHistorySession> consumer) {
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(20);
        }
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(21);
        }
        if (actionKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            VcsCachingHistory.$$$reportNull$$$0(23);
        }
        VcsCachingHistory history = new VcsCachingHistory(vcs, (VcsHistoryProvider)ObjectUtils.notNull((Object)vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        CollectingHistoryPartner partner = new CollectingHistoryPartner(vcs.getProject(), filePath, consumer);
        BackgroundableActionLock lock = VcsCachingHistory.getHistoryLock(vcs, actionKey, filePath, null);
        history.reportHistoryInBackground(filePath, null, vcs.getKeyInstanceMethod(), lock, partner, true);
    }

    public static void collectInBackground(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsHistorySessionConsumer partner, boolean canUseCache) {
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(24);
        }
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(25);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(26);
        }
        VcsCachingHistory history = new VcsCachingHistory(vcs, (VcsHistoryProvider)ObjectUtils.notNull((Object)vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        BackgroundableActionLock lock = VcsCachingHistory.getHistorySessionLock(vcs, filePath, null);
        history.reportHistoryInBackground(filePath, null, vcs.getKeyInstanceMethod(), lock, partner, canUseCache);
    }

    public static void collectInBackground(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsRevisionNumber startRevisionNumber, @NotNull VcsHistorySessionConsumer partner) {
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(27);
        }
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(28);
        }
        if (startRevisionNumber == null) {
            VcsCachingHistory.$$$reportNull$$$0(29);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(30);
        }
        if (!(vcs.getVcsHistoryProvider() instanceof VcsHistoryProviderEx)) {
            throw new UnsupportedOperationException();
        }
        BackgroundableActionLock lock = VcsCachingHistory.getHistorySessionLock(vcs, filePath, startRevisionNumber);
        VcsCachingHistory history = new VcsCachingHistory(vcs, (VcsHistoryProvider)ObjectUtils.notNull((Object)vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        history.reportHistoryInBackground(filePath, startRevisionNumber, vcs.getKeyInstanceMethod(), lock, partner, false);
    }

    public static boolean collectFromCache(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsHistorySessionConsumer partner) {
        VcsAbstractHistorySession session2;
        VcsCachingHistory history;
        VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory;
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(31);
        }
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(32);
        }
        if (partner == null) {
            VcsCachingHistory.$$$reportNull$$$0(33);
        }
        if ((cacheableFactory = (history = new VcsCachingHistory(vcs, (VcsHistoryProvider)ObjectUtils.notNull((Object)vcs.getVcsHistoryProvider()), vcs.getDiffProvider())).getCacheableFactory()) != null && (session2 = history.getHistoryCache().getFull(filePath, vcs.getKeyInstanceMethod(), cacheableFactory)) != null) {
            partner.reportCreatedEmptySession(session2);
            partner.finished();
            return true;
        }
        return false;
    }

    @NotNull
    public static BackgroundableActionLock getHistorySessionLock(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber startRevisionNumber) {
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(34);
        }
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(35);
        }
        BackgroundableActionLock backgroundableActionLock = VcsCachingHistory.getHistoryLock(vcs, VcsBackgroundableActions.CREATE_HISTORY_SESSION, filePath, startRevisionNumber);
        if (backgroundableActionLock == null) {
            VcsCachingHistory.$$$reportNull$$$0(36);
        }
        return backgroundableActionLock;
    }

    @NotNull
    public static BackgroundableActionLock getHistoryLock(@NotNull AbstractVcs vcs, @NotNull VcsBackgroundableActions actionKey, @NotNull FilePath filePath, @Nullable VcsRevisionNumber startRevisionNumber) {
        if (vcs == null) {
            VcsCachingHistory.$$$reportNull$$$0(37);
        }
        if (actionKey == null) {
            VcsCachingHistory.$$$reportNull$$$0(38);
        }
        if (filePath == null) {
            VcsCachingHistory.$$$reportNull$$$0(39);
        }
        if (startRevisionNumber != null) {
            BackgroundableActionLock backgroundableActionLock = BackgroundableActionLock.getLock(vcs.getProject(), new Object[]{actionKey, filePath.getPath(), startRevisionNumber.asString()});
            if (backgroundableActionLock == null) {
                VcsCachingHistory.$$$reportNull$$$0(40);
            }
            return backgroundableActionLock;
        }
        BackgroundableActionLock backgroundableActionLock = BackgroundableActionLock.getLock(vcs.getProject(), new Object[]{actionKey, filePath.getPath()});
        if (backgroundableActionLock == null) {
            VcsCachingHistory.$$$reportNull$$$0(41);
        }
        return backgroundableActionLock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 36: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 36: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyProvider";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 15: 
            case 19: 
            case 21: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 26: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partner";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 36: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/VcsCachingHistory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheableFactory";
                break;
            }
            case 22: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionKey";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/VcsCachingHistory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryCache";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapPartnerToCachingPartner";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistorySessionLock";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportHistoryInBackground";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportHistory";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 36: 
            case 40: 
            case 41: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapPartnerToCachingPartner";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSessionFromCacheWithLastRevisionCheck";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectInBackground";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collectFromCache";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getHistorySessionLock";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getHistoryLock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 36: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HistoryPartnerProxy
    implements VcsHistorySessionConsumer {
        @NotNull
        private final VcsHistorySessionConsumer myPartner;
        @NotNull
        private final Consumer<VcsAbstractHistorySession> myFinish;
        private VcsAbstractHistorySession myCopy;

        private HistoryPartnerProxy(@NotNull VcsHistorySessionConsumer partner, @NotNull Consumer<VcsAbstractHistorySession> finish) {
            if (partner == null) {
                HistoryPartnerProxy.$$$reportNull$$$0(0);
            }
            if (finish == null) {
                HistoryPartnerProxy.$$$reportNull$$$0(1);
            }
            this.myPartner = partner;
            this.myFinish = finish;
        }

        public void reportCreatedEmptySession(VcsAbstractHistorySession session2) {
            this.myCopy = (VcsAbstractHistorySession)session2.copy();
            this.myPartner.reportCreatedEmptySession(session2);
        }

        public void acceptRevision(VcsFileRevision revision) {
            this.myCopy.appendRevision(revision);
            this.myPartner.acceptRevision(revision);
        }

        public void reportException(VcsException exception) {
            this.myPartner.reportException(exception);
        }

        public void finished() {
            this.myPartner.finished();
            this.myFinish.consume((Object)this.myCopy);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "partner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finish";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/history/VcsCachingHistory$HistoryPartnerProxy";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CollectingHistoryPartner
    implements VcsHistorySessionConsumer {
        @NotNull
        private final Project myProject;
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final Consumer<VcsHistorySession> myContinuation;
        @NotNull
        private final LimitHistoryCheck myCheck;
        private VcsAbstractHistorySession mySession;

        private CollectingHistoryPartner(@NotNull Project project, @NotNull FilePath path, @NotNull Consumer<VcsHistorySession> continuation) {
            if (project == null) {
                CollectingHistoryPartner.$$$reportNull$$$0(0);
            }
            if (path == null) {
                CollectingHistoryPartner.$$$reportNull$$$0(1);
            }
            if (continuation == null) {
                CollectingHistoryPartner.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myFilePath = path;
            this.myContinuation = continuation;
            this.myCheck = new LimitHistoryCheck(this.myProject, this.myFilePath.getPath());
        }

        public void reportCreatedEmptySession(VcsAbstractHistorySession session2) {
            List revisionList = session2.getRevisionList();
            while (this.myCheck.isOver(revisionList.size())) {
                revisionList.remove(revisionList.size() - 1);
            }
            this.mySession = session2;
        }

        public void acceptRevision(VcsFileRevision revision) {
            this.myCheck.checkNumber();
            this.mySession.appendRevision(revision);
        }

        public void reportException(VcsException exception) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(exception, VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]));
        }

        public void finished() {
            if (this.mySession != null) {
                ApplicationManager.getApplication().invokeLater(() -> this.myContinuation.consume((Object)this.mySession), ModalityState.defaultModalityState());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "continuation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/history/VcsCachingHistory$CollectingHistoryPartner";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

