/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.application.Topics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.project.ProjectKt;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLargeFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiVFSListener
implements BulkFileListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.impl.PsiVFSListener");
    private final FileTypeManager myFileTypeManager;
    private final ProjectRootManager myProjectRootManager;
    private final PsiManagerImpl myManager;
    private final FileManagerImpl myFileManager;
    private final Project myProject;
    private boolean myReportedUnloadedPsiChange;
    private static final AtomicBoolean ourGlobalListenerInstalled = new AtomicBoolean(false);

    public PsiVFSListener(Project project) {
        PsiVFSListener.installGlobalListener();
        this.myProject = project;
        this.myFileTypeManager = FileTypeManager.getInstance();
        this.myProjectRootManager = ProjectRootManager.getInstance((Project)project);
        this.myManager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
        this.myFileManager = (FileManagerImpl)this.myManager.getFileManager();
        StartupManager.getInstance((Project)project).registerPreStartupActivity(() -> {
            MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
            connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyModuleRootListener());
            connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

                public void fileTypesChanged(@NotNull FileTypeEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PsiVFSListener.this.myFileManager.processFileTypesChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/impl/file/impl/PsiVFSListener$1", "fileTypesChanged"));
                }
            });
            connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new MyFileDocumentManagerAdapter());
        });
    }

    private static void installGlobalListener() {
        if (ourGlobalListenerInstalled.compareAndSet(false, true)) {
            Topics.subscribe((Topic)VirtualFileManager.VFS_CHANGES, null, (Object)new BulkFileListener(){

                public void before(@NotNull List<? extends VFileEvent> events) {
                    if (events == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                        PsiVFSListener listener2 = (PsiVFSListener)project.getComponent(PsiVFSListener.class);
                        listener2.before(events);
                    }
                }

                public void after(@NotNull List<? extends VFileEvent> events) {
                    Project[] projects;
                    if (events == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                        PushedFilePropertiesUpdater updater = PushedFilePropertiesUpdater.getInstance((Project)project);
                        if (!(updater instanceof PushedFilePropertiesUpdaterImpl)) continue;
                        ((PushedFilePropertiesUpdaterImpl)updater).processAfterVfsChanges(events);
                    }
                    for (Project project : projects) {
                        PsiVFSListener listener2 = (PsiVFSListener)project.getComponent(PsiVFSListener.class);
                        listener2.after(events);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "events";
                    objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "before";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "after";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @Nullable
    private PsiDirectory getCachedDirectory(VirtualFile parent) {
        return parent == null ? null : this.myFileManager.getCachedDirectory(parent);
    }

    private void fileCreated(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            PsiVFSListener.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDirectory item;
            VirtualFile parent = vFile.getParent();
            PsiDirectory parentDir = this.getCachedDirectory(parent);
            if (parentDir == null) {
                this.handleVfsChangeWithoutPsi(vFile);
                return;
            }
            Object object = item = vFile.isDirectory() ? this.myFileManager.findDirectory(vFile) : this.myFileManager.findFile(vFile);
            if (item != null && item.getProject() == this.myManager.getProject()) {
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
                treeEvent.setParent((PsiElement)parentDir);
                this.myManager.beforeChildAddition(treeEvent);
                treeEvent.setChild((PsiElement)item);
                this.myManager.childAdded(treeEvent);
            }
        });
    }

    private void beforeFileDeletion(@NotNull VFileDeleteEvent event) {
        VirtualFile vFile;
        VirtualFile parent;
        PsiDirectory parentDir;
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(1);
        }
        if ((parentDir = this.getCachedDirectory(parent = (vFile = event.getFile()).getParent())) == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDirectory item;
            Object object = item = vFile.isDirectory() ? this.myFileManager.findDirectory(vFile) : this.myFileManager.getCachedPsiFile(vFile);
            if (item != null) {
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
                treeEvent.setParent((PsiElement)parentDir);
                treeEvent.setChild((PsiElement)item);
                this.myManager.beforeChildRemoval(treeEvent);
            }
        });
    }

    private void filesDeleted(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(2);
        }
        boolean needToRemoveInvalidFilesAndDirs = false;
        for (VFileEvent vFileEvent : events) {
            PsiFile element;
            VFileDeleteEvent de = (VFileDeleteEvent)vFileEvent;
            VirtualFile vFile = de.getFile();
            VirtualFile parent = vFile.getParent();
            PsiFile psiFile = this.myFileManager.getCachedPsiFileInner(vFile);
            if (psiFile != null) {
                this.clearViewProvider(vFile, "PSI fileDeleted");
                element = psiFile;
            } else {
                PsiDirectory psiDir = this.myFileManager.getCachedDirectory(vFile);
                if (psiDir != null) {
                    needToRemoveInvalidFilesAndDirs = true;
                    element = psiDir;
                } else {
                    if (parent != null) {
                        this.handleVfsChangeWithoutPsi(parent);
                        return;
                    }
                    element = null;
                }
            }
            PsiDirectory parentDir = this.getCachedDirectory(parent);
            if (element == null || parentDir == null) continue;
            ApplicationManager.getApplication().runWriteAction(() -> this.lambda$filesDeleted$3(parentDir, (PsiElement)element));
        }
        if (needToRemoveInvalidFilesAndDirs) {
            this.myFileManager.removeInvalidFilesAndDirs(false);
        }
    }

    private void clearViewProvider(@NotNull VirtualFile vFile, @NotNull String why) {
        if (vFile == null) {
            PsiVFSListener.$$$reportNull$$$0(3);
        }
        if (why == null) {
            PsiVFSListener.$$$reportNull$$$0(4);
        }
        DebugUtil.performPsiModification(why, () -> this.myFileManager.setViewProvider(vFile, null));
    }

    private void beforePropertyChange(@NotNull VFilePropertyChangeEvent event) {
        PsiDirectory parentDir;
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(5);
        }
        VirtualFile vFile = event.getFile();
        String propertyName = event.getPropertyName();
        FileViewProvider viewProvider = this.myFileManager.findCachedViewProvider(vFile);
        VirtualFile parent = vFile.getParent();
        PsiDirectory psiDirectory = parentDir = viewProvider != null && parent != null ? this.myFileManager.findDirectory(parent) : this.getCachedDirectory(parent);
        if (parent != null && parentDir == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeEvent.setParent((PsiElement)parentDir);
            if ("name".equals(propertyName)) {
                String newName = (String)event.getNewValue();
                if (parentDir == null) {
                    return;
                }
                if (vFile.isDirectory()) {
                    PsiDirectory psiDir = this.myFileManager.findDirectory(vFile);
                    if (psiDir != null) {
                        if (!this.myFileTypeManager.isFileIgnored(newName)) {
                            treeEvent.setChild((PsiElement)psiDir);
                            treeEvent.setPropertyName("directoryName");
                            treeEvent.setOldValue(vFile.getName());
                            treeEvent.setNewValue(newName);
                            this.myManager.beforePropertyChange(treeEvent);
                        } else {
                            treeEvent.setChild((PsiElement)psiDir);
                            this.myManager.beforeChildRemoval(treeEvent);
                        }
                    } else if (!(Registry.is((String)"ide.hide.excluded.files") && this.isExcludeRoot(vFile) || this.myFileTypeManager.isFileIgnored(newName))) {
                        this.myManager.beforeChildAddition(treeEvent);
                    }
                } else {
                    FileViewProvider viewProvider1 = this.myFileManager.findViewProvider(vFile);
                    PsiFile psiFile = viewProvider1.getPsi(viewProvider1.getBaseLanguage());
                    PsiFile psiFile1 = this.createFileCopyWithNewName(vFile, newName);
                    if (psiFile != null) {
                        if (psiFile1 == null) {
                            treeEvent.setChild((PsiElement)psiFile);
                            this.myManager.beforeChildRemoval(treeEvent);
                        } else if (!psiFile1.getClass().equals(psiFile.getClass())) {
                            treeEvent.setOldChild((PsiElement)psiFile);
                            this.myManager.beforeChildReplacement(treeEvent);
                        } else {
                            treeEvent.setChild((PsiElement)psiFile);
                            treeEvent.setPropertyName("fileName");
                            treeEvent.setOldValue(vFile.getName());
                            treeEvent.setNewValue(newName);
                            this.myManager.beforePropertyChange(treeEvent);
                        }
                    } else if (psiFile1 != null) {
                        this.myManager.beforeChildAddition(treeEvent);
                    }
                }
            } else if ("writable".equals(propertyName)) {
                PsiFile psiFile = this.myFileManager.getCachedPsiFileInner(vFile);
                if (psiFile == null) {
                    return;
                }
                treeEvent.setElement((PsiElement)psiFile);
                treeEvent.setPropertyName("writable");
                treeEvent.setOldValue(event.getOldValue());
                treeEvent.setNewValue(event.getNewValue());
                this.myManager.beforePropertyChange(treeEvent);
            }
        });
    }

    private boolean isExcludeRoot(VirtualFile file2) {
        VirtualFile[] excludeRoots;
        VirtualFile parent = file2.getParent();
        if (parent == null) {
            return false;
        }
        Module module = this.myProjectRootManager.getFileIndex().getModuleForFile(parent);
        if (module == null) {
            return false;
        }
        for (VirtualFile root : excludeRoots = ModuleRootManager.getInstance((Module)module).getExcludeRoots()) {
            if (!root.equals(file2)) continue;
            return true;
        }
        return false;
    }

    private void propertyChanged(@NotNull VFilePropertyChangeEvent event) {
        PsiDirectory parentDir;
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(6);
        }
        String propertyName = event.getPropertyName();
        VirtualFile vFile = event.getFile();
        FileViewProvider oldFileViewProvider = this.myFileManager.findCachedViewProvider(vFile);
        PsiFile oldPsiFile = this.myFileManager.getCachedPsiFile(vFile);
        VirtualFile parent = vFile.getParent();
        PsiDirectory psiDirectory = parentDir = oldPsiFile != null && parent != null ? this.myFileManager.findDirectory(parent) : this.getCachedDirectory(parent);
        if (oldFileViewProvider != null && "FileContentUtilCore.saveOrReload".equals(event.getRequestor())) {
            this.myFileManager.forceReload(vFile);
            return;
        }
        if (parentDir == null) {
            boolean fire;
            boolean bl = fire = "name".equals(propertyName) && vFile.isDirectory();
            if (fire) {
                PsiDirectory psiDir = this.myFileManager.getCachedDirectory(vFile);
                boolean bl2 = fire = psiDir != null;
            }
            if (!fire && !"writable".equals(propertyName)) {
                this.handleVfsChangeWithoutPsi(vFile);
                return;
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeEvent.setParent((PsiElement)parentDir);
            switch (propertyName) {
                case "name": {
                    if (vFile.isDirectory()) {
                        PsiDirectory psiDir = this.myFileManager.getCachedDirectory(vFile);
                        if (psiDir != null) {
                            if (this.myFileTypeManager.isFileIgnored(vFile)) {
                                this.myFileManager.removeFilesAndDirsRecursively(vFile);
                                treeEvent.setChild((PsiElement)psiDir);
                                this.myManager.childRemoved(treeEvent);
                                break;
                            }
                            treeEvent.setElement((PsiElement)psiDir);
                            treeEvent.setPropertyName("directoryName");
                            treeEvent.setOldValue(event.getOldValue());
                            treeEvent.setNewValue(event.getNewValue());
                            this.myManager.propertyChanged(treeEvent);
                            break;
                        }
                        PsiDirectory psiDir1 = this.myFileManager.findDirectory(vFile);
                        if (psiDir1 == null) break;
                        treeEvent.setChild((PsiElement)psiDir1);
                        this.myManager.childAdded(treeEvent);
                        break;
                    }
                    FileViewProvider fileViewProvider = this.myFileManager.createFileViewProvider(vFile, true);
                    PsiFile newPsiFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
                    if (oldPsiFile != null) {
                        if (newPsiFile == null) {
                            this.clearViewProvider(vFile, "PSI renamed");
                            treeEvent.setChild((PsiElement)oldPsiFile);
                            this.myManager.childRemoved(treeEvent);
                            break;
                        }
                        if (!FileManagerImpl.areViewProvidersEquivalent(fileViewProvider, oldFileViewProvider)) {
                            this.myFileManager.setViewProvider(vFile, fileViewProvider);
                            treeEvent.setOldChild((PsiElement)oldPsiFile);
                            treeEvent.setNewChild((PsiElement)newPsiFile);
                            this.myManager.childReplaced(treeEvent);
                            break;
                        }
                        FileManagerImpl.clearPsiCaches(oldFileViewProvider);
                        treeEvent.setElement((PsiElement)oldPsiFile);
                        treeEvent.setPropertyName("fileName");
                        treeEvent.setOldValue(event.getOldValue());
                        treeEvent.setNewValue(event.getNewValue());
                        this.myManager.propertyChanged(treeEvent);
                        break;
                    }
                    if (newPsiFile == null) break;
                    this.myFileManager.setViewProvider(vFile, fileViewProvider);
                    if (parentDir == null) break;
                    treeEvent.setChild((PsiElement)newPsiFile);
                    this.myManager.childAdded(treeEvent);
                    break;
                }
                case "writable": {
                    if (oldPsiFile == null) {
                        return;
                    }
                    treeEvent.setElement((PsiElement)oldPsiFile);
                    treeEvent.setPropertyName("writable");
                    treeEvent.setOldValue(event.getOldValue());
                    treeEvent.setNewValue(event.getNewValue());
                    this.myManager.propertyChanged(treeEvent);
                    break;
                }
                case "encoding": {
                    if (oldPsiFile == null) {
                        return;
                    }
                    treeEvent.setElement((PsiElement)oldPsiFile);
                    treeEvent.setPropertyName("encoding");
                    treeEvent.setOldValue(event.getOldValue());
                    treeEvent.setNewValue(event.getNewValue());
                    this.myManager.propertyChanged(treeEvent);
                }
            }
        });
    }

    private void beforeFileMovement(@NotNull VFileMoveEvent event) {
        if (event == null) {
            PsiVFSListener.$$$reportNull$$$0(7);
        }
        VirtualFile vFile = event.getFile();
        PsiDirectory oldParentDir = this.myFileManager.findDirectory(event.getOldParent());
        PsiDirectory newParentDir = this.myFileManager.findDirectory(event.getNewParent());
        if (oldParentDir == null && newParentDir == null) {
            return;
        }
        if (this.myFileTypeManager.isFileIgnored(vFile)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            boolean isExcluded;
            PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
            boolean bl = isExcluded = vFile.isDirectory() && Registry.is((String)"ide.hide.excluded.files") && this.myProjectRootManager.getFileIndex().isExcluded(vFile);
            if (oldParentDir != null && !isExcluded) {
                PsiDirectory eventChild = vFile.isDirectory() ? this.myFileManager.findDirectory(vFile) : this.myFileManager.findFile(vFile);
                treeEvent.setChild((PsiElement)eventChild);
                if (newParentDir != null) {
                    treeEvent.setOldParent((PsiElement)oldParentDir);
                    treeEvent.setNewParent((PsiElement)newParentDir);
                    this.myManager.beforeChildMovement(treeEvent);
                } else {
                    treeEvent.setParent((PsiElement)oldParentDir);
                    this.myManager.beforeChildRemoval(treeEvent);
                }
            } else {
                LOG.assertTrue(newParentDir != null);
                treeEvent.setParent((PsiElement)newParentDir);
                this.myManager.beforeChildAddition(treeEvent);
            }
        });
    }

    private void filesMoved(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(8);
        }
        ArrayList<PsiDirectory> oldElements = new ArrayList<PsiDirectory>(events.size());
        ArrayList<PsiDirectory> oldParentDirs = new ArrayList<PsiDirectory>(events.size());
        ArrayList<PsiDirectory> newParentDirs = new ArrayList<PsiDirectory>(events.size());
        for (VFileEvent vFileEvent : events) {
            VFileMoveEvent event = (VFileMoveEvent)vFileEvent;
            VirtualFile vFile = event.getFile();
            PsiDirectory oldParentDir = this.myFileManager.findDirectory(event.getOldParent());
            PsiDirectory newParentDir = this.myFileManager.findDirectory(event.getNewParent());
            PsiDirectory oldElement = vFile.isDirectory() ? this.myFileManager.getCachedDirectory(vFile) : this.myFileManager.getCachedPsiFileInner(vFile);
            oldElements.add(oldElement);
            oldParentDirs.add(oldParentDir);
            newParentDirs.add(newParentDir);
        }
        this.myFileManager.removeInvalidFilesAndDirs(true);
        for (int i = 0; i < events.size(); ++i) {
            FileViewProvider newViewProvider;
            PsiDirectory newElement;
            VFileMoveEvent vFileMoveEvent = (VFileMoveEvent)events.get(i);
            VirtualFile vFile = vFileMoveEvent.getFile();
            PsiDirectory oldParentDir = (PsiDirectory)oldParentDirs.get(i);
            PsiDirectory newParentDir = (PsiDirectory)newParentDirs.get(i);
            if (oldParentDir == null && newParentDir == null) continue;
            PsiElement oldElement = (PsiElement)oldElements.get(i);
            if (vFile.isDirectory()) {
                newElement = this.myFileManager.findDirectory(vFile);
                newViewProvider = null;
            } else {
                newViewProvider = this.myFileManager.createFileViewProvider(vFile, true);
                newElement = newViewProvider.getPsi(this.myFileManager.findViewProvider(vFile).getBaseLanguage());
            }
            if (oldElement == null && newElement == null) continue;
            ApplicationManager.getApplication().runWriteAction(() -> this.lambda$filesMoved$8(oldElement, vFile, newViewProvider, newParentDir, (PsiElement)newElement, oldParentDir));
        }
    }

    @Nullable
    private PsiFile createFileCopyWithNewName(VirtualFile vFile, String name) {
        FileTypeManager instance = FileTypeManager.getInstance();
        if (instance.isFileIgnored(name)) {
            return null;
        }
        FileType fileTypeByFileName = instance.getFileTypeByFileName(name);
        Document document = FileDocumentManager.getInstance().getDocument(vFile);
        return PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText(name, fileTypeByFileName, document != null ? document.getCharsSequence() : "", vFile.getModificationStamp(), true, false);
    }

    private void handleVfsChangeWithoutPsi(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            PsiVFSListener.$$$reportNull$$$0(9);
        }
        if (!this.myReportedUnloadedPsiChange && this.isInRootModel(vFile)) {
            this.myFileManager.firePropertyChangedForUnloadedPsi();
            this.myReportedUnloadedPsiChange = true;
        }
    }

    private boolean isInRootModel(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PsiVFSListener.$$$reportNull$$$0(10);
        }
        if (ProjectKt.getStateStore(this.myProject).isProjectFile(file2)) {
            return false;
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        return index.isInContent(file2) || index.isInLibraryClasses(file2) || index.isInLibrarySource(file2);
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(11);
        }
        this.myReportedUnloadedPsiChange = false;
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileDeleteEvent) {
                this.beforeFileDeletion((VFileDeleteEvent)vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                this.beforePropertyChange((VFilePropertyChangeEvent)vFileEvent);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) continue;
            this.beforeFileMovement((VFileMoveEvent)vFileEvent);
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(12);
        }
        this.groupAndFire(events);
        this.myReportedUnloadedPsiChange = false;
    }

    private void groupAndFire(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PsiVFSListener.$$$reportNull$$$0(13);
        }
        StreamEx.of(events).groupRuns((event1, event2) -> event1 instanceof VFileDeleteEvent && event2 instanceof VFileDeleteEvent || event1 instanceof VFileMoveEvent && event2 instanceof VFileMoveEvent).forEach(this::fireForGrouped);
    }

    private void fireForGrouped(@NotNull List<? extends VFileEvent> subList) {
        VFileEvent event;
        if (subList == null) {
            PsiVFSListener.$$$reportNull$$$0(14);
        }
        if ((event = subList.get(0)) instanceof VFileDeleteEvent) {
            this.filesDeleted(subList);
        } else if (event instanceof VFileMoveEvent) {
            this.filesMoved(subList);
        } else {
            assert (subList.size() == 1);
            if (event instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)event;
                VirtualFile copy = ce.getNewParent().findChild(ce.getNewChildName());
                if (copy != null) {
                    this.fileCreated(copy);
                }
            } else if (event instanceof VFileCreateEvent) {
                VirtualFile file2 = event.getFile();
                if (file2 != null) {
                    this.fileCreated(file2);
                }
            } else if (event instanceof VFilePropertyChangeEvent) {
                this.propertyChanged((VFilePropertyChangeEvent)event);
            }
        }
    }

    private /* synthetic */ void lambda$filesMoved$8(PsiElement oldElement, VirtualFile vFile, FileViewProvider newViewProvider, PsiDirectory newParentDir, PsiElement newElement, PsiDirectory oldParentDir) {
        PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
        if (oldElement == null) {
            this.myFileManager.setViewProvider(vFile, newViewProvider);
            treeEvent.setParent((PsiElement)newParentDir);
            treeEvent.setChild(newElement);
            this.myManager.childAdded(treeEvent);
        } else if (newElement == null) {
            this.clearViewProvider(vFile, "PSI moved");
            treeEvent.setParent((PsiElement)oldParentDir);
            treeEvent.setChild(oldElement);
            this.myManager.childRemoved(treeEvent);
        } else if (newElement instanceof PsiDirectory || FileManagerImpl.areViewProvidersEquivalent(newViewProvider, ((PsiFile)oldElement).getViewProvider())) {
            treeEvent.setOldParent((PsiElement)oldParentDir);
            treeEvent.setNewParent((PsiElement)newParentDir);
            treeEvent.setChild(oldElement);
            this.myManager.childMoved(treeEvent);
        } else {
            this.myFileManager.setViewProvider(vFile, newViewProvider);
            PsiTreeChangeEventImpl treeRemoveEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeRemoveEvent.setParent((PsiElement)oldParentDir);
            treeRemoveEvent.setChild(oldElement);
            this.myManager.childRemoved(treeRemoveEvent);
            PsiTreeChangeEventImpl treeAddEvent = new PsiTreeChangeEventImpl(this.myManager);
            treeAddEvent.setParent((PsiElement)newParentDir);
            treeAddEvent.setChild(newElement);
            this.myManager.childAdded(treeAddEvent);
        }
    }

    private /* synthetic */ void lambda$filesDeleted$3(PsiDirectory parentDir, PsiElement element) {
        PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(this.myManager);
        treeEvent.setParent((PsiElement)parentDir);
        treeEvent.setChild(element);
        this.myManager.childRemoved(treeEvent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "why";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subList";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileDeletion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "filesDeleted";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearViewProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "beforePropertyChange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileMovement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "filesMoved";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "handleVfsChangeWithoutPsi";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isInRootModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "groupAndFire";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "fireForGrouped";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyFileDocumentManagerAdapter
    implements FileDocumentManagerListener {
        private MyFileDocumentManagerAdapter() {
        }

        public void fileWithNoDocumentChanged(@NotNull VirtualFile file2) {
            FileViewProvider viewProvider;
            if (file2 == null) {
                MyFileDocumentManagerAdapter.$$$reportNull$$$0(0);
            }
            if ((viewProvider = PsiVFSListener.this.myFileManager.findCachedViewProvider(file2)) != null) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (FileDocumentManagerImpl.recomputeFileTypeIfNecessary(file2)) {
                        PsiVFSListener.this.myFileManager.forceReload(file2);
                    } else {
                        PsiVFSListener.this.myFileManager.reloadPsiAfterTextChange(viewProvider, file2);
                    }
                });
            } else {
                PsiVFSListener.this.handleVfsChangeWithoutPsi(file2);
            }
        }

        public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
            if (file2 == null) {
                MyFileDocumentManagerAdapter.$$$reportNull$$$0(1);
            }
            if (document == null) {
                MyFileDocumentManagerAdapter.$$$reportNull$$$0(2);
            }
            FileViewProvider psiFile = PsiVFSListener.this.myFileManager.findCachedViewProvider(file2);
            if (!file2.isValid() || psiFile == null || !FileUtilRt.isTooLarge((long)file2.getLength()) || psiFile instanceof PsiLargeFile) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> PsiVFSListener.this.myFileManager.reloadPsiAfterTextChange(psiFile, file2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener$MyFileDocumentManagerAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileWithNoDocumentChanged";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileContentReloaded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyModuleRootListener
    implements ModuleRootListener {
        private VirtualFile[] myOldContentRoots;
        private int depthCounter;

        private MyModuleRootListener() {
        }

        public void beforeRootsChange(@NotNull ModuleRootEvent event) {
            if (event == null) {
                MyModuleRootListener.$$$reportNull$$$0(0);
            }
            if (event.isCausedByFileTypesChange()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                ++this.depthCounter;
                if (this.depthCounter > 1) {
                    return;
                }
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                treeEvent.setPropertyName("roots");
                VirtualFile[] contentRoots = PsiVFSListener.this.myProjectRootManager.getContentRoots();
                LOG.assertTrue(this.myOldContentRoots == null);
                this.myOldContentRoots = contentRoots;
                treeEvent.setOldValue(contentRoots);
                PsiVFSListener.this.myManager.beforePropertyChange(treeEvent);
            });
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            if (event == null) {
                MyModuleRootListener.$$$reportNull$$$0(1);
            }
            PsiVFSListener.this.myFileManager.dispatchPendingEvents();
            if (event.isCausedByFileTypesChange()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                --this.depthCounter;
                assert (this.depthCounter >= 0) : this.depthCounter;
                if (this.depthCounter > 0) {
                    return;
                }
                DebugUtil.performPsiModification(null, () -> PsiVFSListener.this.myFileManager.possiblyInvalidatePhysicalPsi());
                PsiTreeChangeEventImpl treeEvent = new PsiTreeChangeEventImpl(PsiVFSListener.this.myManager);
                treeEvent.setPropertyName("roots");
                VirtualFile[] contentRoots = PsiVFSListener.this.myProjectRootManager.getContentRoots();
                treeEvent.setNewValue(contentRoots);
                LOG.assertTrue(this.myOldContentRoots != null);
                treeEvent.setOldValue(this.myOldContentRoots);
                this.myOldContentRoots = null;
                PsiVFSListener.this.myManager.propertyChanged(treeEvent);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/psi/impl/file/impl/PsiVFSListener$MyModuleRootListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeRootsChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rootsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

