from _typeshed import Incomplete
from typing import Any

from ...connectors.pyodbc import PyODBCConnector
from ...sql.sqltypes import DateTime, Float, Numeric
from .base import BINARY, DATETIMEOFFSET, VARBINARY, MSDialect, MSExecutionContext

class _ms_numeric_pyodbc:
    def bind_processor(self, dialect): ...

class _MSNumeric_pyodbc(_ms_numeric_pyodbc, Numeric): ...
class _MSFloat_pyodbc(_ms_numeric_pyodbc, Float): ...

class _ms_binary_pyodbc:
    def bind_processor(self, dialect): ...

class _ODBCDateTimeBindProcessor:
    has_tz: bool
    def bind_processor(self, dialect): ...

class _ODBCDateTime(_ODBCDateTimeBindProcessor, DateTime): ...

class _ODBCDATETIMEOFFSET(_ODBCDateTimeBindProcessor, DATETIMEOFFSET):
    has_tz: bool

class _VARBINARY_pyodbc(_ms_binary_pyodbc, VARBINARY): ...
class _BINARY_pyodbc(_ms_binary_pyodbc, BINARY): ...

class MSExecutionContext_pyodbc(MSExecutionContext):
    def pre_exec(self) -> None: ...
    def post_exec(self) -> None: ...

class MSDialect_pyodbc(PyODBCConnector, MSDialect):
    supports_statement_cache: bool
    supports_sane_rowcount_returning: bool
    colspecs: Any
    description_encoding: Any
    use_scope_identity: Any
    fast_executemany: Any
    def __init__(self, description_encoding: Incomplete | None = None, fast_executemany: bool = False, **params) -> None: ...
    def on_connect(self): ...
    def do_executemany(self, cursor, statement, parameters, context: Incomplete | None = None) -> None: ...
    def is_disconnect(self, e, connection, cursor): ...

dialect = MSDialect_pyodbc
