from _typeshed import Incomplete
from typing import Any, Protocol

requirements: Incomplete | None
db: Incomplete | None
db_url: Incomplete | None
db_opts: Incomplete | None
file_config: Incomplete | None
test_schema: str | None
test_schema_2: str | None
any_async: bool
ident: str

def combinations(*comb, **kw): ...
def combinations_list(arg_iterable, **kw): ...
def variation(argname, cases): ...
def fixture(*arg, **kw): ...
def get_current_test_name(): ...
def mark_base_test_class(): ...

# Matches the intersection of the config module and the Config class
class _ConfigProtocol(Protocol):  # noqa: Y046
    db: Incomplete
    db_opts: Incomplete
    file_config: Incomplete
    test_schema: Any  # AnyOf[str, None]
    test_schema_2: Any  # AnyOf[str, None]
    def skip_test(self, msg) -> None: ...

class Config:
    db: Incomplete
    db_opts: Incomplete
    options: Incomplete
    file_config: Incomplete
    test_schema: str
    test_schema_2: str
    is_async: Incomplete
    def __init__(self, db, db_opts, options, file_config) -> None: ...
    @classmethod
    def register(cls, db, db_opts, options, file_config) -> Config: ...
    @classmethod
    def set_as_current(cls, config, namespace) -> None: ...
    @classmethod
    def push_engine(cls, db, namespace) -> None: ...
    @classmethod
    def push(cls, config, namespace) -> None: ...
    @classmethod
    def pop(cls, namespace) -> None: ...
    @classmethod
    def reset(cls, namespace) -> None: ...
    @classmethod
    def all_configs(cls): ...
    @classmethod
    def all_dbs(cls) -> None: ...
    def skip_test(self, msg) -> None: ...

def skip_test(msg) -> None: ...
def async_test(fn): ...
