/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.ExtensibleDrawable;
import net.sf.sdedit.drawable.Strokes;

public class Line
extends ExtensibleDrawable {
    private boolean mainLine;

    public Line(int width, Lifeline lifeline) {
        super(width, lifeline);
    }

    public void setMainLine(boolean mainLine) {
        this.mainLine = mainLine;
    }

    public boolean isMainLine() {
        return this.mainLine;
    }

    @Override
    protected void drawObject(Graphics2D g2d) {
        if (this.mainLine) {
            int top = this.getTop();
            int bottom = this.getBottom();
            g2d.setColor(Color.BLACK);
            g2d.setStroke(Strokes.getStroke(Strokes.StrokeType.DOTTED, this.getLifeline().getDiagram().lifelineThickness));
            g2d.drawLine(this.getLeft(), top, this.getLeft(), bottom);
        }
    }

    @Override
    public boolean contains(Point point) {
        int x = point.x;
        int y = point.y;
        return x >= this.getLeft() - 5 && x <= this.getRight() + 5 && y >= this.getTop() && y <= this.getBottom();
    }
}

