/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.Scroll;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.journal.Document;
import com.shatteredpixel.shatteredpixeldungeon.journal.Notes;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.QuickRecipe;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.ScrollPane;
import com.shatteredpixel.shatteredpixeldungeon.ui.ScrollingListPane;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndDocument;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndStory;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTabbed;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTitledMessage;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Image;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.Reflection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class WndJournal
extends WndTabbed {
    public static final int WIDTH_P = 126;
    public static final int HEIGHT_P = 180;
    public static final int WIDTH_L = 200;
    public static final int HEIGHT_L = 130;
    private static final int ITEM_HEIGHT = 18;
    private GuideTab guideTab;
    private AlchemyTab alchemyTab;
    private NotesTab notesTab;
    private CatalogTab catalogTab;
    private LoreTab loreTab;
    public static int last_index = 0;

    public WndJournal() {
        WndTabbed.Tab[] tabs;
        int width = PixelScene.landscape() ? 200 : 126;
        int height = PixelScene.landscape() ? 130 : 180;
        this.resize(width, height);
        this.guideTab = new GuideTab();
        this.add(this.guideTab);
        this.guideTab.setRect(0.0f, 0.0f, width, height);
        this.guideTab.updateList();
        this.alchemyTab = new AlchemyTab();
        this.add(this.alchemyTab);
        this.alchemyTab.setRect(0.0f, 0.0f, width, height);
        this.notesTab = new NotesTab();
        this.add(this.notesTab);
        this.notesTab.setRect(0.0f, 0.0f, width, height);
        this.notesTab.updateList();
        this.catalogTab = new CatalogTab();
        this.add(this.catalogTab);
        this.catalogTab.setRect(0.0f, 0.0f, width, height);
        this.catalogTab.updateList();
        this.loreTab = new LoreTab();
        this.add(this.loreTab);
        this.loreTab.setRect(0.0f, 0.0f, width, height);
        this.loreTab.updateList();
        for (WndTabbed.Tab tab : tabs = new WndTabbed.Tab[]{new WndTabbed.IconTab((Image)new ItemSprite(ItemSpriteSheet.MASTERY, null)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndJournal)WndJournal.this).guideTab.active = ((WndJournal)WndJournal.this).guideTab.visible = value;
                if (value) {
                    last_index = 0;
                }
            }
        }, new WndTabbed.IconTab((Image)new ItemSprite(ItemSpriteSheet.ALCH_PAGE, null)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndJournal)WndJournal.this).alchemyTab.active = ((WndJournal)WndJournal.this).alchemyTab.visible = value;
                if (value) {
                    last_index = 1;
                }
            }
        }, new WndTabbed.IconTab(Icons.get(Icons.STAIRS)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndJournal)WndJournal.this).notesTab.active = ((WndJournal)WndJournal.this).notesTab.visible = value;
                if (value) {
                    last_index = 2;
                }
            }
        }, new WndTabbed.IconTab((Image)new ItemSprite(ItemSpriteSheet.WEAPON_HOLDER, null)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndJournal)WndJournal.this).catalogTab.active = ((WndJournal)WndJournal.this).catalogTab.visible = value;
                if (value) {
                    last_index = 3;
                }
            }
        }, new WndTabbed.IconTab((Image)new ItemSprite(ItemSpriteSheet.GUIDE_PAGE, null)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndJournal)WndJournal.this).loreTab.active = ((WndJournal)WndJournal.this).loreTab.visible = value;
                if (value) {
                    last_index = 4;
                }
            }
        }}) {
            this.add(tab);
        }
        this.layoutTabs();
        this.select(last_index);
    }

    @Override
    public void offset(int xOffset, int yOffset) {
        super.offset(xOffset, yOffset);
        this.guideTab.layout();
        this.alchemyTab.layout();
        this.notesTab.layout();
        this.catalogTab.layout();
        this.loreTab.layout();
    }

    public static class LoreTab
    extends Component {
        private ScrollingListPane list;

        @Override
        protected void createChildren() {
            this.list = new ScrollingListPane();
            this.add(this.list);
        }

        @Override
        protected void layout() {
            super.layout();
            this.list.setRect(0.0f, 0.0f, this.width, this.height);
        }

        private void updateList() {
            this.list.addTitle(Messages.get(this, "title", new Object[0]));
            for (final Document doc : Document.values()) {
                if (!doc.isLoreDoc()) continue;
                final boolean found = doc.anyPagesFound();
                ScrollingListPane.ListItem item = new ScrollingListPane.ListItem(doc.pageSprite(), null, found ? Messages.titleCase(doc.title()) : "???"){

                    @Override
                    public boolean onClick(float x, float y) {
                        if (this.inside(x, y) && found) {
                            ShatteredPixelDungeon.scene().addToFront(new WndDocument(doc));
                            return true;
                        }
                        return false;
                    }
                };
                if (!found) {
                    item.hardlight(0x999999);
                    item.hardlightIcon(0x999999);
                }
                this.list.addItem(item);
            }
            this.list.setRect(this.x, this.y, this.width, this.height);
        }
    }

    private static class CatalogTab
    extends Component {
        private RedButton[] itemButtons;
        private static final int NUM_BUTTONS = 7;
        private static int currentItemIdx = 0;
        private static final int WEAPON_IDX = 0;
        private static final int ARMOR_IDX = 1;
        private static final int WAND_IDX = 2;
        private static final int RING_IDX = 3;
        private static final int ARTIF_IDX = 4;
        private static final int POTION_IDX = 5;
        private static final int SCROLL_IDX = 6;
        private static final int[] spriteIndexes = new int[]{ItemSpriteSheet.WEAPON_HOLDER, ItemSpriteSheet.ARMOR_HOLDER, ItemSpriteSheet.WAND_HOLDER, ItemSpriteSheet.RING_HOLDER, ItemSpriteSheet.ARTIFACT_HOLDER, ItemSpriteSheet.POTION_HOLDER, ItemSpriteSheet.SCROLL_HOLDER};
        private ScrollingListPane list;

        private CatalogTab() {
        }

        @Override
        protected void createChildren() {
            this.itemButtons = new RedButton[7];
            for (int i = 0; i < 7; ++i) {
                final int idx = i;
                this.itemButtons[i] = new RedButton(""){

                    @Override
                    protected void onClick() {
                        currentItemIdx = idx;
                        this.updateList();
                    }
                };
                this.itemButtons[i].icon(new ItemSprite(spriteIndexes[i], null));
                this.add(this.itemButtons[i]);
            }
            this.list = new ScrollingListPane();
            this.add(this.list);
        }

        @Override
        protected void layout() {
            super.layout();
            int perRow = 7;
            float buttonWidth = this.width() / (float)perRow;
            for (int i = 0; i < 7; ++i) {
                this.itemButtons[i].setRect((float)(i % perRow) * buttonWidth, i / perRow * 18, buttonWidth, 18.0f);
                PixelScene.align(this.itemButtons[i]);
            }
            this.list.setRect(0.0f, this.itemButtons[6].bottom() + 1.0f, this.width, this.height - this.itemButtons[6].bottom() - 1.0f);
        }

        private void updateList() {
            ArrayList<Class<Item>> itemClasses;
            this.list.clear();
            for (int i = 0; i < 7; ++i) {
                if (i == currentItemIdx) {
                    this.itemButtons[i].icon().color(0xFFFF44);
                    continue;
                }
                this.itemButtons[i].icon().resetColor();
            }
            this.list.scrollTo(0.0f, 0.0f);
            final HashMap<Class<? extends Item>, Boolean> known = new HashMap<Class<? extends Item>, Boolean>();
            if (currentItemIdx == 0) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.WEAPONS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, true);
                }
            } else if (currentItemIdx == 1) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.ARMOR.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, true);
                }
            } else if (currentItemIdx == 2) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.WANDS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, true);
                }
            } else if (currentItemIdx == 3) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.RINGS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, Ring.getKnown().contains(clazz));
                }
            } else if (currentItemIdx == 4) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.ARTIFACTS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, true);
                }
            } else if (currentItemIdx == 5) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.POTIONS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, Potion.getKnown().contains(clazz));
                }
            } else if (currentItemIdx == 6) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.SCROLLS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, Scroll.getKnown().contains(clazz));
                }
            } else {
                itemClasses = new ArrayList();
            }
            Collections.sort(itemClasses, new Comparator<Class<? extends Item>>(){

                @Override
                public int compare(Class<? extends Item> a, Class<? extends Item> b) {
                    int result = 0;
                    if (((Boolean)known.get(a)).booleanValue() && Catalog.isSeen(a)) {
                        result -= 2;
                    }
                    if (((Boolean)known.get(b)).booleanValue() && Catalog.isSeen(b)) {
                        result += 2;
                    }
                    if (Catalog.isSeen(a)) {
                        --result;
                    }
                    if (Catalog.isSeen(b)) {
                        ++result;
                    }
                    return result;
                }
            });
            for (Class<? extends Item> clazz : itemClasses) {
                final Item item = Reflection.newInstance(clazz);
                boolean itemIDed = (Boolean)known.get(clazz);
                final boolean itemSeen = Catalog.isSeen(clazz);
                if (itemSeen && !itemIDed) {
                    if (item instanceof Ring) {
                        ((Ring)item).anonymize();
                    } else if (item instanceof Potion) {
                        ((Potion)item).anonymize();
                    } else if (item instanceof Scroll) {
                        ((Scroll)item).anonymize();
                    }
                }
                ScrollingListPane.ListItem listItem = new ScrollingListPane.ListItem(itemIDed && itemSeen ? new ItemSprite(item) : new ItemSprite(ItemSpriteSheet.SOMETHING + spriteIndexes[currentItemIdx]), null, itemSeen ? Messages.titleCase(item.trueName()) : "???"){

                    @Override
                    public boolean onClick(float x, float y) {
                        if (this.inside(x, y) && itemSeen) {
                            if (item instanceof ClassArmor) {
                                GameScene.show(new WndTitledMessage(new Image(this.icon), Messages.titleCase(item.trueName()), item.desc()));
                            } else {
                                GameScene.show(new WndTitledMessage(new Image(this.icon), Messages.titleCase(item.trueName()), item.info()));
                            }
                            return true;
                        }
                        return false;
                    }
                };
                if (!itemSeen) {
                    listItem.hardlight(0x999999);
                } else if (!itemIDed) {
                    listItem.hardlight(0xCCCCCC);
                }
                this.list.addItem(listItem);
            }
            this.list.setRect(this.x, this.itemButtons[6].bottom() + 1.0f, this.width, this.height - this.itemButtons[6].bottom() - 1.0f);
        }
    }

    private static class NotesTab
    extends Component {
        private ScrollingListPane list;

        private NotesTab() {
        }

        @Override
        protected void createChildren() {
            this.list = new ScrollingListPane();
            this.add(this.list);
        }

        @Override
        protected void layout() {
            super.layout();
            this.list.setRect(this.x, this.y, this.width, this.height);
        }

        private void updateList() {
            ArrayList<Notes.LandmarkRecord> landmarks;
            ArrayList<Notes.KeyRecord> keys = Notes.getRecords(Notes.KeyRecord.class);
            if (!keys.isEmpty()) {
                this.list.addTitle(Messages.get(this, "keys", new Object[0]));
                for (Notes.Record record : keys) {
                    ScrollingListPane.ListItem listItem = new ScrollingListPane.ListItem(Icons.get(Icons.STAIRS), Integer.toString(record.depth()), Messages.titleCase(record.desc()));
                    if (Dungeon.depth == record.depth()) {
                        listItem.hardlight(0xFFFF44);
                    }
                    this.list.addItem(listItem);
                }
            }
            if (!(landmarks = Notes.getRecords(Notes.LandmarkRecord.class)).isEmpty()) {
                this.list.addTitle(Messages.get(this, "landmarks", new Object[0]));
                for (Notes.Record record : landmarks) {
                    ScrollingListPane.ListItem item = new ScrollingListPane.ListItem(Icons.get(Icons.STAIRS), Integer.toString(record.depth()), Messages.titleCase(record.desc()));
                    if (Dungeon.depth == record.depth()) {
                        item.hardlight(0xFFFF44);
                    }
                    this.list.addItem(item);
                }
            }
            this.list.setRect(this.x, this.y, this.width, this.height);
        }
    }

    public static class AlchemyTab
    extends Component {
        private RedButton[] pageButtons;
        private static final int NUM_BUTTONS = 9;
        private static final int[] sprites = new int[]{ItemSpriteSheet.SEED_HOLDER, ItemSpriteSheet.STONE_HOLDER, ItemSpriteSheet.FOOD_HOLDER, ItemSpriteSheet.POTION_HOLDER, ItemSpriteSheet.SCROLL_HOLDER, ItemSpriteSheet.BOMB_HOLDER, ItemSpriteSheet.MISSILE_HOLDER, ItemSpriteSheet.ELIXIR_HOLDER, ItemSpriteSheet.SPELL_HOLDER};
        public static int currentPageIdx = 0;
        private IconTitle title;
        private RenderedTextBlock body;
        private ScrollPane list;
        private ArrayList<QuickRecipe> recipes = new ArrayList();

        @Override
        protected void createChildren() {
            this.pageButtons = new RedButton[9];
            for (int i = 0; i < 9; ++i) {
                final int idx = i;
                this.pageButtons[i] = new RedButton(""){

                    @Override
                    protected void onClick() {
                        currentPageIdx = idx;
                        this.updateList();
                    }
                };
                if (Document.ALCHEMY_GUIDE.isPageFound(i)) {
                    this.pageButtons[i].icon(new ItemSprite(sprites[i], null));
                } else {
                    this.pageButtons[i].icon(new ItemSprite(ItemSpriteSheet.SOMETHING, null));
                    this.pageButtons[i].enable(false);
                }
                this.add(this.pageButtons[i]);
            }
            this.title = new IconTitle();
            this.title.icon(new ItemSprite(ItemSpriteSheet.ALCH_PAGE));
            this.title.visible = false;
            this.body = PixelScene.renderTextBlock(6);
            this.list = new ScrollPane(new Component());
            this.add(this.list);
        }

        @Override
        protected void layout() {
            super.layout();
            if (PixelScene.landscape()) {
                float buttonWidth = this.width() / (float)this.pageButtons.length;
                for (int i = 0; i < 9; ++i) {
                    this.pageButtons[i].setRect((float)i * buttonWidth, 0.0f, buttonWidth, 18.0f);
                    PixelScene.align(this.pageButtons[i]);
                }
            } else {
                float buttonWidth = this.width() / 5.0f;
                float y = 0.0f;
                float x = 0.0f;
                for (int i = 0; i < 9; ++i) {
                    this.pageButtons[i].setRect(x, y, buttonWidth, 18.0f);
                    PixelScene.align(this.pageButtons[i]);
                    x += buttonWidth;
                    if (i != 4) continue;
                    y += 18.0f;
                    x = 0.0f;
                    buttonWidth = this.width() / 4.0f;
                }
            }
            this.list.setRect(0.0f, this.pageButtons[8].bottom() + 1.0f, this.width, this.height - this.pageButtons[8].bottom() - 1.0f);
            this.updateList();
        }

        private void updateList() {
            if (currentPageIdx != -1 && !Document.ALCHEMY_GUIDE.isPageFound(currentPageIdx)) {
                currentPageIdx = -1;
            }
            for (int i = 0; i < 9; ++i) {
                if (i == currentPageIdx) {
                    this.pageButtons[i].icon().color(0xFFFF44);
                    continue;
                }
                this.pageButtons[i].icon().resetColor();
            }
            if (currentPageIdx == -1) {
                return;
            }
            for (QuickRecipe r : this.recipes) {
                if (r == null) continue;
                r.killAndErase();
                r.destroy();
            }
            this.recipes.clear();
            Component content = this.list.content();
            content.clear();
            this.title.visible = true;
            this.title.label(Document.ALCHEMY_GUIDE.pageTitle(currentPageIdx));
            this.title.setRect(0.0f, 0.0f, this.width(), 10.0f);
            content.add(this.title);
            this.body.maxWidth((int)this.width());
            this.body.text(Document.ALCHEMY_GUIDE.pageBody(currentPageIdx));
            this.body.setPos(0.0f, this.title.bottom());
            content.add(this.body);
            Document.ALCHEMY_GUIDE.readPage(currentPageIdx);
            ArrayList<QuickRecipe> toAdd = QuickRecipe.getRecipes(currentPageIdx);
            float top = this.body.bottom() + 2.0f;
            ArrayList<QuickRecipe> toAddThisRow = new ArrayList<QuickRecipe>();
            while (!toAdd.isEmpty()) {
                float spacing;
                if (toAdd.get(0) == null) {
                    toAdd.remove(0);
                    top += 6.0f;
                }
                int w = 0;
                while (!toAdd.isEmpty() && toAdd.get(0) != null && (float)w + toAdd.get(0).width() <= this.width()) {
                    toAddThisRow.add(toAdd.remove(0));
                    w = (int)((float)w + ((QuickRecipe)toAddThisRow.get(0)).width());
                }
                float left = spacing = (this.width() - (float)w) / (float)(toAddThisRow.size() + 1);
                while (!toAddThisRow.isEmpty()) {
                    QuickRecipe r = (QuickRecipe)toAddThisRow.remove(0);
                    r.setPos(left, top);
                    left += r.width() + spacing;
                    if (!toAddThisRow.isEmpty()) {
                        ColorBlock spacer = new ColorBlock(1.0f, 16.0f, -14540254);
                        spacer.y = top;
                        spacer.x = left - spacing / 2.0f - 0.5f;
                        PixelScene.align(spacer);
                        content.add(spacer);
                    }
                    this.recipes.add(r);
                    content.add(r);
                }
                if (!toAdd.isEmpty() && toAdd.get(0) == null) {
                    toAdd.remove(0);
                }
                if (!toAdd.isEmpty() && toAdd.get(0) != null) {
                    ColorBlock spacer = new ColorBlock(this.width(), 1.0f, -14540254);
                    spacer.y = top + 16.0f;
                    spacer.x = 0.0f;
                    content.add(spacer);
                }
                top += 17.0f;
                toAddThisRow.clear();
            }
            content.setSize(this.width(), top -= 1.0f);
            this.list.setSize(this.list.width(), this.list.height());
            this.list.scrollTo(0.0f, 0.0f);
        }
    }

    public static class GuideTab
    extends Component {
        private ScrollingListPane list;

        @Override
        protected void createChildren() {
            this.list = new ScrollingListPane();
            this.add(this.list);
        }

        @Override
        protected void layout() {
            super.layout();
            this.list.setRect(0.0f, 0.0f, this.width, this.height);
        }

        private void updateList() {
            this.list.addTitle(Document.ADVENTURERS_GUIDE.title());
            for (final String page : Document.ADVENTURERS_GUIDE.pageNames()) {
                final boolean found = Document.ADVENTURERS_GUIDE.isPageFound(page);
                ScrollingListPane.ListItem item = new ScrollingListPane.ListItem(Document.ADVENTURERS_GUIDE.pageSprite(page), null, found ? Messages.titleCase(Document.ADVENTURERS_GUIDE.pageTitle(page)) : Messages.titleCase(Messages.get(this, "missing", new Object[0]))){

                    @Override
                    public boolean onClick(float x, float y) {
                        if (this.inside(x, y) && found) {
                            GameScene.show(new WndStory(Document.ADVENTURERS_GUIDE.pageSprite(page), Document.ADVENTURERS_GUIDE.pageTitle(page), Document.ADVENTURERS_GUIDE.pageBody(page)));
                            Document.ADVENTURERS_GUIDE.readPage(page);
                            return true;
                        }
                        return false;
                    }
                };
                if (!found) {
                    item.hardlight(0x999999);
                    item.hardlightIcon(0x999999);
                }
                this.list.addItem(item);
            }
            this.list.setRect(this.x, this.y, this.width, this.height);
        }
    }
}

