/*
 * Decompiled with CFR 0.152.
 */
package hughai.controllers.level2;

import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.EnemySelector2;
import hughai.EnemyTracker;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.TerrainPos;
import hughai.mapping.ThreatMap;
import hughai.packcoordinators.AttackPackCoordinator;
import hughai.packcoordinators.GuardPackCoordinator;
import hughai.packcoordinators.MoveToPackCoordinator;
import hughai.packcoordinators.PackCoordinatorSelector;
import hughai.packcoordinators.SpreadSearchPackCoordinatorWithSearchGrid;
import hughai.unitdata.BuildTable;
import hughai.unitdata.UnitController;
import hughai.utils.Config;
import hughai.utils.LogFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class TankController2 {
    public int MinTanksForAttack = 5;
    public int MinTanksForSpreadSearch = 50;
    HashSet<Unit> unitsToControl = new HashSet();
    UnitDef typicalunitdef;
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    PlayerObjects playerObjects;
    UnitController unitcontroller;
    EnemyTracker enemyTracker;
    EnemySelector2 enemyselector;
    BuildTable buildtable;
    AttackPackCoordinator attackpackcoordinator;
    GuardPackCoordinator guardpackcoordinator;
    SpreadSearchPackCoordinatorWithSearchGrid spreadsearchpackcoordinator;
    MoveToPackCoordinator movetopackcoordinator;
    PackCoordinatorSelector packcoordinatorselector;
    Config config;
    TerrainPos LastAttackPos = null;
    Random random = new Random();
    boolean Active = false;

    public TankController2(PlayerObjects playerObjects, UnitDef unitDef) {
        this.playerObjects = playerObjects;
        this.config = playerObjects.getConfig();
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.enemyTracker = playerObjects.getEnemyTracker();
        this.unitcontroller = playerObjects.getUnitController();
        this.typicalunitdef = unitDef;
        this.enemyselector = new EnemySelector2(playerObjects, unitDef.getSpeed() * 2.0f, unitDef);
        this.attackpackcoordinator = new AttackPackCoordinator(playerObjects);
        this.spreadsearchpackcoordinator = new SpreadSearchPackCoordinatorWithSearchGrid(playerObjects);
        this.movetopackcoordinator = new MoveToPackCoordinator(playerObjects);
        this.guardpackcoordinator = new GuardPackCoordinator(playerObjects);
        this.packcoordinatorselector = new PackCoordinatorSelector(playerObjects);
        this.packcoordinatorselector.LoadCoordinator(this.attackpackcoordinator);
        this.packcoordinatorselector.LoadCoordinator(this.spreadsearchpackcoordinator);
        this.packcoordinatorselector.LoadCoordinator(this.movetopackcoordinator);
        this.packcoordinatorselector.LoadCoordinator(this.guardpackcoordinator);
        this.logfile.WriteLine("*TankController Initialized*");
    }

    public void Activate() {
        if (!this.Active) {
            this.enemyTracker.registerListener(new EnemyTrackerHandler());
            this.csai.registerGameListener(new GameListenerHandler());
            if (this.csai.DebugOn) {
                this.csai.RegisterVoiceCommand("tankscount", new VoiceCommandCountTanks());
                this.csai.RegisterVoiceCommand("tanksmoveto", new VoiceCommandMoveTo());
                this.csai.RegisterVoiceCommand("dumptanks", new VoiceCommandDumpTanksHandler());
            }
            this.Active = true;
        }
    }

    public void Disactivate() {
        if (this.Active) {
            this.enemyTracker.unregisterGameListener(new EnemyTrackerHandler());
            this.csai.unregisterGameListener(new GameListenerHandler());
            this.csai.UnregisterVoiceCommand("tankscount");
            this.csai.UnregisterVoiceCommand("tanksmoveto");
            this.csai.UnregisterVoiceCommand("tanksattackpos");
            this.packcoordinatorselector.DisactivateAll();
            this.Active = false;
        }
    }

    public void AssignUnits(Collection<Unit> collection) {
        for (Unit unit : collection) {
            this.unitsToControl.add(unit);
            this.logfile.WriteLine("New tankcontroller unit: " + unit.getUnitId() + " " + unit.getDef().getHumanName());
            this.attackpackcoordinator.AssignUnits(collection);
            this.spreadsearchpackcoordinator.AssignUnits(collection);
            this.movetopackcoordinator.AssignUnits(collection);
            this.guardpackcoordinator.AssignUnits(collection);
        }
    }

    public void RevokeUnits(Collection<Unit> collection) {
        for (Unit unit : collection) {
            this.unitsToControl.remove(unit);
            this.attackpackcoordinator.RevokeUnits(collection);
            this.spreadsearchpackcoordinator.RevokeUnits(collection);
            this.movetopackcoordinator.RevokeUnits(collection);
            this.guardpackcoordinator.RevokeUnits(collection);
        }
    }

    public void AssignEnergy(int n) {
    }

    public void AssignMetal(int n) {
    }

    public void AssignPower(double d) {
    }

    public void AssignMetalStream(double d) {
    }

    TerrainPos getmedianfriendlypos() {
        TerrainPos terrainPos;
        int n = this.unitsToControl.size();
        if (n == 0) {
            return null;
        }
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        int n2 = 0;
        for (Unit unit : this.unitsToControl) {
            terrainPos = this.unitcontroller.getPos(unit);
            fArray[n2] = terrainPos.x;
            fArray2[n2] = terrainPos.z;
            ++n2;
        }
        float f = fArray[n / 2];
        float f2 = fArray2[n / 2];
        terrainPos = new TerrainPos(f, 0.0f, f2);
        terrainPos.y = this.playerObjects.getMaps().getHeightMap().getElevationAt(terrainPos);
        return terrainPos;
    }

    void DoSomething() {
        float f = 0.0f;
        for (Unit object2 : this.unitsToControl) {
            f += this.unitcontroller.getUnitDef(object2).getPower();
        }
        this.logfile.WriteLine("Tankcontroller: attack power available: " + f);
        TerrainPos terrainPos = this.getmedianfriendlypos();
        ThreatMap threatMap = this.playerObjects.getMaps().getThreatMap();
        Unit unit = null;
        TerrainPos terrainPos2 = null;
        float f2 = Float.POSITIVE_INFINITY;
        for (Unit unit2 : this.enemyTracker.getEnemyUnits()) {
            float f3;
            UnitDef unitDef;
            TerrainPos terrainPos3 = this.enemyTracker.getPos(unit2);
            if (terrainPos3 == null || !((unitDef = this.enemyTracker.getEnemyUnitDefByUnit().get(unit2)).getSpeed() < 2.0f * this.typicalunitdef.getSpeed()) || !(threatMap.getThreatAt(terrainPos3) * 3.0f < f) || !((f3 = terrainPos.GetSquaredDistance(terrainPos3)) < f2)) continue;
            f2 = f3;
            unit = unit2;
            terrainPos2 = terrainPos3;
        }
        if (unit != null) {
            this.logfile.WriteLine("tankcontroller found enemy, attacking: " + terrainPos2);
            this.attackpackcoordinator.SetTarget(terrainPos2);
            this.packcoordinatorselector.ActivatePackCoordinator(this.attackpackcoordinator);
            this.LastAttackPos = terrainPos2;
        } else if (this.unitsToControl.size() > this.MinTanksForSpreadSearch) {
            this.spreadsearchpackcoordinator.SetTarget(terrainPos);
            this.packcoordinatorselector.ActivatePackCoordinator(this.spreadsearchpackcoordinator);
        } else {
            List<Unit> list;
            String string = this.playerObjects.getBuildTree().listToOurTeamsUnitName(this.config.getCommanderunitnames());
            if (this.unitcontroller.UnitsByName.containsKey(string) && (list = this.unitcontroller.UnitsByName.get(string)).size() > 0) {
                this.guardpackcoordinator.SetTarget(list.get(0));
                this.packcoordinatorselector.ActivatePackCoordinator(this.guardpackcoordinator);
            }
        }
    }

    class EnemyTrackerHandler
    extends EnemyTracker.EnemyAdapter {
        EnemyTrackerHandler() {
        }

        @Override
        public void AcquiredEnemy(Unit unit) {
        }

        @Override
        public void EnemyDestroyed(Unit unit) {
        }
    }

    class UnitControllerHandler
    extends UnitController.UnitAdapter {
        UnitControllerHandler() {
        }
    }

    class GameListenerHandler
    extends GameAdapter {
        GameListenerHandler() {
        }

        @Override
        public void Tick(int n) {
            TankController2.this.DoSomething();
        }
    }

    class VoiceCommandMoveTo
    implements VoiceCommandHandler {
        VoiceCommandMoveTo() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            TerrainPos terrainPos = new TerrainPos();
            terrainPos.x = Float.parseFloat(stringArray[2]);
            terrainPos.z = Float.parseFloat(stringArray[3]);
            terrainPos.y = TankController2.this.playerObjects.getMaps().getHeightMap().getElevationAt(terrainPos);
            TankController2.this.movetopackcoordinator.SetTarget(terrainPos);
            TankController2.this.packcoordinatorselector.ActivatePackCoordinator(TankController2.this.movetopackcoordinator);
        }
    }

    class VoiceCommandCountTanks
    implements VoiceCommandHandler {
        VoiceCommandCountTanks() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            TankController2.this.csai.SendTextMsg("Number tanks: " + TankController2.this.unitsToControl.size());
            TankController2.this.logfile.WriteLine("Number tanks: " + TankController2.this.unitsToControl.size());
        }
    }

    class VoiceCommandDumpTanksHandler
    implements VoiceCommandHandler {
        VoiceCommandDumpTanksHandler() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            TankController2.this.logfile.WriteLine("Tankcontroller dump:");
            for (Unit unit : TankController2.this.unitsToControl) {
                TankController2.this.logfile.WriteLine(unit.getUnitId() + " " + unit.getDef().getHumanName());
            }
        }
    }
}

