"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const sinon_1 = __importDefault(require("sinon"));
const typescript_1 = __importDefault(require("typescript"));
const svelte_sys_1 = require("../../../src/plugins/typescript/svelte-sys");
describe('Svelte Sys', () => {
    afterEach(() => {
        sinon_1.default.restore();
    });
    function setupLoader() {
        const tsFile = 'const a = "ts file";';
        const svelteFile = 'const a = "svelte file";';
        const fileExistsStub = sinon_1.default.stub().returns(true);
        const getSnapshotStub = sinon_1.default.stub().callsFake((path) => ({
            getText: () => (path.endsWith('.svelte.ts') ? svelteFile : tsFile),
            getLength: () => path.endsWith('.svelte.ts') ? svelteFile.length : tsFile.length
        }));
        // sinon.replace(ts.sys, 'fileExists', fileExistsStub);
        const loader = (0, svelte_sys_1.createSvelteSys)(getSnapshotStub, {
            ...typescript_1.default.sys,
            fileExists: fileExistsStub
        });
        return {
            tsFile,
            svelteFile,
            fileExistsStub,
            getSnapshotStub,
            loader
        };
    }
    describe('#fileExists', () => {
        it('should leave files with no .svelte.ts-ending as is', async () => {
            const { loader, fileExistsStub } = setupLoader();
            loader.fileExists('../file.ts');
            assert.strictEqual(fileExistsStub.getCall(0).args[0], '../file.ts');
        });
        it('should convert .svelte.ts-endings', async () => {
            const { loader, fileExistsStub } = setupLoader();
            loader.fileExists('../file.svelte.ts');
            assert.strictEqual(fileExistsStub.getCall(0).args[0], '../file.svelte');
        });
    });
    describe('#readFile', () => {
        it('should invoke getSnapshot for ts/js files', async () => {
            const { loader, getSnapshotStub, tsFile } = setupLoader();
            const code = loader.readFile('../file.ts');
            assert.strictEqual(getSnapshotStub.called, true);
            assert.strictEqual(code, tsFile);
        });
        it('should invoke getSnapshot for svelte files', async () => {
            const { loader, getSnapshotStub, svelteFile } = setupLoader();
            const code = loader.readFile('../file.svelte.ts');
            assert.strictEqual(getSnapshotStub.called, true);
            assert.strictEqual(code, svelteFile);
        });
    });
});
//# sourceMappingURL=svelte-sys.test.js.map