/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.evolution.alignment.Alignment;
import beast.util.NexusParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AlignmentViewer
extends JPanel {
    private static final long serialVersionUID = 1L;
    Object[][] tableData;
    Object[] columnData;
    boolean useColor = false;
    boolean useDots = true;
    Alignment m_alignment;
    Map<Character, Color> m_customColorMap = new HashMap<Character, Color>();

    public void setCustomColorMap(Map<Character, Color> map) {
        for (char c : this.m_customColorMap.keySet()) {
            this.m_customColorMap.put(Character.valueOf(c), map.get(Character.valueOf(c)));
        }
    }

    public AlignmentViewer(Alignment alignment) {
        Object object;
        int n;
        this.m_alignment = alignment;
        int n2 = alignment.getSiteCount();
        int n3 = alignment.getTaxonCount();
        this.tableData = new Object[n3][n2 + 1];
        char[] cArray = this.updateTableData();
        for (n = 0; n < n3; ++n) {
            this.tableData[n][0] = alignment.getTaxaNames().get(n);
        }
        this.columnData = new Object[n2 + 1];
        for (n = 1; n < n2 + 1; ++n) {
            this.columnData[n] = "<html>.<br>" + cArray[n - 1] + "</html>";
        }
        this.columnData[0] = "<html><br>taxon name</html>";
        this.columnData[1] = "<html>1<br>" + cArray[0] + "</html>";
        for (n = 10; n < n2; n += 10) {
            object = n + "";
            for (int i = 0; i < ((String)object).length(); ++i) {
                if (n + i >= this.columnData.length) continue;
                this.columnData[n + i] = "<html>" + ((String)object).charAt(i) + "<br>" + cArray[n - 1] + "</html>";
            }
            this.columnData[n - 5] = "<html>+<br>" + cArray[n - 1] + "</html>";
        }
        AbstractTableModel abstractTableModel = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public String getColumnName(int n) {
                return AlignmentViewer.this.columnData[n] + "";
            }

            @Override
            public int getRowCount() {
                return AlignmentViewer.this.tableData.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return AlignmentViewer.this.tableData[n][n2];
            }
        };
        object = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getColumnCount() {
                return AlignmentViewer.this.columnData.length - 1;
            }

            @Override
            public String getColumnName(int n) {
                return AlignmentViewer.this.columnData[n + 1] + "";
            }

            @Override
            public int getRowCount() {
                return AlignmentViewer.this.tableData.length;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return AlignmentViewer.this.tableData[n][n2 + 1];
            }
        };
        JTable jTable = new JTable(abstractTableModel);
        jTable.setAutoResizeMode(0);
        Font font = jTable.getFont();
        font = new Font(font.getFontName(), font.getStyle(), font.getSize() * 2 / 3);
        jTable.setFont(font);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(200);
        jTable.getTableHeader().setFont(font);
        JTable jTable2 = new JTable((TableModel)object);
        jTable2.setAutoResizeMode(0);
        jTable2.setFont(font);
        jTable2.getTableHeader().setFont(font);
        for (int i = 0; i < n2; ++i) {
            tableColumn = jTable2.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(6);
        }
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        jTable2.setSelectionModel(listSelectionModel);
        jTable2.setShowGrid(false);
        JScrollPane jScrollPane = new JScrollPane(jTable2);
        Dimension dimension = jTable.getPreferredSize();
        JViewport jViewport = new JViewport();
        jViewport.setView(jTable);
        jViewport.setPreferredSize(dimension);
        jViewport.setMaximumSize(dimension);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jTable.getTableHeader());
        jScrollPane.setRowHeaderView(jViewport);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    /*
     * Unable to fully structure code
     */
    private char[] updateTableData() {
        var1_1 = this.m_alignment.getSiteCount();
        var2_2 = this.m_alignment.getTaxonCount();
        var3_3 = this.m_alignment.getDataType();
        var4_4 = new char[var1_1];
        var5_5 = this.setupColorMap();
        var6_6 = this.setupIntegerColorMap();
lbl7:
        // 3 sources

        try {
            for (var7_7 = 0; var7_7 < var1_1; ++var7_7) {
                block8: {
                    var8_9 = this.m_alignment.getPatternIndex(var7_7);
                    var9_10 = this.m_alignment.getPattern(var8_9);
                    var10_11 = var3_3.state2string(var9_10);
                    if (!var10_11.contains(",")) break block8;
                    var11_12 = var10_11.split(",");
                    var4_4[var7_7] = this.mostFrequentCharInPattern(var11_12);
                    for (var12_14 = 0; var12_14 < var2_2; ++var12_14) {
                        try {
                            var13_15 = Integer.valueOf(var11_12[var12_14]);
                            if (var13_15 + 48 == var4_4[var7_7]) {
                                var13_15 = Math.min(Math.max(var13_15, 0), var6_6[0].length - 1);
                                this.tableData[var12_14][var7_7 + 1] = var6_6[0][var13_15];
                                continue;
                            }
                            var13_15 = Math.min(Math.max(var13_15, 0), var6_6[0].length - 1);
                            this.tableData[var12_14][var7_7 + 1] = var6_6[1][var13_15];
                            continue;
                        }
                        catch (NumberFormatException var13_16) {
                            this.tableData[var12_14][var7_7 + 1] = this.useColor != false ? Character.valueOf(' ') : var11_12[var12_14];
                        }
                    }
                    ** GOTO lbl7
                }
                var4_4[var7_7] = this.mostFrequentCharInPattern(var10_11);
                for (var11_13 = 0; var11_13 < var2_2; ++var11_13) {
                    var12_14 = var10_11.charAt(var11_13);
                    this.tableData[var11_13][var7_7 + 1] = var12_14 == var4_4[var7_7] ? var5_5[0][var12_14] : var5_5[1][var12_14];
                }
                ** GOTO lbl7
            }
        }
        catch (Exception var7_8) {
            // empty catch block
        }
        return var4_4;
    }

    private Object[][] setupColorMap() {
        if (this.useColor) {
            char c;
            Object[][] objectArray = new String[2][256];
            for (int i = 65; i < 90; ++i) {
                c = i - 65;
                int n = ((c & 0x80) >> 7) + ((c & 0x10) >> 4) + ((c & 2) << 1);
                int n2 = ((c & 0x40) >> 6) + ((c & 8) >> 2) + (c & 4);
                int n3 = ((c & 0x20) >> 5) + ((c & 4) >> 1) + ((c & '\u0001') << 2);
                int n4 = (n << 21 + (n2 << 18)) + (n2 << 13) + (n3 << 10) + (n3 << 5) + (n << 2);
                objectArray[0][i] = "<html><font color='#" + Integer.toString(n4, 16) + "'><b>.</b></html>";
                objectArray[1][i] = "<html><font color='#" + Integer.toString(n4, 16) + "'><b>" + (char)i + "</font></html>";
            }
            Iterator<Character> iterator = this.m_customColorMap.keySet().iterator();
            while (iterator.hasNext()) {
                c = iterator.next().charValue();
                Color color = this.m_customColorMap.get(Character.valueOf(c));
                objectArray[0][c] = "<html><font color='#" + Integer.toString(color.getRGB(), 16) + "'><b>.</b></html>";
                objectArray[1][c] = "<html><font color='#" + Integer.toString(color.getRGB(), 16) + "'><b>" + c + "</font></html>";
            }
            if (!this.useDots) {
                objectArray[0] = objectArray[1];
            }
            return objectArray;
        }
        Object[][] objectArray = new Character[2][256];
        for (int i = 0; i < 256; ++i) {
            objectArray[0][i] = Character.valueOf('.');
            objectArray[1][i] = Character.valueOf((char)i);
        }
        if (!this.useDots) {
            objectArray[0] = objectArray[1];
        }
        return objectArray;
    }

    private Object[][] setupIntegerColorMap() {
        if (this.useColor) {
            Object[][] objectArray = new String[2][256];
            for (int i = 0; i < 256; ++i) {
                int n = ((i & 0x80) >> 7) + ((i & 0x10) >> 4) + ((i & 2) << 1);
                int color = ((i & 0x40) >> 6) + ((i & 8) >> 2) + (i & 4);
                int n2 = ((i & 0x20) >> 5) + ((i & 4) >> 1) + ((i & 1) << 2);
                int n3 = (n << 21 + (color << 18)) + (color << 13) + (n2 << 10) + (n2 << 5) + (n << 2);
                objectArray[0][i] = "<html><font color='#" + Integer.toString(n3, 16) + "'><b>.</b></html>";
                objectArray[1][i] = "<html><font color='#" + Integer.toString(n3, 16) + "'><b>" + i + "</font></html>";
            }
            for (char c : this.m_customColorMap.keySet()) {
                Color color = this.m_customColorMap.get(Character.valueOf(c));
                objectArray[0][c] = "<html><font color='#" + Integer.toString(color.getRGB(), 16) + "'><b>.</b></html>";
                objectArray[1][c] = "<html><font color='#" + Integer.toString(color.getRGB(), 16) + "'><b>" + c + "</font></html>";
            }
            if (!this.useDots) {
                objectArray[0] = objectArray[1];
            }
            return objectArray;
        }
        Object[][] objectArray = new String[2][256];
        for (int i = 0; i < 256; ++i) {
            objectArray[0][i] = ".";
            objectArray[1][i] = Integer.toString(i);
        }
        if (!this.useDots) {
            objectArray[0] = objectArray[1];
        }
        return objectArray;
    }

    private char mostFrequentCharInPattern(String string) {
        int n;
        char[] cArray = new char[256];
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            cArray[c] = (char)(cArray[c] + '\u0001');
        }
        n = 0;
        char c = '\u0000';
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] <= c) continue;
            n = i;
            c = cArray[i];
        }
        return (char)n;
    }

    private char mostFrequentCharInPattern(String[] stringArray) {
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        int n = 0;
        char c = '\u0000';
        for (String string : stringArray) {
            try {
                char c2 = (char)(Integer.parseInt(string) + 48);
                if (hashMap.containsKey(Character.valueOf(c2))) {
                    hashMap.put(Character.valueOf(c2), (Integer)hashMap.get(Character.valueOf(c2)) + 1);
                } else {
                    hashMap.put(Character.valueOf(c2), 1);
                }
                if ((Integer)hashMap.get(Character.valueOf(c2)) <= n) continue;
                n = (Integer)hashMap.get(Character.valueOf(c2));
                c = c2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return c;
    }

    public void showInDialog() {
        JDialog jDialog = new JDialog();
        jDialog.setName("AlignmentViewer");
        jDialog.add(this);
        Box box = Box.createHorizontalBox();
        JCheckBox jCheckBox = new JCheckBox("Use dots", true);
        jCheckBox.addActionListener(actionEvent -> {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            this.useDots = jCheckBox.isSelected();
            this.updateTableData();
            this.repaint();
        });
        box.add(jCheckBox);
        JCheckBox jCheckBox2 = new JCheckBox("Use Color");
        jCheckBox2.setName("UseColor");
        jCheckBox2.addActionListener(actionEvent -> {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            this.useColor = jCheckBox.isSelected();
            this.updateTableData();
            this.repaint();
        });
        box.add(jCheckBox2);
        jDialog.add((Component)box, "South");
        int n = UIManager.getFont("Label.font").getSize();
        jDialog.setSize(1024 * n / 13, 600 * n / 13);
        jDialog.setModal(true);
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    public static void main(String[] stringArray) {
        try {
            NexusParser nexusParser = new NexusParser();
            nexusParser.parseFile(new File(stringArray[0]));
            Alignment alignment = nexusParser.m_alignment;
            AlignmentViewer alignmentViewer = new AlignmentViewer(alignment);
            alignmentViewer.showInDialog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

