/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiSubTemplate;
import beast.app.beauti.PartitionContext;
import beast.app.draw.BEASTObjectDialog;
import beast.app.draw.InputEditor;
import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Input;
import beast.core.parameter.IntegerParameter;
import beast.core.parameter.RealParameter;
import beast.math.distributions.Prior;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PriorInputEditor
extends InputEditor.Base {
    private static final long serialVersionUID = 1L;

    public PriorInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return Prior.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        Object object;
        BEASTObject bEASTObject2;
        this.m_bAddButtons = bl;
        this.m_input = input;
        this.m_beastObject = bEASTInterface;
        this.itemNr = n;
        Box box = Box.createHorizontalBox();
        Prior prior = (Prior)bEASTInterface;
        String string = prior.getParameterName();
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Dimension dimension = new Dimension(font.getSize() * 200 / 13, font.getSize() * 25 / 13);
        jLabel.setMinimumSize(dimension);
        jLabel.setPreferredSize(dimension);
        box.add(jLabel);
        List<BeautiSubTemplate> list = this.doc.getInputEditorFactory().getAvailableTemplates(prior.distInput, prior, null, this.doc);
        JComboBox<BeautiSubTemplate> jComboBox = new JComboBox<BeautiSubTemplate>(list.toArray(new BeautiSubTemplate[0]));
        jComboBox.setName(string + ".distr");
        String string2 = prior.distInput.get().getID();
        string2 = string2.substring(0, string2.indexOf(46));
        for (BEASTObject bEASTObject2 : list) {
            if (bEASTObject2.classInput.get() == null || !bEASTObject2.shortClassName.equals(string2)) continue;
            jComboBox.setSelectedItem(bEASTObject2);
        }
        jComboBox.addActionListener(actionEvent -> {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            List list = (List)this.m_input.get();
            BeautiSubTemplate beautiSubTemplate = (BeautiSubTemplate)jComboBox.getSelectedItem();
            PartitionContext partitionContext = this.doc.getContextFor((BEASTInterface)list.get(this.itemNr));
            Prior prior = (Prior)list.get(this.itemNr);
            try {
                beautiSubTemplate.createSubNet(partitionContext, prior, prior.distInput, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.sync();
            this.refreshPanel();
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jComboBox);
        jPanel.setMaximumSize(dimension);
        box.add(jPanel);
        if (prior.m_x.get() instanceof RealParameter) {
            bEASTObject2 = (RealParameter)prior.m_x.get();
            object = new JButton(this.paramToString((RealParameter)bEASTObject2));
            ((AbstractButton)object).addActionListener(actionEvent -> {
                JButton jButton = (JButton)actionEvent.getSource();
                List list = (List)this.m_input.get();
                Prior prior = (Prior)list.get(this.itemNr);
                RealParameter realParameter = (RealParameter)prior.m_x.get();
                BEASTObjectDialog bEASTObjectDialog = new BEASTObjectDialog(realParameter, RealParameter.class, this.doc);
                if (bEASTObjectDialog.showDialog()) {
                    bEASTObjectDialog.accept(realParameter, this.doc);
                    jButton.setText(this.paramToString(realParameter));
                    this.refreshPanel();
                }
            });
            box.add(Box.createHorizontalStrut(10));
            box.add((Component)object);
        } else if (prior.m_x.get() instanceof IntegerParameter) {
            bEASTObject2 = (IntegerParameter)prior.m_x.get();
            object = new JButton(this.paramToString((IntegerParameter)bEASTObject2));
            ((AbstractButton)object).addActionListener(actionEvent -> {
                JButton jButton = (JButton)actionEvent.getSource();
                List list = (List)this.m_input.get();
                Prior prior = (Prior)list.get(this.itemNr);
                IntegerParameter integerParameter = (IntegerParameter)prior.m_x.get();
                BEASTObjectDialog bEASTObjectDialog = new BEASTObjectDialog(integerParameter, IntegerParameter.class, this.doc);
                if (bEASTObjectDialog.showDialog()) {
                    bEASTObjectDialog.accept(integerParameter, this.doc);
                    jButton.setText(this.paramToString(integerParameter));
                    this.refreshPanel();
                }
            });
            box.add(Box.createHorizontalStrut(10));
            box.add((Component)object);
        }
        int n2 = jComboBox.getFont().getSize();
        jComboBox.setMaximumSize(new Dimension(1024 * n2 / 13, 24 * n2 / 13));
        object = this.getDoc().tipTextMap.get(bEASTInterface.getID());
        if (object != null) {
            JLabel jLabel2 = new JLabel(" " + (String)object);
            box.add(jLabel2);
        }
        box.add(Box.createGlue());
        this.add(box);
    }

    String paramToString(RealParameter realParameter) {
        Double d = realParameter.lowerValueInput.get();
        Double d2 = realParameter.upperValueInput.get();
        return "initial = " + Arrays.toString(((List)realParameter.valuesInput.get()).toArray()) + " [" + (d == null ? "-\u221e" : d + "") + "," + (d2 == null ? "\u221e" : d2 + "") + "]";
    }

    String paramToString(IntegerParameter integerParameter) {
        Integer n = integerParameter.lowerValueInput.get();
        Integer n2 = integerParameter.upperValueInput.get();
        return "initial = " + Arrays.toString(((List)integerParameter.valuesInput.get()).toArray()) + " [" + (n == null ? "-\u221e" : n + "") + "," + (n2 == null ? "\u221e" : n2 + "") + "]";
    }
}

