/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.likelihood;

import beagle.Beagle;
import beagle.BeagleFactory;
import beagle.BeagleFlag;
import beagle.BeagleInfo;
import beagle.InstanceDetails;
import beagle.ResourceDetails;
import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.evolution.branchratemodel.StrictClockModel;
import beast.evolution.likelihood.TreeLikelihood;
import beast.evolution.sitemodel.SiteModelInterface;
import beast.evolution.substitutionmodel.EigenDecomposition;
import beast.evolution.tree.Node;
import beast.evolution.tree.TreeInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Description(value="Uses Beagle library to calculate Tree likelihood")
public class BeagleTreeLikelihood
extends TreeLikelihood {
    private static final String RESOURCE_ORDER_PROPERTY = "beagle.resource.order";
    private static final String PREFERRED_FLAGS_PROPERTY = "beagle.preferred.flags";
    private static final String REQUIRED_FLAGS_PROPERTY = "beagle.required.flags";
    private static final String SCALING_PROPERTY = "beagle.scaling";
    private static final String RESCALE_FREQUENCY_PROPERTY = "beagle.rescale";
    private static final PartialsRescalingScheme DEFAULT_RESCALING_SCHEME = PartialsRescalingScheme.DYNAMIC;
    private static int instanceCount = 0;
    private static List<Integer> resourceOrder = null;
    private static List<Integer> preferredOrder = null;
    private static List<Integer> requiredOrder = null;
    private static List<String> scalingOrder = null;
    private static final int RESCALE_FREQUENCY = 10000;
    private static final int RESCALE_TIMES = 1;
    boolean m_bUseAmbiguities;
    boolean m_bUseTipLikelihoods;
    int m_nStateCount;
    int m_nNodeCount;
    private double[] currentCategoryRates;
    private double[] currentFreqs;
    private double[] currentCategoryWeights;
    private int invariantCategory = -1;
    private int eigenCount;
    private int[][] matrixUpdateIndices;
    private double[][] branchLengths;
    private int[] branchUpdateCount;
    private int[] scaleBufferIndices;
    private int[] storedScaleBufferIndices;
    private int[][] operations;
    private int operationListCount;
    private int[] operationCount;
    protected BufferIndexHelper partialBufferHelper;
    private BufferIndexHelper eigenBufferHelper;
    protected BufferIndexHelper matrixBufferHelper;
    protected BufferIndexHelper scaleBufferHelper;
    protected int tipCount;
    protected int internalNodeCount;
    protected int patternCount;
    private PartialsRescalingScheme rescalingScheme = DEFAULT_RESCALING_SCHEME;
    private int rescalingFrequency = 10000;
    protected boolean useScaleFactors = false;
    private boolean useAutoScaling = false;
    private boolean recomputeScaleFactors = false;
    private boolean everUnderflowed = false;
    private int rescalingCount = 0;
    private int rescalingCountInner = 0;
    protected int categoryCount;
    protected double[] tipPartials;
    protected Beagle beagle;
    protected boolean updateSubstitutionModel;
    protected boolean storedUpdateSubstitutionModel;
    protected boolean updateSiteModel;
    protected boolean storedUpdateSiteModel;
    private boolean ascertainedSitePatterns = false;

    @Override
    public void initAndValidate() {
        boolean bl = Boolean.valueOf(System.getProperty("java.only"));
        if (bl) {
            return;
        }
        this.initialize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initialize() {
        String string;
        int n;
        this.m_nNodeCount = ((TreeInterface)this.treeInput.get()).getNodeCount();
        this.m_bUseAmbiguities = (Boolean)this.m_useAmbiguities.get();
        this.m_bUseTipLikelihoods = (Boolean)this.m_useTipLikelihoods.get();
        if (!(this.siteModelInput.get() instanceof SiteModelInterface.Base)) {
            throw new IllegalArgumentException("siteModel input should be of type SiteModel.Base");
        }
        this.m_siteModel = (SiteModelInterface.Base)this.siteModelInput.get();
        this.m_siteModel.setDataType(((Alignment)this.dataInput.get()).getDataType());
        this.substitutionModel = this.m_siteModel.substModelInput.get();
        this.branchRateModel = (BranchRateModel.Base)this.branchRateModelInput.get();
        if (this.branchRateModel == null) {
            this.branchRateModel = new StrictClockModel();
        }
        this.m_branchLengths = new double[this.m_nNodeCount];
        this.storedBranchLengths = new double[this.m_nNodeCount];
        this.m_nStateCount = ((Alignment)this.dataInput.get()).getMaxStateCount();
        this.patternCount = ((Alignment)this.dataInput.get()).getPatternCount();
        this.eigenCount = 1;
        double[] dArray = this.m_siteModel.getCategoryRates(null);
        if (this.m_siteModel.hasPropInvariantCategory) {
            for (n = 0; n < dArray.length; ++n) {
                int n2;
                if (dArray[n] != 0.0) continue;
                this.proportionInvariant = this.m_siteModel.getRateForCategory(n, null);
                int n3 = ((Alignment)this.dataInput.get()).getMaxStateCount();
                int n4 = ((Alignment)this.dataInput.get()).getPatternCount();
                this.calcConstantPatternIndices(n4, n3);
                this.invariantCategory = n;
                double[] dArray2 = new double[dArray.length - 1];
                for (n2 = 0; n2 < this.invariantCategory; ++n2) {
                    dArray2[n2] = dArray[n2];
                }
                for (n2 = this.invariantCategory + 1; n2 < dArray.length; ++n2) {
                    dArray2[n2 - 1] = dArray[n2];
                }
                dArray = dArray2;
                break;
            }
            if (this.constantPattern != null && this.constantPattern.size() > ((Alignment)this.dataInput.get()).getPatternCount()) {
                Log.debug("switch off constant sites optimisiation: calculating through separate TreeLikelihood category (as in the olden days)");
                this.invariantCategory = -1;
                this.proportionInvariant = 0.0;
                this.constantPattern = null;
                dArray = this.m_siteModel.getCategoryRates(null);
            }
        }
        this.categoryCount = this.m_siteModel.getCategoryCount() - (this.invariantCategory >= 0 ? 1 : 0);
        this.tipCount = ((TreeInterface)this.treeInput.get()).getLeafNodeCount();
        this.internalNodeCount = this.m_nNodeCount - this.tipCount;
        n = this.tipCount;
        if (this.m_bUseAmbiguities) {
            n = 0;
        }
        this.partialBufferHelper = new BufferIndexHelper(this.m_nNodeCount, this.tipCount);
        this.eigenBufferHelper = new BufferIndexHelper(this.eigenCount, 0);
        this.matrixBufferHelper = new BufferIndexHelper(this.m_nNodeCount, 0);
        this.scaleBufferHelper = new BufferIndexHelper(this.getScaleBufferCount(), 0);
        if (resourceOrder == null) {
            resourceOrder = BeagleTreeLikelihood.parseSystemPropertyIntegerArray(RESOURCE_ORDER_PROPERTY);
        }
        if (preferredOrder == null) {
            preferredOrder = BeagleTreeLikelihood.parseSystemPropertyIntegerArray(PREFERRED_FLAGS_PROPERTY);
        }
        if (requiredOrder == null) {
            requiredOrder = BeagleTreeLikelihood.parseSystemPropertyIntegerArray(REQUIRED_FLAGS_PROPERTY);
        }
        if (scalingOrder == null) {
            scalingOrder = BeagleTreeLikelihood.parseSystemPropertyStringArray(SCALING_PROPERTY);
        }
        this.rescalingScheme = PartialsRescalingScheme.DEFAULT;
        this.rescalingScheme = DEFAULT_RESCALING_SCHEME;
        int[] nArray = null;
        long l = 0L;
        long l2 = 0L;
        if (scalingOrder.size() > 0) {
            this.rescalingScheme = PartialsRescalingScheme.parseFromString(scalingOrder.get(instanceCount % scalingOrder.size()));
        }
        if (resourceOrder.size() > 0 && (nArray = new int[]{resourceOrder.get(instanceCount % resourceOrder.size()), 0})[0] > 0) {
            l |= BeagleFlag.PROCESSOR_GPU.getMask();
        }
        if (preferredOrder.size() > 0) {
            l = preferredOrder.get(instanceCount % preferredOrder.size()).intValue();
        }
        if (requiredOrder.size() > 0) {
            l2 = requiredOrder.get(instanceCount % requiredOrder.size()).intValue();
        }
        if (((TreeLikelihood.Scaling)((Object)this.scaling.get())).equals((Object)TreeLikelihood.Scaling.always)) {
            this.rescalingScheme = PartialsRescalingScheme.ALWAYS;
        }
        if (((TreeLikelihood.Scaling)((Object)this.scaling.get())).equals((Object)TreeLikelihood.Scaling.none)) {
            this.rescalingScheme = PartialsRescalingScheme.NONE;
        }
        if (this.rescalingScheme == PartialsRescalingScheme.DEFAULT) {
            this.rescalingScheme = nArray != null && nArray[0] > 1 ? PartialsRescalingScheme.NONE : PartialsRescalingScheme.DYNAMIC;
        }
        if (this.rescalingScheme == PartialsRescalingScheme.AUTO) {
            l |= BeagleFlag.SCALING_AUTO.getMask();
            this.useAutoScaling = true;
        }
        if ((string = System.getProperty(RESCALE_FREQUENCY_PROPERTY)) != null) {
            this.rescalingFrequency = Integer.parseInt(string);
            if (this.rescalingFrequency < 1) {
                this.rescalingFrequency = 10000;
            }
        }
        if (l == 0L && nArray == null && this.m_nStateCount == 4 && this.patternCount < 10000) {
            l |= BeagleFlag.PROCESSOR_CPU.getMask();
        }
        if (this.substitutionModel.canReturnComplexDiagonalization()) {
            l2 |= BeagleFlag.EIGEN_COMPLEX.getMask();
        }
        ++instanceCount;
        try {
            this.beagle = BeagleFactory.loadBeagleInstance(this.tipCount, this.partialBufferHelper.getBufferCount(), n, this.m_nStateCount, this.patternCount, this.eigenBufferHelper.getBufferCount(), this.matrixBufferHelper.getBufferCount(), this.categoryCount, this.scaleBufferHelper.getBufferCount(), nArray, l, l2);
        }
        catch (Exception exception) {
            this.beagle = null;
        }
        if (this.beagle == null) {
            return false;
        }
        InstanceDetails instanceDetails = this.beagle.getDetails();
        ResourceDetails resourceDetails = null;
        if (instanceDetails == null) {
            Log.warning.println("  No external BEAGLE resources available, or resource list/requirements not met, using Java implementation");
            this.beagle = null;
            return false;
        }
        resourceDetails = BeagleFactory.getResourceDetails(instanceDetails.getResourceNumber());
        if (resourceDetails == null) {
            Log.warning.println("  Error retrieving BEAGLE resource for instance: " + instanceDetails.toString());
            this.beagle = null;
            return false;
        }
        Node[] nodeArray = new StringBuilder("  Using BEAGLE version: " + BeagleInfo.getVersion() + " resource ");
        nodeArray.append(resourceDetails.getNumber()).append(": ");
        nodeArray.append(resourceDetails.getName()).append("\n");
        if (resourceDetails.getDescription() != null) {
            String[] stringArray;
            for (String string2 : stringArray = resourceDetails.getDescription().split("\\|")) {
                if (string2.trim().length() <= 0) continue;
                nodeArray.append("    ").append(string2.trim()).append("\n");
            }
        }
        nodeArray.append("    with instance flags: ").append(instanceDetails.toString());
        Log.info.println(nodeArray.toString());
        Log.warning.println("  " + (this.m_bUseAmbiguities ? "Using" : "Ignoring") + " ambiguities in tree likelihood.");
        Log.warning.println("  " + (this.m_bUseTipLikelihoods ? "Using" : "Ignoring") + " character uncertainty in tree likelihood.");
        Log.warning.println("  With " + this.patternCount + " unique site patterns.");
        nodeArray = ((TreeInterface)this.treeInput.get()).getNodesAsArray();
        for (int i = 0; i < this.tipCount; ++i) {
            int n5 = ((Alignment)this.dataInput.get()).getTaxonIndex(nodeArray[i].getID());
            if (this.m_bUseAmbiguities || this.m_bUseTipLikelihoods) {
                this.setPartials(this.beagle, i, n5);
                continue;
            }
            this.setStates(this.beagle, i, n5);
        }
        if (((Alignment)this.dataInput.get()).isAscertained) {
            this.ascertainedSitePatterns = true;
        }
        double[] dArray3 = new double[this.patternCount];
        for (int i = 0; i < this.patternCount; ++i) {
            dArray3[i] = ((Alignment)this.dataInput.get()).getPatternWeight(i);
        }
        this.beagle.setPatternWeights(dArray3);
        if (this.rescalingScheme == PartialsRescalingScheme.AUTO && resourceDetails != null && (resourceDetails.getFlags() & BeagleFlag.SCALING_AUTO.getMask()) == 0L) {
            this.rescalingScheme = PartialsRescalingScheme.DYNAMIC;
            Log.warning.println("  Auto rescaling not supported in BEAGLE, using : " + this.rescalingScheme.getText());
        } else {
            Log.warning.println("  Using rescaling scheme : " + this.rescalingScheme.getText());
        }
        if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC) {
            this.everUnderflowed = false;
        }
        this.updateSubstitutionModel = true;
        this.updateSiteModel = true;
        this.setUpSubstModel();
        this.beagle.setCategoryRates(dArray);
        this.currentCategoryRates = dArray;
        this.currentFreqs = new double[this.m_nStateCount];
        this.currentCategoryWeights = new double[dArray.length];
        return true;
    }

    private static List<Integer> parseSystemPropertyIntegerArray(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string2 = System.getProperty(string);
        if (string2 != null) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(",")) {
                try {
                    int n = Integer.parseInt(string3.trim());
                    arrayList.add(n);
                }
                catch (NumberFormatException numberFormatException) {
                    Log.warning.println("Invalid entry '" + string3 + "' in " + string);
                }
            }
        }
        return arrayList;
    }

    private static List<String> parseSystemPropertyStringArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = System.getProperty(string);
        if (string2 != null) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(",")) {
                try {
                    String string4 = string3.trim();
                    arrayList.add(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    Log.warning.println("Invalid getEigenDecompositionentry '" + string3 + "' in " + string);
                }
            }
        }
        return arrayList;
    }

    protected int getScaleBufferCount() {
        return this.internalNodeCount + 1;
    }

    protected final void setPartials(Beagle beagle, int n, int n2) {
        int n3;
        int n4;
        Alignment alignment = (Alignment)this.dataInput.get();
        double[] dArray = new double[this.patternCount * this.m_nStateCount * this.categoryCount];
        int n5 = 0;
        for (n4 = 0; n4 < this.patternCount; ++n4) {
            double[] dArray2 = alignment.getTipLikelihoods(n2, n4);
            if (dArray2 != null) {
                for (n3 = 0; n3 < this.m_nStateCount; ++n3) {
                    dArray[n5++] = dArray2[n3];
                }
                continue;
            }
            n3 = alignment.getPattern(n2, n4);
            boolean[] blArray = alignment.getStateSet(n3);
            for (int i = 0; i < this.m_nStateCount; ++i) {
                dArray[n5++] = blArray[i] ? 1.0 : 0.0;
            }
        }
        int n6 = n4 = this.patternCount * this.m_nStateCount;
        for (n3 = 1; n3 < this.categoryCount; ++n3) {
            System.arraycopy(dArray, 0, dArray, n6, n4);
            n6 += n4;
        }
        beagle.setPartials(n, dArray);
    }

    public int getPatternCount() {
        return this.patternCount;
    }

    void setUpSubstModel() {
        for (int i = 0; i < this.eigenCount; ++i) {
            EigenDecomposition eigenDecomposition = this.substitutionModel.getEigenDecomposition(null);
            this.eigenBufferHelper.flipOffset(i);
            this.beagle.setEigenDecomposition(this.eigenBufferHelper.getOffsetIndex(i), eigenDecomposition.getEigenVectors(), eigenDecomposition.getInverseEigenVectors(), eigenDecomposition.getEigenValues());
        }
    }

    protected final void setStates(Beagle beagle, int n, int n2) {
        Alignment alignment = (Alignment)this.dataInput.get();
        int[] nArray = new int[this.patternCount];
        for (int i = 0; i < this.patternCount; ++i) {
            int n3;
            nArray[i] = n3 = alignment.getPattern(n2, i);
        }
        beagle.setTipStates(n, nArray);
    }

    @Override
    protected boolean requiresRecalculation() {
        this.hasDirt = 0;
        double[] dArray = this.m_siteModel.getCategoryRates(null);
        if (this.constantPattern != null) {
            int n;
            double[] dArray2 = new double[dArray.length - 1];
            for (n = 0; n < this.invariantCategory; ++n) {
                dArray2[n] = dArray[n];
            }
            for (n = this.invariantCategory + 1; n < dArray.length; ++n) {
                dArray2[n - 1] = dArray[n];
            }
            dArray = dArray2;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == this.currentCategoryRates[i]) continue;
            this.updateSiteModel = true;
            break;
        }
        if (this.substitutionModel instanceof CalculationNode) {
            this.updateSubstitutionModel |= ((CalculationNode)((Object)this.substitutionModel)).isDirtyCalculation();
        }
        if (((Alignment)this.dataInput.get()).isDirtyCalculation()) {
            this.hasDirt = 2;
            return true;
        }
        if (this.m_siteModel.isDirtyCalculation()) {
            this.hasDirt = 1;
            return true;
        }
        if (this.branchRateModel != null && this.branchRateModel.isDirtyCalculation()) {
            return true;
        }
        return ((TreeInterface)this.treeInput.get()).somethingIsDirty();
    }

    @Override
    public void store() {
        this.partialBufferHelper.storeState();
        this.eigenBufferHelper.storeState();
        this.matrixBufferHelper.storeState();
        if (this.useScaleFactors || this.useAutoScaling) {
            this.scaleBufferHelper.storeState();
            System.arraycopy(this.scaleBufferIndices, 0, this.storedScaleBufferIndices, 0, this.scaleBufferIndices.length);
        }
        super.store();
        System.arraycopy(this.m_branchLengths, 0, this.storedBranchLengths, 0, this.m_branchLengths.length);
    }

    @Override
    public void restore() {
        this.updateSiteModel = true;
        this.partialBufferHelper.restoreState();
        this.eigenBufferHelper.restoreState();
        this.matrixBufferHelper.restoreState();
        if (this.useScaleFactors || this.useAutoScaling) {
            this.scaleBufferHelper.restoreState();
            int[] nArray = this.storedScaleBufferIndices;
            this.storedScaleBufferIndices = this.scaleBufferIndices;
            this.scaleBufferIndices = nArray;
        }
        super.restore();
    }

    @Override
    public double calculateLogP() {
        double d;
        int n;
        if (this.patternLogLikelihoods == null) {
            this.patternLogLikelihoods = new double[this.patternCount];
        }
        if (this.matrixUpdateIndices == null) {
            this.matrixUpdateIndices = new int[this.eigenCount][this.m_nNodeCount];
            this.branchLengths = new double[this.eigenCount][this.m_nNodeCount];
            this.branchUpdateCount = new int[this.eigenCount];
            this.scaleBufferIndices = new int[this.internalNodeCount];
            this.storedScaleBufferIndices = new int[this.internalNodeCount];
        }
        if (this.operations == null) {
            this.operations = new int[1][this.internalNodeCount * 7];
            this.operationCount = new int[1];
        }
        this.recomputeScaleFactors = false;
        if (this.rescalingScheme == PartialsRescalingScheme.ALWAYS) {
            this.useScaleFactors = true;
            this.recomputeScaleFactors = true;
        } else if (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC && this.everUnderflowed) {
            this.useScaleFactors = true;
            if (this.rescalingCountInner < 1) {
                this.recomputeScaleFactors = true;
                this.hasDirt = 2;
            }
            ++this.rescalingCountInner;
            ++this.rescalingCount;
            if (this.rescalingCount > 10000) {
                this.rescalingCount = 0;
                this.rescalingCountInner = 0;
            }
        } else if (this.rescalingScheme == PartialsRescalingScheme.DELAYED && this.everUnderflowed) {
            this.useScaleFactors = true;
            this.recomputeScaleFactors = true;
            this.hasDirt = 2;
            ++this.rescalingCount;
        }
        for (int i = 0; i < this.eigenCount; ++i) {
            this.branchUpdateCount[i] = 0;
        }
        this.operationListCount = 0;
        this.operationCount[0] = 0;
        Node node = ((TreeInterface)this.treeInput.get()).getRoot();
        this.traverse(node, null, true);
        if (this.updateSubstitutionModel) {
            this.setUpSubstModel();
        }
        if (this.updateSiteModel) {
            double[] dArray = this.m_siteModel.getCategoryRates(null);
            if (this.constantPattern != null) {
                double[] dArray2 = new double[dArray.length - 1];
                for (n = 0; n < this.invariantCategory; ++n) {
                    dArray2[n] = dArray[n];
                }
                for (n = this.invariantCategory + 1; n < dArray.length; ++n) {
                    dArray2[n - 1] = dArray[n];
                }
                dArray = dArray2;
            }
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] == this.currentCategoryRates[i]) continue;
                this.beagle.setCategoryRates(dArray);
                i = dArray.length;
            }
            this.currentCategoryRates = dArray;
        }
        for (int i = 0; i < this.eigenCount; ++i) {
            if (this.branchUpdateCount[i] <= 0) continue;
            this.beagle.updateTransitionMatrices(this.eigenBufferHelper.getOffsetIndex(i), this.matrixUpdateIndices[i], null, null, this.branchLengths[i], this.branchUpdateCount[i]);
        }
        boolean bl = true;
        do {
            int n2;
            int n3;
            double[] dArray;
            this.beagle.updatePartials(this.operations[0], this.operationCount[0], -1);
            int n4 = this.partialBufferHelper.getOffsetIndex(node.getNr());
            double[] dArray3 = this.m_siteModel.getCategoryProportions(null);
            if (this.constantPattern != null) {
                dArray = new double[dArray3.length - 1];
                for (n3 = 0; n3 < this.invariantCategory; ++n3) {
                    dArray[n3] = dArray3[n3];
                }
                for (n3 = this.invariantCategory + 1; n3 < dArray3.length; ++n3) {
                    dArray[n3 - 1] = dArray3[n3];
                }
                dArray3 = dArray;
            }
            dArray = this.substitutionModel.getFrequencies();
            n3 = -1;
            if (this.useScaleFactors) {
                if (this.recomputeScaleFactors) {
                    this.scaleBufferHelper.flipOffset(this.internalNodeCount);
                    n3 = this.scaleBufferHelper.getOffsetIndex(this.internalNodeCount);
                    this.beagle.resetScaleFactors(n3);
                    this.beagle.accumulateScaleFactors(this.scaleBufferIndices, this.internalNodeCount, n3);
                } else {
                    n3 = this.scaleBufferHelper.getOffsetIndex(this.internalNodeCount);
                }
            } else if (this.useAutoScaling) {
                this.beagle.accumulateScaleFactors(this.scaleBufferIndices, this.internalNodeCount, -1);
            }
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                if (dArray3[n2] == this.currentCategoryWeights[n2]) continue;
                this.beagle.setCategoryWeights(0, dArray3);
                n2 = dArray3.length;
            }
            this.currentCategoryWeights = dArray3;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                if (dArray[n2] == this.currentFreqs[n2]) continue;
                this.beagle.setStateFrequencies(0, dArray);
                n2 = dArray.length;
            }
            this.currentFreqs = dArray;
            double[] dArray4 = new double[1];
            this.beagle.calculateRootLogLikelihoods(new int[]{n4}, new int[]{0}, new int[]{0}, new int[]{n3}, 1, dArray4);
            d = dArray4[0];
            if (this.ascertainedSitePatterns) {
                this.beagle.getSiteLogLikelihoods(this.patternLogLikelihoods);
                d = this.getAscertainmentCorrectedLogLikelihood((Alignment)this.dataInput.get(), this.patternLogLikelihoods, ((Alignment)this.dataInput.get()).getWeights(), dArray);
            } else if (this.invariantCategory >= 0) {
                this.beagle.getSiteLogLikelihoods(this.patternLogLikelihoods);
                int[] nArray = ((Alignment)this.dataInput.get()).getWeights();
                this.proportionInvariant = this.m_siteModel.getProportionInvariant();
                Iterator iterator = this.constantPattern.iterator();
                while (iterator.hasNext()) {
                    int n5 = (Integer)iterator.next();
                    int n6 = n5 / this.m_nStateCount;
                    int n7 = n5 % this.m_nStateCount;
                    this.patternLogLikelihoods[n6] = Math.log(Math.exp(this.patternLogLikelihoods[n6]) + this.proportionInvariant * dArray[n7]);
                }
                d = 0.0;
                for (int i = 0; i < this.patternCount; ++i) {
                    d += this.patternLogLikelihoods[i] * (double)nArray[i];
                }
            }
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                this.everUnderflowed = true;
                d = Double.NEGATIVE_INFINITY;
                if (bl && (this.rescalingScheme == PartialsRescalingScheme.DYNAMIC || this.rescalingScheme == PartialsRescalingScheme.DELAYED)) {
                    this.useScaleFactors = true;
                    this.recomputeScaleFactors = true;
                    for (int i = 0; i < this.eigenCount; ++i) {
                        this.branchUpdateCount[i] = 0;
                    }
                    this.operationCount[0] = 0;
                    this.traverse(node, null, false);
                    n = 0;
                    bl = false;
                    continue;
                }
                n = 1;
                continue;
            }
            n = 1;
        } while (n == 0);
        this.updateSubstitutionModel = false;
        this.updateSiteModel = false;
        this.logP = d;
        return d;
    }

    protected void setPartials(int n, double[] dArray) {
        this.beagle.setPartials(this.partialBufferHelper.getOffsetIndex(n), dArray);
    }

    private double getAscertainmentCorrectedLogLikelihood(Alignment alignment, double[] dArray, int[] nArray, double[] dArray2) {
        if (this.constantPattern != null) {
            this.proportionInvariant = this.m_siteModel.getProportionInvariant();
            Iterator iterator = this.constantPattern.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                int n2 = n / this.m_nStateCount;
                int n3 = n % this.m_nStateCount;
                dArray[n2] = Math.log(Math.exp(dArray[n2]) + this.proportionInvariant * dArray2[n3]);
            }
        }
        double d = 0.0;
        double d2 = alignment.getAscertainmentCorrection(dArray);
        for (int i = 0; i < this.patternCount; ++i) {
            d += (dArray[i] - d2) * (double)nArray[i];
        }
        return d;
    }

    private int traverse(Node node, int[] nArray, boolean bl) {
        int n = node.getNr();
        if (nArray != null) {
            nArray[0] = -1;
        }
        int n2 = node.isDirty() | this.hasDirt;
        double d = this.branchRateModel.getRateForBranch(node);
        double d2 = node.getLength() * d;
        if (!(node.isRoot() || n2 == 0 && d2 == this.m_branchLengths[n])) {
            this.m_branchLengths[n] = d2;
            if (d2 < 0.0) {
                throw new RuntimeException("Negative branch length: " + d2);
            }
            if (bl) {
                this.matrixBufferHelper.flipOffset(n);
            }
            int n3 = this.branchUpdateCount[0];
            this.matrixUpdateIndices[0][n3] = this.matrixBufferHelper.getOffsetIndex(n);
            this.branchLengths[0][n3] = d2;
            this.branchUpdateCount[0] = this.branchUpdateCount[0] + 1;
            n2 |= 1;
        }
        if (!node.isLeaf()) {
            Node node2 = node.getLeft();
            int[] nArray2 = new int[]{-1};
            int n4 = this.traverse(node2, nArray2, bl);
            Node node3 = node.getRight();
            int[] nArray3 = new int[]{-1};
            int n5 = this.traverse(node3, nArray3, bl);
            if (n4 != 0 || n5 != 0) {
                int n6 = this.operationCount[this.operationListCount] * 7;
                if (bl) {
                    this.partialBufferHelper.flipOffset(n);
                }
                int[] nArray4 = this.operations[this.operationListCount];
                nArray4[n6] = this.partialBufferHelper.getOffsetIndex(n);
                if (this.useScaleFactors) {
                    int n7 = n - this.tipCount;
                    if (this.recomputeScaleFactors) {
                        this.scaleBufferHelper.flipOffset(n7);
                        this.scaleBufferIndices[n7] = this.scaleBufferHelper.getOffsetIndex(n7);
                        nArray4[n6 + 1] = this.scaleBufferIndices[n7];
                        nArray4[n6 + 2] = -1;
                    } else {
                        nArray4[n6 + 1] = -1;
                        nArray4[n6 + 2] = this.scaleBufferIndices[n7];
                    }
                } else {
                    if (this.useAutoScaling) {
                        this.scaleBufferIndices[n - this.tipCount] = this.partialBufferHelper.getOffsetIndex(n);
                    }
                    nArray4[n6 + 1] = -1;
                    nArray4[n6 + 2] = -1;
                }
                nArray4[n6 + 3] = this.partialBufferHelper.getOffsetIndex(node2.getNr());
                nArray4[n6 + 4] = this.matrixBufferHelper.getOffsetIndex(node2.getNr());
                nArray4[n6 + 5] = this.partialBufferHelper.getOffsetIndex(node3.getNr());
                nArray4[n6 + 6] = this.matrixBufferHelper.getOffsetIndex(node3.getNr());
                int n8 = this.operationListCount;
                this.operationCount[n8] = this.operationCount[n8] + 1;
                n2 |= n4 | n5;
            }
        }
        return n2;
    }

    @Override
    public double[] getPatternLogLikelihoods() {
        this.beagle.getSiteLogLikelihoods(this.patternLogLikelihoods);
        return (double[])this.patternLogLikelihoods.clone();
    }

    public static enum PartialsRescalingScheme {
        DEFAULT("default"),
        NONE("none"),
        DYNAMIC("dynamic"),
        ALWAYS("always"),
        DELAYED("delayed"),
        AUTO("auto");

        private final String text;

        private PartialsRescalingScheme(String string2) {
            this.text = string2;
        }

        public String getText() {
            return this.text;
        }

        public static PartialsRescalingScheme parseFromString(String string) {
            for (PartialsRescalingScheme partialsRescalingScheme : PartialsRescalingScheme.values()) {
                if (partialsRescalingScheme.getText().compareToIgnoreCase(string) != 0) continue;
                return partialsRescalingScheme;
            }
            return DEFAULT;
        }
    }

    protected class BufferIndexHelper {
        private final int maxIndexValue;
        private final int minIndexValue;
        private final int offsetCount;
        private int[] indexOffsets;
        private int[] storedIndexOffsets;

        BufferIndexHelper(int n, int n2) {
            this.maxIndexValue = n;
            this.minIndexValue = n2;
            this.offsetCount = n - n2;
            this.indexOffsets = new int[this.offsetCount];
            this.storedIndexOffsets = new int[this.offsetCount];
        }

        public int getBufferCount() {
            return 2 * this.offsetCount + this.minIndexValue;
        }

        void flipOffset(int n) {
            if (n >= this.minIndexValue) {
                this.indexOffsets[n - this.minIndexValue] = this.offsetCount - this.indexOffsets[n - this.minIndexValue];
            }
        }

        int getOffsetIndex(int n) {
            if (n < this.minIndexValue) {
                return n;
            }
            return this.indexOffsets[n - this.minIndexValue] + n;
        }

        void getIndices(int[] nArray) {
            for (int i = 0; i < this.maxIndexValue; ++i) {
                nArray[i] = this.getOffsetIndex(i);
            }
        }

        void storeState() {
            System.arraycopy(this.indexOffsets, 0, this.storedIndexOffsets, 0, this.indexOffsets.length);
        }

        void restoreState() {
            int[] nArray = this.storedIndexOffsets;
            this.storedIndexOffsets = this.indexOffsets;
            this.indexOffsets = nArray;
        }
    }
}

