/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.speciation;

import beast.core.Citation;
import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.speciation.YuleModel;
import beast.evolution.tree.TreeInterface;
import java.util.Arrays;
import org.apache.commons.math.special.Gamma;

@Description(value="Birth Death model based on Gernhard 2008. <br/>This derivation conditions directly on fixed N taxa. <br/>The inference is directly on b-d (strictly positive) and d/b (constrained in [0,1)) <br/>Verified using simulated trees generated by Klass tree sample. (http://www.klaashartmann.com/treesample/) <br/>Sampling proportion not verified via simulation. Proportion set by default to 1, an assignment which makes the expressions identical to the expressions before the change.")
@Citation(value="Gernhard 2008. The conditioned reconstructed process. Journal of Theoretical Biology Volume 253, Issue 4, 21 August 2008, Pages 769-778", DOI="doi:10.1016/j.jtbi.2008.04.005", year=2008, firstAuthorSurname="gernhard")
public class BirthDeathGernhard08Model
extends YuleModel {
    static final String[] TYPES = new String[]{"unscaled", "timesonly", "oriented", "labeled"};
    public final Input<String> typeInput = new Input<String>("type", "tree type, should be one of " + Arrays.toString(TYPES) + " (default unscaled)", "unscaled", TYPES);
    public final Input<RealParameter> relativeDeathRateParameterInput = new Input("relativeDeathRate", "relative death rate parameter, mu/lambda in birth death model", Input.Validate.REQUIRED);
    public final Input<RealParameter> sampleProbabilityInput = new Input("sampleProbability", "sample probability, rho in birth/death model");
    private TreeType type;

    @Override
    public void initAndValidate() {
        super.initAndValidate();
        String string = this.typeInput.get().toLowerCase();
        if (string.equals("unscaled")) {
            this.type = TreeType.UNSCALED;
        } else if (string.equals("timesonly")) {
            this.type = TreeType.TIMESONLY;
        } else if (string.equals("oriented")) {
            this.type = TreeType.ORIENTED;
        } else if (string.equals("labeled")) {
            this.type = TreeType.LABELED;
        } else {
            throw new IllegalArgumentException("type '" + string + "' is not recognized. Should be one of unscaled, timesonly, oriented and labeled.");
        }
    }

    @Override
    public double calculateTreeLogLikelihood(TreeInterface treeInterface) {
        double d = this.relativeDeathRateParameterInput.get().getValue();
        double d2 = this.sampleProbabilityInput.get() == null ? 1.0 : this.sampleProbabilityInput.get().getValue();
        return this.calculateTreeLogLikelihood(treeInterface, d2, d);
    }

    @Override
    protected double logCoeff(int n) {
        switch (this.type) {
            case UNSCALED: {
                break;
            }
            case TIMESONLY: {
                return Gamma.logGamma(n + 1);
            }
            case ORIENTED: {
                return Math.log(n);
            }
            case LABELED: {
                double d = (double)(n - 1) * Math.log(2.0);
                if (this.conditionalOnRoot) {
                    return d - Math.log(n - 1) - Gamma.logGamma(n + 1);
                }
                if (this.conditionalOnOrigin) {
                    return d - Gamma.logGamma(n + 1);
                }
                return d - Gamma.logGamma(n);
            }
        }
        return 0.0;
    }

    @Override
    protected boolean requiresRecalculation() {
        return super.requiresRecalculation() || this.relativeDeathRateParameterInput.get().somethingIsDirty() || this.sampleProbabilityInput.get().somethingIsDirty();
    }

    public static enum TreeType {
        UNSCALED,
        TIMESONLY,
        ORIENTED,
        LABELED;

    }
}

